/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FinBillStatusEnum;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingBillTypeEnum;
import com.kingdee.eas.fm.fin.client.AbstractBondsFilterUI;
import com.kingdee.eas.fm.fin.client.BondsFilterParam;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.fs.client.CurrencyUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class BondsFilterUI
extends AbstractBondsFilterUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BondsFilterUI.class);
    CompanyOrgUnitInfo companyInfo;
    private static final String RESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";

    public Object getParam() {
        Set marketSet;
        Set gtSet;
        Set fpSet;
        Set cgSet;
        BondsFilterParam filterParam = new BondsFilterParam();
        if (!(this.comboCurrency.getSelectedItem() instanceof FMSysDefinedEnum)) {
            filterParam.setCurrencyId(((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString());
        } else {
            filterParam.setCurrencyId(null);
        }
        if (!(this.comboStatus.getSelectedItem() instanceof FMSysDefinedEnum)) {
            filterParam.setStatus((FinBillStatusEnum)((Object)this.comboStatus.getSelectedItem()));
        } else {
            filterParam.setStatus(null);
        }
        Set cmpSet = this.getCompanyIdSet();
        if (cmpSet != null && cmpSet.size() > 0) {
            filterParam.setCompanyIdSet(this.getCompanyIdSet());
        }
        if (this.dpIssueDate.getSqlDate() != null) {
            filterParam.setIssueDate(DateTimeUtils.truncateDate((Date)this.dpIssueDate.getSqlDate()));
        }
        if (this.dpExpiredDate.getSqlDate() != null) {
            filterParam.setExpiredDate(DateTimeUtils.truncateDate((Date)this.dpExpiredDate.getSqlDate()));
        }
        if ((cgSet = this.getIdSetFromF7(this.prmtCreditorGroup)) != null && cgSet.size() > 0) {
            filterParam.setFinGroupSet(cgSet);
        }
        if ((fpSet = this.getIdSetFromF7(this.prmtFinProduct)) != null && fpSet.size() > 0) {
            filterParam.setFinProductSet(fpSet);
        }
        if ((gtSet = this.getIdSetFromF7(this.prmtGaranteeType)) != null && gtSet.size() > 0) {
            filterParam.setGtSet(gtSet);
        }
        if ((marketSet = this.getIdSetFromF7(this.prmtMarketPlace)) != null && marketSet.size() > 0) {
            filterParam.setMarketPlaceSet(marketSet);
        }
        filterParam.setViewZero(this.isViewZero.isSelected());
        return filterParam;
    }

    protected Class getParamClass() {
        return BondsFilterParam.class;
    }

    protected boolean isNeedEachSerializable() {
        return false;
    }

    public void setParam(Object param) {
        BondsFilterParam filterParam;
        block11: {
            if (param == null) {
                return;
            }
            filterParam = (BondsFilterParam)((Object)param);
            this.setCompanyIdSet(filterParam.getCompanyIdSet());
            if (filterParam.getCurrencyId() != null) {
                try {
                    if (filterParam.getCurrencyId() != null) {
                        CurrencyInfo cur = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(filterParam.getCurrencyId()));
                        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)cur);
                        break block11;
                    }
                    FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            } else {
                this.comboCurrency.setSelectedIndex(this.comboCurrency.getItemCount() - 1);
            }
        }
        if (filterParam.getStatus() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboStatus, (Object)((Object)filterParam.getStatus()));
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.comboStatus, (Object)FMSysDefinedEnum.SELECT_ALL);
        }
        this.dpIssueDate.setValue((Object)filterParam.getIssueDate());
        this.dpExpiredDate.setValue((Object)filterParam.getExpiredDate());
        try {
            this.prmtFinProduct.setData((Object)this.getBaseInfoFromIdSet(filterParam.getFinProductSet()));
            this.prmtGaranteeType.setData((Object)this.getBaseInfoFromIdSet(filterParam.getGtSet()));
            this.prmtCreditorGroup.setData((Object)this.getBaseInfoFromIdSet(filterParam.getFinGroupSet()));
            this.prmtMarketPlace.setData((Object)this.getBaseInfoFromIdSet(filterParam.getMarketPlaceSet()));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.isViewZero.setSelected(filterParam.isViewZero());
    }

    public void clear() {
        super.clear();
        try {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
            FMClientHelper.setSelectObject((KDComboBox)this.comboStatus, (Object)FMSysDefinedEnum.SELECT_ALL);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        Calendar cal = Calendar.getInstance();
        cal.set(1, 2000);
        cal.set(2, 0);
        cal.set(5, 1);
        this.dpIssueDate.setValue((Object)cal.getTime());
        this.dpExpiredDate.setValue((Object)DateUtil.getLastDayOfCurMonth());
        this.prmtCreditorGroup.setData(null);
        this.prmtFinProduct.setData(null);
        this.prmtGaranteeType.setData(null);
        this.prmtMarketPlace.setData(null);
    }

    protected void init() throws Exception {
        super.init();
        CurrencyUtil.fillCombCurrency((KDComboBox)this.comboCurrency);
        this.comboCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
        FinHelper.fillCombBillStatus(this.comboStatus);
        this.comboStatus.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        FMClientHelper.setSelectObject((KDComboBox)this.comboStatus, (Object)FMSysDefinedEnum.SELECT_ALL);
        FinUtils.setFinProductF7(this.prmtFinProduct, FinancingBillTypeEnum.BONDS);
        this.companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        Calendar cal = Calendar.getInstance();
        cal.set(1, 2000);
        cal.set(2, 0);
        cal.set(5, 1);
        this.dpIssueDate.setValue((Object)cal.getTime());
        this.dpExpiredDate.setValue((Object)DateUtil.getLastDayOfCurMonth());
    }

    public boolean verify() {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.dpIssueDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.dpExpiredDate);
        if (DateTimeUtils.truncateDate((Date)((Date)this.dpIssueDate.getValue())).after(DateTimeUtils.truncateDate((Date)((Date)this.dpExpiredDate.getValue())))) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"LoanEndDateLaterThanBeginDate"));
            SysUtil.abort();
        }
        return super.verify();
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.prmtFinProduct.setData(null);
        this.prmtMarketPlace.setData(null);
        this.prmtCreditorGroup.setData(null);
        this.prmtGaranteeType.setData(null);
        this.isViewZero.setSelected(false);
    }
}

