/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.cl.ConsignmentLoanBillInfo;
import com.kingdee.eas.fm.cl.ConsignmentLoanBillUpdateFacadeFactory;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.fm.common.SumBillEnum;
import com.kingdee.eas.fm.common.SumFiledsInfo;
import com.kingdee.eas.fm.common.client.DefaultKDTCurrencyProvider;
import com.kingdee.eas.fm.common.client.DefaultKDTablePrecisionFormater;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMCommonSortedDataProvider;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.IKDTPrecisionProvider;
import com.kingdee.eas.fm.common.client.IKDTablePrecisionFormater;
import com.kingdee.eas.fm.common.client.MutexUtils;
import com.kingdee.eas.fm.fin.FinBaseDataException;
import com.kingdee.eas.fm.fin.FinBillStatusEnum;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinClientHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingFeeBillCollection;
import com.kingdee.eas.fm.fin.FinancingFeeBillFactory;
import com.kingdee.eas.fm.fin.FinancingFeeBillInfo;
import com.kingdee.eas.fm.fin.FinancingFeeRourceEnum;
import com.kingdee.eas.fm.fin.FinancingShareEnum;
import com.kingdee.eas.fm.fin.FinancingShareMaintainCollection;
import com.kingdee.eas.fm.fin.FinancingShareMaintainFactory;
import com.kingdee.eas.fm.fin.FinancingShareMaintainInfo;
import com.kingdee.eas.fm.fin.ILoan;
import com.kingdee.eas.fm.fin.ILoanFacade;
import com.kingdee.eas.fm.fin.LoanAdjustInterestCollection;
import com.kingdee.eas.fm.fin.LoanAdjustInterestFactory;
import com.kingdee.eas.fm.fin.LoanCollection;
import com.kingdee.eas.fm.fin.LoanException;
import com.kingdee.eas.fm.fin.LoanFacadeFactory;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.LoanInterestPredictionFacadeFactory;
import com.kingdee.eas.fm.fin.LoanOfIntPayDateEntryInfo;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.RepaymentTypeEnum;
import com.kingdee.eas.fm.fin.client.AbstractBondsListUI;
import com.kingdee.eas.fm.fin.client.BondAdjustInterestEditUI;
import com.kingdee.eas.fm.fin.client.BondClientHelper;
import com.kingdee.eas.fm.fin.client.BondsEditUI;
import com.kingdee.eas.fm.fin.client.BondsFilterParam;
import com.kingdee.eas.fm.fin.client.BondsFilterUI;
import com.kingdee.eas.fm.fin.client.FinancingFeeBillBathUI;
import com.kingdee.eas.fm.fin.client.IRRHelp;
import com.kingdee.eas.fm.fin.rpcoptimize.LoanListUIDataRpc;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.ft.LoanAndRepayEntryFactory;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.IBatchOrgListBiz;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.context.IDelegationSupport;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BondsListUI
extends AbstractBondsListUI
implements IDelegationSupport,
IBatchOrgListBiz {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BondsListUI.class);
    protected BondsFilterUI filterUI = null;
    static final String tdTemplateFile = "/FM/FIN/LOAN";
    LoanListUIDataRpc envirRpc = null;
    public int digits = 2;
    protected CompanyOrgUnitInfo rateCurrentCompany;
    protected CurrencyInfo rateCurrencyInfo;
    protected Map rateMap = new HashMap();
    String MONTH_INTEREST = "month_interest";
    String MONTH_ALANCE = "month_alance";
    String DAY_INT = "day_int";
    Map periodMap = new HashMap();
    Map map = new HashMap();
    String YEAR_RELATIVE = "year_relative";
    String STARTTIME = "startTime";
    String ENDTIME = "endTime";
    String YEAR_INTEREST = "year_interest";
    String YEAR_ALANCE = "year_alance";
    private static boolean FIN022 = false;
    private IKDTablePrecisionFormater precFormater = new DefaultKDTablePrecisionFormater();

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)new FillListener());
    }

    public BondsListUI() throws Exception {
        this.precFormater.setPrecProvider((IKDTPrecisionProvider)new DefaultKDTCurrencyProvider(this.getCurrencyIdColName()));
    }

    protected boolean isRpcCacheProcess() {
        return true;
    }

    protected FmRpcCacheInfo getRpcCacheParam() {
        LoanListUIDataRpc cacheInfo = new LoanListUIDataRpc();
        cacheInfo.setBatchImplClassName(this.getRpcBatchImplClassName());
        return cacheInfo;
    }

    protected String getRpcBatchImplClassName() {
        return "com.kingdee.eas.fm.fin.rpcoptimize.LoanListUIDataRpcFetcher";
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemCreateTo.setIcon(EASResource.getIcon((String)"imgTbtn_requite"));
        this.btnCreateTo.setIcon(EASResource.getIcon((String)"imgTbtn_requite"));
        this.actionAddHisBondsContrat.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_historyedition"));
        this.actionAddHisBondsContrat.setEnabled(true);
        this.actionCopy.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_copy"));
        this.actionViewBgBalance.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_inquirebudget"));
        this.actionReCalcPrediction.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_compute"));
        this.actionBatchSubmit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionGenRecBill.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_releasebymodule"));
        this.actionBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_discount"));
        this.actionCancelBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_canceldiscount"));
        this.actionFinFeeShare.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_handworkcollate"));
        this.actionFinFeeUnShare.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fallotpopedomforbid"));
        this.actionAdjRate.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_backwarddepreciat"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        this.actionFinFee.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_modifyformat"));
        this.actionImportRepayPlan.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_importexcel"));
        this.actionCreateTo.setEnabled(false);
        this.actionBatchSubmit.setEnabled(true);
        this.actionAudit.setEnabled(true);
        this.actionAntiAudit.setEnabled(true);
        this.actionTDPrint.setEnabled(true);
        this.actionTDPrintPreview.setEnabled(true);
        int val = this.envirRpc.getPatam_CS001();
        boolean isBillBook = val == 0;
        this.actionBook.setVisible(isBillBook);
        this.actionCancelBook.setVisible(isBillBook);
        this.btnCancelBook.setVisible(false);
        this.actionViewBgBalance.setEnabled(true);
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany())) {
            this.actionFinFee.setEnabled(false);
            this.actionFinFee.setVisible(false);
            this.actionGenRecBill.setEnabled(false);
            this.actionGenRecBill.setVisible(false);
        } else {
            this.actionFinFee.setEnabled(true);
            this.actionGenRecBill.setEnabled(true);
            this.actionGenRecBill.setVisible(true);
        }
        this.actionFinFeeShare.setEnabled(true);
        this.actionFinFeeUnShare.setEnabled(true);
        this.actionAdjRate.setEnabled(true);
        this.actionReCalcPrediction.setEnabled(true);
        this.actionImportRepayPlan.setEnabled(true);
        this.actionAddHisBondsContrat.setEnabled(true);
    }

    protected String getEditUIName() {
        return BondsEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LoanFactory.getRemoteInstance();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new BondsFilterUI();
        }
        return this.filterUI;
    }

    @Override
    protected void checkBizUnit() throws EASBizException, BOSException {
        super.checkBizUnit();
        if (!"FINDVIEW".equalsIgnoreCase(this.getOprtState())) {
            FMClientHelper.hideIfBizUnitCompany((KDTable)this.tblMain, (String)"company.name");
        }
        if (this.envirRpc.getIsUnion().booleanValue()) {
            this.btnCreateTo.setVisible(false);
            this.menuItemCreateTo.setVisible(false);
        } else {
            this.btnCreateTo.setVisible(true);
            this.menuItemCreateTo.setVisible(true);
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        SelectorItemCollection select = new SelectorItemCollection();
        select.add("id");
        select.add("status");
        select.add("fiVouchered");
        select.add("cashier");
        String selectedKeyValue = this.getSelectedKeyValue();
        if (selectedKeyValue == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)selectedKeyValue));
        LoanInfo info = (LoanInfo)this.getBizInterface().getValue((IObjectPK)pk, select);
        if (info.isFiVouchered()) {
            this.actionVoucher.setEnabled(false);
            this.actionDelVoucher.setEnabled(true);
        } else {
            this.actionVoucher.setEnabled(FinBillStatusEnum.AUDITED.equals((Object)info.getStatus()));
            this.actionDelVoucher.setEnabled(false);
        }
        if (info.getStatus().equals((Object)FinBillStatusEnum.SAVE)) {
            this.actionVoucher.setEnabled(false);
            this.actionDelVoucher.setEnabled(false);
        }
        boolean isBook = info.getCashier() == null;
        this.actionBook.setEnabled(isBook);
        this.actionCancelBook.setEnabled(!isBook);
    }

    public String[] getMergeColumnKeys() {
        return new String[0];
    }

    @Override
    protected String getCurrencyIdColName() {
        return "CurrencyId";
    }

    @Override
    protected String[] getPrecColName() {
        return new String[]{"seeAlso", "planIssuanceAmt", "Amount", "Balance", "intFreeAmt", "cautionAmt"};
    }

    protected String[] getSumColName() {
        return new String[]{"Amount", "Balance", "cautionAmt"};
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String keyValue = this.getSelectedKeyValue();
        if (keyValue == null) {
            return;
        }
        LoanInfo info = LoanFactory.getRemoteInstance().getLoanInfo((IObjectPK)new ObjectUuidPK(keyValue));
        if (info.getBalance().compareTo(SysConstant.BIGZERO) == 0) {
            throw new FinBizException(FinBizException.BALANCEISZERO);
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        boolean resultRequest = iMutex.requestBizObjIDForUpdate(keyValue);
        if (!resultRequest) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"512_BillLocked"));
            this.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkCreateTo();
        String id = this.getSelectedKeyValue();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        boolean resultRequest = iMutex.requestBizObjIDForUpdate(id);
        if (!resultRequest) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"512_BillLocked"));
            this.abort();
        }
        try {
            LoanInfo info = LoanFactory.getRemoteInstance().getLoanInfo(ConvertUtils.PK((Object)id));
            BondClientHelper.generateDestBillForCompany(ConvertUtils.IDSTR((Object)info.getCompany()), (CoreBillListUI)this, LoanInfo.BOSTYPE.toString(), RepaymentInfo.BOSTYPE.toString(), id);
        }
        catch (Exception ex) {
            iMutex.releaseObjIDForUpdate(id);
            throw ex;
        }
    }

    private void checkCreateTo() throws Exception {
        String id;
        if (this.getSelectedIdValues().size() > 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"278_BondsListUI"));
            this.abort();
        }
        if ((id = this.getSelectedKeyValue()) != null) {
            LoanInfo info = LoanFactory.getRemoteInstance().getLoanInfo((IObjectPK)new ObjectUuidPK(id));
            if (info.getStatus().equals((Object)FinBillStatusEnum.SAVE)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"339_LoanListUI"));
                this.abort();
            }
            if (info.getStatus().equals((Object)FinBillStatusEnum.SUBMIT)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"340_LoanListUI"));
                this.abort();
            }
            this.checkBalance(info);
            if (info.getEntLoanID() != null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"280_LoanDeferListUI"));
                this.abort();
            }
        }
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("IsBankLoan"));
        sic.add(new SelectorItemInfo("CreditorGroup.name"));
        sic.add(new SelectorItemInfo("RepaymentType"));
        sic.add(new SelectorItemInfo("yearDays"));
        sic.add(new SelectorItemInfo("contractNum"));
        sic.add(new SelectorItemInfo("intFreeAmt"));
        sic.add(new SelectorItemInfo("intRateTypeExpression"));
        sic.add(new SelectorItemInfo("penAccrualType"));
        sic.add(new SelectorItemInfo("penAccrualRate"));
        sic.add(new SelectorItemInfo("cautionAmt"));
        sic.add(new SelectorItemInfo("auctionPerc"));
        sic.add(new SelectorItemInfo("repaymentSource"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("depositary.*"));
        sic.add(new SelectorItemInfo("costCenter.*"));
        sic.add(new SelectorItemInfo("depositary.name"));
        sic.add(new SelectorItemInfo("depositary.number"));
        sic.add(new SelectorItemInfo("depositary.id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("GroupID.id"));
        sic.add(new SelectorItemInfo("GroupID.name"));
        sic.add(new SelectorItemInfo("Institution.id"));
        sic.add(new SelectorItemInfo("Institution.name"));
        sic.add(new SelectorItemInfo("Currency.id"));
        sic.add(new SelectorItemInfo("Currency.name"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("LoanAcct.id"));
        sic.add(new SelectorItemInfo("LoanAcct.name"));
        sic.add(new SelectorItemInfo("LoanAcct.number"));
        sic.add(new SelectorItemInfo("BankAcct.account.id"));
        sic.add(new SelectorItemInfo("BankAcct.account.name"));
        sic.add(new SelectorItemInfo("BankAcct.account.number"));
        sic.add(new SelectorItemInfo("Institution.id"));
        sic.add(new SelectorItemInfo("Institution.number"));
        sic.add(new SelectorItemInfo("Institution.name"));
        sic.add(new SelectorItemInfo("GroupID.id"));
        sic.add(new SelectorItemInfo("GroupID.number"));
        sic.add(new SelectorItemInfo("GroupID.name"));
        return sic;
    }

    public void setListUITable(KDTable tblMain, KDTDataRequestEvent e) throws EASBizException, BOSException {
        Object currencyId = null;
        if (e == null) {
            return;
        }
        HashSet<String> idSet = new HashSet<String>();
        for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
            idSet.add(tblMain.getRow(i).getCell("id").getValue().toString());
        }
        Date now = DateUtil.getDayBegin();
        Map<String, BigDecimal> intRateMap = FinHelper.getRateMap(idSet);
        int count = e.getLastRow();
        for (int i = e.getFirstRow(); i <= count; ++i) {
            String rateExpression;
            IRow row2 = tblMain.getRow(i);
            int ratePrec = 2;
            int newRatePrec = 2;
            String ID = row2.getCell("id").getValue().toString();
            BigDecimal o = intRateMap.get(ID);
            BizEnumValueInfo exp = (BizEnumValueInfo)row2.getCell("intRateTypeExpression").getValue();
            BigDecimal rate = (BigDecimal)row2.getCell("YieldRate").getValue();
            ratePrec = this.getRatePrecision(rate);
            StringBuffer sbRateFormat = new StringBuffer(FMClientHelper.getNumberFtm((int)ratePrec));
            StringBuffer sbNewRateFormat = new StringBuffer(FMClientHelper.getNumberFtm((int)newRatePrec));
            if (exp == null || (rateExpression = exp.getValue().toString()) == null) continue;
            if (rateExpression.equals("year")) {
                sbRateFormat.append("\\%");
                row2.getCell("YieldRate").getStyleAttributes().setNumberFormat(sbRateFormat.toString());
                continue;
            }
            sbRateFormat.append("\\\u2030");
            row2.getCell("YieldRate").getStyleAttributes().setNumberFormat(sbRateFormat.toString());
        }
        tblMain.getColumn("AmountLocalCur").getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
        tblMain.getColumn("AmountLocalCur").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    private int getRatePrecision(BigDecimal rate) {
        int prec = 0;
        if (rate == null) {
            return prec;
        }
        String strRate = rate.stripTrailingZeros().toPlainString();
        int len = strRate.length();
        int index = strRate.indexOf(".");
        if (index < 0) {
            return prec;
        }
        prec = len - index - 1;
        return prec;
    }

    @Override
    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanVoucher(1);
        super.actionDelVoucher_actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanVoucher(0);
        String id = this.getSelectedKeyValue();
        ArrayList idList = this.getSelectedIdValues();
        HashSet idSet = new HashSet(idList);
        LoanCollection col = this.getLoanColl(idSet);
        for (int i = 0; i < col.size(); ++i) {
            LoanInfo info = col.get(i);
            if (info == null || !info.getStatus().equals((Object)FinBillStatusEnum.SAVE)) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"279_BondsListUI"));
            this.abort();
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        boolean resultRequest = iMutex.requestBizObjIDForUpdate(id);
        if (!resultRequest) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"512_BillLocked"));
            SysUtil.abort();
        }
        try {
            super.actionVoucher_actionPerformed(e);
        }
        finally {
            iMutex.releaseObjIDForUpdate(id);
        }
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"COPY", (Object)"COPY");
        this.prepareUIContext(uiContext, e);
        uiContext.put((Object)"IDList", null);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    public void actionCopyTo_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"COPY", (Object)"COPY");
        this.prepareUIContext(uiContext, e);
        uiContext.put((Object)"IDList", null);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    private void checkCanVoucher(int type) throws Exception {
        this.checkSelected();
        LoanInfo loanInfo = LoanFactory.getRemoteInstance().getLoanInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        if (0 == type ? loanInfo.isHistoryBill() : 1 == type && loanInfo.isHistoryBill()) {
            throw new LoanException(LoanException.CHLOANISNOTVOUCHER);
        }
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        ItemAction action = this.getActionFromActionEvent(e);
        if (action.equals(this.actionEdit)) {
            uiContext.put((Object)"editScope", (Object)"");
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        Set idSet;
        String srcBillId;
        int adjustSeq;
        this.checkSelected();
        String keyValue = this.getSelectedKeyValue();
        if (keyValue == null) {
            return;
        }
        LoanInfo info = LoanFactory.getRemoteInstance().getLoanInfo((IObjectPK)new ObjectUuidPK(keyValue));
        if (info.isIsGenRecBill()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"280_BondsListUI"));
            SysUtil.abort();
        }
        if (info.getStatus().equals((Object)FinBillStatusEnum.AUDITED)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"281_BondsListUI"));
            SysUtil.abort();
        }
        if (info.getMainConLoan() != null) {
            int seq = LoanFactory.getRemoteInstance().getSeq((IObjectPK)new ObjectUuidPK(info.getMainConLoan().getId().toString()));
            if (info.getSeqMulCon() != seq) {
                throw new FinBizException(FinBizException.MUSTFLOWSEQ);
            }
        }
        if (info.getCashier() != null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"282_BondsListUI"));
            SysUtil.abort();
        }
        if ((adjustSeq = LoanFactory.getRemoteInstance().getAdjust((IObjectPK)new ObjectUuidPK(info.getId().toString()))) > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"283_BondsListUI"));
            SysUtil.abort();
        }
        if ((srcBillId = info.getSourceBillId()) != null && FinUtils.type_payableBill.equals((Object)BOSUuid.read((String)srcBillId).getType())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"284_BondsListUI"));
            SysUtil.abort();
        }
        if ((idSet = FMHelper.getDestBillIdSet(null, (String)info.getId().toString())).size() > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"285_BondsListUI"));
            SysUtil.abort();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("loan", (Object)info.getId()));
        if (LoanAndRepayEntryFactory.getRemoteInstance().exists(filter)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"286_BondsListUI"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
        if (srcBillId != null) {
            BOSObjectType bt = BOSUuid.read((String)info.getSourceBillId()).getType();
            if (new ConsignmentLoanBillInfo().getBOSType().equals((Object)bt)) {
                ConsignmentLoanBillUpdateFacadeFactory.getRemoteInstance().updateColumn("FMakeLoanAnnal", "0", info.getSourceBillId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionBook_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkIsHistoryBill();
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        ArrayList<String> ids = new ArrayList<String>();
        BizEnumValueDTO status = null;
        for (int i = 0; i < indexs.length; ++i) {
            row = this.tblMain.getRow(indexs[i]);
            status = (BizEnumValueDTO)row.getCell("status").getValue();
            if (status.getInt() != 3) continue;
            ids.add(row.getCell("id").getValue().toString());
        }
        if (ids.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"287_BondsListUI"));
            SysUtil.abort();
        }
        ArrayList<String> lockIds = new ArrayList<String>();
        try {
            int result;
            IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
            for (int i = 0; i < ids.size(); ++i) {
                boolean resultRequest = iMutex.requestBizObjIDForUpdate((String)ids.get(i));
                if (!resultRequest) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"512_BillLocked"));
                    SysUtil.abort();
                }
                lockIds.add((String)ids.get(i));
            }
            if (ids.size() == indexs.length) {
                ILoanFacade facade = LoanFacadeFactory.getRemoteInstance();
                facade.book(ids);
                this.showMsg(e);
            } else if (ids.size() < indexs.length && (result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"343_LoanListUI"))) == 0) {
                ILoanFacade facade = LoanFacadeFactory.getRemoteInstance();
                facade.book(ids);
                this.showMsg(e);
            }
        }
        finally {
            if (!EmptyUtil.isEmpty(lockIds)) {
                MutexUtils.releaseMutex(lockIds);
            }
        }
    }

    private void checkIsHistoryBill() throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        HashSet idSet = new HashSet(idList);
        LoanCollection col = this.getLoanColl(idSet);
        for (int i = 0; i < col.size(); ++i) {
            LoanInfo info = col.get(i);
            if (info == null || !info.isHistoryBill()) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"288_BondsListUI"));
            this.abort();
        }
    }

    @Override
    public void actionCancelBook_actionPerformed(ActionEvent e) throws Exception {
        int result;
        this.checkSelected();
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        ArrayList<String> ids = new ArrayList<String>();
        Object cashier = null;
        for (int i = 0; i < indexs.length; ++i) {
            row = this.tblMain.getRow(indexs[i]);
            cashier = row.getCell("cashier.name").getValue();
            if (cashier == null) continue;
            ids.add(row.getCell("id").getValue().toString());
        }
        if (ids.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"344_LoanListUI"));
            SysUtil.abort();
        } else if (ids.size() == indexs.length) {
            ILoanFacade facade = LoanFacadeFactory.getRemoteInstance();
            facade.cancelBook(ids);
            this.showMsg(e);
        } else if (ids.size() < indexs.length && (result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"345_LoanListUI"))) == 0) {
            ILoanFacade facade = LoanFacadeFactory.getRemoteInstance();
            facade.cancelBook(ids);
            this.showMsg(e);
        }
    }

    private void showMsg(ActionEvent e) throws Exception {
        this.refresh(e);
        FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e);
    }

    @Override
    public void onLoad() throws Exception {
        this.envirRpc = (LoanListUIDataRpc)this.rpcCacheInfo;
        FIN022 = ContextHelperFactory.getRemoteInstance().getBooleanParam("FIN022", (IObjectPK)new ObjectUuidPK(this.envirRpc.getCurrentCompany().getId()));
        this.precFormater.init(this.getMainTable(), this.getPrecColName());
        super.onLoad();
        this.initTable();
        IColumn yearDaysColumn = this.tblMain.getColumn("yearDays");
        yearDaysColumn.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.actionAttachment.setVisible(true);
        String dformat = CtrlFormatUtilities.getDateFormatString();
        this.tblMain.getColumn("bizDate").getStyleAttributes().setNumberFormat(dformat);
        this.tblMain.getColumn("IssueDate").getStyleAttributes().setNumberFormat(dformat);
        this.tblMain.getColumn("ExpiredDate").getStyleAttributes().setNumberFormat(dformat);
        this.actionEdit.setEnabled(true);
        this.actionRemove.setEnabled(true);
        this.actionCreateTo.setEnabled(true);
        this.actionVoucher.setEnabled(true);
        this.actionDelVoucher.setEnabled(true);
        this.btnVoucher.setEnabled(true);
        this.btnDelVoucher.setEnabled(true);
        this.actionEdit.setVisible(true);
        this.actionRemove.setVisible(true);
        this.actionCreateTo.setVisible(true);
        this.actionVoucher.setVisible(true);
        this.actionDelVoucher.setVisible(true);
        this.btnVoucher.setVisible(true);
        this.btnDelVoucher.setVisible(true);
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany())) {
            this.actionAddNew.setEnabled(false);
            this.actionAddNew.setVisible(false);
        } else {
            this.actionAddNew.setEnabled(true);
            this.actionAddNew.setVisible(true);
        }
        this.refresh(null);
    }

    @Override
    public void actionViewBgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        if (id != null) {
            FMClientHelper.viewBgBalance4ListUI((Component)((Object)this), (String)id);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("fpItem.id"));
        sic.add(new SelectorItemInfo("fpItem.number"));
        sic.add(new SelectorItemInfo("fpItem.name"));
        sic.add(new SelectorItemInfo("LoanAcct.id"));
        sic.add(new SelectorItemInfo("LoanAcct.name"));
        sic.add(new SelectorItemInfo("LoanAcct.number"));
        sic.add(new SelectorItemInfo("BankAcct.bankAccountNumber"));
        sic.add(new SelectorItemInfo("BankAcct.number"));
        sic.add(new SelectorItemInfo("BankAcct.name"));
        sic.add(new SelectorItemInfo("BankAcct.account.id"));
        sic.add(new SelectorItemInfo("BankAcct.account.name"));
        sic.add(new SelectorItemInfo("BankAcct.account.number"));
        sic.add(new SelectorItemInfo("GroupID.id"));
        sic.add(new SelectorItemInfo("GroupID.number"));
        sic.add(new SelectorItemInfo("GroupID.name"));
        sic.add(new SelectorItemInfo("depositary.id"));
        sic.add(new SelectorItemInfo("depositary.number"));
        sic.add(new SelectorItemInfo("depositary.name"));
        sic.add("outBgItemId");
        sic.add("outBgItemNumber");
        sic.add("outBgItemName");
        return sic;
    }

    @Override
    public void actionAddHisBondsContrat_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        this.prepareUIContext(uiContext, e);
        uiContext.put((Object)"IDList", null);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create("com.kingdee.eas.fm.fin.client.HisBondsContractEditUI", (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void actionReCalcPrediction_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() <= 0) {
            return;
        }
        HashSet idSet = new HashSet(idList);
        Set intIDSet = LoanInterestPredictionFacadeFactory.getRemoteInstance().genLoanInterestPredictionFromListUI(idSet);
        if (intIDSet != null && intIDSet.size() <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"346_LoanListUI"));
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"347_LoanListUI"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        int i;
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() <= 0) {
            return;
        }
        HashSet idSet = new HashSet(idList);
        LoanCollection col = this.getLoanColl(idSet);
        for (int i2 = 0; i2 < col.size(); ++i2) {
            LoanInfo info = col.get(i2);
            if (info.getStatus() == FinBillStatusEnum.SAVE || info.getStatus() == FinBillStatusEnum.SUBMIT) {
                throw new LoanException(LoanException.ANTIAUDIT_BILL_ERROR, new Object[]{info.getNumber()});
            }
            if (!FinHelper.hasIntRecordOfLoan(info.getId().toString()) || !FinHelper.hasRepaymentOfLoan(info.getId().toString()) || info.isIsGenRecBill()) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"289_BondsListUI"));
                this.abort();
            }
            if (!this.isLoanAdjustInterest(info.getId().toString())) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"290_BondsListUI"));
            this.abort();
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        for (i = 0; i < idList.size(); ++i) {
            boolean resultRequest = iMutex.requestBizObjIDForUpdate((String)idList.get(i));
            if (resultRequest) continue;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"512_BillLocked"));
            SysUtil.abort();
        }
        for (i = 0; i < idList.size(); ++i) {
            LoanInfo info = LoanFactory.getRemoteInstance().getLoanInfo((IObjectPK)new ObjectUuidPK(idList.get(i).toString()));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("loan", (Object)info.getId()));
            if (!FinancingShareMaintainFactory.getRemoteInstance().exists(filter)) continue;
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"291_BondsListUI"));
            this.abort();
        }
        try {
            LoanFactory.getRemoteInstance().batchAntiAudit(idSet);
            this.showMsg(e);
            this.refreshList();
        }
        finally {
            MutexUtils.releaseMutex((List)idList);
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() <= 0) {
            return;
        }
        boolean idsInProcess = FMHelper.hasWFInstance(null, (List)idList);
        if (idsInProcess) {
            this.actionMultiapprove_actionPerformed(e);
            return;
        }
        HashSet idSet = new HashSet(idList);
        LoanCollection col = this.getLoanColl(idSet);
        for (int i = 0; i < col.size(); ++i) {
            LoanInfo info = col.get(i);
            if (info.getStatus() != FinBillStatusEnum.SAVE && info.getStatus() != FinBillStatusEnum.AUDITED) continue;
            throw new LoanException(LoanException.AUDIT_BILL_ERROR, new Object[]{info.getNumber()});
        }
        LoanFactory.getRemoteInstance().batchAudit(idSet);
        this.showMsg(e);
    }

    protected LoanCollection getLoanColl(Set idSet) throws BOSException, Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        return ((ILoan)this.getBizInterface()).getLoanCollection(evi);
    }

    @Override
    public void actionBatchSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() <= 0) {
            return;
        }
        HashSet idSet = new HashSet(idList);
        LoanCollection col = this.getLoanColl(idSet);
        for (int i = 0; i < col.size(); ++i) {
            LoanInfo info = col.get(i);
            if (info.getStatus() != FinBillStatusEnum.SUBMIT && info.getStatus() != FinBillStatusEnum.AUDITED) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"349_LoanListUI"));
            this.abort();
        }
        LoanFactory.getRemoteInstance().batchSubmit(idSet);
        this.refreshList();
    }

    @Override
    public FilterInfo getFilterInfo() {
        FilterInfo filter = super.getFilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(3)));
        filter.setMaskString("#0 and #1 and #2");
        logger.error((Object)("\u501f\u6b3e\u8fd8\u6b3e\u62c9\u501f\u6b3e\u5355Filter\uff1a" + filter));
        return filter;
    }

    protected void execQuery() {
        try {
            FilterInfo extFilter = this.getBillCanbeReceived();
            FilterInfo mainInfo = new FilterInfo();
            StringBuffer maskString = new StringBuffer();
            if (extFilter != null && extFilter.getFilterItems().size() > 0) {
                if (this.getBOTPViewStatus() == 1) {
                    int i;
                    for (i = 0; i < this.mainQuery.getFilter().getFilterItems().size(); ++i) {
                        if ("company.id".equals(this.mainQuery.getFilter().getFilterItems().get(i).getPropertyName())) continue;
                        mainInfo.getFilterItems().add(this.mainQuery.getFilter().getFilterItems().get(i));
                    }
                    for (i = 0; i < mainInfo.getFilterItems().size(); ++i) {
                        if (i == mainInfo.getFilterItems().size() - 2) {
                            maskString.append("(#" + i + " or ");
                            continue;
                        }
                        if (i == mainInfo.getFilterItems().size() - 1) {
                            maskString.append("#" + i + ")");
                            continue;
                        }
                        maskString.append("#" + i + " and ");
                    }
                    mainInfo.setMaskString(maskString.toString());
                    this.mainQuery.setFilter(mainInfo);
                }
                this.mainQuery.getFilter().mergeFilter(extFilter, "AND");
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e.getCause());
        }
        super.execQuery();
        this.formatFootRow();
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    private FilterInfo getBillCanbeReceived() {
        FilterInfo f = new FilterInfo();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null) {
            Map btpeditparameter = (Map)this.getUIContext().get("BTPEDITPARAMETER");
            String targetBillType = (String)btpeditparameter.get("TargetBillType");
            if (targetBillType != null && "ReceivingBill".equals(targetBillType)) {
                f.getFilterItems().add(ConvertUtils.FITEM((Object[])new Object[]{"company.id", ConvertUtils.PSTR((String)"ARAPCOMPANY.id", (Object)btpeditparameter)}));
                f.getFilterItems().add(new FilterItemInfo("cashier.id", null, CompareType.EQUALS));
                f.getFilterItems().add(new FilterItemInfo("isGenRecBill", (Object)Boolean.FALSE));
                f.getFilterItems().add(new FilterItemInfo("Balance", (Object)Constants.ZERO, CompareType.GREATER));
                f.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(3)));
            }
            if (targetBillType != null && "AssureAmount".equals(targetBillType)) {
                CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
                f.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentCompany.getId().toString()));
            }
        }
        return f;
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.formatFootRow();
    }

    private void formatFootRow() {
        try {
            BondsFilterParam param = (BondsFilterParam)((Object)this.getFilterUI().getParam());
            if (this.tblMain.getFootManager() == null) {
                return;
            }
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrencyId() == null ? this.currentCompanyCommon.getBaseCurrency().getId().toString() : AccessHelper.getId((Object)param.getCurrencyId());
            String[] stringArray = new SumFiledsInfo(SumBillEnum.FinLoan).getSumFileds();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void actionGenRecBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkGenRecBill();
        String id = this.getSelectedKeyValue();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        boolean resultRequest = iMutex.requestBizObjIDForUpdate(id);
        if (!resultRequest) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"512_BillLocked"));
            SysUtil.abort();
        }
        try {
            CtrlUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
            FMClientHelper.generateDestBillWithCU((CtrlUnitInfo)orgUnitInfo, (CoreBillListUI)this, (String)LoanInfo.BOSTYPE.toString(), (String)new ReceivingBillInfo().getBOSType().toString(), (String)id);
        }
        catch (Exception ex) {
            iMutex.releaseObjIDForUpdate(id);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionFinFee_actionPerformed(ActionEvent e) throws Exception {
        IMutexServiceControl iMutex;
        boolean resultRequest;
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        LoanInfo info = (LoanInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
        if (!info.getStatus().equals((Object)FinBillStatusEnum.SUBMIT) && !info.getStatus().equals((Object)FinBillStatusEnum.AUDITED)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"293_BondsListUI"));
            SysUtil.abort();
        }
        if (!(resultRequest = (iMutex = MutexServiceControlFactory.getRemoteInstance()).requestBizObjIDForUpdate(id))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"512_BillLocked"));
            SysUtil.abort();
        }
        try {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"id", (Object)info.getId().toString());
            uiContext.put((Object)"FinancingProduct", (Object)info.getType());
            uiContext.put((Object)"sourceBillNm", (Object)info.getNumber());
            uiContext.put((Object)"sourceBillType", (Object)FinancingFeeRourceEnum.Loan);
            IUIWindow uiWindow = null;
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(FinancingFeeBillBathUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
        finally {
            iMutex.releaseObjIDForUpdate(id);
        }
    }

    private void checkGenRecBill() throws Exception {
        this.checkSelected();
        LoanInfo loanInfo = LoanFactory.getRemoteInstance().getLoanInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        if (loanInfo.getCashier() != null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"294_BondsListUI"));
            SysUtil.abort();
        }
        if (loanInfo.isIsGenRecBill()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"295_BondsListUI"));
            SysUtil.abort();
        }
        if (loanInfo.getStatus() != FinBillStatusEnum.AUDITED) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"296_BondsListUI"));
            SysUtil.abort();
        }
        if (loanInfo.getBalance().compareTo(Constants.ZERO) <= 0 && loanInfo.getStatus() != FinBillStatusEnum.SUBMIT) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"297_BondsListUI"));
            SysUtil.abort();
        }
        if (loanInfo.isHistoryBill()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"350_LoanListUI"));
            SysUtil.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionAdjRate_actionPerformed(ActionEvent e) throws Exception {
        this.adjustRateCheck();
        String id = this.getSelectedKeyValue();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        boolean resultRequest = iMutex.requestBizObjIDForUpdate(id);
        if (!resultRequest) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"512_BillLocked"));
            SysUtil.abort();
        }
        try {
            BondAdjustInterestEditUI.show((CoreUIObject)this, (IObjectPK)new ObjectUuidPK(id));
        }
        finally {
            iMutex.releaseObjIDForUpdate(id);
        }
        BigDecimal newRate = FinClientHelper.getRateMap(id);
        if (newRate != null) {
            this.envirRpc.getIntRateMap().put(id, newRate);
        }
        this.refresh(e);
    }

    private void adjustRateCheck() throws Exception {
        this.checkSelected();
        LoanInfo info = LoanFactory.getRemoteInstance().getLoanInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        this.checkStatus(info);
        this.checkBalance(info);
    }

    private void checkBalance(LoanInfo info) {
        if (info.getBalance().compareTo(Constants.ZERO) <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"298_BondsListUI"));
            SysUtil.abort();
        }
    }

    public boolean isLoanAdjustInterest(String loanId) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("loan", (Object)loanId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        LoanAdjustInterestCollection coll = LoanAdjustInterestFactory.getRemoteInstance().getLoanAdjustInterestCollection(evi);
        return !EmptyUtil.isEmpty((AbstractObjectCollection)coll);
    }

    private void checkStatus(LoanInfo loanInfo) {
        if (loanInfo.getStatus() == FinBillStatusEnum.SAVE || loanInfo.getStatus() == FinBillStatusEnum.SUBMIT) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"299_BondsListUI"));
            SysUtil.abort();
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    private void initTable() {
        if (this.currentCompanyCommon != null && this.currentCompanyCommon.getBaseCurrency() != null) {
            FMClientHelper.setNumberFormat((KDTable)this.tblMain, (String[])this.getSumColName(), (String)FMClientHelper.getNumberFtm((int)FMClientHelper.getPrecOfCurrency((BOSUuid)this.currentCompanyCommon.getBaseCurrency().getId())));
        }
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(false);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(true);
    }

    private void tdPrint(boolean isPreview) {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        FMCommonSortedDataProvider data = new FMCommonSortedDataProvider((List)idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        if (isPreview) {
            appHlp.printPreview(tdTemplateFile, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.print(tdTemplateFile, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fm.fin.BondsQuery");
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    @Override
    public void actionFinFeeShare_actionPerformed(ActionEvent e) throws Exception {
        String keyValue;
        if (this.getSelectedIdValues().size() > 1) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"639_FinancingShare"));
            this.abort();
        }
        if ((keyValue = this.getSelectedKeyValue()) == null) {
            return;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("intPayDateEntrys.id"));
        selector.add(new SelectorItemInfo("intPayDateEntrys.PayDate"));
        selector.add(new SelectorItemInfo("intPayDateEntrys.seq"));
        LoanInfo info = LoanFactory.getRemoteInstance().getLoanInfo((IObjectPK)new ObjectUuidPK(keyValue), selector);
        if (!info.getStatus().equals((Object)FinBillStatusEnum.AUDITED)) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"300_BondsListUI"));
            this.abort();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("loan", (Object)info.getId()));
        if (FinancingShareMaintainFactory.getRemoteInstance().exists(filter)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"641_FinancingShare"));
            this.abort();
        }
        PeriodCollection coll = PeriodFactory.getRemoteInstance().getPeriodCollection();
        for (int i = 0; i < coll.size(); ++i) {
            PeriodInfo PeriodInfo_info = coll.get(i);
            this.periodMap.put(Integer.toString(PeriodInfo_info.getNumber()), PeriodInfo_info);
        }
        int year_int_start = DateTimeUtils.getYear((Date)info.getIssueDate());
        int month_int_start = DateTimeUtils.getMonth((Date)info.getIssueDate());
        int year_int_end = DateTimeUtils.getYear((Date)info.getExpiredDate());
        int month_int_end = DateTimeUtils.getMonth((Date)info.getExpiredDate());
        String period_int_start = month_int_start < 10 ? Integer.toString(year_int_start) + "0" + Integer.toString(month_int_start) : Integer.toString(year_int_start) + Integer.toString(month_int_start);
        String period_int_end = month_int_end < 10 ? Integer.toString(year_int_end) + "0" + Integer.toString(month_int_end) : Integer.toString(year_int_end) + Integer.toString(month_int_end);
        if (this.periodMap.get(period_int_start) == null) {
            MsgBox.showError((String)(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"642_FinancingShare") + period_int_start));
            this.abort();
        }
        if (this.periodMap.get(period_int_end) == null) {
            MsgBox.showError((String)(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"642_FinancingShare") + period_int_end));
            this.abort();
        }
        if (info != null && info.getId() != null) {
            String flag_result = this.share(info);
            if (flag_result != null && flag_result.equals("0001")) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"643_FinancingShare"));
                super.actionRefresh_actionPerformed(e);
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"644_FinancingShare"));
            }
        }
    }

    @Override
    public void actionFinFeeUnShare_actionPerformed(ActionEvent e) throws Exception {
        String keyValue;
        if (this.getSelectedIdValues().size() > 1) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"645_FinancingShare"));
            this.abort();
        }
        if ((keyValue = this.getSelectedKeyValue()) == null) {
            return;
        }
        LoanInfo info = LoanFactory.getRemoteInstance().getLoanInfo((IObjectPK)new ObjectUuidPK(keyValue));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("loan", (Object)info.getId()));
        if (!FinancingShareMaintainFactory.getRemoteInstance().exists(filter)) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"646_FinancingShare"));
            this.abort();
        } else {
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)2));
            filter.getFilterItems().add(new FilterItemInfo("Fivouchered", (Object)1));
            filter.setMaskString("#0 and (#1 or #2)");
            if (FinancingShareMaintainFactory.getRemoteInstance().exists(filter)) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"647_FinancingShare"));
                this.abort();
            } else {
                FilterInfo filter1 = new FilterInfo();
                filter1.getFilterItems().add(new FilterItemInfo("loan", (Object)info.getId()));
                EntityViewInfo view = new EntityViewInfo();
                view.setFilter(filter1);
                FinancingShareMaintainCollection coll = FinancingShareMaintainFactory.getRemoteInstance().getFinancingShareMaintainCollection(view);
                FinancingShareMaintainInfo fInfo = null;
                if (coll.size() > 0) {
                    for (int i = 0; i < coll.size(); ++i) {
                        fInfo = coll.get(i);
                        String did = fInfo.getId().toString();
                        IBOTRelation botRelation = BOTRelationFactory.getRemoteInstance();
                        botRelation.removeRelationByDestObjId(did, info.getBOSType().toString());
                    }
                }
                FinancingShareMaintainFactory.getRemoteInstance().delete(filter1);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("isloanshare"));
                info.put("isloanshare", Boolean.FALSE);
                LoanFactory.getRemoteInstance().updatePartial((CoreBaseInfo)info, selector);
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"648_FinancingShare"));
                super.actionRefresh_actionPerformed(e);
            }
        }
    }

    public String share(LoanInfo loan) throws BOSException, EASBizException {
        String result = "0000";
        this.rateCurrentCompany = loan.getCompany();
        this.rateCurrencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(loan.getCurrency().getId()));
        BigDecimal financing_amount = this.getFinancing_Amount(loan);
        if (loan.getAmount() != null) {
            this.createTable(loan, financing_amount);
            result = "0001";
        } else {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"301_BondsListUI"));
            this.abort();
        }
        return result;
    }

    private void createTable(LoanInfo loan, BigDecimal financing_amount) throws BOSException, EASBizException {
        HashMap<Integer, Date> LoanOfIntPayDate = new HashMap<Integer, Date>();
        BigDecimal yearRate = loan.getYieldRate();
        for (int i = 0; i < loan.getIntPayDateEntrys().size(); ++i) {
            LoanOfIntPayDateEntryInfo info = loan.getIntPayDateEntrys().get(i);
            Integer indexloan = info.getSeq();
            LoanOfIntPayDate.put(indexloan - 1, info.getPayDate());
        }
        int yeardate = 360;
        int diffdaytime = DateTimeUtils.getDay((Date)loan.getExpiredDate()) - DateTimeUtils.getDay((Date)loan.getIssueDate());
        Object id = null;
        if (LoanOfIntPayDate.size() > 0) {
            Date mo = (Date)LoanOfIntPayDate.get(0);
            int dayDiff = DateUtil.getDiffDays((Date)loan.getIssueDate(), (Date)mo);
            if (dayDiff < 200) {
                yearRate = yearRate.divide(new BigDecimal(2));
                yeardate = 180;
            }
        }
        if (loan.getIntRateTypeExpression().equals((Object)IntRateTypeExpressionEnum.YEAR)) {
            BigDecimal loan_amount = loan.getAmount();
            BigDecimal interest = loan_amount.multiply(yearRate).multiply(new BigDecimal(0.01)).divide(new BigDecimal(1), this.digits, 4);
            BigDecimal alance = loan_amount.subtract(financing_amount).divide(new BigDecimal(1), this.digits, 4);
            if (alance.compareTo(BigDecimal.ZERO) != 1) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"302_BondsListUI"));
                this.abort();
            }
            ArrayList<BigDecimal> arrayList = new ArrayList<BigDecimal>();
            arrayList.add(BigDecimal.ZERO.subtract(alance));
            Date curDate = DateTimeUtils.addDay((Date)loan.getIssueDate(), (long)(1 + diffdaytime));
            ArrayList arrayMapList = new ArrayList();
            if (loan.getIntPayDateEntrys().size() == 0) {
                if (!curDate.before(loan.getExpiredDate())) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"303_BondsListUI"));
                    this.abort();
                }
                while (curDate.before(loan.getExpiredDate())) {
                    HashMap<String, Comparable<Integer>> mapYear = new HashMap<String, Comparable<Integer>>();
                    int dayDiff = DateUtil.getDiffDays((Date)curDate, (Date)DateTimeUtils.addYear((Date)curDate, (int)1)) - 1;
                    mapYear.put("dayDiff", Integer.valueOf(dayDiff));
                    if (loan.getExpiredDate().before(DateTimeUtils.addYear((Date)curDate, (int)1)) || loan.getExpiredDate().compareTo(DateTimeUtils.addYear((Date)curDate, (int)1)) == 0) {
                        arrayList.add(interest.add(loan_amount).divide(new BigDecimal(1), this.digits, 4));
                        mapYear.put(this.YEAR_RELATIVE, Integer.valueOf(DateTimeUtils.getYear((Date)curDate)));
                        mapYear.put(this.STARTTIME, curDate);
                        mapYear.put(this.ENDTIME, loan.getExpiredDate());
                    } else {
                        arrayList.add(interest.divide(new BigDecimal(1), this.digits, 4));
                        mapYear.put(this.YEAR_RELATIVE, Integer.valueOf(DateTimeUtils.getYear((Date)curDate)));
                        mapYear.put(this.STARTTIME, curDate);
                        mapYear.put(this.ENDTIME, DateTimeUtils.addYear((Date)curDate, (int)1));
                    }
                    arrayMapList.add(mapYear);
                    curDate = DateTimeUtils.addYear((Date)curDate, (int)1);
                }
            }
            for (int i = 0; i < loan.getIntPayDateEntrys().size(); ++i) {
                HashMap<String, Comparable<Integer>> mapYear = new HashMap<String, Comparable<Integer>>();
                int dayDiff = DateUtil.getDiffDays((Date)curDate, (Date)((Date)LoanOfIntPayDate.get(i)));
                mapYear.put("dayDiff", Integer.valueOf(dayDiff));
                if (diffdaytime != 0 && i == 0) {
                    BigDecimal diffamount = loan_amount.multiply(loan.getYieldRate()).multiply(new BigDecimal(diffdaytime)).multiply(new BigDecimal(0.01)).divide(new BigDecimal(360), this.digits, 4);
                    arrayList.add(interest.divide(new BigDecimal(1), this.digits, 4).add(diffamount));
                } else {
                    arrayList.add(interest.divide(new BigDecimal(1), this.digits, 4));
                }
                mapYear.put(this.YEAR_RELATIVE, Integer.valueOf(DateTimeUtils.getYear((Date)curDate)));
                mapYear.put(this.STARTTIME, curDate);
                mapYear.put(this.ENDTIME, (Date)LoanOfIntPayDate.get(i));
                arrayMapList.add(mapYear);
                curDate = DateTimeUtils.addDay((Date)((Date)LoanOfIntPayDate.get(i)), (long)1L);
                if (i != loan.getIntPayDateEntrys().size() - 1) continue;
                mapYear = new HashMap();
                dayDiff = DateUtil.getDiffDays((Date)curDate, (Date)loan.getExpiredDate());
                mapYear.put("dayDiff", Integer.valueOf(dayDiff));
                arrayList.add(interest.add(loan_amount).divide(new BigDecimal(1), this.digits, 4));
                mapYear.put(this.YEAR_RELATIVE, Integer.valueOf(DateTimeUtils.getYear((Date)curDate)));
                mapYear.put(this.STARTTIME, curDate);
                mapYear.put(this.ENDTIME, loan.getExpiredDate());
                arrayMapList.add(mapYear);
            }
            Logger.getLogger((String)((Object)arrayMapList).toString());
            double[] cashFlows1 = new double[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                cashFlows1[i] = ((BigDecimal)arrayList.get(i)).divide(new BigDecimal(1), 2, 4).doubleValue();
            }
            double result_IRR = IRRHelp.getIRR(cashFlows1, 0.1);
            if (loan.get("IRR") != null) {
                result_IRR = ((BigDecimal)loan.get("IRR")).doubleValue();
            }
            if (result_IRR == Double.NaN) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"304_BondsListUI"));
                this.abort();
            }
            BigDecimal irr = new BigDecimal(result_IRR).divide(new BigDecimal(1), 12, 4);
            Logger.getLogger((String)("irr=" + irr.toString()));
            BigDecimal year_alance = alance;
            for (int i = 0; i < arrayMapList.size(); ++i) {
                HashMap mapYear = (HashMap)arrayMapList.get(i);
                BigDecimal year_interest = BigDecimal.ZERO;
                if (diffdaytime != 0 && i == 0) {
                    BigDecimal diffamount = year_alance.multiply(irr).multiply(new BigDecimal(diffdaytime)).divide(new BigDecimal(yeardate), this.digits, 4);
                    year_interest = year_alance.multiply(irr).divide(new BigDecimal(1), this.digits, 4);
                    BigDecimal diffamount1 = loan_amount.multiply(loan.getYieldRate()).multiply(new BigDecimal(diffdaytime)).multiply(new BigDecimal(0.01)).divide(new BigDecimal(360), this.digits, 4);
                    mapYear.put(this.YEAR_INTEREST, year_interest);
                    year_interest = year_interest.add(diffamount);
                    year_alance = year_alance.add(year_interest).subtract(interest.add(diffamount1)).divide(new BigDecimal(1), this.digits, 4);
                } else {
                    year_interest = year_alance.multiply(irr).divide(new BigDecimal(1), this.digits, 4);
                    year_alance = year_alance.add(year_interest).subtract(interest).divide(new BigDecimal(1), this.digits, 4);
                    mapYear.put(this.YEAR_INTEREST, year_interest);
                }
                mapYear.put(this.YEAR_ALANCE, interest);
            }
            HashMap<String, Map> period_interest_alance = new HashMap<String, Map>();
            int index = 1;
            if (diffdaytime == 0) {
                index = 0;
            }
            for (int j = 0; j < arrayMapList.size(); ++j) {
                Map listMap = (Map)arrayMapList.get(j);
                Date start = (Date)listMap.get(this.STARTTIME);
                Date end = (Date)listMap.get(this.ENDTIME);
                int daydiff = (Integer)listMap.get("dayDiff");
                BigDecimal month_interest_year = (BigDecimal)listMap.get(this.YEAR_INTEREST);
                BigDecimal month_alance_year = (BigDecimal)listMap.get(this.YEAR_ALANCE);
                Date cur_mothDate = start;
                while (cur_mothDate.before(end) || cur_mothDate.compareTo(end) == 0) {
                    int day;
                    Date monthEnd = DateUtil.getLastDayOfMonth((Date)cur_mothDate);
                    if (end.before(monthEnd)) {
                        monthEnd = end;
                        day = DateUtil.getDiffDays((Date)cur_mothDate, (Date)monthEnd);
                    } else {
                        day = DateUtil.getDiffDays((Date)cur_mothDate, (Date)monthEnd);
                    }
                    String month_int = "";
                    month_int = DateTimeUtils.getMonth((Date)cur_mothDate) < 10 ? "0" + Integer.toString(DateTimeUtils.getMonth((Date)cur_mothDate)) : Integer.toString(DateTimeUtils.getMonth((Date)cur_mothDate));
                    String period = Integer.toString(DateTimeUtils.getYear((Date)cur_mothDate)) + month_int;
                    if (period_interest_alance.get(period) == null) {
                        HashMap<String, Number> value = new HashMap<String, Number>();
                        BigDecimal month_interes = BigDecimal.ZERO;
                        BigDecimal month_alance = BigDecimal.ZERO;
                        if (index == 1) {
                            BigDecimal diffamount = month_interest_year.multiply(new BigDecimal(diffdaytime)).divide(new BigDecimal(yeardate), this.digits, 4);
                            month_interes = month_interest_year.multiply(new BigDecimal(day)).divide(new BigDecimal(daydiff), this.digits, 4).add(diffamount);
                            BigDecimal diffamountmonth_alance = month_alance_year.multiply(new BigDecimal(diffdaytime)).divide(new BigDecimal(yeardate), this.digits, 4);
                            month_alance = month_alance_year.multiply(new BigDecimal(day)).divide(new BigDecimal(daydiff), this.digits, 4).add(diffamountmonth_alance);
                            ++index;
                        } else {
                            month_interes = month_interest_year.multiply(new BigDecimal(day)).divide(new BigDecimal(daydiff), this.digits, 4);
                            month_alance = month_alance_year.multiply(new BigDecimal(day)).divide(new BigDecimal(daydiff), this.digits, 4);
                        }
                        value.put(this.MONTH_INTEREST, month_interes);
                        value.put(this.MONTH_ALANCE, month_alance);
                        value.put(this.DAY_INT, day);
                        period_interest_alance.put(period, value);
                    } else {
                        BigDecimal month_interes = month_interest_year.multiply(new BigDecimal(day)).divide(new BigDecimal(daydiff), this.digits, 4);
                        BigDecimal month_alance = month_alance_year.multiply(new BigDecimal(day)).divide(new BigDecimal(daydiff), this.digits, 4);
                        Map value = (Map)period_interest_alance.get(period);
                        value.put(this.MONTH_INTEREST, ((BigDecimal)value.get(this.MONTH_INTEREST)).add(month_interes).divide(new BigDecimal(1), this.digits, 4));
                        value.put(this.MONTH_ALANCE, ((BigDecimal)value.get(this.MONTH_ALANCE)).add(month_alance).divide(new BigDecimal(1), this.digits, 4));
                        value.put(this.DAY_INT, (Integer)value.get(this.DAY_INT) + day - 1);
                        period_interest_alance.put(period, value);
                    }
                    cur_mothDate = DateTimeUtils.addDay((Date)monthEnd, (long)1L);
                }
            }
            Logger.getLogger((String)((Object)period_interest_alance).toString());
            this.insertFinancingShareTable(period_interest_alance, loan, irr);
        } else {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"305_BondsListUI"));
            this.abort();
        }
    }

    private void insertFinancingShareTable(Map period_interest_alance, LoanInfo loan, BigDecimal irr) throws BOSException, EASBizException {
        Set set = period_interest_alance.entrySet();
        int index = 0;
        Iterator it = set.iterator();
        while (it.hasNext()) {
            FinancingShareMaintainInfo fsmInfo = new FinancingShareMaintainInfo();
            Map.Entry entry = it.next();
            Map valuse = (Map)entry.getValue();
            fsmInfo.setProvisionInterest((BigDecimal)valuse.get(this.MONTH_INTEREST));
            fsmInfo.setPayInterest((BigDecimal)valuse.get(this.MONTH_ALANCE));
            fsmInfo.setAmortize(((BigDecimal)valuse.get(this.MONTH_INTEREST)).subtract((BigDecimal)valuse.get(this.MONTH_ALANCE)));
            fsmInfo.setCurrency(loan.getCurrency());
            fsmInfo.setState(FinancingShareEnum.SUBMIT);
            fsmInfo.setAmount(loan.getAmount());
            fsmInfo.setActualAmortize(fsmInfo.getAmortize());
            fsmInfo.setCompany(loan.getCompany());
            fsmInfo.setLoan(loan);
            if (this.periodMap.get((String)entry.getKey()) != null) {
                PeriodInfo periodinfo = (PeriodInfo)this.periodMap.get((String)entry.getKey());
                fsmInfo.setPeriod(periodinfo);
                fsmInfo.setPeriodDate(periodinfo.getBeginDate());
            }
            fsmInfo.setBank(loan.getInstitution());
            fsmInfo.setGroup(loan.getGroupID());
            fsmInfo.setIsGroupBank(loan.isIsGroupLoan());
            fsmInfo.setNumber(loan.getNumber() + index);
            try {
                IObjectPK pk = FinancingShareMaintainFactory.getRemoteInstance().addnew((CoreBaseInfo)fsmInfo);
                BOTRelationInfo bOTRelationInfo = new BOTRelationInfo();
                bOTRelationInfo.setId(BOSUuid.create((BOSObjectType)bOTRelationInfo.getBOSType()));
                bOTRelationInfo.setSrcEntityID(loan.getBOSType().toString());
                bOTRelationInfo.setDestEntityID(fsmInfo.getBOSType().toString());
                bOTRelationInfo.setSrcObjectID(loan.getId().toString());
                bOTRelationInfo.setDestObjectID(pk.toString());
                bOTRelationInfo.setOperatorID("user");
                bOTRelationInfo.setIsEffected(false);
                BOTRelationFactory.getRemoteInstance().addnew(bOTRelationInfo);
            }
            catch (EASBizException e) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("loan", (Object)loan.getId()));
                if (FinancingShareMaintainFactory.getRemoteInstance().exists(filter)) {
                    FinancingShareMaintainFactory.getRemoteInstance().delete(filter);
                }
                this.abort();
            }
            ++index;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("isloanshare"));
        selector.add(new SelectorItemInfo("IRR"));
        loan.put("isloanshare", Boolean.TRUE);
        loan.put("IRR", irr);
        LoanFactory.getRemoteInstance().updatePartial((CoreBaseInfo)loan, selector);
    }

    private BigDecimal getFinancing_Amount(LoanInfo loan) throws BOSException, EASBizException {
        BigDecimal result_Amount = BigDecimal.ZERO;
        String number = loan.getNumber();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillType", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("sourcebillNm", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)3));
        filter.getFilterItems().add(new FilterItemInfo("isloanshare", (Object)1));
        view.setFilter(filter);
        FinancingFeeBillCollection coll = FinancingFeeBillFactory.getRemoteInstance().getFinancingFeeBillCollection(view);
        if (coll.size() != 0) {
            for (int i = 0; i < coll.size(); ++i) {
                FinancingFeeBillInfo info = coll.get(i);
                BigDecimal rate = this.getRate(info);
                BigDecimal amount = info.getAmount().multiply(rate).divide(new BigDecimal(1), this.digits, 4);
                if (null == amount) continue;
                result_Amount = result_Amount.add(amount);
            }
        } else {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"306_BondsListUI"));
            this.abort();
        }
        return result_Amount;
    }

    private BigDecimal getRate(FinancingFeeBillInfo info) throws EASBizException, BOSException {
        String currencyid = info.getCurrency().getId().toString();
        BigDecimal rate = BigDecimal.ZERO;
        CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(info.getCurrency().getId()));
        if (!EmptyUtil.isEmpty((CoreBaseInfo)this.rateCurrencyInfo)) {
            if (currencyid.equals(this.rateCurrencyInfo.getId().toString())) {
                rate = Constants.ONE;
            } else {
                ExchangeRateInfo rateInfo = FMHelper.getExRateInfo((CurrencyInfo)currency, (CurrencyInfo)this.rateCurrencyInfo, (CompanyOrgUnitInfo)this.rateCurrentCompany, (Date)info.getBizDate());
                if (EmptyUtil.isEmpty((CoreBaseInfo)rateInfo)) {
                    throw new FinBaseDataException(FinBaseDataException.EXCEPTIONEXHANGERATE, new Object[]{currency.getName(), this.rateCurrencyInfo.getName()});
                }
                rate = ConvertModeEnum.INDIRECTEXCHANGERATE.equals((Object)rateInfo.getConvertMode()) ? Constants.ONE.divide(rateInfo.getConvertRate(), 20, 4) : rateInfo.getConvertRate();
            }
        }
        return rate;
    }

    protected String[] getQueryShowField() {
        return new String[]{"company.name", "number", "bizDate", "status", "contractNum", "Type.name", "depositary", "BankAcct", "CreditorGroup", "UsedQuota", "Currency.name", "LocalCurExRate", "Amount", "Balance", "IssueDate", "ExpiredDate", "Horizon", "RepaymentType", "guaranteeType", "payIntMode", "rateType", "floatAction", "intRateTypeExpression", "yearDays", "YieldRate", "newYieldRate", "panaAccrualWay", "panaAccrualRate", "intFeeAcctView.name", "isMulCon", "seqMulCon", "isHistoryLoan", "project.name", "handlerRemark", "creator", "cashier.name", "accountant.name", "description", "id", "Currency.id", "fivouchered", "voucherType", "voucherNumber", "isGenRec", "bgItem"};
    }

    public String getMainBizOrgColumnName() {
        return "company.id";
    }

    public String getMainBizOrgPropertyName() {
        return "company";
    }

    public String getPropertyOfBizOrg(OrgType orgType) {
        return "company.id";
    }

    public String[] getPropertyOfCopOrg() {
        return null;
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.IVT_MANAGE;
    }

    protected String getDateField() {
        return "IssueDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionEdit", "actionRemove", "actionAntiAudit"};
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.fm.BondsBill";
        param.alias = "\u503a\u5238\u53d1\u884c\u5355";
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        DatataskCaller task = new DatataskCaller();
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.fm.BondsBill";
        param.alias = "\u503a\u5238\u53d1\u884c\u5355";
        param.putContextParam((Object)"filter", (Object)this.getMainQuery().getFilter());
        param.datataskMode = 1;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        task.setParentComponent((Component)((Object)this));
        task.invoke(paramList, 1, false);
    }

    @Override
    public void actionImportRepayPlan_actionPerformed(ActionEvent e) throws Exception {
        HashSet idSet;
        LoanCollection col;
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() != 1) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"683_single_bill_import"));
            this.abort();
        }
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)(col = this.getLoanColl(idSet = new HashSet(idList)))) && col.get(0).getRepaymentType() == RepaymentTypeEnum.BY_LUMP_SUM) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"684_RepaymentType_not_allow"));
            this.abort();
        }
        this.importData(idList.get(0).toString());
    }

    protected ArrayList getRepayImportParam(String loanId) {
        HashMap<String, String> loanMap = new HashMap<String, String>();
        loanMap.put("loanID", loanId);
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.fm.RepayPlan";
        param.alias = "\u507f\u8fd8\u8ba1\u5212";
        param.setContextParam(loanMap);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    private void importData(String loanId) throws Exception {
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.setMainOrgContext(this.getMainOrgContext());
        if (this.getRepayImportParam(loanId) != null) {
            task.invoke(this.getRepayImportParam(loanId), 0);
        }
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            try {
                BondsListUI.this.setListUITable(BondsListUI.this.tblMain, e);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }
}

