/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankAreaTypeEnum;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.NewCostCenterF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.FMBatchProcessFacadeFactory;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.FinancingBillTypeEnum;
import com.kingdee.eas.fm.fin.IRepayment;
import com.kingdee.eas.fm.fin.LoanEntryCollection;
import com.kingdee.eas.fm.fin.LoanEntryInfo;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.client.AbstractBondsRepaymentEditUI;
import com.kingdee.eas.fm.fin.client.BondsBTPBillEditImpl;
import com.kingdee.eas.fm.fin.client.LoanEditUI;
import com.kingdee.eas.fm.fin.client.RepaymentHandler;
import com.kingdee.eas.fm.fin.rpcoptimize.RepaymentEditUIDataRpc;
import com.kingdee.eas.fm.fin.rpcoptimize.RepaymentEditUIEnvirRpc;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.nt.client.CSF7SelectorSupplier;
import com.kingdee.eas.framework.ContextTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreBillEditUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.client.context.f7.DefaultF7ContextManager;
import com.kingdee.eas.framework.client.context.f7.IF7ContextChange;
import com.kingdee.eas.framework.client.context.f7.IF7Register;
import com.kingdee.eas.framework.client.mutex.IVOChangeListener;
import com.kingdee.eas.framework.client.mutex.VOChangeEvent;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Logger;
import org.jfree.util.Log;

public class BondsRepaymentEditUI
extends AbstractBondsRepaymentEditUI
implements IMultiOrgSupport {
    private static final long serialVersionUID = 1L;
    private FinancingBillInfo finBillInfo;
    private BigDecimal addAmt = Constants.ZERO;
    private BigDecimal balance = Constants.ZERO;
    private Integer repaySeq = new Integer(0);
    private static int isIndirectRate = 0;
    private LoanEntryCollection rePayPlan = new LoanEntryCollection();
    private String originalSourceBillid = null;
    private boolean successFlag = false;
    private boolean lockByFin021 = false;
    private boolean restoreFromExcept = false;
    private int lastRepaySeq = 0;
    private Date lastRepayDate = new Date();
    private boolean isFpItemControl = false;
    private RepaymentHandler hander = new RepaymentHandler();
    private static final Logger logger = CoreUIObject.getLogger(BondsRepaymentEditUI.class);
    protected boolean ready4User = false;
    private BigDecimal applyAmount = Constants.ZERO;
    protected RepaymentEditUIEnvirRpc envirRpc = (RepaymentEditUIEnvirRpc)this.batchFetchData(this.getEnvirRpc());
    protected RepaymentEditUIDataRpc dataRpc = null;
    IObjectPK pk1;
    private DefaultF7ContextManager F7ContextManager = null;

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    protected String getClassAlise() {
        return EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"317_BondsRepaymentEditUI");
    }

    protected FmRpcCacheInfo batchFetchData(FmRpcCacheInfo rpcInfo) throws Exception {
        return FMBatchProcessFacadeFactory.getRemoteInstance().batchFetchData(rpcInfo);
    }

    protected RepaymentEditUIEnvirRpc getEnvirRpc() {
        RepaymentEditUIEnvirRpc cacheInfo = new RepaymentEditUIEnvirRpc();
        cacheInfo.setBatchImplClassName("com.kingdee.eas.fm.fin.rpcoptimize.RepaymentEditUIEnvirRpcFetcher");
        cacheInfo.setBillInfo((CoreBaseInfo)new RepaymentInfo());
        return cacheInfo;
    }

    private void fetchDataRpc(RepaymentInfo rpInfo) {
        RepaymentEditUIDataRpc tmpRpc = new RepaymentEditUIDataRpc();
        tmpRpc.setDataRpcParam(rpInfo, FinHelper.getUIState((EditUI)this), this.getBOTPViewStatus());
        tmpRpc.setBatchImplClassName("com.kingdee.eas.fm.fin.rpcoptimize.RepaymentEditUIDataRpcFetcher");
        tmpRpc.setBillInfo((CoreBaseInfo)new RepaymentInfo());
        try {
            this.dataRpc = (RepaymentEditUIDataRpc)this.batchFetchData(tmpRpc);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        RepaymentFactory.getRemoteInstance().confirm(this.editData);
        this.initOldData((IObjectValue)this.editData);
        this.getUIWindow().close();
    }

    private boolean isInMsgCenter() {
        Boolean wf = (Boolean)this.getUIContext().get("isFromWorkflow");
        if (wf == null) {
            return false;
        }
        return wf;
    }

    @Override
    public void loadFields() {
        this.ready4User = false;
        super.loadFields();
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.envirRpc.getCurrentCompany().getId().toString(), (FmRpcCacheInfo)this.envirRpc);
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        if (this.editData.getPayee() != null) {
            this.prmtPayee.setData((Object)this.editData.getPayee());
        } else if (this.editData.getPayeeCust() != null) {
            this.prmtPayee.setData((Object)this.editData.getPayeeCust());
        } else {
            this.prmtPayee.setValue((Object)this.editData.getPayeeName());
        }
        if (this.editData.getRegion() != null) {
            this.kDLabelRegion.setText(this.editData.getRegion().getAlias());
        }
        try {
            if (this.finBillInfo != null) {
                this.prmtSourceBill.setData((Object)this.finBillInfo);
                this.txtSourceTotalAmt.setValue((Object)this.finBillInfo.getAmount());
                BigDecimal AddAmount = this.editData.getAddAmount() == null ? Constants.ZERO : this.editData.getAddAmount();
                this.txtSourceRemAmt.setValue((Object)this.finBillInfo.getAmount().subtract(AddAmount));
                this.calcAmount();
                this.calcAddAmount();
                this.dpEndDate.setValue((Object)this.finBillInfo.getExpiredDate());
            } else if (this.editData.getSourceBillId() != null) {
                FinancingBillInfo info = null;
                info = this.hander.getFinancingBill(this.editData.getSourceBillId());
                this.prmtSourceBill.setData((Object)info);
                FinUtils.noActionOnSetDefault(this.txtSourceTotalAmt, (Object)info.getAmount());
                if (this.editData.getAddAmount() != null) {
                    FinUtils.noActionOnSetDefault(this.txtSourceRemAmt, (Object)info.getAmount().subtract(this.editData.getAddAmount()));
                }
                this.setRepayRecord(info.getId().toString());
            }
            this.calcCompsValue();
            this.storeFields();
            this.initOldData((IObjectValue)this.editData);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.ready4User = true;
    }

    private void calcCompsValue() {
        if (FinHelper.isInStates((EditUI)this, new int[]{6, 2}) && (this.dataRpc.isExistLoanInterest() || this.dataRpc.isExistIntAfterBizDate())) {
            this.dpBizDate.setEnabled(false);
        }
    }

    private int calcDaysBetweenTwoDate(Date startDate, Date endDate) {
        long endTime = endDate.getTime();
        long beginTime = startDate.getTime();
        long betweenDays = (long)((double)((endTime - beginTime) / 86400000L) + 0.5);
        long days = new Long(betweenDays).intValue();
        return Integer.valueOf(days + "".trim());
    }

    protected void prepareInitData(RepaymentInfo info) {
        info.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
        if (info.getBizDate() == null) {
            info.setBizDate(DateUtil.getDayBegin());
        } else {
            this.editData.setBizDate(DateTimeUtils.truncateDate((Date)this.editData.getBizDate()));
        }
        if (info.getCreditorCompany() != null && info.getCreditorCompany().getName() == null) {
            String creditorID = info.getCreditorCompany().getId().toString();
            CompanyOrgUnitInfo creditor = null;
            try {
                creditor = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(creditorID));
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
            info.setCreditorCompany(creditor);
        }
    }

    private boolean isBotp() {
        int status;
        if (this.getUIContext().get("BOTPViewStatus") == null) {
            return false;
        }
        return this.getUIContext().get("BOTPViewStatus") instanceof Integer && (status = ((Integer)this.getUIContext().get("BOTPViewStatus")).intValue()) == 1;
    }

    protected void initDataStatus() {
        this.ready4User = false;
        this.dpBizDate.setEnabled(true);
        this.editData = (RepaymentInfo)this.getDataObject();
        if (this.editData == null) {
            return;
        }
        this.envirRpc.setCurrentCompany(this.editData.getCompany());
        try {
            this.envirRpc = (RepaymentEditUIEnvirRpc)this.batchFetchData(this.envirRpc);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        super.initDataStatus();
        this.initDataStatusByParamBefore();
        this.initDataStatusBySource(this.editData);
        this.initDataStatusByState();
        this.initDataStatusByParamAfter();
        this.prmtPayee.setEnabled(true);
        this.comboSourceType.setEnabled(false);
        this.prmtSourceBill.setEnabled(false);
        this.ready4User = true;
    }

    private void initDataStatusByState() {
        if (this.oprtState.equals(OprtState.ADDNEW)) {
            this.txtAmount.setEditable(true);
            this.prmtCurrency.setEditable(true);
            if (this.isBotp()) {
                this.txtmarginBalance.setEnabled(false);
                this.prmtMainOrgCompany.setEnabled(false);
            }
        } else if (this.oprtState.equals(OprtState.EDIT)) {
            this.txtSourceAmount.setEnabled(false);
            this.txtAmount.setEnabled(false);
            this.txtAmount.setEnabled(false);
            this.prmtCurrency.setEnabled(false);
            this.txtcautionAmt.setEnabled(false);
            this.chkIsCalInt.setEnabled(false);
            this.dpStartDate.setEditable(false);
            this.dpStartDate.setEnabled(false);
            JComponent[] comps = new JComponent[]{this.dpBizDate, this.txtInterest, this.prmtBankAcct, this.prmtLoanAcct, this.prmtInterestAcct, this.kDTextFieldDesc};
            FinUtils.setEditable(comps, true);
            this.prmtMainOrgCompany.setEnabled(false);
        }
    }

    private void initDataStatusByParamBefore() {
        if (!this.fin021Control()) {
            return;
        }
        if (this.oprtState.equals(OprtState.ADDNEW) && (!this.restoreFromExcept && this.lockByFin021 || this.restoreFromExcept && !this.lockByFin021)) {
            JComponent[] comps = new JComponent[]{this.chkIsCalInt, this.txtAmount, this.dpBizDate};
            FinUtils.setEditable(comps, true);
            try {
                this.chkIsCalInt_actionPerformed(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void initDataStatusByParamAfter() {
        if (!this.fin021Control()) {
            return;
        }
        if (this.oprtState.equals(OprtState.EDIT)) {
            try {
                if (this.isDirectlyFromLoan()) {
                    this.dpBizDate.setEnabled(false);
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isDirectlyFromLoan() throws BOSException {
        String srcId;
        String SrcEntityID;
        ArrayList list = BOTRelationFactory.getRemoteInstance().getAllUpstreamObjIdByDestID(this.editData.getId().toString());
        HashSet set = new HashSet(list);
        list.clear();
        list.addAll(set);
        return !EmptyUtil.isEmpty((Collection)list) && list.size() == 1 && "051F1B22".equals(SrcEntityID = BOSUuid.read((String)(srcId = (String)list.get(0))).getType().toString());
    }

    private void initDataByLoan() {
        if (this.editData.getLoan() != null) {
            this.txtRate.setHorizontalAlignment(4);
            this.txtIntervalDays.setHorizontalAlignment(4);
            this.txtRate.setEnabled(false);
            this.txtIntervalDays.setEnabled(false);
            this.cboRateExpresssion.setEnabled(false);
            this.dpStartDate.setEnabled(false);
            this.dpStartDate.setValue((Object)this.editData.getLoan().getIssueDate());
            this.dpEndDate.setValue((Object)this.editData.getLoan().getExpiredDate());
            this.cboRateExpresssion.setSelectedItem((Object)this.editData.getLoan().getIntRateTypeExpression());
            this.txtIntervalDays.setValue((Object)new Integer(this.calcDaysBetweenTwoDate((Date)this.dpStartDate.getValue(), (Date)this.dpEndDate.getValue())));
            if (this.editData.getLoan().getIntRateTypeExpression() == IntRateTypeExpressionEnum.YEAR) {
                this.kDLabelContainer20.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"281_LoanEditUI"));
            } else {
                this.kDLabelContainer20.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"282_LoanEditUI"));
            }
            this.txtRate.setPrecision(10);
            this.txtRate.setRemoveingZeroInDispaly(false);
            this.txtRate.setValue((Object)this.editData.getLoan().getYieldRate());
            if (!this.fin021Control() && this.getUIContext().get("srcBillID") != null) {
                this.txtSourceAmount.setValue((Object)this.editData.getLoan().getBalance());
            }
        } else if (this.editData != null && this.editData.getId() != null) {
            try {
                IRepayment iRepayment = RepaymentFactory.getRemoteInstance();
                if (iRepayment.exists((IObjectPK)new ObjectUuidPK(this.editData.getId().toString()))) {
                    RepaymentInfo info = iRepayment.getRepaymentInfo((IObjectPK)new ObjectUuidPK(this.editData.getId().toString()));
                    this.dpStartDate.setValue((Object)info.getStartDate());
                } else {
                    this.dpStartDate.setValue((Object)this.editData.getStartDate());
                }
            }
            catch (BOSException e) {
                logger.info((Object)e);
            }
            catch (EASBizException e) {
                logger.info((Object)e);
            }
        }
    }

    private boolean isCreateFromInvestManagerment() {
        LoanInfo loanInfo;
        return this.finBillInfo != null && this.finBillInfo instanceof LoanInfo && ((loanInfo = (LoanInfo)this.finBillInfo).getConsignLoan() != null || loanInfo.getTransBill() != null || loanInfo.getEntLoanID() != null);
    }

    private void initDataStatusBySource(RepaymentInfo info) {
        this.actionFee.setVisible(false);
        this.chkIsCalInt.setEnabled(false);
        this.chkIsRepayInt.setEnabled(false);
        boolean isCreateFromInvMgr = this.isCreateFromInvestManagerment();
        if (isCreateFromInvMgr) {
            this.txtSourceAmount.setEnabled(false);
            this.txtAmount.setEnabled(false);
            this.prmtCurrency.setEnabled(false);
            this.dpBizDate.setEnabled(false);
            this.txtInterest.setEnabled(false);
            this.chkIsCalInt.setEnabled(false);
        } else {
            this.setSourceAmountEnable();
            this.txtAmount.setEnabled(true);
            this.dpBizDate.setEnabled(true);
            this.txtInterest.setEnabled(true);
        }
        this.chkIsCalInt.setEnabled(!isCreateFromInvMgr);
    }

    private void setSourceAmountEnable() {
        if (this.prmtSourceCurrency.getValue() == null || this.prmtCurrency.getValue() == null || ((CurrencyInfo)this.prmtSourceCurrency.getValue()).getId().equals((Object)((CurrencyInfo)this.prmtCurrency.getValue()).getId())) {
            this.txtSourceAmount.setEnabled(false);
        } else {
            this.txtSourceAmount.setEnabled(true);
        }
    }

    public void onLoad() throws Exception {
        CurrencyInfo currency;
        String param = (String)this.getUIContext().get("UIClassParam");
        if (FMHelper.isEmpty((String)param)) {
            param = (String)this.getUIContext().get("BizType");
        }
        if (this.envirRpc.getCurrentCompany() != null && "ADDNEW".equals(this.oprtState)) {
            IPermission iPermission = PermissionFactory.getRemoteInstance();
            iPermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(this.envirRpc.getCurrentCompany().getId()), "fin_Repayment_addnew");
        }
        if (this.getUIContext().get("InitDataObject") != null) {
            RepaymentInfo repayInfo = (RepaymentInfo)this.getUIContext().get("InitDataObject");
            if (repayInfo.getSourceBillId() == null || "".equals(repayInfo.getSourceBillId())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"359_RepaymentEditUI"));
                SysUtil.abort();
            }
            this.finBillInfo = this.hander.getFinancingBill(repayInfo.getSourceBillId());
        }
        super.onLoad();
        if (this.editData.isIsBondsRepayment()) {
            this.comboSourceType.setSelectedItem((Object)FinancingBillTypeEnum.BONDS);
            this.comboSourceType.setEnabled(false);
        }
        this.initControl();
        this.initDataByLoan();
        if (this.editData.getSourceBillId() != null && this.txtSourceCurExRate.getBigDecimalValue() != null && !FMHelper.isEmpty((CoreBaseInfo)(currency = (CurrencyInfo)this.prmtCurrency.getValue())) && !FMHelper.isEmpty((CoreBaseInfo)this.finBillInfo)) {
            this.changeAmountMax(this.finBillInfo, currency);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.txtNumber.isEnabled()) {
            this.txtNumber.requestFocusInWindow();
        } else {
            this.dpBizDate.requestFocusInWindow();
        }
    }

    private void setAcctViewF7() throws EASBizException, BOSException {
        String cuId = this.envirRpc.getCurrentCompany().getCU().getId().toString();
        String currencyId = AccessHelper.getId((Object)this.prmtCurrency.getValue());
        EntityViewInfo treeevi = CasRecPayHandler.getAccountViewEvi((String)cuId, (String)this.envirRpc.getCurrentCompany().getId().toString(), (String)currencyId, (boolean)false);
        AccountPromptBox opseelect = new AccountPromptBox((IUIObject)this, this.envirRpc.getCurrentCompany(), treeevi.getFilter(), false, true);
    }

    private void setRepayRecord(String sourceBillId) {
        Map repayRecord = null;
        try {
            repayRecord = RepaymentFactory.getRemoteInstance().getInitEditData((IObjectPK)new ObjectUuidPK(sourceBillId));
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.repaySeq = (Integer)repayRecord.get("maxseq");
        this.addAmt = (BigDecimal)repayRecord.get("accoumulateamt");
        if (this.finBillInfo != null && this.finBillInfo instanceof LoanInfo && this.finBillInfo.isHistoryBill() && this.repaySeq == 1) {
            BigDecimal historyRepayAmount = ((LoanInfo)this.finBillInfo).getHisRepayAmount();
            historyRepayAmount = historyRepayAmount == null ? Constants.ZERO : historyRepayAmount;
            this.addAmt = this.addAmt.add(historyRepayAmount);
        }
        this.lastRepayDate = (Date)repayRecord.get("lastrepaydate");
    }

    private void prmtSourceBill_setF7Filter() {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("Balance", (Object)SysConstant.BIGZERO, CompareType.GREATER));
        this.prmtSourceBill.setEntityViewInfo(evi);
    }

    @Override
    public void storeFields() {
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        super.storeFields();
        try {
            if (this.prmtSourceBill.getData() != null) {
                FinancingBillInfo info = (FinancingBillInfo)this.prmtSourceBill.getData();
                FinancingBillInfo finBillInfo = this.hander.getFinancingBill(info.getId().toString());
                BankInfo bank = finBillInfo.getInstitution();
                if (bank != null) {
                    this.editData.setRegion(bank.getBankAreaType());
                }
                this.editData.setSourceBillId(finBillInfo.getId().toString());
                this.editData.setSourceBillNum(finBillInfo.getNumber());
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        if (this.editData.getCreditCurExRate() == null) {
            this.editData.setCreditCurExRate(Constants.ZERO);
        }
        if (this.editData.getCautionAmt() == null) {
            this.editData.setCautionAmt(Constants.ZERO);
        }
        this.editData.setAddAmount(this.txtRepayTotalAmt.getBigDecimalValue());
        this.editData.setMakeType(this.editData.getMakeType());
        this.editData.setPayee(this.getSupplier(this.prmtPayee.getData()));
        this.editData.setPayeeCust(this.getCustomer(this.prmtPayee.getData()));
        this.editData.setPayeeName(this.prmtPayee.getValue() == null ? "" : this.prmtPayee.getValue().toString());
    }

    private CustomerInfo getCustomer(Object objCust) {
        if (objCust instanceof CustomerInfo) {
            return (CustomerInfo)objCust;
        }
        return null;
    }

    private SupplierInfo getSupplier(Object obj) {
        if (obj instanceof SupplierInfo) {
            return (SupplierInfo)obj;
        }
        return null;
    }

    protected void initOldData(IObjectValue dataObject) {
        RepaymentInfo info = (RepaymentInfo)dataObject;
        if (info.getSourceBillId() != null && !"".equals(info.getSourceBillId())) {
            try {
                FinancingBillInfo finBillInfo = this.hander.getFinancingBill(info.getSourceBillId());
                info.setSourceBillNum(finBillInfo.getNumber());
                if (info.getId() != null && !this.oprtState.equals(OprtState.ADDNEW)) {
                    RepaymentInfo currentInfo = RepaymentFactory.getRemoteInstance().getRepaymentInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()));
                    info.setReturnedQuota(currentInfo.getReturnedQuota());
                }
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
        super.initOldData(dataObject);
    }

    @Override
    protected IObjectValue createNewData() {
        RepaymentInfo objectValue = (RepaymentInfo)super.createNewData();
        objectValue.setBizDate(DateUtil.getDayBegin());
        if (this.isBotp()) {
            this.setRepayRecord(this.finBillInfo.getId().toString());
            objectValue.setRepaySeq(this.repaySeq);
            objectValue.setAddAmount(this.addAmt);
            objectValue.setSourceCurExRate(Constants.ONE);
        } else {
            try {
                CompanyOrgUnitInfo curtCompany = this.getLoginedCompany();
                if (this.getOprtState().equals(OprtState.ADDNEW) && ContextHelperFactory.getRemoteInstance().isOnlyUnion(curtCompany)) {
                    CompanyOrgUnitInfo billCompany = this.getAddNewDefaultCompany(curtCompany);
                    objectValue.setCompany(billCompany);
                    objectValue.setCurrency(billCompany.getBaseCurrency());
                }
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        objectValue.setCautionAmt(Constants.ZERO);
        objectValue.setReturnedQuota(Constants.ZERO);
        objectValue.setTotalPayedAmt(Constants.ZERO);
        if (objectValue.getCompany() != null) {
            this.envirRpc.setCurrentCompany(objectValue.getCompany());
            this.envirRpc.setCurrentCurrency(objectValue.getCurrency());
        }
        return objectValue;
    }

    public CompanyOrgUnitInfo getLoginedCompany() {
        return ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    }

    private CompanyOrgUnitInfo getAddNewDefaultCompany(CompanyOrgUnitInfo curtCompany) {
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)curtCompany)) {
            CompanyOrgUnitCollection orgRang = this.envirRpc.getUserOrgRang();
            for (int i = 0; i < orgRang.size(); ++i) {
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)orgRang.getObject(i);
                if (!company.isIsBizUnit() || company.getAccountTable() == null || company.isIsOUSealUp()) continue;
                return company;
            }
        }
        return curtCompany;
    }

    @Override
    protected void prmtSourceBill_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtSourceBill_dataChanged(e);
        if (e.getNewValue() == null || !(e.getNewValue() instanceof FinancingBillInfo)) {
            return;
        }
        if (!"ADDNEW".equals(this.oprtState)) {
            return;
        }
        FinancingBillInfo info = (FinancingBillInfo)e.getNewValue();
        if ((info = this.hander.getFinancingBill(info.getId().toString())) == null) {
            throw new BOSException("finBillInfo can not empty!");
        }
        Object bank = info.getInstitution();
        if (FMHelper.isEmpty((Object)bank)) {
            bank = info.get("institutionname");
        }
        if (bank instanceof BankInfo) {
            BankAreaTypeEnum bankAreaType = bank.getBankAreaType();
            this.kDLabelRegion.setText(bankAreaType.getAlias());
        }
        this.txtAmount.setMaximumValue((Comparable)info.getBalance());
        this.txtSourceAmount.setMinimumValue((Comparable)Constants.ZERO);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.txtNumber.isEnabled()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.dpBizDate);
        if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.EDIT)) {
            if (this.lastRepayDate != null) {
                int lastRepaySeq = this.repaySeq - 1;
                if (this.getOprtState().equals(OprtState.EDIT) && this.editData.getId() != null) {
                    String sourceBillID;
                    Date currentRepayDate = null;
                    int currentRepaySeq = 0;
                    String sql = null;
                    sql = "select FBizDate,FRepaySeq from T_FIN_Repayment where FID = '" + this.editData.getId().toString() + "'";
                    ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
                    IRowSet set = exec.executeSQL();
                    try {
                        if (set != null && set.next()) {
                            java.sql.Date d = set.getDate(1);
                            currentRepaySeq = set.getInt(2);
                            currentRepayDate = new Date(d.getTime());
                            set.close();
                        }
                    }
                    catch (SQLException ex) {
                        Log.debug((Object)ex.getMessage());
                    }
                    if (currentRepaySeq < lastRepaySeq) {
                        String string = sourceBillID = this.editData.getSourceBillId() == null ? null : this.editData.getSourceBillId().toString();
                        if (sourceBillID != null) {
                            if (currentRepaySeq == 1) {
                                Date nextRepayDateFromDB = this.getLastAndNextRepayDateFromDB(sourceBillID, currentRepaySeq, 0);
                                if (this.dpBizDate.getSqlDate().after(nextRepayDateFromDB)) {
                                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"318_BondsRepaymentEditUI"));
                                    SysUtil.abort();
                                }
                            } else {
                                Date lastRepayDateFromDB = this.getLastAndNextRepayDateFromDB(sourceBillID, currentRepaySeq, 1);
                                Date nextRepayDateFromDB = this.getLastAndNextRepayDateFromDB(sourceBillID, currentRepaySeq, 0);
                                if (this.dpBizDate.getSqlDate().before(lastRepayDateFromDB) || this.dpBizDate.getSqlDate().after(nextRepayDateFromDB)) {
                                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"318_BondsRepaymentEditUI"));
                                    SysUtil.abort();
                                }
                            }
                        }
                    } else {
                        String string = sourceBillID = this.editData.getSourceBillId() == null ? null : this.editData.getSourceBillId().toString();
                        if (sourceBillID != null && currentRepaySeq != 1) {
                            Date lastRepayDateFromDB = this.getLastAndNextRepayDateFromDB(sourceBillID, currentRepaySeq, 1);
                            if (this.dpBizDate.getSqlDate().before(lastRepayDateFromDB)) {
                                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"318_BondsRepaymentEditUI"));
                                SysUtil.abort();
                            }
                        }
                    }
                } else if (this.dpBizDate.getSqlDate().before(this.lastRepayDate)) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"319_BondsRepaymentEditUI"));
                    SysUtil.abort();
                }
            }
            if (this.dpStartDate.getSqlDate() != null && this.dpBizDate.getSqlDate().before(this.dpStartDate.getSqlDate())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"320_BondsRepaymentEditUI"));
                SysUtil.abort();
            }
        }
        if (this.finBillInfo instanceof LoanInfo) {
            LoanInfo loanInfo = (LoanInfo)this.finBillInfo;
            if (this.txtSourceRemAmt.getBigDecimalValue().compareTo(new BigDecimal(String.valueOf(0))) > 0 && this.txtSourceRemAmt.getBigDecimalValue().compareTo(loanInfo.getIntFreeAmt()) < 0) {
                this.txtSourceAmount.requestFocus();
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"321_BondsRepaymentEditUI"));
                SysUtil.abort();
            }
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.comboSourceType);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtSourceBill);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtCurrency);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtLocalCurExRate);
        FMClientHelper.verifyNotNegtive((CoreUIObject)this, (KDFormattedTextField)this.txtSourceAmount);
        FinancingBillInfo finBillInfo = (FinancingBillInfo)this.prmtSourceBill.getData();
        if (this.isFpItemControl) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtBgItem);
        }
        FMClientHelper.verifyNotNegtive((CoreUIObject)this, (KDFormattedTextField)this.txtSourceRemAmt);
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.checkAuctionAmt();
        }
        this.checkCautionAcctBank();
    }

    private Date getLastAndNextRepayDateFromDB(String sourceBillID, int currentRepaySeq, int IslastPayDate) throws BOSException {
        Date RepayDateFromDB = null;
        int seq = IslastPayDate == 1 ? currentRepaySeq - 1 : currentRepaySeq + 1;
        String sqlForLastRepay = "select FBizDate from T_FIN_Repayment where FRepaySeq = " + seq + "  and FSourceBillID = '" + sourceBillID + "'";
        ISQLExecutor exec2 = SQLExecutorFactory.getRemoteInstance((String)sqlForLastRepay);
        IRowSet set2 = exec2.executeSQL();
        try {
            if (set2 != null && set2.next()) {
                java.sql.Date d = set2.getDate(1);
                RepayDateFromDB = new Date(d.getTime());
                set2.close();
            }
        }
        catch (SQLException ex) {
            Log.debug((Object)ex.getMessage());
        }
        return DateTimeUtils.truncateDate(RepayDateFromDB);
    }

    private void checkCautionAcctBank() {
        if (this.editData.getAcutionAcctBank() != null) {
            if (this.editData.getMarginBalance().compareTo(Constants.ZERO) > 0) {
                if (this.editData.getCautionAmt().compareTo(Constants.ZERO) <= 0) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"293_LoanEditUI"));
                    this.txtcautionAmt.requestFocus();
                    SysUtil.abort();
                }
            } else if (this.editData.getCautionAmt().compareTo(Constants.ZERO) < 0) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"322_BondsRepaymentEditUI"));
                this.txtcautionAmt.requestFocus();
                SysUtil.abort();
            }
        }
    }

    private void checkAuctionAmt() {
        if (this.editData.getCautionAmt().compareTo(Constants.ZERO) < 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"363_RepaymentEditUI"));
            SysUtil.abort();
        }
        if (this.editData.getLoan() != null) {
            BigDecimal cautionAmt = this.editData.getLoan().getCautionAmt();
            BigDecimal cautionAmtRepay = this.editData.getLoan().getCautionAmtRepay();
            BigDecimal cautionAmtNow = this.editData.getCautionAmt();
            if (cautionAmtNow.compareTo(FMHelper.subtract((BigDecimal)cautionAmt, (BigDecimal)cautionAmtRepay)) == 1) {
                String msg = EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"323_BondsRepaymentEditUI") + cautionAmt + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"324_BondsRepaymentEditUI") + cautionAmtRepay;
                MsgBox.showWarning((Component)((Object)this), (String)msg);
                SysUtil.abort();
            }
        }
    }

    @Override
    protected void txtAmount_dataChanged(DataChangeEvent e) throws Exception {
        super.txtAmount_dataChanged(e);
        this.calcAmount();
        this.calcAddAmount();
    }

    @Override
    protected void txtSourceCurExRate_dataChanged(DataChangeEvent e) throws Exception {
        super.txtSourceCurExRate_dataChanged(e);
        if (this.editData.getSourceBillId() != null && this.txtSourceCurExRate.getBigDecimalValue() != null && this.getOprtState() != OprtState.VIEW && !"FINDVIEW".equals(this.oprtState)) {
            FinancingBillInfo sourceBill = this.hander.getFinancingBill(this.editData.getSourceBillId());
            CurrencyInfo currency = (CurrencyInfo)this.prmtCurrency.getValue();
            this.changeAmountMax(sourceBill, currency);
        }
        this.calcAmount();
    }

    @Override
    protected void txtSourceAmount_dataChanged(DataChangeEvent e) throws Exception {
        super.txtSourceAmount_dataChanged(e);
        this.calcPayment();
        this.calcLocalAmount();
        this.calcAddAmount();
    }

    @Override
    protected void txtSourceAmount_actionPerformed(ActionEvent e) throws Exception {
        super.txtSourceAmount_actionPerformed(e);
        this.calcPayment();
        this.calcLocalAmount();
        this.calcAddAmount();
    }

    @Override
    protected void txtInterest_dataChanged(DataChangeEvent e) throws Exception {
        super.txtInterest_dataChanged(e);
        this.calcPayment();
    }

    @Override
    protected void txtLocalCurExRate_dataChanged(DataChangeEvent e) throws Exception {
        super.txtLocalCurExRate_dataChanged(e);
        this.calcLocalAmount();
        this.calcAddAmount();
    }

    private void calcPayment() {
        BigDecimal bdAmount = this.txtSourceAmount.getBigDecimalValue();
        BigDecimal bdInt = this.txtInterest.getBigDecimalValue();
        if (bdAmount != null && bdInt != null) {
            FMClientHelper.setCutValue((KDFormattedTextField)this.txtPayment, (Number)bdAmount.add(bdInt));
            if (!FMHelper.isEmpty((CoreBaseInfo)this.editData)) {
                this.editData.setPayment(this.txtPayment.getBigDecimalValue());
            }
        }
    }

    private void calcLocalAmount() {
        BigDecimal bdRetAmount = this.txtSourceAmount.getBigDecimalValue();
        BigDecimal bdLocalRate = this.txtLocalCurExRate.getBigDecimalValue();
        if (bdLocalRate != null && bdRetAmount != null && bdLocalRate.compareTo(Constants.ZERO) != 0) {
            if (isIndirectRate == 1) {
                FMClientHelper.setCutValue((KDFormattedTextField)this.txtLocalAmount, (Number)bdRetAmount.divide(bdLocalRate, this.txtLocalAmount.getPrecision(), 4));
            } else {
                FMClientHelper.setCutValue((KDFormattedTextField)this.txtLocalAmount, (Number)bdRetAmount.multiply(bdLocalRate));
            }
        } else {
            FMClientHelper.setCutValue((KDFormattedTextField)this.txtLocalAmount, (Number)Constants.ZERO);
        }
        if (!FMHelper.isEmpty((CoreBaseInfo)this.editData)) {
            this.editData.setLocalAmount(this.txtLocalAmount.getBigDecimalValue());
        }
    }

    private void calcAmount() {
        BigDecimal bdRetAmount = this.txtAmount.getBigDecimalValue();
        BigDecimal bdLocalRate = this.txtSourceCurExRate.getBigDecimalValue();
        if (bdLocalRate != null && bdRetAmount != null && bdLocalRate.compareTo(Constants.ZERO) != 0) {
            if (isIndirectRate == 1) {
                FMClientHelper.setCutValue((KDFormattedTextField)this.txtSourceAmount, (Number)bdRetAmount.multiply(bdLocalRate));
            } else {
                FMClientHelper.setCutValue((KDFormattedTextField)this.txtSourceAmount, (Number)bdRetAmount.divide(bdLocalRate, this.txtSourceAmount.getPrecision(), 4));
            }
        } else {
            FMClientHelper.setCutValue((KDFormattedTextField)this.txtSourceAmount, (Number)Constants.ZERO);
        }
    }

    private void calcSourceCurExRate() {
        RepaymentInfo info = (RepaymentInfo)this.getDataObject();
        CurrencyInfo currency = (CurrencyInfo)this.prmtCurrency.getValue();
        CurrencyInfo sourceCurrency = (CurrencyInfo)this.prmtSourceCurrency.getValue();
        if (currency == null || sourceCurrency == null) {
            return;
        }
        try {
            if (info != null) {
                FinUtils.initExchangeRate(null, (BasicFormattedTextField)this.txtSourceCurExRate, this.envirRpc.getCurrentCompany(), currency, sourceCurrency, info.getBizDate(), null);
            }
        }
        catch (EASBizException e) {
            this.prmtCurrency.setData(null);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.prmtCurrency.setData(null);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
    }

    private void calcAddAmount() {
        BigDecimal txtAmountB;
        BigDecimal tmp = new BigDecimal(String.valueOf(0));
        BigDecimal bigDecimal = txtAmountB = this.txtAmount.getBigDecimalValue() == null ? Constants.ZERO : this.txtAmount.getBigDecimalValue();
        if (this.txtSourceTotalAmt.getBigDecimalValue() != null && this.getOprtState().equals(OprtState.ADDNEW)) {
            tmp = tmp.add(txtAmountB).add(this.txtSourceTotalAmt.getBigDecimalValue().subtract(this.balance));
            FMClientHelper.setCutValue((KDFormattedTextField)this.txtRepayTotalAmt, (Number)tmp);
            FMClientHelper.setCutValue((KDFormattedTextField)this.txtSourceRemAmt, (Number)this.txtSourceTotalAmt.getBigDecimalValue().subtract(tmp));
            if (this.getUIContext().get("srcillID") != null && this.getUIContext().get("srcillID").toString().length() > 0 && FMHelper.isEmpty((String)this.editData.getSourceBillId())) {
                this.editData.setSourceBillId(this.getUIContext().get("srcillID").toString());
            }
        }
    }

    @Override
    protected void prmtCurrency_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtCurrency_dataChanged(e);
        CurrencyInfo currency = (CurrencyInfo)e.getNewValue();
        if (currency == null) {
            return;
        }
        if (currency.getCreateTime() == null) {
            currency = FMClientHelper.getCurrencyInfo((BOSUuid)currency.getId());
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("precision"));
        this.txtSourceAmount.setPrecision(currency.getPrecision());
        this.txtInterest.setPrecision(currency.getPrecision());
        this.txtLocalAmount.setPrecision(currency.getPrecision());
        this.txtPayment.setPrecision(currency.getPrecision());
        this.txtcautionAmt.setPrecision(currency.getPrecision());
        RepaymentInfo info = (RepaymentInfo)this.getDataObject();
        try {
            if (info != null) {
                FinUtils.initExchangeRate(null, (BasicFormattedTextField)this.txtLocalCurExRate, this.envirRpc.getCurrentCompany(), currency, this.envirRpc.getCurrentCurrency(), info.getBizDate(), null);
            }
        }
        catch (EASBizException e1) {
            this.prmtCurrency.setData(null);
            throw e1;
        }
        try {
            ObjectUuidPK excTablepk = new ObjectUuidPK(this.envirRpc.getCurrentCompany().getBaseExchangeTable().getId().toString());
            ObjectUuidPK sourceCurrpk = new ObjectUuidPK(currency.getId());
            ObjectUuidPK destCurrpk = new ObjectUuidPK(this.envirRpc.getCurrentCurrency().getId());
            ExchangeRateInfo exchangeRateInfo = ExchangeRateFactory.getRemoteInstance().getExchangeRateConvertInfo((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, (Date)this.dpBizDate.getSqlDate());
            if (exchangeRateInfo != null && exchangeRateInfo.getExchangeAux() != null) {
                isIndirectRate = exchangeRateInfo.getExchangeAux().getConvertMode().getValue();
            }
        }
        catch (Exception e1) {
            logger.error((Object)e1);
        }
        this.calcAmount();
        this.calcSourceCurExRate();
        if (this.editData.getSourceBillId() != null && this.txtSourceCurExRate.getBigDecimalValue() != null) {
            FinancingBillInfo sourceBill = this.hander.getFinancingBill(this.editData.getSourceBillId());
            this.changeAmountMax(sourceBill, currency);
        }
        this.setAcctBankF7(this.prmtBankAcct, this.envirRpc.getCurrentCompany().getId().toString());
        this.setSourceAmountEnable();
    }

    @Override
    protected void prmtSourceCurrency_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtSourceCurrency_dataChanged(e);
        CurrencyInfo sourceCurrency = (CurrencyInfo)e.getNewValue();
        if (sourceCurrency == null) {
            return;
        }
        if (sourceCurrency.getCreateTime() == null) {
            sourceCurrency = FMClientHelper.getCurrencyInfo((BOSUuid)sourceCurrency.getId());
        }
        this.txtAmount.setPrecision(sourceCurrency.getPrecision());
        this.txtRepayTotalAmt.setPrecision(sourceCurrency.getPrecision());
        this.txtSourceTotalAmt.setPrecision(sourceCurrency.getPrecision());
        this.txtSourceRemAmt.setPrecision(sourceCurrency.getPrecision());
        this.calcSourceCurExRate();
    }

    private void initCreditPrecision(CurrencyInfo currency) {
        int prec = 5;
        if (currency != null) {
            prec = currency.getPrecision();
        }
    }

    protected KDTable getDetailTable() {
        return null;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("SourceType"));
        sic.add(new SelectorItemInfo("Creditor.id"));
        sic.add(new SelectorItemInfo("Creditor.name"));
        sic.add(new SelectorItemInfo("Creditor.number"));
        sic.add(new SelectorItemInfo("CTLCancel"));
        sic.add(new SelectorItemInfo("createFrom"));
        sic.add(new SelectorItemInfo("CreditCurExRate"));
        sic.add(new SelectorItemInfo("ReturnedQuota"));
        sic.add(new SelectorItemInfo("Interest"));
        sic.add(new SelectorItemInfo("Payment"));
        sic.add(new SelectorItemInfo("BankAcct.id"));
        sic.add(new SelectorItemInfo("BankAcct.number"));
        sic.add(new SelectorItemInfo("BankAcct.name"));
        sic.add(new SelectorItemInfo("LoanAcct.id"));
        sic.add(new SelectorItemInfo("LoanAcct.number"));
        sic.add(new SelectorItemInfo("LoanAcct.name"));
        sic.add(new SelectorItemInfo("InterestAcct.id"));
        sic.add(new SelectorItemInfo("InterestAcct.number"));
        sic.add(new SelectorItemInfo("InterestAcct.name"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("Amount"));
        sic.add(new SelectorItemInfo("LocalCurExRate"));
        sic.add(new SelectorItemInfo("LocalAmount"));
        sic.add(new SelectorItemInfo("useAssureBill"));
        sic.add(new SelectorItemInfo("assureBill.*"));
        sic.add(new SelectorItemInfo("assCurrency.id"));
        sic.add(new SelectorItemInfo("assCurrency.number"));
        sic.add(new SelectorItemInfo("assCurrency.name"));
        sic.add(new SelectorItemInfo("assCurrency.precision"));
        sic.add(new SelectorItemInfo("assExRate"));
        sic.add(new SelectorItemInfo("innerAccount.id"));
        sic.add(new SelectorItemInfo("innerAccount.number"));
        sic.add(new SelectorItemInfo("innerAccount.name"));
        sic.add(new SelectorItemInfo("repaySeq"));
        sic.add(new SelectorItemInfo("addAmount"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("payee.id"));
        sic.add(new SelectorItemInfo("payee.number"));
        sic.add(new SelectorItemInfo("payee.name"));
        sic.add(new SelectorItemInfo("isCalInt"));
        sic.add(new SelectorItemInfo("isRepayInt"));
        sic.add(new SelectorItemInfo("isCalPunishInt"));
        sic.add(new SelectorItemInfo("isIncredit"));
        sic.add(new SelectorItemInfo("creditPercetage"));
        sic.add(new SelectorItemInfo("cautionAmt"));
        sic.add(new SelectorItemInfo("intFeeAcctView.*"));
        sic.add(new SelectorItemInfo("acutionAcctBank.*"));
        sic.add(new SelectorItemInfo("marginCurrency.id"));
        sic.add(new SelectorItemInfo("marginCurrency.number"));
        sic.add(new SelectorItemInfo("marginCurrency.name"));
        sic.add(new SelectorItemInfo("marginCurrency.precision"));
        sic.add(new SelectorItemInfo("marginBalance"));
        sic.add(new SelectorItemInfo("hxdNumber"));
        sic.add(new SelectorItemInfo("babNumber"));
        sic.add(new SelectorItemInfo("SourceBillId"));
        sic.add(new SelectorItemInfo("Region"));
        sic.add(new SelectorItemInfo("PushDown"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.cu"));
        sic.add(new SelectorItemInfo("company.isBizUnit"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("applyUnit.id"));
        sic.add(new SelectorItemInfo("makeType"));
        sic.add(new SelectorItemInfo("CreditorCompany.id"));
        sic.add(new SelectorItemInfo("CreditorCompany.name"));
        sic.add(new SelectorItemInfo("CreditorCompany.number"));
        sic.add(new SelectorItemInfo("payeeCust.id"));
        sic.add(new SelectorItemInfo("payeeCust.number"));
        sic.add(new SelectorItemInfo("payeeCust.name"));
        sic.add(new SelectorItemInfo("Currency.id"));
        sic.add(new SelectorItemInfo("Currency.number"));
        sic.add(new SelectorItemInfo("Currency.name"));
        sic.add(new SelectorItemInfo("Currency.precision"));
        sic.add(new SelectorItemInfo("loan.*"));
        sic.add(new SelectorItemInfo("CreditLimit.Currency.name"));
        sic.add(new SelectorItemInfo("isPerformanced"));
        sic.add(new SelectorItemInfo("fpItem.id"));
        sic.add(new SelectorItemInfo("fpItem.number"));
        sic.add(new SelectorItemInfo("fpItem.name"));
        sic.add(new SelectorItemInfo("fundFlowItem.*"));
        sic.add("project.name");
        sic.add("project.number");
        sic.add("outBgItemId");
        sic.add("outBgItemNumber");
        sic.add("outBgItemName");
        sic.add("SourceCurrency.id");
        sic.add("SourceCurrency.number");
        sic.add("SourceCurrency.name");
        sic.add("SourceCurExRate");
        sic.add("SourceAmount");
        sic.add("costCenter.id");
        sic.add("costCenter.number");
        sic.add("costCenter.name");
        sic.add("payeeName");
        sic.add("payeeAccountBank");
        sic.add("payeeBank");
        sic.add("payeeBankNumber");
        sic.add("settleMethod");
        return sic;
    }

    protected void unLockUIAndAction() {
        super.unLockUIAndAction();
        this.initDataStatus();
    }

    public boolean isModify() {
        if (this.getBOTPViewStatus() == 1 || this.isInMsgCenter()) {
            return false;
        }
        return super.isModify();
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        RepaymentInfo info = (RepaymentInfo)dataObject;
        this.fetchDataRpc(info);
        info.setIsBondsRepayment(true);
        info.setSourceType(FinancingBillTypeEnum.BONDS);
        super.setDataObject(dataObject);
        if (!this.getOprtState().equals("EDIT") && !this.getOprtState().equals("VIEW")) {
            this.prepareInitData(this.editData);
        }
        if (this.getOprtState().equals("ADDNEW") || this.getOprtState().equals("EDIT")) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)2, CompareType.NOTEQUALS));
            view.setFilter(filter);
            this.prmtCurrency.setEntityViewInfo(view);
        }
        if (FinHelper.isInStates((EditUI)this, new int[]{5})) {
            if (info.getBizDate() == null) {
                info.setBizDate(DateUtil.getDayBegin());
            } else {
                info.setBizDate(DateTimeUtils.truncateDate((Date)info.getBizDate()));
            }
            if (info.getCompany() == null) {
                info.setCompany(this.dataRpc.getCurrentCompany());
            }
            if (info.getCurrency() == null) {
                info.setCurrency(this.dataRpc.getCurrentCurrency());
            }
            if (info.getAmount() == null) {
                info.setAmount(Constants.ZERO);
            }
            if (info.getLocalAmount() == null) {
                info.setLocalAmount(Constants.ZERO);
            }
            if (info.getSourceAmount() == null) {
                info.setSourceAmount(Constants.ZERO);
            }
            if (info.getMarginBalance() == null) {
                info.setMarginBalance(Constants.ZERO);
            }
            if (info.getCautionAmt() == null) {
                info.setCautionAmt(Constants.ZERO);
            }
            if (info.getTotalPayedAmt() == null) {
                info.setTotalPayedAmt(Constants.ZERO);
            }
        } else if (FinHelper.isInStates((EditUI)this, new int[]{5, 1})) {
            if (info.getBizDate() == null) {
                info.setBizDate(DateUtil.getDayBegin());
            } else {
                info.setBizDate(DateTimeUtils.truncateDate((Date)info.getBizDate()));
            }
            if (info.getCompany() == null) {
                info.setCompany(this.dataRpc.getCurrentCompany());
            }
            if (info.getCurrency() == null) {
                info.setCurrency(this.dataRpc.getCurrentCurrency());
            }
            if (info.getAmount() == null) {
                info.setAmount(Constants.ZERO);
            }
            if (info.getLocalAmount() == null) {
                info.setLocalAmount(Constants.ZERO);
            }
            if (info.getSourceAmount() == null) {
                info.setSourceAmount(Constants.ZERO);
            }
            if (info.getMarginBalance() == null) {
                info.setMarginBalance(Constants.ZERO);
            }
            if (info.getCautionAmt() == null) {
                info.setCautionAmt(Constants.ZERO);
            }
            if (info.getTotalPayedAmt() == null) {
                info.setTotalPayedAmt(Constants.ZERO);
            }
        }
        this.resetRepaymentInfo(info);
        this.fireVOChangeListener();
    }

    private void resetRepaymentInfo(RepaymentInfo info) {
        this.rePayPlan.clear();
        this.originalSourceBillid = info.getSourceBillId();
        if (this.getBOTPViewStatus() != 1) {
            return;
        }
        try {
            if (info.getSourceBillId() != null) {
                this.finBillInfo = BondsRepaymentEditUI.getFinancingBill(info.getSourceBillId());
            }
            this.txtRepaySeq.setText(String.valueOf(this.editData.getRepaySeq()));
            if (EmptyUtil.isEmpty((CoreBaseInfo)this.editData.getCompany())) {
                this.editData.setCompany(this.envirRpc.getCurrentCompany());
            }
            this.balance = this.finBillInfo.getBalance();
            this.setRepayRecord(this.finBillInfo.getId().toString());
            info.setRepaySeq(this.repaySeq);
            if (!EmptyUtil.isEmpty((Object)this.editData.getAmount())) {
                info.setAmount(this.editData.getAmount());
            } else {
                info.setAmount(info.getSourceAmount() == null ? this.finBillInfo.getAmount() : info.getSourceAmount());
            }
            info.setUseAssureBill(this.finBillInfo.isUseAssureBill());
            info.setAssureBill(this.finBillInfo.getAssureBill());
            info.setAssExRate(this.finBillInfo.getAssExRate());
            info.setIsIncredit(this.finBillInfo.isIsInCredit());
            if (StringUtil.isEmpty((String)info.getCreateFrom())) {
                this.setOtherBill(info);
            }
            info.setSourceCurrency(this.finBillInfo.getCurrency());
            info.setSourceCurExRate(info.getSourceCurExRate() == null ? Constants.ONE : info.getSourceCurExRate());
            if (!StringUtil.isEmpty((String)info.getCreateFrom())) {
                this.setLoanBill(info);
            }
            if (!StringUtil.isEmpty((String)info.getSourceBillId())) {
                info.setIsIncredit(this.finBillInfo.isIsInCredit());
                info.setCreditLimit(this.finBillInfo.getCreditLimit());
                if (info.getCreditPercetage() == null) {
                    info.setCreditPercetage(Constants.ONE_HUNDRED);
                }
                if (info.getCreditCurExRate() == null) {
                    info.setCreditCurExRate(this.finBillInfo.getCreditCurExRate());
                }
                if (info.getReturnedQuota() == null) {
                    info.setReturnedQuota(this.finBillInfo.getCreditLocalAmt());
                }
            }
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (EASBizException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        int seq = this.repaySeq;
        if (this.originalSourceBillid != null && this.fin021Control()) {
            String srcBosType;
            if (BOSUuid.isValid((String)this.originalSourceBillid, (boolean)false) && "051F1B22".equals(srcBosType = BOSUuid.read((String)this.originalSourceBillid).getType().toString())) {
                Map map = this.getRepayPlan(this.originalSourceBillid);
                this.rePayPlan = (LoanEntryCollection)((Object)map.get("REPAYPLAN"));
                try {
                    if (!EmptyUtil.isEmpty((AbstractObjectCollection)this.rePayPlan)) {
                        if (this.oprtState.equals(OprtState.EDIT)) {
                            seq = Integer.parseInt(this.txtRepaySeq.getText());
                        }
                        if (seq > this.rePayPlan.size()) {
                            this.restoreFromExcept = true;
                            throw new FinBizException(FinBizException.REPAYPLANALLPAYED);
                        }
                    }
                    this.restoreFromExcept = false;
                }
                catch (FinBizException e) {
                    this.relockComponent();
                    ExceptionHandler.handle((Throwable)((Object)e));
                    this.initOldData((IObjectValue)this.editData);
                    this.abort();
                }
            }
        } else {
            this.lockByFin021 = false;
            this.restoreFromExcept = false;
        }
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)this.rePayPlan)) {
            this.lockByFin021 = true;
            this.lastRepaySeq = this.repaySeq;
            LoanEntryInfo repayEntry = this.rePayPlan.get(seq - 1);
            info.setAmount(repayEntry.getAmount());
            info.setBizDate(repayEntry.getDate());
            this.txtAmount.setEnabled(false);
            this.dpBizDate.setEnabled(false);
            switch (repayEntry.getRepayIntType().getValue()) {
                case 1: {
                    info.setIsRepayInt(true);
                    info.setIsCalInt(true);
                    this.chkIsCalInt.setEnabled(false);
                    this.chkIsRepayInt.setEnabled(false);
                    break;
                }
                case 2: {
                    info.setIsRepayInt(false);
                    info.setIsCalInt(false);
                    this.chkIsCalInt.setEnabled(true);
                    this.chkIsRepayInt.setEnabled(false);
                }
            }
        } else {
            this.lockByFin021 = false;
        }
    }

    private void resetRepatSeq() {
        this.txtRepaySeq.setValue((Object)this.lastRepaySeq);
    }

    private void relockComponent() {
        if (this.restoreFromExcept && this.lockByFin021) {
            JComponent[] comps = new JComponent[]{this.chkIsCalInt, this.txtAmount, this.dpBizDate};
            FinUtils.setEditable(comps, false);
            try {
                this.chkIsCalInt_actionPerformed(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.resetRepatSeq();
        }
    }

    private Map getRepayPlan(String LoanId) {
        Map repayPlan = null;
        try {
            repayPlan = RepaymentFactory.getRemoteInstance().getRePayPlan((IObjectPK)new ObjectUuidPK(LoanId));
        }
        catch (FinBizException e) {
            ExceptionHandler.handle((Throwable)((Object)e));
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return repayPlan;
    }

    private static FinancingBillInfo getFinancingBill(String id) throws EASBizException, BOSException {
        BOSUuid bisid = BOSUuid.read((String)id);
        SelectorItemCollection selectors = BondsRepaymentEditUI.getFinBillSelector();
        CoreBaseInfo info = EJBAccessFactory.createRemoteInstance().getEntityInfo(id, selectors);
        return (FinancingBillInfo)info;
    }

    private static SelectorItemCollection getFinBillSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("Type.id"));
        selector.add(new SelectorItemInfo("Type.number"));
        selector.add(new SelectorItemInfo("Type.name"));
        selector.add(new SelectorItemInfo("Currency.id"));
        selector.add(new SelectorItemInfo("Currency.number"));
        selector.add(new SelectorItemInfo("Currency.name"));
        selector.add(new SelectorItemInfo("CreditCurrency.id"));
        selector.add(new SelectorItemInfo("CreditCurrency.number"));
        selector.add(new SelectorItemInfo("CreditCurrency.name"));
        selector.add(new SelectorItemInfo("GaranteeType.id"));
        selector.add(new SelectorItemInfo("GaranteeType.number"));
        selector.add(new SelectorItemInfo("GaranteeType.name"));
        selector.add(new SelectorItemInfo("CreditLimit.id"));
        selector.add(new SelectorItemInfo("CreditLimit.number"));
        selector.add(new SelectorItemInfo("CreditLimit.name"));
        selector.add(new SelectorItemInfo("Institution.id"));
        selector.add(new SelectorItemInfo("Institution.number"));
        selector.add(new SelectorItemInfo("Institution.name"));
        selector.add(new SelectorItemInfo("Institution.BankAreaType"));
        selector.add(new SelectorItemInfo("CreditLimit.Property"));
        selector.add(new SelectorItemInfo("assureBill.*"));
        selector.add(new SelectorItemInfo("assCurrency.*"));
        selector.add("*");
        return selector;
    }

    private static SelectorItemCollection getEentRepaymentSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("Currency.id"));
        selector.add(new SelectorItemInfo("Currency.number"));
        selector.add(new SelectorItemInfo("Currency.name"));
        selector.add("*");
        return selector;
    }

    private void setLoanBill(RepaymentInfo info) {
        try {
            String loanID = RepaymentFactory.getRemoteInstance().getRelationLoanBillID(info.getCreateFrom());
            if (!StringUtil.isEmpty((String)loanID)) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("BankAcct.id"));
                sic.add(new SelectorItemInfo("BankAcct.name"));
                sic.add(new SelectorItemInfo("BankAcct.number"));
                sic.add(new SelectorItemInfo("intAcctView.id"));
                sic.add(new SelectorItemInfo("intAcctView.name"));
                sic.add(new SelectorItemInfo("intAcctView.number"));
                sic.add(new SelectorItemInfo("Currency.id"));
                sic.add(new SelectorItemInfo("Currency.number"));
                sic.add(new SelectorItemInfo("Currency.name"));
                sic.add(new SelectorItemInfo("cautionAcctBank.id"));
                sic.add(new SelectorItemInfo("cautionAcctBank.number"));
                sic.add(new SelectorItemInfo("cautionAcctBank.name"));
                sic.add(new SelectorItemInfo("Creditor.id"));
                sic.add(new SelectorItemInfo("Creditor.number"));
                sic.add(new SelectorItemInfo("Creditor.name"));
                sic.add(new SelectorItemInfo("Institution.id"));
                sic.add(new SelectorItemInfo("Institution.number"));
                sic.add(new SelectorItemInfo("Institution.name"));
                LoanInfo infoLoan = LoanFactory.getRemoteInstance().getLoanInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)loanID)), sic);
                info.setLoan(infoLoan);
                info.setCTLCancel(false);
                info.setCreditor(infoLoan.getInstitution());
                info.setCurrency(infoLoan.getCurrency());
                info.setLocalCurExRate(infoLoan.getLocalCurExRate());
                info.setCreditLimit(infoLoan.getCreditLimit());
                info.setStartDate(infoLoan.getIssueDate());
                info.setCreditorCompany(infoLoan.getGroupID());
                info.setSourceCurrency(infoLoan.getCurrency());
                info.setRegion(infoLoan.getRegion());
                info.setCreditPercetage(Constants.ONE_HUNDRED);
                info.setCreditCurExRate(infoLoan.getCreditCurExRate());
                BigDecimal tmp = FMHelper.multiply((BigDecimal)info.getSourceAmount(), (BigDecimal)info.getCreditCurExRate());
                info.setReturnedQuota(tmp);
                info.setAcutionAcctBank(infoLoan.getCautionAcctBank());
                info.setMarginCurrency(infoLoan.getCurrency());
                info.setMarginBalance(FMHelper.subtract((BigDecimal)infoLoan.getCautionAmt(), (BigDecimal)infoLoan.getCautionAmtRepay()));
                info.setSourceBillId(loanID);
            }
        }
        catch (Exception e) {
            Log.error((Object)e.getMessage());
        }
    }

    private void setOtherBill(RepaymentInfo info) {
        try {
            String srcID;
            BOSUuid bisid;
            BOSObjectType idType;
            if (this.getUIContext().get("srcBillID") != null) {
                String srcID2 = this.getUIContext().get("srcBillID").toString();
                BOSUuid bisid2 = BOSUuid.read((String)srcID2);
                BOSObjectType idType2 = bisid2.getType();
                if (idType2.equals((Object)LoanInfo.BOSTYPE)) {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("*"));
                    sic.add(new SelectorItemInfo("BankAcct.id"));
                    sic.add(new SelectorItemInfo("BankAcct.name"));
                    sic.add(new SelectorItemInfo("BankAcct.number"));
                    sic.add(new SelectorItemInfo("intAcctView.id"));
                    sic.add(new SelectorItemInfo("intAcctView.name"));
                    sic.add(new SelectorItemInfo("intAcctView.number"));
                    sic.add(new SelectorItemInfo("Currency.id"));
                    sic.add(new SelectorItemInfo("Currency.number"));
                    sic.add(new SelectorItemInfo("Currency.name"));
                    sic.add(new SelectorItemInfo("cautionAcctBank.id"));
                    sic.add(new SelectorItemInfo("cautionAcctBank.number"));
                    sic.add(new SelectorItemInfo("cautionAcctBank.name"));
                    sic.add(new SelectorItemInfo("intFeeAcctView.id"));
                    sic.add(new SelectorItemInfo("intFeeAcctView.number"));
                    sic.add(new SelectorItemInfo("intFeeAcctView.name"));
                    LoanInfo infoLoan = LoanFactory.getRemoteInstance().getLoanInfo((IObjectPK)new ObjectUuidPK(srcID2), sic);
                    info.setLoan(infoLoan);
                    info.setCreditPercetage(Constants.ONE_HUNDRED);
                    info.setCreditCurExRate(infoLoan.getCreditCurExRate());
                    BigDecimal tmp = FMHelper.multiply((BigDecimal)info.getSourceAmount(), (BigDecimal)info.getCreditCurExRate());
                    info.setReturnedQuota(tmp);
                    if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getBankAcct())) {
                        info.setBankAcct(infoLoan.getBankAcct());
                    }
                    if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getInterestAcct())) {
                        info.setInterestAcct(infoLoan.getIntFeeAcctView());
                    }
                    info.setAcutionAcctBank(infoLoan.getCautionAcctBank());
                    info.setMarginCurrency(infoLoan.getCurrency());
                    info.setMarginBalance(FMHelper.subtract((BigDecimal)infoLoan.getCautionAmt(), (BigDecimal)infoLoan.getCautionAmtRepay()));
                    info.setInterest(Constants.ZERO);
                }
            } else if (info.getSourceBillId() != null && (idType = (bisid = BOSUuid.read((String)(srcID = info.getSourceBillId()))).getType()).equals((Object)LoanInfo.BOSTYPE)) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("BankAcct.id"));
                sic.add(new SelectorItemInfo("BankAcct.name"));
                sic.add(new SelectorItemInfo("BankAcct.number"));
                sic.add(new SelectorItemInfo("intAcctView.id"));
                sic.add(new SelectorItemInfo("intAcctView.name"));
                sic.add(new SelectorItemInfo("intAcctView.number"));
                LoanInfo infoLoan = LoanFactory.getRemoteInstance().getLoanInfo((IObjectPK)new ObjectUuidPK(srcID), sic);
                info.setLoan(infoLoan);
                info.setCreditPercetage(Constants.ONE_HUNDRED);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    protected void chkIsCalInt_actionPerformed(ActionEvent e) throws Exception {
        if (this.chkIsCalInt.isSelected()) {
            if (!this.fin021Control()) {
                this.chkIsRepayInt.setSelected(true);
                this.chkIsRepayInt.setEnabled(true);
            }
            this.txtInterest.setValue((Object)new BigDecimal(String.valueOf(0)));
            this.txtInterest.setEnabled(false);
        } else {
            if (!this.fin021Control()) {
                this.chkIsRepayInt.setSelected(false);
                this.chkIsRepayInt.setEnabled(false);
            }
            this.txtInterest.setValue((Object)new BigDecimal(String.valueOf(0)));
            this.txtInterest.setEnabled(true);
        }
    }

    private boolean fin021Control() {
        return ContextHelperFactory.getRemoteInstance().getBooleanParam("FIN021", (IObjectPK)new ObjectUuidPK(ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId()));
    }

    @Override
    protected void chkIsRepayInt_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.verifyFin021();
        }
        catch (FinBizException ex) {
            this.handUIException((Throwable)((Object)ex));
            this.abort();
        }
        this.verify(e);
        this.checkFinalCheckout();
        RepaymentInfo tempInfo = null;
        if (FSClientHelper.isClearingHouseCompanyId((String)this.envirRpc.getCurrentCompany().getId().toString()) && (this.editData.getSourceType() == FinancingBillTypeEnum.LetterOfGuarantee || this.editData.getSourceType() == FinancingBillTypeEnum.LetterOfCredit) && this.editData.getInnerAccount() != null) {
            tempInfo = this.editData;
        }
        if (this.finBillInfo instanceof LoanInfo) {
            this.editData.setLoanInfo((LoanInfo)this.finBillInfo);
            this.editData.setCU(this.envirRpc.getCurrentCompany().getCU());
            if (!this.editData.isIsCalInt() && !this.editData.isIsRepayInt()) {
                super.actionSubmit_actionPerformed(e);
                this.doAntiWage();
                this.emptyAllFields();
            } else if (this.editData.isIsCalInt() && !this.editData.isIsRepayInt()) {
                super.actionSubmit_actionPerformed(e);
                this.doAntiWage();
                this.emptyAllFields();
            } else if (this.editData.isIsCalInt() && this.editData.isIsRepayInt()) {
                int result = this.createLoanInterest();
                if (result == 1) {
                    super.actionSubmit_actionPerformed(e);
                    this.doAntiWage();
                } else {
                    this.doAntiWage();
                }
                this.emptyAllFields();
            } else {
                super.actionSubmit_actionPerformed(e);
                this.doAntiWage();
                this.emptyAllFields();
            }
            if (this.getUIContext().get("fmtype") != null && "createTo".equalsIgnoreCase((String)this.getUIContext().get("fmtype"))) {
                this.getUIWindow().close();
            } else {
                this.emptyAllFields();
            }
        } else {
            super.actionSubmit_actionPerformed(e);
        }
        if (tempInfo != null) {
            RepaymentFactory.getRemoteInstance().writeAcount(tempInfo);
        }
    }

    private void verifyFin021() throws BOSException, FinBizException {
        Map repayPlanMap;
        LoanEntryCollection rePayPlanColl;
        if (this.fin021Control() && (this.oprtState.equals(OprtState.EDIT) && this.isDirectlyFromLoan() && !EmptyUtil.isEmpty((String)this.editData.getSourceBillId()) ? !EmptyUtil.isEmpty((AbstractObjectCollection)(rePayPlanColl = (LoanEntryCollection)((Object)(repayPlanMap = this.getRepayPlan(this.editData.getSourceBillId())).get("REPAYPLAN")))) && this.editData.getRepaySeq() > rePayPlanColl.size() : this.oprtState.equals(OprtState.ADDNEW) && !EmptyUtil.isEmpty((String)this.originalSourceBillid) && !EmptyUtil.isEmpty((AbstractObjectCollection)(rePayPlanColl = (LoanEntryCollection)((Object)(repayPlanMap = this.getRepayPlan(this.originalSourceBillid)).get("REPAYPLAN")))) && this.editData.getRepaySeq() > rePayPlanColl.size())) {
            throw new FinBizException(FinBizException.REPAYPLANALLPAYED);
        }
    }

    public IObjectPK runSubmit() throws Exception {
        this.pk1 = super.runSubmit();
        return this.pk1;
    }

    private void doAntiWage() throws EASBizException, BOSException {
        int j;
        int result;
        Map antiMap = new HashMap();
        antiMap = RepaymentFactory.getRemoteInstance().checkCanDoAnti((IObjectPK)new ObjectUuidPK(this.finBillInfo.getId()));
        if (antiMap == null) {
            return;
        }
        ArrayList assureList = (ArrayList)antiMap.get("assureList");
        ArrayList pledgeList = (ArrayList)antiMap.get("pledgeList");
        ArrayList impawnList = (ArrayList)antiMap.get("impawnList");
        ArrayList<String> assureIdList = new ArrayList<String>();
        ArrayList<String> wageIdList = new ArrayList<String>();
        for (int i = 0; i < assureList.size(); ++i) {
            String[] assures = (String[])assureList.get(i);
            result = MsgBox.showConfirm2((String)(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"493_RepaymentEditUI") + assures[1] + "?"));
            if (result != 0) continue;
            assureIdList.add(assures[0]);
        }
        for (j = 0; j < pledgeList.size(); ++j) {
            String[] pledges = (String[])pledgeList.get(j);
            result = MsgBox.showConfirm2((String)(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"494_RepaymentEditUI") + pledges[1] + "?"));
            if (result != 0) continue;
            wageIdList.add(pledges[0]);
        }
        for (j = 0; j < impawnList.size(); ++j) {
            String[] impawns = (String[])impawnList.get(j);
            result = MsgBox.showConfirm2((String)(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"495_RepaymentEditUI") + impawns[1] + "?"));
            if (result != 0) continue;
            wageIdList.add(impawns[0]);
        }
        if (assureIdList.size() != 0 || wageIdList.size() != 0) {
            RepaymentFactory.getRemoteInstance().doAntiWage(assureIdList, wageIdList);
        }
    }

    protected void prepareNumber(IObjectValue caller, String number) {
        this.editData.setNumber(number);
    }

    @Override
    public void actionFee_actionPerformed(ActionEvent e) throws Exception {
        super.actionFee_actionPerformed(e);
    }

    private void emptyAllFields() {
        this.txtSourceAmount.setValue((Object)Constants.ZERO);
        this.txtNumber.setText(null);
        this.prmtSourceBill.setValue(null);
        this.editData.setNumber(null);
        this.txtRepaySeq.setValue((Object)new Integer(0));
        this.txtSourceTotalAmt.setValue((Object)Constants.ZERO);
        this.txtInterest.setValue((Object)Constants.ZERO);
        this.txtRepayTotalAmt.setValue((Object)Constants.ZERO);
        this.txtSourceRemAmt.setValue((Object)Constants.ZERO);
        this.txtPayment.setValue((Object)Constants.ZERO);
        this.chkIsCalInt.setSelected(false);
        this.chkIsRepayInt.setSelected(false);
        this.txtAmount.setValue((Object)Constants.ZERO);
        this.dpBizDate.setValue((Object)new Date());
        this.dpEndDate.setValue(null);
        this.txtSourceRemAmt.setValue((Object)Constants.ZERO);
        this.txtRepayTotalAmt.setValue((Object)Constants.ZERO);
        this.txtIntervalDays.setValue((Object)Constants.ZERO);
        this.txtRate.setValue((Object)Constants.ZERO);
        this.kDTextFieldDesc.setText(null);
        this.prmtLoanAcct.setValue(null);
        this.prmtBankAcct.setValue(null);
        this.prmtFundFlowItem.setValue(null);
        this.prmtCostCenter.setValue(null);
        this.PrmtProject.setValue(null);
        this.prmtInterestAcct.setValue(null);
        this.txtbabNumber.setText("");
        this.chkisPerformanced.setSelected(false);
    }

    private int createLoanInterest() {
        return FinHelper.getInstance().showBondsIntReceiveEditUI((CoreUIObject)this, this.editData);
    }

    public boolean getSuccessFlag() {
        return this.successFlag;
    }

    public int getBtpCreateFromType() {
        return 0;
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        BondsBTPBillEditImpl billEdit = new BondsBTPBillEditImpl((CoreBillEditUI)this);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("TargetBillType", "-");
        map.put("fromRepayment", "fromRepayment");
        map.put("fromBankLoan", "1");
        if (!EmptyUtil.isEmpty((Object)this.prmtMainOrgCompany.getValue())) {
            map.put("CURRENTCOMPANY", ((CompanyOrgUnitInfo)this.prmtMainOrgCompany.getValue()).getId().toString());
        }
        billEdit.createFrom(null, map);
    }

    public List getSrcBosTypeForBotp(List srcBosTypeList) {
        ArrayList<String> bizType = new ArrayList<String>();
        new LoanInfo();
        if (srcBosTypeList.contains(LoanInfo.BOSTYPE.toString())) {
            bizType.add("051F1B22");
        }
        return super.getSrcBosTypeForBotp(bizType);
    }

    @Override
    public void actionViewBgBalance_actionPerformed(ActionEvent e) throws Exception {
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        this.storeFields();
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fm.fin.app.Repayment", null, (IObjectValue)this.editData);
    }

    @Override
    protected void cboRateExpresssion_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 2) {
            return;
        }
        if (IntRateTypeExpressionEnum.YEAR.equals((Object)((IntRateTypeExpressionEnum)this.cboRateExpresssion.getSelectedItem()))) {
            this.kDLabelContainer20.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"190_BondApplyBillEditUI"));
        } else if (IntRateTypeExpressionEnum.MONTH.equals(this.cboRateExpresssion.getSelectedItem())) {
            this.kDLabelContainer20.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"191_BondApplyBillEditUI"));
        } else {
            this.kDLabelContainer20.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"191_BondApplyBillEditUI"));
        }
    }

    protected boolean isModifySave() {
        return false;
    }

    @Override
    protected void prmtInterestAcct_willCommit(CommitEvent e) throws Exception {
        this.setAcctViewFilter(this.prmtInterestAcct);
    }

    @Override
    protected void prmtInterestAcct_willShow(SelectorEvent e) throws Exception {
        this.setAcctViewFilter(this.prmtInterestAcct);
    }

    @Override
    protected void prmtLoanAcct_willCommit(CommitEvent e) throws Exception {
        this.setAcctViewFilter(this.prmtLoanAcct);
    }

    @Override
    protected void prmtLoanAcct_willShow(SelectorEvent e) throws Exception {
        this.setAcctViewFilter(this.prmtLoanAcct);
    }

    private void setAcctViewFilter(KDBizPromptBox f7box) throws EASBizException, BOSException {
        CompanyOrgUnitInfo CURRENT_COMPANY = this.envirRpc.getCurrentCompany();
        String cuId = CURRENT_COMPANY.getCU().getId().toString();
        String currencyId = AccessHelper.getId((Object)this.prmtCurrency.getValue());
        EntityViewInfo treeevi = CasRecPayHandler.getAccountViewEvi((String)cuId, (String)this.envirRpc.getCurrentCompany().getId().toString(), (String)currencyId, (boolean)false);
        AccountPromptBox opseelect = new AccountPromptBox((IUIObject)this, this.envirRpc.getCurrentCompany(), treeevi.getFilter(), false, true);
        f7box.setSelector((KDPromptSelector)opseelect);
        EntityViewInfo evi = CasRecPayHandler.getAccountViewEvi((String)cuId, (String)this.envirRpc.getCurrentCompany().getId().toString(), (String)currencyId, (boolean)true);
        f7box.setEntityViewInfo(evi);
        f7box.getQueryAgent().resetRuntimeEntityView();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionViewBgBalance.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_inquirebudget"));
        this.actionFee.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_diathesisaccord"));
        this.actionConfirm.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_affirm"));
    }

    private void initControl() throws Exception {
        boolean isBizUnit;
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"317_BondsRepaymentEditUI"));
        UIUtil.updateUITitle((CoreUIObject)this, (String)this.getUITitle());
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtmarginBalance);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtcautionAmt);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtSourceAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtLocalAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtInterest);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtPayment);
        FMClientHelper.initDecimalField((BasicFormattedTextField)this.txtLocalCurExRate);
        FMClientHelper.initDecimalField((BasicFormattedTextField)this.txtSourceCurExRate);
        FMClientHelper.initDecimalField((BasicFormattedTextField)this.txtSourceTotalAmt);
        FMClientHelper.initDecimalField((BasicFormattedTextField)this.txtSourceRemAmt);
        this.txtcautionAmt.setHorizontalAlignment(4);
        this.txtcautionAmt.setSupportedEmpty(false);
        this.txtcautionAmt.setMinimumValue((Comparable)Constants.ZERO);
        this.txtLocalCurExRate.setPrecision(8);
        this.txtInterest.setPrecision(5);
        this.kDTextFieldDesc.setMaxLength(80);
        this.txtNumber.setMaxLength(50);
        this.txtSourceTotalAmt.setRemoveingZeroInDispaly(false);
        this.txtSourceRemAmt.setRemoveingZeroInDispaly(false);
        this.txtRepayTotalAmt.setHorizontalAlignment(4);
        this.txtRepayTotalAmt.setRemoveingZeroInDispaly(false);
        this.txtSourceAmount.setRemoveingZeroInDispaly(false);
        this.txtAmount.setRemoveingZeroInDispaly(false);
        this.dpBizDate.setSupportedEmpty(false);
        this.actionMultiapprove.setVisible(false);
        this.actionNextPerson.setVisible(false);
        this.actionWorkflowList.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.actionEdit.setEnabled(true);
        this.actionCreateFrom.setEnabled(this.getOprtState().equals(OprtState.ADDNEW));
        this.btnCreateFrom.setEnabled(this.actionCreateFrom.isEnabled());
        this.menuSubmitOption.setVisible(true);
        this.chkMenuItemSubmitAndAddNew.setVisible(true);
        this.chkMenuItemSubmitAndPrint.setVisible(false);
        if (this.finBillInfo != null && !(this.finBillInfo instanceof LoanInfo)) {
            boolean isVis = this.finBillInfo instanceof LoanInfo;
            this.conthxdNumber.setVisible(isVis);
            this.contbabNumber.setVisible(isVis);
        }
        CSF7SelectorSupplier arg0 = new CSF7SelectorSupplier((IUIObject)this, this.prmtPayee);
        this.prmtPayee.setSelector((KDPromptSelector)arg0);
        this.actionViewBgBalance.setEnabled(true);
        this.prmtacutionAcctBank.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        this.setAcctBankF7(this.prmtacutionAcctBank, this.envirRpc.getCurrentCompany().getId().toString());
        this.setCostCenterF7(this.prmtCostCenter, (IUIObject)this);
        this.setAcctViewF7();
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)this.PrmtProject);
        this.isFpItemControl = ContextHelperFactory.getRemoteInstance().getBooleanParam("FIN002", (IObjectPK)new ObjectUuidPK(this.envirRpc.getCurrentCompany().getId()));
        this.setAcctBankF7(this.prmtBankAcct, this.envirRpc.getCurrentCompany().getId().toString());
        this.prmtSourceBill_setF7Filter();
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.output, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        FMClientHelper.initFundFlowItemF7((IUIObject)this, (KDLabelContainer)this.contBgItem, (KDLabelContainer)this.contFundFlowItem, (FundFlowDirection)FundFlowDirection.OUT);
        this.actionConfirm.setVisible(false);
        this.actionSubmit.setVisible(true);
        if (this.getBOTPViewStatus() == 1) {
            this.dpStartDate.setEnabled(false);
        }
        if (this.isCreateFromInvestManagerment()) {
            this.chkIsCalInt.setSelected(false);
            this.chkIsRepayInt.setSelected(false);
        }
        if (isBizUnit = GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.envirRpc.getCurrentCompany())) {
            this.actionFee.setVisible(false);
        }
    }

    private boolean isCreateFromIvtRepay(String createFrom) {
        return false;
    }

    public void setCostCenterF7(KDBizPromptBox comp, IUIObject ui) {
        CompanyOrgUnitInfo companyInfo = this.envirRpc.getCurrentCompany();
        NewCostCenterF7 costCenterF7 = new NewCostCenterF7(ui);
        costCenterF7.setNeedAddOrgRange(false);
        costCenterF7.setIsCUFilter(true);
        costCenterF7.setMultiSelect(false);
        costCenterF7.setContainSealUp(false);
        costCenterF7.setCurrentCUID(companyInfo.getCU().getId().toString());
        int FIN018 = ContextHelperFactory.getRemoteInstance().getIntParam("FIN018", (IObjectPK)new ObjectUuidPK(companyInfo.getId().toString()));
        if (FIN018 == 1) {
            costCenterF7.showCheckBoxOfShowingAllOUs();
            costCenterF7.setIsCUFilter(false);
        }
        comp.setSelector((KDPromptSelector)costCenterF7);
    }

    private void setAcctBankF7(KDBizPromptBox comp, String companyid) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("bank.inGroup", (Object)new Integer(0)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        comp.setEntityViewInfo(evi);
        comp.getQueryAgent().resetRuntimeEntityView();
    }

    private void changeAmountMax(FinancingBillInfo info, CurrencyInfo currency) throws EASBizException, BOSException {
        currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId()));
        Integer precision = currency.getPrecision();
        BigDecimal balance = info.getBalance();
        BigDecimal max = Constants.ZERO;
        BigDecimal sourceMax = Constants.ZERO;
        BigDecimal sourceCurExRate = this.txtSourceCurExRate.getBigDecimalValue();
        if (this.getOprtState().equals(OprtState.EDIT)) {
            max = balance.add(this.editData.getAmount());
            sourceMax = balance.add(this.editData.getAmount()).divide(sourceCurExRate, (int)precision, 4);
        } else {
            max = balance;
            sourceMax = balance.divide(sourceCurExRate, (int)precision, 4);
        }
        this.txtAmount.setMaximumValue((Comparable)max);
        this.txtSourceAmount.setMaximumValue((Comparable)sourceMax);
        this.txtAmount.setMinimumValue((Comparable)Constants.ZERO);
        this.txtSourceAmount.setMinimumValue((Comparable)Constants.ZERO);
        if (this.txtAmount.getBigDecimalValue() != null && this.txtAmount.getBigDecimalValue().compareTo(max) > 0) {
            this.txtAmount.setValue((Object)max);
        }
        if (this.txtSourceAmount.getBigDecimalValue() != null && this.txtSourceAmount.getBigDecimalValue().compareTo(sourceMax) > 0) {
            this.txtSourceAmount.setValue((Object)sourceMax);
        }
    }

    private static SelectorItemCollection getLetterOfCreditSelectors() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("ID"));
        selector.add(new SelectorItemInfo("IsDYZ"));
        return selector;
    }

    private void fireVOChangeListener() {
        try {
            IVOChangeListener listener;
            if (this.finBillInfo != null && LoanInfo.BOSTYPE.equals((Object)this.finBillInfo.getBOSType()) && (listener = this.getVOChangeListener()) != null) {
                VOChangeEvent e = new VOChangeEvent((Object)new LoanEditUI());
                if ((IObjectValue)this.getUIContext().get("LOAN.VO") != null) {
                    e.setCurrentObject((IObjectValue)this.getUIContext().get("LOAN.VO"));
                }
                e.setNewObject((IObjectValue)this.finBillInfo);
                e.setState(OprtState.EDIT);
                listener.change(e);
            }
            this.getUIContext().put("LOAN.VO", this.finBillInfo);
        }
        catch (Throwable e) {
            this.handUIException(e);
            this.abort();
        }
    }

    protected void afterSubmitAddNew() {
        super.afterSubmitAddNew();
        if (this.finBillInfo != null && LoanInfo.BOSTYPE.equals((Object)this.finBillInfo.getBOSType())) {
            IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
            iMutex.releaseObjIDForUpdate(this.finBillInfo.getId().toString());
        }
    }

    public boolean destroyWindow() {
        if (this.finBillInfo != null && LoanInfo.BOSTYPE.equals((Object)this.finBillInfo.getBOSType())) {
            IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
            iMutex.releaseObjIDForUpdate(this.finBillInfo.getId().toString());
        }
        return super.destroyWindow();
    }

    public OrgType getMainOrgType() {
        return OrgType.Company;
    }

    public KDBizPromptBox getMainOrg() {
        return this.prmtMainOrgCompany;
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        if (!this.ready4User) {
            return;
        }
        if (chgVo.getNewOrg() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)"newOrg_notNull"));
            this.getMainOrg().setValue(chgVo.getOldOrg());
        }
        this.envirRpc.setCurrentCompany((CompanyOrgUnitInfo)chgVo.getNewOrg());
        try {
            this.envirRpc = (RepaymentEditUIEnvirRpc)this.batchFetchData(this.envirRpc);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.txtNumber.setText(null);
        this.prmtBankAcct.setValue(null);
        this.prmtLoanAcct.setValue(null);
        this.prmtacutionAcctBank.setValue(null);
        this.prmtLoanAcct.setValue(null);
        this.prmtSourceBill.setValue(null);
        this.prmtBgItem.setValue(null);
        this.prmtInterestAcct.setValue(null);
        this.prmtCostCenter.setValue(null);
        this.comboSourceType.setSelectedItem(null);
        this.txtSourceAmount.setValue(null);
        this.txtAmount.setValue(null);
        this.txtSourceTotalAmt.setValue(null);
        this.txtInterest.setValue(null);
        this.txtPayment.setValue(null);
        this.txtLocalAmount.setValue(null);
        this.txtLocalCurExRate.setValue(null);
        this.txtRepayTotalAmt.setValue(null);
        this.txtSourceRemAmt.setValue(null);
        try {
            this.initControl();
            this.calcCompsValue();
            this.editData.setNumber(null);
            this.txtNumber.setText(null);
            FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.envirRpc.getCurrentCompany().getId().toString(), (FmRpcCacheInfo)this.envirRpc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getPermissionItem() {
        return this.getPermissionItem(this.getOprtState());
    }

    protected String getPermissionItem(String status) {
        if ("ADDNEW".equals(status)) {
            return "fin_Repayment_addnew";
        }
        if ("EDIT".equals(status)) {
            return "fin_Repayment_update";
        }
        if ("VIEW".equals(status) || "FINDVIEW".equals(status)) {
            return "fin_Repayment_list";
        }
        return null;
    }

    public IF7ContextChange getF7ContextManager() {
        if (this.F7ContextManager == null) {
            this.F7ContextManager = new DefaultF7ContextManager((Component)((Object)this), OrgType.Company, ContextTypeEnum.INQUERYING, 0);
            return this.F7ContextManager;
        }
        return this.F7ContextManager;
    }

    public IF7Register getF7Register() {
        if (this.F7ContextManager == null) {
            this.F7ContextManager = new DefaultF7ContextManager((Component)((Object)this), OrgType.Company, ContextTypeEnum.INQUERYING, 0);
            return this.F7ContextManager;
        }
        return this.F7ContextManager;
    }

    public String getMainOrgKeyForCustomerParams(OrgType orgType) {
        return "company.id";
    }

    public boolean isSupportVirturalOrgs() {
        return false;
    }

    public boolean isSupportMultiOrgs() {
        return false;
    }

    @Override
    protected void prmtmarginCurrency_willShow(SelectorEvent e) throws Exception {
        AccountBankInfo acutionAcctBank = (AccountBankInfo)this.prmtacutionAcctBank.getValue();
        if (acutionAcctBank != null) {
            acutionAcctBank = (AccountBankInfo)AccountBankFactory.getRemoteInstance().getValue("select isByCurrency,currency.id where id='" + acutionAcctBank.getId().toString() + "'");
            if (acutionAcctBank.isIsByCurrency()) {
                EntityViewInfo ev = new EntityViewInfo("where id='" + acutionAcctBank.getCurrency().getId().toString() + "'");
                this.prmtmarginCurrency.setEntityViewInfo(ev);
                this.prmtmarginCurrency.getQueryAgent().resetRuntimeEntityView();
            } else {
                this.prmtmarginCurrency.setEntityViewInfo(null);
            }
        } else {
            this.prmtmarginCurrency.setEntityViewInfo(null);
        }
    }

    @Override
    protected void prmtacutionAcctBank_dataChanged(DataChangeEvent e) throws Exception {
        AccountBankInfo acutionAcctBank = (AccountBankInfo)e.getNewValue();
        if (acutionAcctBank != null && acutionAcctBank.isIsByCurrency()) {
            CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(acutionAcctBank.getCurrency().getId().toString()));
            this.prmtmarginCurrency.setValue((Object)currency);
        }
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.IVT_MANAGE;
    }

    private void checkFinalCheckout() throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentCompany();
        boolean canOp = FMClientHelper.checkFinalCheckout((SystemEnum)this.getSystemEnum(), (String)companyInfo.getId().toString(), (Date)this.editData.getBizDate());
        if (!canOp) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.recon.FmSettleResource", (String)"36_SETTLED"));
            SysUtil.abort();
        }
    }
}

