/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.IChangeOrgEvent;
import com.kingdee.eas.fm.fin.FinancingBillTypeEnum;
import com.kingdee.eas.fm.fin.LoanCollection;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.LoanInterestFactory;
import com.kingdee.eas.fm.fin.client.AbstractCalInterestBondUI;
import com.kingdee.eas.fm.fin.client.LoanModel;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CalInterestBondUI
extends AbstractCalInterestBondUI {
    private static final Logger logger = CoreUIObject.getLogger(CalInterestBondUI.class);
    private static final String RESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";
    private Set createdIntReceivedID;
    Map hm = new HashMap();

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        FMClientHelper.initCompanyF7((String)"fin_Loan_addnew", (KDBizPromptBox)this.prmtMainOrgCompany, (boolean)false, (IChangeOrgEvent)new IChangeOrgEvent(){

            public void afterMainOrgChanged(OrgChangeVO chgVo) {
                if (chgVo.getNewOrg() == null) {
                    MsgBox.showInfo((String)EASResource.getString((String)CalInterestBondUI.RESOURCE, (String)"newOrg_notNull"));
                    CalInterestBondUI.this.prmtMainOrgCompany.setValue(chgVo.getOldOrg());
                }
                CalInterestBondUI.this.prmtPayIntMode.setValue(null);
                CalInterestBondUI.this.prmtLoan.setValue(null);
            }
        });
    }

    private void init() throws Exception {
        this.chkStartDate.setSelected(false);
        this.startDate.setSupportedEmpty(false);
        this.startDate.setValue(null);
        this.startDate.setVisible(false);
        this.endDate.setSupportedEmpty(false);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"TM0025", CompareType.NOTEQUALS));
        evi.setFilter(filter);
        this.prmtPayIntMode.setEntityViewInfo(evi);
        this.prmtPayIntMode.getQueryAgent().resetRuntimeEntityView();
        this.prmtFinProduct.setQueryInfo("com.kingdee.eas.fm.fin.app.FinancingProductsQuery");
        this.prmtFinProduct.setDisplayFormat("$name$");
        this.prmtFinProduct.setEditFormat("$number$");
        this.prmtFinProduct.setCommitFormat("$number$");
        EntityViewInfo finProductEvi = LoanModel.getFinProductFilter(FinancingBillTypeEnum.BONDS);
        finProductEvi.getFilter().getFilterItems().add(new FilterItemInfo("isUsed", (Object)new Boolean(true)));
        this.prmtFinProduct.setEntityViewInfo(finProductEvi);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private boolean verify() {
        if (this.chkStartDate.isSelected() && this.startDate.getSqlDate().after(this.endDate.getSqlDate())) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"LoanEndDateLaterThanBeginDate"));
            return false;
        }
        return true;
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        this.checkFinalCheckout();
        this.createdIntReceivedID = new HashSet();
        this.createdIntReceivedID.clear();
        Set ids = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtLoan));
        if (ids.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"269_BillNumberIsNull"));
            this.abort();
            LoanCollection col = LoanFactory.getRemoteInstance().getLoanCollection(this.getEntityView());
            if (col != null) {
                this.hm = LoanInterestFactory.getRemoteInstance().batchPreInt(this.convertIDSet(col), this.startDate.getSqlDate(), this.endDate.getSqlDate(), true, false);
            }
        } else {
            this.hm = LoanInterestFactory.getRemoteInstance().batchPreInt(ids, this.startDate.getSqlDate(), this.endDate.getSqlDate(), true, false);
        }
        this.createdIntReceivedID = (Set)this.hm.get("createdID");
        if (this.createdIntReceivedID.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"338_CalInterestBondUI"));
            SysUtil.abort();
        } else {
            if (this.getUIContext().get("UIClassParam") != null) {
                // empty if block
            }
            this.disposeUIWindow();
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.createdIntReceivedID = null;
        super.disposeUIWindow();
    }

    @Override
    protected void chkStartDate_actionPerformed(ActionEvent e) throws Exception {
        if (this.chkStartDate.isSelected()) {
            this.startDate.setVisible(true);
            this.startDate.setValue((Object)new Date());
        } else {
            this.startDate.setVisible(false);
            this.startDate.setValue(null);
        }
    }

    @Override
    protected void prmtCurrency_dataChanged(DataChangeEvent e) throws Exception {
        this.prmtLoan.setValue(null);
    }

    @Override
    protected void prmtLoan_willShow(SelectorEvent e) throws Exception {
        if (this.prmtMainOrgCompany.getValue() == null) {
            MsgBox.showConfirm2((String)EASResource.getString((String)RESOURCE, (String)"cleckCompany"));
            SysUtil.abort();
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        this.setFilterItems(filter);
        evi.setFilter(filter);
        this.prmtLoan.setEntityViewInfo(evi);
        this.prmtLoan.getQueryAgent().resetRuntimeEntityView();
    }

    private void setFilterItems(FilterInfo filter) {
        Set payIntModeIdSet;
        filter.getFilterItems().add(new FilterItemInfo("balance", (Object)Constants.ZERO, CompareType.GREATER));
        filter.getFilterItems().add(new FilterItemInfo("entLoanID.id", null));
        filter.getFilterItems().add(new FilterItemInfo("transBill.id", null));
        filter.getFilterItems().add(new FilterItemInfo("consignLoan.id", null));
        filter.getFilterItems().add(new FilterItemInfo("isBonds", (Object)Boolean.TRUE));
        FilterInfo fiinfo = new FilterInfo();
        fiinfo.getFilterItems().add(new FilterItemInfo("payIntMode.number", (Object)"TM0025", CompareType.NOTEQUALS));
        fiinfo.getFilterItems().add(new FilterItemInfo("payIntMode.id", null, CompareType.EQUALS));
        fiinfo.setMaskString("(#0 or #1)");
        Set currencyIdSet = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtCurrency));
        if (currencyIdSet != null && currencyIdSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyIdSet, CompareType.INCLUDE));
        }
        if ((payIntModeIdSet = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtPayIntMode))) != null && payIntModeIdSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("payIntMode.id", (Object)payIntModeIdSet, CompareType.INCLUDE));
        }
        ConvertUtils.FILTER((FilterInfo)filter, (FilterItemInfo[])new FilterItemInfo[]{ConvertUtils.FITEM((Object[])new Object[]{"company.id", ConvertUtils.IDSTR((Object)this.prmtMainOrgCompany.getValue())})});
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(0), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(3)));
        try {
            filter.mergeFilter(fiinfo, "and");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private EntityViewInfo getEntityView() {
        EntityViewInfo env = this.prmtLoan.getEntityViewInfo();
        if (env == null) {
            env = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        this.setFilterItems(filter);
        env.setFilter(filter);
        return env;
    }

    private Set convertIDSet(LoanCollection col) {
        HashSet<String> idSets = new HashSet<String>();
        LoanInfo info = null;
        for (int i = 0; i < col.size(); ++i) {
            info = col.get(i);
            idSets.add(info.getId().toString());
        }
        return idSets;
    }

    public static Map showCalInterestBondUI(CoreUI ui) {
        Map returnValue = new HashMap();
        try {
            UIContext uiContext = new UIContext((Object)ui);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CalInterestBondUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            returnValue = ((CalInterestBondUI)uiWindow.getUIObject()).getReturnValueWithMsg();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        Set id = (Set)returnValue.get("createdID");
        if (EmptyUtil.isEmpty((Collection)id)) {
            SysUtil.abort();
        }
        if (id.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"338_CalInterestBondUI"));
        } else {
            String msg = (String)returnValue.get("failureMsg");
            if (msg != null && msg.length() > 0) {
                MsgBox.showInfo((String)msg);
                Object var3_4 = null;
            }
        }
        return returnValue;
    }

    private Map getReturnValueWithMsg() {
        return this.hm;
    }

    @Override
    protected void endDate_dataChanged(DataChangeEvent e) throws Exception {
        this.prmtPayIntMode.setData(null);
        Date tmp = DateTimeUtils.truncateDate((Date)this.endDate.getSqlDate());
        Calendar c = Calendar.getInstance();
        c.setTime(tmp);
        int month = c.get(2);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (month == 2 || month == 5 || month == 8) {
            HashSet<Integer> integerSet = new HashSet<Integer>();
            integerSet.add(new Integer(1));
            integerSet.add(new Integer(3));
            integerSet.add(new Integer(100));
            filter.getFilterItems().add(new FilterItemInfo("cycleType", integerSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)"TM0025", CompareType.NOTEQUALS));
            evi.setFilter(filter);
            this.prmtPayIntMode.setEntityViewInfo(evi);
        } else if (month == 11) {
            this.prmtPayIntMode.setEntityViewInfo(null);
        } else {
            HashSet<Integer> integerSet = new HashSet<Integer>();
            integerSet.add(new Integer(1));
            integerSet.add(new Integer(100));
            filter.getFilterItems().add(new FilterItemInfo("cycleType", integerSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)"TM0025", CompareType.NOTEQUALS));
            evi.setFilter(filter);
            this.prmtPayIntMode.setEntityViewInfo(evi);
        }
    }

    @Override
    protected void prmtLoan_willCommit(CommitEvent e) throws Exception {
        if (this.prmtMainOrgCompany.getValue() == null) {
            MsgBox.showConfirm2((String)EASResource.getString((String)RESOURCE, (String)"cleckCompany"));
            SysUtil.abort();
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        this.setFilterItems(filter);
        evi.setFilter(filter);
        this.prmtLoan.setEntityViewInfo(evi);
        this.prmtLoan.getQueryAgent().resetRuntimeEntityView();
    }

    private void checkFinalCheckout() throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentCompany();
        Calendar cl = Calendar.getInstance();
        cl.setTime((Date)this.endDate.getValue());
        cl.add(5, 1);
        boolean canOp = FMClientHelper.checkFinalCheckout((SystemEnum)SystemEnum.IVT_MANAGE, (String)companyInfo.getId().toString(), (Date)cl.getTime());
        if (!canOp) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.recon.FmSettleResource", (String)"36_SETTLED"));
            SysUtil.abort();
        }
    }
}

