/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIDialog;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fi.cas.client.RecPayHandler;
import com.kingdee.eas.fm.common.DepTypeEnum;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.common.TimeDepositTypeEnum;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.CompDepositAccountBillFactory;
import com.kingdee.eas.fm.fin.CompDepositAccountBillInfo;
import com.kingdee.eas.fm.fin.TDException;
import com.kingdee.eas.fm.fin.TimeDepositConstants;
import com.kingdee.eas.fm.fin.TimeDepositHelper;
import com.kingdee.eas.fm.fin.client.AbstractCompDepositAccountBillEditUI;
import com.kingdee.eas.fm.fin.client.CompDepositBillDataProvider;
import com.kingdee.eas.fm.fin.client.IntReceivedBillEditUI;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.im.IntTermFactory;
import com.kingdee.eas.fm.im.IntTermInfo;
import com.kingdee.eas.fm.im.TermTypeEnum;
import com.kingdee.eas.fm.ivt.ChLoanHelper;
import com.kingdee.eas.fm.td.TimeDepositApplyFactory;
import com.kingdee.eas.fm.td.TimeDepositApplyInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CompDepositAccountBillEditUI
extends AbstractCompDepositAccountBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(CompDepositAccountBillEditUI.class);
    private CompanyOrgUnitInfo companyInfo = null;
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    public static final String COMPDEPOSITBILL_FILENAME = "/FM/FIN/COMPDEPOSIT";
    private TimeDepositHelper helper = TimeDepositHelper.getInstance();
    private BankInfo clearingHouse;
    private boolean isHis = false;
    private boolean isRedeposit = false;
    private String currentOperStatus = null;
    private Map successHm;
    private CompanyOrgUnitInfo clearingHouseCompany;
    private static final String OUT_ACCOUNT = EASResource.getString((String)"com.kingdee.eas.fm.fin.TdResource", (String)"out_account");
    private static final String CUR_ACCOUNT = EASResource.getString((String)"com.kingdee.eas.fm.fin.TdResource", (String)"cur_account");

    public CompDepositAccountBillEditUI() throws Exception {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (this.companyInfo == null) {
            this.companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        }
    }

    @Override
    public void loadFields() {
        Map listeners = null;
        try {
            listeners = FMClientHelper.removeCompListeners((CoreUI)this);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (this.editData.getCompany() != null) {
            FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.editData.getCompany().getId().toString());
        } else {
            FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString());
        }
        super.loadFields();
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        if (this.editData.getCurrency() != null) {
            UIUtil.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        }
        if (this.editData.getExchangeRate() != null) {
            this.txtExchangeRate.setValue((Object)this.editData.getExchangeRate());
        }
        if (this.editData.getNaturalAmt() != null) {
            this.txtNaturalAmt.setValue((Object)this.editData.getNaturalAmt());
        }
        if (this.editData.getExchangeRate() == null) {
            try {
                this.calcRate(this.editData.getCurrency(), null, null, (Date)this.pkBizDate.getValue());
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        } else {
            this.txtExchangeRate.setValue((Object)this.editData.getExchangeRate());
        }
        this.txtBalance.setValue((Object)this.editData.getBalance());
        this.txtExpireIn.setValue((Object)this.editData.getExpireIn());
        try {
            FMClientHelper.addCompListeners((CoreUI)this, (Map)listeners);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.calcNaturalAmt();
        }
        if ((TimeDepositTypeEnum.TIMEDEPOSIT_INNER.equals((Object)this.editData.getDepositType()) || TimeDepositTypeEnum.TIMEDEPOSIT_OUTER.equals((Object)this.editData.getDepositType())) && this.getOprtState().equals(OprtState.ADDNEW)) {
            this.calcMaturityDay();
            this.calcMatureIntAmt();
        } else {
            this.calcMatureIntAmt();
            try {
                if (this.getBOTPViewStatus() != 1) {
                    this.calYearRate();
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.setYearDays();
        }
        try {
            this.initItemsEnabled();
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    private void initItemsEnabled() throws Exception {
        Boolean isHisObj = (Boolean)this.getUIContext().get("addType");
        CompDepositAccountBillInfo info = (CompDepositAccountBillInfo)this.getDataObject();
        this.isHis = info != null && info.isIsHistory() || isHisObj != null && isHisObj != false;
        Boolean isRedepositObj = (Boolean)this.getUIContext().get("ISRTD");
        this.isRedeposit = info.isIsReDeposited() || isRedepositObj != null && isRedepositObj != false;
        this.initControl();
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            if (this.isRedeposit()) {
                this.initControlToRedeposit();
            } else if (this.isHis()) {
                this.initControlToHis();
            }
        } else if (this.isHis()) {
            this.initControlToHis();
        } else if (this.isRedeposit) {
            this.initControlToRedeposit();
        } else {
            this.initControl();
        }
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.actionCreateFrom.setEnabled(false);
            this.actionCreateFrom.setVisible(false);
        } else {
            this.actionCreateFrom.setEnabled(true);
            this.actionCreateFrom.setVisible(true);
        }
        this.initControlStatusByDepositType(false);
        this.initMaturityDay();
        this.initRate();
        if (this.getOprtState().equals("CERTIFICATEEDIT")) {
            this.btnSubmit.setEnabled(false);
            Component[] compArr = this.getComponents();
            for (int i = 0; i < compArr.length; ++i) {
                if (this.contCertificateNo.getName().equals(compArr[i].getName())) {
                    compArr[i].setEnabled(true);
                    continue;
                }
                compArr[i].setEnabled(false);
            }
        } else {
            this.btnSubmit.setEnabled(true);
        }
    }

    private void initRate() {
        IntRateTypeExpressionEnum intRateTypeExpressionEnum = (IntRateTypeExpressionEnum)this.comboIntRateTypeExpression.getSelectedItem();
        String strValue = "";
        if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.YEAR) {
            strValue = this.contRate.getBoundLabelText();
            strValue = strValue.replaceAll("\u2030", "%");
            this.contRate.setBoundLabelText(strValue);
            strValue = this.contCurRate.getBoundLabelText();
            strValue = strValue.replaceAll("\u2030", "%");
            this.contCurRate.setBoundLabelText(strValue);
            strValue = this.contBaseRate.getBoundLabelText();
            strValue = strValue.replaceAll("\u2030", "%");
            this.contBaseRate.setBoundLabelText(strValue);
        } else if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.MONTH) {
            strValue = this.contRate.getBoundLabelText();
            strValue = strValue.replaceAll("%", "\u2030");
            this.contRate.setBoundLabelText(strValue);
            strValue = this.contCurRate.getBoundLabelText();
            strValue = strValue.replaceAll("%", "\u2030");
            this.contCurRate.setBoundLabelText(strValue);
            strValue = this.contBaseRate.getBoundLabelText();
            strValue = strValue.replaceAll("%", "\u2030");
            this.contBaseRate.setBoundLabelText(strValue);
        } else {
            strValue = this.contRate.getBoundLabelText();
            strValue = strValue.replaceAll("%", "\u2030");
            this.contRate.setBoundLabelText(strValue);
            strValue = this.contCurRate.getBoundLabelText();
            strValue = strValue.replaceAll("%", "\u2030");
            this.contCurRate.setBoundLabelText(strValue);
            strValue = this.contBaseRate.getBoundLabelText();
            strValue = strValue.replaceAll("%", "\u2030");
            this.contBaseRate.setBoundLabelText(strValue);
        }
    }

    private void initControlStatusByDepositType(boolean clearValue) {
        if (this.comboDepositType.getSelectedItem() == TimeDepositTypeEnum.TIMEDEPOSIT_INNER || this.comboDepositType.getSelectedItem() == TimeDepositTypeEnum.TIMEDEPOSIT_OUTER) {
            this.doSettingRelatedToTimeDeposit(clearValue);
            this.editData.setNull("depType");
        } else {
            this.doSettingRelatedToCallDeposit(clearValue);
        }
        if (this.comboDepositType.getSelectedItem() == TimeDepositTypeEnum.TIMEDEPOSIT_OUTER || this.comboDepositType.getSelectedItem() == TimeDepositTypeEnum.CALLDEPOSIT_OUTER) {
            this.prmtCorpCurAcct.setRequired(false);
        } else {
            this.prmtCorpCurAcct.setRequired(true);
        }
    }

    @Override
    public void storeFields() {
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        super.storeFields();
        this.editData.setBalance(this.txtBalance.getBigDecimalValue());
        this.editData.setIsreceived(false);
        if (this.editData.isIsHistory()) {
            this.editData.setInitBalanceOfHistoryBill(this.editData.getBalance());
        } else {
            this.editData.setInitBalanceOfHistoryBill(this.editData.getAmount());
        }
        if (!this.editData.isIsHistory()) {
            this.editData.setLastIntDate(DateTimeUtils.truncateDate((Date)this.editData.getEffectiveDate()));
        }
    }

    public void onLoad() throws Exception {
        if (!this.getOprtState().equals("FINDVIEW")) {
            FSClientHelper.checkClearingHouseCompany();
            this.clearingHouse = FSClientHelper.getClearingHouse();
            this.clearingHouseCompany = this.clearingHouse.getRelatedCompany();
            if (this.clearingHouse.getSettleDate() == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"123_CompDepositAccountBillEditUI"));
                SysUtil.abort();
            }
        }
        CashHelper.initCombCurrency((KDComboBox)this.comboCurrency, (boolean)false);
        super.onLoad();
        FMClientHelper.initDecimalField((BasicFormattedTextField)this.txtExchangeRate);
        Boolean isHisObj = (Boolean)this.getUIContext().get("addType");
        Boolean isRedepositObj = (Boolean)this.getUIContext().get("ISRTD");
        if (isHisObj != null) {
            this.isHis = isHisObj;
        }
        if (isRedepositObj != null) {
            this.isRedeposit = isRedepositObj;
        }
        this.calcMatureIntAmt();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        if (this.editData.isIsHistory()) {
            this.actionCreateFrom.setVisible(false);
            this.pkdlastRecvIntDay.setVisible(true);
            this.contLastRecvIntDay.setVisible(true);
            this.pkdlastPayDay.setVisible(true);
            this.contLastPayDay.setVisible(true);
            if (this.editData.getLastPayDate() == null) {
                this.pkdlastPayDay.setValue((Object)((Date)this.pkEffectiveDate.getValue()));
                this.editData.setLastPayDate((Date)this.pkEffectiveDate.getValue());
            }
            this.initOldData((IObjectValue)this.editData);
        }
        this.pkBizDate.getValue();
        F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtMyhandler);
        F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtAccountant);
        F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtCreator);
        this.txtAmount.setHorizontalAlignment(4);
        this.txtNaturalAmt.setHorizontalAlignment(4);
        this.txtBalance.setHorizontalAlignment(4);
        this.txtRate.setHorizontalAlignment(4);
        this.txtBaseRate.setHorizontalAlignment(4);
        this.txtIntFreeAmt.setHorizontalAlignment(4);
        this.txtExpireIn.setHorizontalAlignment(4);
        this.txtExchangeRate.setHorizontalAlignment(4);
        this.txtConvertDays.setHorizontalAlignment(4);
        this.txtCurRate.setHorizontalAlignment(4);
        this.txtAmount.setRemoveingZeroInDispaly(false);
        this.txtNaturalAmt.setRemoveingZeroInDispaly(false);
        this.txtBalance.setRemoveingZeroInDispaly(false);
        this.txtRate.setRemoveingZeroInDispaly(false);
        this.txtBaseRate.setRemoveingZeroInDispaly(false);
        this.txtExchangeRate.setRemoveingZeroInDispaly(false);
        this.txtCurRate.setRemoveingZeroInDispaly(false);
        this.txtExpireIn.setRemoveingZeroInDispaly(false);
        this.txtIntFreeAmt.setRemoveingZeroInDispaly(false);
        this.txtAmount.setMaximumValue((Comparable)Constants.MAX_VALUE);
        this.prmtIntRateTable.setBackground(new Color(16579551));
        this.prmtInterm.setForeground(new Color(16579551));
        UIUtil.updateUITitle((CoreUIObject)this, (String)this.resHelper.getString("this.title"));
        if (this.isHis || this.editData.isIsHistory()) {
            String msgStr = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"523_CompDepositAccountBillEditUI"), this.getUITitle());
            this.setUITitle(msgStr);
        }
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)this.prmtProject);
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.input, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        FMClientHelper.initFundFlowItemF7((IUIObject)this, (KDLabelContainer)this.contBgItem, (KDLabelContainer)this.contFundFlowItem, (FundFlowDirection)FundFlowDirection.IN);
        if (this.getOprtState().equals("CERTIFICATEEDIT")) {
            this.contFundFlowItem.setEnabled(false);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.txtNumber.isEnabled()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CompDepositAccountBillEditUI.this.txtNumber.requestFocus();
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CompDepositAccountBillEditUI.this.pkBizDate.requestFocus();
                }
            });
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
    }

    private void setPre() {
        this.txtAmount.setPrecision(2);
        this.txtAmount.setRemoveingZeroInDispaly(false);
        this.txtNaturalAmt.setPrecision(2);
        this.txtNaturalAmt.setRemoveingZeroInDispaly(false);
        this.txtBalance.setPrecision(2);
        this.txtBalance.setRemoveingZeroInDispaly(false);
        this.txtRate.setPrecision(4);
        this.txtRate.setRemoveingZeroInDispaly(false);
        this.txtCurRate.setPrecision(4);
        this.txtCurRate.setRemoveingZeroInDispaly(false);
        this.txtBaseRate.setPrecision(4);
        this.txtBaseRate.setRemoveingZeroInDispaly(false);
    }

    protected IObjectValue createNewData() {
        CompDepositAccountBillInfo info = new CompDepositAccountBillInfo();
        Boolean isRTD = (Boolean)this.getUIContext().get("ISRTD");
        Boolean isHis = (Boolean)this.getUIContext().get("ISHIS");
        if (isRTD != null) {
            info.setIsReDeposited(isRTD);
        } else {
            info.setIsReDeposited(false);
        }
        if (isHis != null) {
            info.setIsHistory(isHis);
            info.setLastIntDate(DateUtil.getDayBegin());
        } else {
            info.setIsHistory(false);
            info.setLastIntDate(null);
        }
        info.setCompany(this.currentCompany);
        info.setEffectiveDate(this.clearingHouse.getSettleDate());
        info.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
        info.setAmount(Constants.ZERO);
        info.setHandler(info.getCreator());
        info.setDepositBank(this.clearingHouse);
        info.setBasePoints(Constants.ZERO);
        info.setYearDays(360);
        info.setBaseRate(Constants.ZERO);
        info.setRate(Constants.ZERO);
        info.setExpireIn(Constants.ZERO);
        info.setCurRate(Constants.ZERO);
        info.setBizDate(this.clearingHouse.getSettleDate());
        info.setIntRateTypeExpression(IntRateTypeExpressionEnum.YEAR);
        info.setCurrency(this.clearingHouseCompany.getBaseCurrency());
        info.setIsreceived(false);
        info.setCurrency(this.currentCompany.getBaseCurrency());
        info.setDepositType(TimeDepositTypeEnum.TIMEDEPOSIT_INNER);
        info.setIntFreeAmt(Constants.ZERO);
        info.setFiVouchered(false);
        info.setIsChangeByReDeposited(false);
        info.setBalance(Constants.ZERO);
        if (info.isIsReDeposited()) {
            this.copyValueToNewData_rtd(info);
        } else if (this.isHis()) {
            info.setIsHistory(true);
        }
        this.setNumberForMat(info);
        info.setBaseRate(Constants.ZERO);
        return info;
    }

    private void setNumberForMat(CompDepositAccountBillInfo objectValue) {
        if (null != objectValue.getCurrency()) {
            int baseCurrPre = FMClientHelper.getPrecOfCurrency((BOSUuid)BOSUuid.read((String)objectValue.getCurrency().getId().toString()));
            this.setPre(baseCurrPre);
        }
    }

    private void setPre(int baseCurrPre) {
        this.txtAmount.setPrecision(baseCurrPre);
        this.txtAmount.setRemoveingZeroInDispaly(false);
        this.txtNaturalAmt.setPrecision(baseCurrPre);
        this.txtNaturalAmt.setDataType(1);
        this.txtNaturalAmt.setRemoveingZeroInDispaly(false);
        this.txtBalance.setPrecision(baseCurrPre);
        this.txtBalance.setRemoveingZeroInDispaly(false);
        this.txtRate.setPrecision(4);
        this.txtRate.setRemoveingZeroInDispaly(false);
    }

    private void copyValueToNewData_rtd(CompDepositAccountBillInfo objectValue) {
        String id = (String)this.getUIContext().get("infoid");
        CompDepositAccountBillInfo CompDepositAccountBill2 = null;
        try {
            CompDepositAccountBill2 = (CompDepositAccountBillInfo)this.getValue((IObjectPK)new ObjectUuidPK(id));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        objectValue.setCompany(CompDepositAccountBill2.getCompany());
        objectValue.setDepCompany(CompDepositAccountBill2.getDepCompany());
        objectValue.setDepositBank(CompDepositAccountBill2.getDepositBank());
        objectValue.setDepositType(CompDepositAccountBill2.getDepositType());
        objectValue.setIntRateTypeExpression(CompDepositAccountBill2.getIntRateTypeExpression());
        objectValue.setEffectiveDate(DateTimeUtils.truncateDate((Date)CompDepositAccountBill2.getMaturityDay()));
        objectValue.setInterm(CompDepositAccountBill2.getInterm());
        objectValue.setRate(CompDepositAccountBill2.getRate());
        objectValue.setCurRate(CompDepositAccountBill2.getCurRate());
        objectValue.setYearDays(CompDepositAccountBill2.getYearDays());
        objectValue.setCorpDepAcct(CompDepositAccountBill2.getCorpDepAcct());
        objectValue.setCorpCurAcct(CompDepositAccountBill2.getCorpDepAcct());
        objectValue.setCurrency(CompDepositAccountBill2.getCurrency());
        objectValue.setAmount(CompDepositAccountBill2.getBalance());
        objectValue.setHandler(CompDepositAccountBill2.getHandler());
        String msgStr = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"524_CompDepositAccountBillEditUI"), CompDepositAccountBill2.getNumber());
        objectValue.setDescription(msgStr);
        objectValue.setIsReDeposited(true);
        objectValue.setBalance(objectValue.getAmount());
        objectValue.setSourceBillId(id);
        objectValue.setAccrualToDepositAmt(Constants.ZERO);
        objectValue.setExchangeRate(CompDepositAccountBill2.getExchangeRate());
        objectValue.setCertificateNo(CompDepositAccountBill2.getCertificateNo());
    }

    private boolean isHis() {
        return this.isHis;
    }

    private boolean isRedeposit() {
        return this.isRedeposit;
    }

    private void initControl() throws Exception {
        this.pkBizDate.setEnabled(true);
        this.comboDepositType.setEnabled(true);
        this.isAccrualToDepositAmt.setEnabled(false);
        this.prmtCorpDepAcct.setEnabled(true);
        this.prmtDepCompany.setEnabled(false);
        this.prmtCorpCurAcct.setEnabled(true);
        this.comboCurrency.setEnabled(true);
        this.txtAmount.setEnabled(true);
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (this.currentCompany.getBaseCurrency() != null && currencyInfo != null) {
            if (this.currentCompany.getBaseCurrency().getId().toString().equals(currencyInfo.getId().toString())) {
                this.txtExchangeRate.setEnabled(false);
                this.txtExchangeRate.setEditable(false);
            } else {
                this.txtExchangeRate.setEnabled(true);
                this.txtExchangeRate.setEditable(true);
            }
        }
        this.txtExchangeRate.setSupportedEmpty(false);
        this.txtExchangeRate.setDataType(1);
        this.txtNaturalAmt.setEnabled(false);
        this.txtBalance.setEnabled(false);
        this.pkEffectiveDate.setEnabled(true);
        this.prmtInterm.setEnabled(true);
        this.pkMaturityDay.setEnabled(false);
        this.comboIntRateTypeExpression.setEnabled(true);
        this.txtConvertDays.setEnabled(true);
        this.txtRate.setEnabled(true);
        this.txtIntFreeAmt.setEnabled(true);
        this.txtExpireIn.setEnabled(false);
        this.txtCurRate.setEnabled(true);
        this.prmtMyhandler.setEnabled(true);
        this.txtCertificateNo.setEnabled(true);
        this.prmtIntAccount.setEnabled(true);
        this.pkdlastRecvIntDay.setEnabled(false);
        this.pkdlastRecvIntDay.setRequired(false);
        this.pkdlastPayDay.setEnabled(false);
        this.pkdlastPayDay.setRequired(false);
        this.prmtProject.setEnabled(true);
        this.txtDigest.setEnabled(true);
        this.prmtCreator.setEnabled(false);
        this.prmtAccountant.setEnabled(false);
        this.prmtDepositBank.setEnabled(false);
        this.contCorpCurAcct.setBoundLabelText(CUR_ACCOUNT);
    }

    private void initControlToRedeposit() {
        this.comboDepositType.setEnabled(false);
        this.isAccrualToDepositAmt.setEnabled(true);
        this.prmtDepositBank.setEnabled(false);
        this.prmtCorpCurAcct.setEnabled(false);
        this.comboCurrency.setEnabled(false);
        this.txtAmount.setEnabled(false);
        this.pkEffectiveDate.setEnabled(false);
        this.btnSave.setVisible(false);
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fm.fin.TdResource", (String)"redepositUITitle"));
        this.contCorpCurAcct.setBoundLabelText(OUT_ACCOUNT);
    }

    private void initControlToHis() {
        this.txtBalance.setEnabled(true);
        this.contLastRecvIntDay.setVisible(true);
        this.pkdlastRecvIntDay.setEnabled(true);
        this.pkdlastRecvIntDay.setRequired(true);
        this.pkdlastPayDay.setEnabled(true);
        this.pkdlastPayDay.setRequired(true);
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fm.fin.TdResource", (String)"historyBillUITile"));
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        ClientVerifyHelper.verifyRequire((CoreUIObject)this);
        this.doBizVerify();
    }

    private void doBizVerify() throws TDException, EASBizException, BOSException {
        if (!FMClientHelper.verifyIsPlus((String)this.txtAmount.getBigDecimalValue().toString())) {
            this.txtAmount.requestFocus(true);
            throw new TDException(TDException.AMT_NEGATIVE_EXC);
        }
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtIntFreeAmt);
        if (!FMClientHelper.verifyIsPlus1((String)this.txtIntFreeAmt.getBigDecimalValue().toString())) {
            this.txtIntFreeAmt.requestFocus(true);
            throw new TDException(TDException.FLOORAMT_NEGATIVE_EXC);
        }
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtBalance);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtRate);
        if (!FMClientHelper.verifyIsPlus((String)this.txtRate.getBigDecimalValue().toString())) {
            this.txtRate.requestFocus(true);
            throw new TDException(TDException.YEARRATE_NEAGTIVE_EXC);
        }
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtCurRate);
        if (!FMClientHelper.verifyIsPlus1((String)this.txtCurRate.getBigDecimalValue().toString())) {
            this.txtCurRate.requestFocus(true);
            throw new TDException(TDException.CURYEARRATE_NEAGTIVE_EXC);
        }
        this.checkCtrlStrategy();
        if (this.isHis()) {
            Date startDate;
            if (this.txtBalance.getBigDecimalValue().intValue() == 0 || this.txtBalance.getBigDecimalValue().doubleValue() > this.txtAmount.getBigDecimalValue().doubleValue()) {
                this.txtBalance.requestFocus();
                throw new TDException(TDException.HIS_REMAMT_OVERMANY);
            }
            Date lastRecDate = (Date)this.pkdlastRecvIntDay.getValue();
            if (lastRecDate.before(startDate = (Date)this.pkEffectiveDate.getValue())) {
                throw new TDException(TDException.HIS_LASTRECDATE_EXC);
            }
        }
    }

    private void checkCtrlStrategy() throws TDException, EASBizException, BOSException {
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (!this.editData.isIsHistory()) {
            this.editData.setLastIntDate(DateTimeUtils.truncateDate((Date)this.editData.getEffectiveDate()));
        }
        super.actionSave_actionPerformed(e);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        if (this.getOprtState().equals(OprtState.ADDNEW) && this.editData.isIsReDeposited()) {
            Boolean succ;
            this.editData.setCU(ContextHelperFactory.getRemoteInstance().getCurrentCtrlUnit());
            CompDepositAccountBillFactory.getRemoteInstance().checkNumberDup(null, (CoreBillBaseInfo)this.editData);
            this.editData.setBalance(this.editData.getAmount());
            CompDepositAccountBillInfo rInfo = this.editData;
            if (rInfo.getId() == null) {
                this.editData.setId(BOSUuid.create((BOSObjectType)rInfo.getBOSType()));
            }
            this.storeFields();
            this.successHm = IntReceivedBillEditUI.showIntReceiveEditUI((CoreUIObject)this, (CoreBaseInfo)this.editData, "2", (String)this.getUIContext().get("infoid"));
            this.initOldData((IObjectValue)this.editData);
            if (this.successHm != null && (succ = (Boolean)this.successHm.get("successFlag")) != null && succ.booleanValue()) {
                this.uiWindow.close();
            }
        } else {
            if (!this.editData.isIsHistory()) {
                this.editData.setLastIntDate(DateTimeUtils.truncateDate((Date)this.editData.getEffectiveDate()));
            } else {
                TimeDepositTypeEnum type;
                Date lastPayDay = (Date)this.pkdlastPayDay.getValue();
                Date effectiveDate = (Date)this.pkEffectiveDate.getValue();
                Date maturityDay = (Date)this.pkMaturityDay.getValue();
                if (lastPayDay == null) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"129_CompDepositAccountBillEditUI"));
                    SysUtil.abort();
                }
                if (effectiveDate == null) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"130_CompDepositAccountBillEditUI"));
                    SysUtil.abort();
                }
                if (((type = (TimeDepositTypeEnum)this.comboDepositType.getSelectedItem()) == TimeDepositTypeEnum.TIMEDEPOSIT_INNER || type == TimeDepositTypeEnum.TIMEDEPOSIT_OUTER) && maturityDay == null) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"131_CompDepositAccountBillEditUI"));
                    SysUtil.abort();
                }
                if (lastPayDay.before(effectiveDate)) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"132_CompDepositAccountBillEditUI"));
                    SysUtil.abort();
                }
                if (maturityDay != null && maturityDay.before(lastPayDay)) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"133_CompDepositAccountBillEditUI"));
                    SysUtil.abort();
                }
            }
            boolean isSubmitIsAccepted = ContextHelperFactory.getRemoteInstance().getBooleanParam("FIN017", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
            if (isSubmitIsAccepted) {
                FinHelper.checkInnerAcctCtrl((InnerAccountInfo)this.prmtCorpCurAcct.getValue(), (CurrencyInfo)this.comboCurrency.getSelectedItem(), this.txtAmount.getBigDecimalValue());
            }
            super.actionSubmit_actionPerformed(e);
            this.storeFields();
            this.initOldData((IObjectValue)this.editData);
        }
    }

    public void actionSubmitOption_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmitOption_actionPerformed(e);
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreateTo_actionPerformed(e);
    }

    @Override
    public void actionViewBgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fm.fin.app.CompDepositAccountBill", null, (IObjectValue)this.editData);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CompDepositAccountBillFactory.getRemoteInstance();
    }

    private void doSettingRelatedToTimeDeposit(boolean clearValue) {
        this.contRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.TdResource", (String)"YearRate"));
        if (!this.getOprtState().equals(OprtState.EDIT)) {
            this.prmtInterm.setEnabled(true);
        }
        this.comboIntRateTypeExpression.setEnabled(true);
        this.txtConvertDays.setEnabled(true);
        this.contInterm.setVisible(true);
        this.contMaturityDay.setVisible(true);
        this.contIntRateTable.setVisible(false);
        this.kDLabelType.setVisible(false);
        if (clearValue) {
            this.prmtIntRateTable.setValue(null);
            this.txtBaseRate.setValue((Object)Constants.ZERO);
        }
        this.txtRate.setEnabled(true);
        this.setYearDays();
        this.prmtInterm.setRequired(true);
        this.pkMaturityDay.setRequired(true);
        this.txtRate.setRequired(true);
        this.prmtIntRateTable.setRequired(false);
        this.prmtInterm.setEnabled(true);
        this.CboDepType.setSelectedItem(null);
    }

    private void doSettingRelatedToCallDeposit(boolean clearValue) {
        this.contRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.TdResource", (String)"RefYearRate"));
        this.txtExpireIn.setValue((Object)new BigDecimal(String.valueOf(0)));
        this.txtExpireIn.setEnabled(false);
        this.prmtInterm.setEnabled(false);
        this.comboIntRateTypeExpression.setEnabled(false);
        this.txtConvertDays.setEnabled(false);
        if (clearValue) {
            this.txtConvertDays.setValue(null);
        }
        this.txtRate.setEnabled(false);
        this.txtRate.setRequired(false);
        if (clearValue) {
            this.txtRate.setValue(null);
            this.prmtInterm.setValue(null);
        }
        this.contIntRateTable.setVisible(true);
        this.kDLabelType.setVisible(true);
        this.CboDepType.setSelectedItem((Object)DepTypeEnum.SevenDay);
        this.contInterm.setVisible(false);
        this.contMaturityDay.setVisible(false);
        if (clearValue) {
            this.pkMaturityDay.setValue(null);
            this.prmtInterm.setValue(null);
        }
        this.prmtInterm.setRequired(false);
        this.pkMaturityDay.setRequired(false);
        this.txtRate.setRequired(true);
        this.prmtIntRateTable.setRequired(true);
    }

    private void setYearDays() {
        IntRateTypeInfo rateType = (IntRateTypeInfo)this.prmtIntRateTable.getValue();
        if (rateType != null) {
            if (rateType.getId().toString().equals("lJlpCQEQEADgAAc+wKgSjiR9knQ=")) {
                this.txtConvertDays.setValue((Object)new Integer(360));
                this.comboIntRateTypeExpression.setEnabled(true);
                this.txtConvertDays.setEnabled(true);
            } else {
                this.comboIntRateTypeExpression.setSelectedItem((Object)rateType.getRateExpression());
                this.txtConvertDays.setValue((Object)new Integer(rateType.getFactorDay()));
                this.comboIntRateTypeExpression.setEnabled(false);
                this.txtConvertDays.setEnabled(false);
            }
        }
    }

    @Override
    protected void comboDepositType_itemStateChanged(ItemEvent e) throws Exception {
        super.comboDepositType_itemStateChanged(e);
        this.initControlStatusByDepositType(true);
    }

    @Override
    protected void comboIntRateTypeExpression_itemStateChanged(ItemEvent e) throws Exception {
        this.calcMatureIntAmt();
    }

    @Override
    protected void prmtCorpDepAcct_willShow(SelectorEvent e) throws Exception {
        CompanyOrgUnitInfo ApplyUnit;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("closed", (Object)"0"));
        filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)"1"));
        if (this.clearingHouse != null) {
            filter.getFilterItems().add(new FilterItemInfo("clearingHouse.id", (Object)this.clearingHouse.getId().toString()));
        }
        filter.getFilterItems().add(new FilterItemInfo("TYPE.Property", (Object)Integer.toString(2)));
        if (this.isRedeposit()) {
            filter.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)((CompanyOrgUnitInfo)this.prmtDepCompany.getData()).getId().toString()));
        }
        if ((ApplyUnit = (CompanyOrgUnitInfo)this.prmtDepCompany.getValue()) != null && this.getBOTPViewStatus() == 1 || this.getOprtState().equals(OprtState.EDIT)) {
            filter.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)ApplyUnit.getId().toString()));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtCorpDepAcct.setEntityViewInfo(evi);
        this.prmtCorpDepAcct.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtCorpDepAcct_willCommit(CommitEvent e) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("closed", (Object)"0"));
        filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)"1"));
        filter.getFilterItems().add(new FilterItemInfo("clearingHouse.id", (Object)this.clearingHouse.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("TYPE.Property", (Object)Integer.toString(2)));
        if (this.isRedeposit()) {
            filter.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)((CompanyOrgUnitInfo)this.prmtDepCompany.getData()).getId().toString()));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtCorpDepAcct.setEntityViewInfo(evi);
        this.prmtCorpDepAcct.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtCorpCurAcct_willShow(SelectorEvent e) throws Exception {
        if (this.prmtCorpDepAcct.getData() != null) {
            int result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"134_CompDepositAccountBillEditUI"));
            if (result == 0) {
                this.setprmtCorpCurAcctFilter(true);
            } else {
                this.setprmtCorpCurAcctFilter(false);
            }
        } else {
            this.setprmtCorpCurAcctFilter(false);
        }
    }

    @Override
    protected void prmtCorpCurAcct_willCommit(CommitEvent e) throws Exception {
        if (this.prmtCorpDepAcct.getData() != null) {
            int result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"134_CompDepositAccountBillEditUI"));
            if (result == 0) {
                this.setprmtCorpCurAcctFilter(true);
            } else {
                this.setprmtCorpCurAcctFilter(false);
            }
        } else {
            this.setprmtCorpCurAcctFilter(false);
        }
    }

    @Override
    protected void prmtCorpDepAcct_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtCorpDepAcct.getData() != null) {
            InnerAccountInfo loanAccount = (InnerAccountInfo)this.prmtCorpDepAcct.getData();
            CompanyOrgUnitInfo ApplyUnit = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(loanAccount.getApplyUnit().getId()));
            if (loanAccount != null) {
                this.prmtDepCompany.setValue((Object)ApplyUnit);
                if (!this.isRedeposit()) {
                    this.prmtCorpCurAcct.setValue(null);
                }
            }
        } else if (this.editData != null && !this.editData.isIsReDeposited()) {
            this.prmtDepCompany.setValue(null);
            this.prmtCorpCurAcct.setValue(null);
        }
    }

    @Override
    protected void prmtIntAccount_willShow(SelectorEvent e) throws Exception {
        this.setAccountFilter(this.clearingHouse, this.prmtIntAccount, this.companyInfo, 0);
    }

    @Override
    protected void comboCurrency_actionPerformed(ActionEvent e) throws Exception {
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (currencyInfo != null) {
            int pre = ChLoanHelper.getInstance().getCurrencyPre(currencyInfo.getId().toString());
            this.txtNaturalAmt.setDataType(1);
            this.txtNaturalAmt.setPrecision(pre);
            this.txtAmount.setPrecision(pre);
            this.txtIntFreeAmt.setPrecision(pre);
            this.txtBalance.setPrecision(pre);
        }
        if (currencyInfo == null) {
            return;
        }
        String baseCurrencyId = this.companyInfo.getBaseCurrency().getId().toString();
        if (baseCurrencyId.equals(currencyInfo.getId().toString())) {
            this.txtExchangeRate.setEnabled(false);
        } else if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.txtExchangeRate.setEnabled(true);
        }
        this.calcRate(currencyInfo, null, null, (Date)this.pkBizDate.getValue());
        this.calcNaturalAmt();
        this.calYearRate();
        if (this.currentCompany.getBaseCurrency() != null && currencyInfo != null) {
            if (this.currentCompany.getBaseCurrency().getId().toString().equals(currencyInfo.getId().toString())) {
                this.txtExchangeRate.setEnabled(false);
                this.txtExchangeRate.setEditable(false);
            } else {
                this.txtExchangeRate.setEnabled(true);
                this.txtExchangeRate.setEditable(true);
            }
        }
    }

    @Override
    protected void prmtIntRateTable_dataChanged(DataChangeEvent e) throws Exception {
        this.calcMatureIntAmt();
        this.calYearRate();
        this.setYearDays();
    }

    @Override
    protected void pkBizDate_dataChanged(DataChangeEvent e) throws Exception {
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        this.calcRate(currencyInfo, null, this.companyInfo, (Date)this.pkBizDate.getValue());
    }

    private void calcRate(CurrencyInfo currencyInfo, String destCurrId, CompanyOrgUnitInfo company, Date date) throws Exception {
        int prec = 5;
        if (!(EmptyUtil.isEmpty((CoreBaseInfo)currencyInfo) || EmptyUtil.isEmpty((Object)currencyInfo.getId()) || EmptyUtil.isEmpty((Object)date))) {
            prec = RecPayHandler.getExRatePrec((String)currencyInfo.getId().toString(), null, null, (Date)date);
            this.txtExchangeRate.setPrecision(prec == 0 ? 5 : prec);
            this.txtExchangeRate.setValue((Object)RecPayHandler.getExchangeRate((CurrencyInfo)currencyInfo, null, (Date)date));
        }
    }

    private void calcNaturalAmt() {
        BigDecimal depositAmt = this.txtAmount.getBigDecimalValue();
        BigDecimal exchangeRate = this.txtExchangeRate.getBigDecimalValue();
        if (depositAmt == null || exchangeRate == null) {
            return;
        }
        this.txtNaturalAmt.setValue((Object)depositAmt.multiply(exchangeRate));
    }

    private void calYearRate() throws Exception {
        if ((TimeDepositTypeEnum)this.comboDepositType.getSelectedItem() == TimeDepositTypeEnum.CALLDEPOSIT_INNER || (TimeDepositTypeEnum)this.comboDepositType.getSelectedItem() == TimeDepositTypeEnum.CALLDEPOSIT_OUTER) {
            IntRateTypeInfo intType = (IntRateTypeInfo)this.prmtIntRateTable.getValue();
            CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            if (intType == null || null == currency) {
                return;
            }
            BigDecimal yearrate = this.helper.calcYearRate(null, intType, currency, (Date)this.pkEffectiveDate.getValue());
            this.txtRate.setValue((Object)yearrate);
            this.txtBaseRate.setValue((Object)yearrate);
        }
    }

    @Override
    protected void txtAmount_focusLost(FocusEvent e) throws Exception {
        this.calcMatureIntAmt();
        this.calcNaturalAmt();
        this.calcBalance();
    }

    private void calcBalance() {
        if (!this.getOprtState().equals("VIEW")) {
            this.txtBalance.setValue((Object)this.txtAmount.getBigDecimalValue());
        }
    }

    private void calcMatureIntAmt() {
        if ((TimeDepositTypeEnum)this.comboDepositType.getSelectedItem() == TimeDepositTypeEnum.TIMEDEPOSIT_INNER || (TimeDepositTypeEnum)this.comboDepositType.getSelectedItem() == TimeDepositTypeEnum.TIMEDEPOSIT_OUTER) {
            if (this.txtAmount.getBigDecimalValue() == null || this.txtRate.getBigDecimalValue() == null || this.prmtInterm.getValue() == null || this.txtConvertDays.getNumberValue() == null || this.pkMaturityDay.getValue() == null) {
                this.txtExpireIn.setValue((Object)Constants.ZERO);
                return;
            }
            BigDecimal depositAmt = (BigDecimal)this.txtAmount.getValue(BigDecimal.class);
            BigDecimal IntFreeAmt = (BigDecimal)this.txtIntFreeAmt.getValue(BigDecimal.class);
            BigDecimal yearrate = (BigDecimal)this.txtRate.getValue(BigDecimal.class);
            if (!FMClientHelper.verifyIsPlus((String)this.txtConvertDays.getBigDecimalValue().toString())) {
                this.txtConvertDays.setValue((Object)new Integer(360));
            }
            int yearDays = this.txtConvertDays.getIntegerValue();
            int intervalDays = 0;
            IntTermInfo termInfo = (IntTermInfo)this.prmtInterm.getValue();
            intervalDays = TimeDepositHelper.getInstance().value_TD001(this.currentCompany) && termInfo.getType() == TermTypeEnum.MONTH ? termInfo.getTerm() * 30 : (TimeDepositHelper.getInstance().value_TD001(this.currentCompany) && termInfo.getType() == TermTypeEnum.YEAR ? termInfo.getTerm() * 360 : TimeDepositHelper.getInstance().calcuIntervalDays((Date)this.pkMaturityDay.getValue(), (Date)this.pkEffectiveDate.getValue()));
            IntRateTypeExpressionEnum intRateTypeExpressionEnum = (IntRateTypeExpressionEnum)this.comboIntRateTypeExpression.getSelectedItem();
            BigDecimal base = Constants.ONE_HUNDRED;
            if (intRateTypeExpressionEnum != IntRateTypeExpressionEnum.YEAR) {
                base = Constants.ONE_THOUSAND;
            }
            if (IntFreeAmt != null) {
                depositAmt = depositAmt.subtract(IntFreeAmt);
            }
            BigDecimal intAmt = this.helper.calcMatureIntAmt(depositAmt, yearrate, new BigDecimal(yearDays), new BigDecimal(String.valueOf(intervalDays)), base);
            this.txtExpireIn.setValue((Object)intAmt);
        } else {
            this.txtExpireIn.setValue((Object)Constants.ZERO);
        }
    }

    @Override
    protected void txtExchangeRate_dataChanged(DataChangeEvent e) throws Exception {
        if (null != this.txtAmount.getBigDecimalValue() && null != this.txtExchangeRate.getBigDecimalValue()) {
            this.txtNaturalAmt.setValue((Object)this.txtAmount.getBigDecimalValue().multiply(this.txtExchangeRate.getBigDecimalValue()));
        }
    }

    @Override
    protected void prmtInterm_dataChanged(DataChangeEvent e) throws Exception {
        this.calcMaturityDay();
        this.calcMatureIntAmt();
    }

    @Override
    protected void pkEffectiveDate_dataChanged(DataChangeEvent e) throws Exception {
        this.calcMaturityDay();
        this.calcMatureIntAmt();
        this.calYearRate();
    }

    @Override
    protected void txtRate_dataChanged(DataChangeEvent e) throws Exception {
        this.calcMatureIntAmt();
    }

    @Override
    protected void txtIntFreeAmt_dataChanged(DataChangeEvent e) throws Exception {
        this.calcMatureIntAmt();
    }

    @Override
    protected void txtIntFreeAmt_focusLost(FocusEvent e) throws Exception {
        this.calcMatureIntAmt();
    }

    @Override
    protected void txtAmount_dataChanged(DataChangeEvent e) throws Exception {
        this.txtBalance.setMaximumValue((Comparable)this.txtAmount.getBigDecimalValue());
        this.txtBalance.setValue((Object)this.txtAmount.getBigDecimalValue());
        this.calcMatureIntAmt();
        this.calcNaturalAmt();
        this.calcRemAmt();
    }

    private void calcRemAmt() {
        this.txtBalance.setValue((Object)this.txtAmount.getBigDecimalValue());
    }

    private void initMaturityDay() {
        Date startday = (Date)this.pkEffectiveDate.getValue();
        IntTermInfo intterm = (IntTermInfo)this.prmtInterm.getValue();
        if (intterm == null || startday == null) {
            return;
        }
        if (this.isOther(intterm)) {
            this.pkMaturityDay.setEnabled(true);
            this.pkMaturityDay.setMinimumDate(DateUtil.getAfterDay((Date)((Date)this.pkEffectiveDate.getValue())));
        } else {
            this.pkMaturityDay.setEnabled(false);
        }
    }

    private void calcMaturityDay() {
        Date startday = (Date)this.pkEffectiveDate.getValue();
        IntTermInfo intterm = (IntTermInfo)this.prmtInterm.getValue();
        if (intterm == null || startday == null) {
            return;
        }
        if (this.isOther(intterm)) {
            this.pkMaturityDay.setEnabled(true);
            this.pkMaturityDay.setMinimumDate(DateUtil.getAfterDay((Date)((Date)this.pkEffectiveDate.getValue())));
            this.pkMaturityDay.setValue((Object)DateUtil.getAfterDay((Date)((Date)this.pkEffectiveDate.getValue())));
        } else {
            this.pkMaturityDay.setEnabled(false);
            this.pkMaturityDay.setValue((Object)this.helper.calcMaturityDay(startday, intterm));
        }
    }

    @Override
    protected void pkMaturityDay_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtInterm.getValue() != null && this.isOther((IntTermInfo)this.prmtInterm.getValue())) {
            this.calcMatureIntAmt();
        }
    }

    private boolean isOther(IntTermInfo intterm) {
        return intterm.getId().toString().equals("jhNyIgEWEADgAAr6wKgSC61eI6Y=");
    }

    public static void showReDeopsitWindow(CoreUIObject ui, String selectedValue, int type) throws UIException, EASBizException {
        try {
            Boolean succ;
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"infoid", (Object)selectedValue);
            uiContext.put((Object)"ISRTD", (Object)Boolean.TRUE);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CompDepositAccountBillEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            if (uiWindow instanceof UIDialog) {
                FMClientHelper.settleUIDialogDimension((UIDialog)((UIDialog)uiWindow), (IUIObject)uiWindow.getUIObject());
            }
            uiWindow.show();
            Map successHm = ((CompDepositAccountBillEditUI)uiWindow.getUIObject()).getSuccessHm();
            if (successHm != null && (succ = (Boolean)successHm.get("successFlag")) != null && succ.booleanValue()) {
                uiWindow.close();
            }
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
    }

    public Map getSuccessHm() {
        return this.successHm;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("effectedStatus"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("IsHistory"));
        sic.add(new SelectorItemInfo("isReDeposited"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("interm.*"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("fpItem.id"));
        sic.add(new SelectorItemInfo("fpItem.number"));
        sic.add(new SelectorItemInfo("fpItem.name"));
        sic.add("fundFlowItem.*");
        return sic;
    }

    @Override
    protected void comboIntRateTypeExpression_actionPerformed(ActionEvent e) throws Exception {
        this.calYearDays();
    }

    private void calYearDays() {
        IntRateTypeExpressionEnum intRateTypeExpressionEnum = (IntRateTypeExpressionEnum)this.comboIntRateTypeExpression.getSelectedItem();
        String strValue = "";
        if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.YEAR) {
            this.txtConvertDays.setValue((Object)TimeDepositConstants.VALUE_360);
            strValue = this.contRate.getBoundLabelText();
            strValue = strValue.replaceAll("\u2030", "%");
            this.contRate.setBoundLabelText(strValue);
            strValue = this.contCurRate.getBoundLabelText();
            strValue = strValue.replaceAll("\u2030", "%");
            this.contCurRate.setBoundLabelText(strValue);
            strValue = this.contBaseRate.getBoundLabelText();
            strValue = strValue.replaceAll("\u2030", "%");
            this.contBaseRate.setBoundLabelText(strValue);
        } else if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.MONTH) {
            this.txtConvertDays.setValue((Object)TimeDepositConstants.VALUE_30);
            strValue = this.contRate.getBoundLabelText();
            strValue = strValue.replaceAll("%", "\u2030");
            this.contRate.setBoundLabelText(strValue);
            strValue = this.contCurRate.getBoundLabelText();
            strValue = strValue.replaceAll("%", "\u2030");
            this.contCurRate.setBoundLabelText(strValue);
            strValue = this.contBaseRate.getBoundLabelText();
            strValue = strValue.replaceAll("%", "\u2030");
            this.contBaseRate.setBoundLabelText(strValue);
        } else {
            this.txtConvertDays.setValue((Object)TimeDepositConstants.VALUE_1);
            strValue = this.contRate.getBoundLabelText();
            strValue = strValue.replaceAll("%", "\u2030");
            this.contRate.setBoundLabelText(strValue);
            strValue = this.contCurRate.getBoundLabelText();
            strValue = strValue.replaceAll("%", "\u2030");
            this.contCurRate.setBoundLabelText(strValue);
            strValue = this.contBaseRate.getBoundLabelText();
            strValue = strValue.replaceAll("%", "\u2030");
            this.contBaseRate.setBoundLabelText(strValue);
        }
    }

    @Override
    protected void comboCurrency_itemStateChanged(ItemEvent e) throws Exception {
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (currencyInfo == null) {
            return;
        }
        String baseCurrencyId = this.companyInfo.getBaseCurrency().getId().toString();
        if (baseCurrencyId.equals(currencyInfo.getId().toString())) {
            this.txtExchangeRate.setEnabled(false);
        } else if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.txtExchangeRate.setEnabled(true);
        }
        this.setPre();
        this.calcRate(currencyInfo, null, this.companyInfo, (Date)this.pkBizDate.getValue());
        this.calcNaturalAmt();
        this.calYearRate();
    }

    @Override
    protected void txtConvertDays_dataChanged(DataChangeEvent e) throws Exception {
        this.calcMatureIntAmt();
    }

    protected void txtBasePoints_dataChanged(DataChangeEvent e) throws Exception {
        this.calYearRate();
    }

    @Override
    protected void prmtIntRateTable_willShow(SelectorEvent e) throws Exception {
        FilterInfo filter = new FilterInfo();
        TimeDepositTypeEnum deposittype = (TimeDepositTypeEnum)this.comboDepositType.getSelectedItem();
        if (deposittype == TimeDepositTypeEnum.CALLDEPOSIT_INNER || deposittype == TimeDepositTypeEnum.CALLDEPOSIT_OUTER) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"lJlpCQEQEADgAAc+wKgSjiR9knQ=", CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"QYYAAAAKQTYkfZJ0", CompareType.NOTEQUALS));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtIntRateTable.setEntityViewInfo(evi);
        this.prmtIntRateTable.getQueryAgent().resetRuntimeEntityView();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionViewBgBalance.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_inquirebudget"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dysz"));
    }

    private void setprmtCorpCurAcctFilter(boolean isAcc) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("closed", (Object)"0"));
        filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)"1"));
        if (isAcc) {
            InnerAccountInfo Acc = (InnerAccountInfo)this.prmtCorpDepAcct.getData();
            filter.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)Acc.getApplyUnit().getId().toString()));
        }
        if (this.clearingHouse != null) {
            filter.getFilterItems().add(new FilterItemInfo("clearingHouse.id", (Object)this.clearingHouse.getId().toString()));
        }
        filter.getFilterItems().add(new FilterItemInfo("TYPE.Property", (Object)Integer.toString(1)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtCorpCurAcct.setEntityViewInfo(evi);
        this.prmtCorpCurAcct.getQueryAgent().resetRuntimeEntityView();
    }

    public void setAccountFilter(BankInfo clearingHouse, KDBizPromptBox ptmtAccount, CompanyOrgUnitInfo loanCompany, int type) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("closed", (Object)"0"));
        filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)"1"));
        if (loanCompany != null) {
            filter.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)loanCompany.getId().toString()));
        }
        filter.getFilterItems().add(new FilterItemInfo("clearingHouse.id", (Object)clearingHouse.getId().toString()));
        if (type == 1) {
            filter.getFilterItems().add(new FilterItemInfo("type.property", (Object)new Integer(1)));
        } else if (type == 2) {
            filter.getFilterItems().add(new FilterItemInfo("type.property", (Object)new Integer(3)));
        }
        evi.setFilter(filter);
        ptmtAccount.setEntityViewInfo(evi);
        ptmtAccount.setSelectorCollection(this.getCustomSelectors());
        ptmtAccount.getQueryAgent().resetRuntimeEntityView();
    }

    private SelectorItemCollection getCustomSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("applyUnit.*"));
        return sic;
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put("FROME", "COMPDEPOSIT");
        ctx.put("COMPANYID", ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString());
        this.getBillEdit().createFrom(null, ctx);
    }

    public int getBtpCreateFromType() {
        return 0;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        CompDepositAccountBillInfo info = (CompDepositAccountBillInfo)dataObject;
        if (this.getBOTPViewStatus() != 1 || this.getOprtState() != OprtState.ADDNEW) {
            return;
        }
        try {
            String sourceBillId = info.getSourceBillId();
            if (sourceBillId == null) {
                return;
            }
            SelectorItemCollection sic = super.getSelectors();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("payerAccount.*"));
            sic.add(new SelectorItemInfo("payeeAccount.*"));
            sic.add(new SelectorItemInfo("payerAccount.InnerAcct.*"));
            sic.add(new SelectorItemInfo("payeeAccount.InnerAcct.*"));
            TimeDepositApplyInfo timeDepositApplyInfo = TimeDepositApplyFactory.getRemoteInstance().getTimeDepositApplyInfo((IObjectPK)new ObjectUuidPK(sourceBillId), sic);
            info.setCompany(this.currentCompany);
            info.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
            if (timeDepositApplyInfo.getApplyType().toString().equals(TimeDepositTypeEnum.TIMEDEPOSIT_INNER.toString())) {
                info.setDepositType(TimeDepositTypeEnum.TIMEDEPOSIT_INNER);
                this.doSettingRelatedToTimeDeposit(true);
                this.txtRate.setEditable(true);
                this.contRate.setEnabled(true);
            } else if (timeDepositApplyInfo.getApplyType().toString().equals(TimeDepositTypeEnum.TIMEDEPOSIT_OUTER.toString())) {
                info.setDepositType(TimeDepositTypeEnum.TIMEDEPOSIT_OUTER);
                this.doSettingRelatedToTimeDeposit(true);
                this.txtRate.setEditable(true);
                this.contRate.setEnabled(true);
            } else if (timeDepositApplyInfo.getApplyType().toString().equals(TimeDepositTypeEnum.CALLDEPOSIT_INNER.toString())) {
                info.setDepositType(TimeDepositTypeEnum.CALLDEPOSIT_INNER);
                this.doSettingRelatedToCallDeposit(true);
                info.setDepType(timeDepositApplyInfo.getDepositType());
            } else if (timeDepositApplyInfo.getApplyType().toString().equals(TimeDepositTypeEnum.CALLDEPOSIT_OUTER.toString())) {
                info.setDepositType(TimeDepositTypeEnum.CALLDEPOSIT_OUTER);
                this.doSettingRelatedToCallDeposit(true);
                info.setDepType(timeDepositApplyInfo.getDepositType());
            }
            if (timeDepositApplyInfo.getPayerAccount() != null && timeDepositApplyInfo.getPayerAccount().getInnerAcct() != null) {
                info.setCorpCurAcct(timeDepositApplyInfo.getPayerAccount().getInnerAcct());
            }
            if (timeDepositApplyInfo.getPayeeAccount() != null && timeDepositApplyInfo.getPayeeAccount().getInnerAcct() != null) {
                info.setCorpDepAcct(timeDepositApplyInfo.getPayeeAccount().getInnerAcct());
            }
            if (timeDepositApplyInfo.getIntTermID() != null) {
                IntTermInfo intTermInfo = (IntTermInfo)IntTermFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(timeDepositApplyInfo.getIntTermID().getId().toString()));
                info.setInterm(intTermInfo);
                info.setMaturityDay(this.helper.calcMaturityDay((Date)this.pkEffectiveDate.getValue(), intTermInfo));
            }
            info.setHandler(info.getCreator());
            info.setDepositBank(this.clearingHouse);
            info.setBasePoints(Constants.ZERO);
            info.setYearDays(360);
            info.setRate(timeDepositApplyInfo.getRate());
            info.setExpireIn(Constants.ZERO);
            info.setCurRate(Constants.ZERO);
            if (EmptyUtil.isEmpty((Object)info.getBizDate())) {
                info.setBizDate(this.clearingHouse.getSettleDate());
            }
            info.setIntRateTypeExpression(IntRateTypeExpressionEnum.YEAR);
            info.setIsreceived(false);
            info.setIntFreeAmt(Constants.ZERO);
            info.setFiVouchered(false);
            info.setIsChangeByReDeposited(false);
            info.setBalance(info.getAmount());
            info.setBaseRate(EmptyUtil.isEmpty((Object)info.getBaseRate()) ? Constants.ZERO : info.getBaseRate());
            info.setExchangeRate(RecPayHandler.getExchangeRate((CurrencyInfo)info.getCurrency(), null, (Date)DateUtil.getDayBegin()));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.txtRate.setEditable(true);
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        if (this.editData != null && this.editData.getId() != null) {
            idList.add(this.editData.getId().toString());
        }
        if (idList == null || idList.size() == 0 || OprtState.EDIT == this.getOprtState()) {
            return;
        }
        CompDepositBillDataProvider data = new CompDepositBillDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(COMPDEPOSITBILL_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        if (this.editData != null && this.editData.getId() != null) {
            idList.add(this.editData.getId().toString());
        }
        if (idList == null || idList.size() == 0 || OprtState.EDIT == this.getOprtState()) {
            return;
        }
        CompDepositBillDataProvider data = new CompDepositBillDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(COMPDEPOSITBILL_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    protected void applyDefaultValue(IObjectValue vo) {
    }

    public static void showModifyCertificateNoWindow(CoreUIObject ui, String selectedValue) throws UIException, EASBizException {
        try {
            Boolean succ;
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"ID", (Object)selectedValue);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CompDepositAccountBillEditUI.class.getName(), (Map)uiContext, null, "CERTIFICATEEDIT");
            if (uiWindow instanceof UIDialog) {
                FMClientHelper.settleUIDialogDimension((UIDialog)((UIDialog)uiWindow), (IUIObject)uiWindow.getUIObject());
            }
            uiWindow.show();
            Map successHm = ((CompDepositAccountBillEditUI)uiWindow.getUIObject()).getSuccessHm();
            if (successHm != null && (succ = (Boolean)successHm.get("successFlag")) != null && succ.booleanValue()) {
                uiWindow.close();
            }
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.IVT_MANAGE;
    }

    protected String getDateField() {
        return "effectiveDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionSave", "actionSubmit"};
    }
}

