/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.TimeDepositTypeEnum;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.CompDepositBillFilterParam;
import com.kingdee.eas.fm.fin.CompDepositBillStatusEnum;
import com.kingdee.eas.fm.fin.client.AbstractCompDepositBillFilterUI;
import com.kingdee.eas.fm.fin.client.TimeDepositHelper;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class CompDepositBillFilterUI
extends AbstractCompDepositBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CompDepositBillFilterUI.class);

    public CompDepositBillFilterUI() throws Exception {
        this.cboCurrency.getSelectedItem();
        this.prmtDepCompany.setSelector((KDPromptSelector)F7SelectorFactory.getSelectCompany((IUIObject)this, null, null, (boolean)true));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void chkIA_actionPerformed(ActionEvent e) throws Exception {
        super.chkIA_actionPerformed(e);
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    protected void init() throws Exception {
        super.init();
        this.customInit();
        this.btnCompanySelect.setEnabled(true);
        this.btnCompanySelect.setVisible(true);
        this.kDLabelContainer2.setVisible(false);
        CompanyOrgUnitCollection coll = InAcctFactory.getRemoteInstance().getInAcctApplyCompany();
        this.setCompanyIdSet(AccessHelper.getIds((Object[])coll.toArray()));
    }

    private void customInit() {
        this.initDate();
        this.initCurrency();
        this.initBillType();
        this.initStatus();
    }

    private void initStatus() {
        this.cboStatus.removeAllItems();
        this.cboStatus.addItems(CompDepositBillStatusEnum.getEnumList().toArray());
        this.cboStatus.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.cboStatus.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    private void initCurrency() {
        CashHelper.initCombCurrency((KDComboBox)this.cboCurrency, (boolean)false);
        this.cboCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    private void initBillType() {
        this.cboBillType.removeAllItems();
        this.cboBillType.addItems(TimeDepositTypeEnum.getEnumList().toArray());
        this.cboBillType.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.cboBillType.setSelectedItem((Object)TimeDepositTypeEnum.TIMEDEPOSIT_INNER);
    }

    public void initDate() {
        Date settleDate = new Date();
        try {
            CompanyOrgUnitInfo chCompany = FSClientHelper.getClearingHouse().getRelatedCompany();
            Date TempDate = FSHelper.getDailySettledDate(null, (String)chCompany.getId().toString());
            if (TempDate != null) {
                settleDate = TempDate;
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        this.dtpDateFrom.setValue((Object)DateUtil.getFirstDayOfMonth((Date)settleDate));
        this.dtpDateTo.setValue((Object)settleDate);
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    private Date getStartDate(Date now) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(6, calendar.get(6) - calendar.get(6) + 1);
        return calendar.getTime();
    }

    public Object getParam() {
        Object obj;
        CompDepositBillFilterParam param = new CompDepositBillFilterParam();
        if (null != this.cboStatus.getSelectedItem() && (obj = this.cboStatus.getSelectedItem()) instanceof CompDepositBillStatusEnum) {
            param.setStatus((CompDepositBillStatusEnum)((Object)obj));
        }
        if (null != this.dtpDateFrom.getValue()) {
            param.setDateFrom(DateTimeUtils.truncateDate((Date)((Date)this.dtpDateFrom.getValue())));
        }
        if (null != this.dtpDateTo.getValue()) {
            param.setDateTo(DateTimeUtils.truncateDate((Date)((Date)this.dtpDateTo.getValue())));
        }
        if (null != this.cboBillType.getSelectedItem() && (obj = this.cboBillType.getSelectedItem()) instanceof TimeDepositTypeEnum) {
            param.setBillType((TimeDepositTypeEnum)this.cboBillType.getSelectedItem());
        }
        if (null != this.cboCurrency.getSelectedItem()) {
            obj = this.cboCurrency.getSelectedItem();
            if (obj instanceof CurrencyInfo) {
                param.setCurrency((CurrencyInfo)this.cboCurrency.getSelectedItem());
                param.setSelectedAllCurrency(false);
            } else if (obj.equals(FMSysDefinedEnum.ALL_ITEMS)) {
                param.setSelectedAllCurrency(true);
            }
        }
        param.setDepCompanyIDs(this.getCompanyIds());
        param.setCompanys(this.getCompanyIdSet());
        return param;
    }

    public void setParam(Object param) {
        if (null == param || !(param instanceof CompDepositBillFilterParam)) {
            return;
        }
        CompDepositBillFilterParam filterParam = (CompDepositBillFilterParam)param;
        this.dtpDateFrom.setValue((Object)filterParam.getDateFrom());
        this.dtpDateTo.setValue((Object)filterParam.getDateTo());
        if (filterParam.getBillType() == null) {
            this.cboBillType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            this.cboBillType.setSelectedItem((Object)filterParam.getBillType());
        }
        if (filterParam.getStatus() == null) {
            this.cboStatus.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            this.cboStatus.setSelectedItem((Object)filterParam.getStatus());
        }
        if (filterParam.isSelectedAllCurrency()) {
            this.cboCurrency.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)filterParam.getCurrency());
        }
        try {
            this.prmtDepCompany.setValue((Object)this.getBaseInfoFromIdSet(FMHelper.asSet((String[])filterParam.getDepCompanyIDs())));
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        this.setCompanyIdSet(filterParam.getCompanys());
    }

    public boolean verify() {
        if (this.dtpDateFrom.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"136_CompDepositBillFilterUI"));
            SysUtil.abort();
        }
        if (this.dtpDateTo.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"137_CompDepositBillFilterUI"));
            SysUtil.abort();
        }
        if (DateTimeUtils.truncateDate((Date)((Date)this.dtpDateFrom.getValue())).after(DateTimeUtils.truncateDate((Date)((Date)this.dtpDateTo.getValue())))) {
            MsgBox.showInfo((String)EASResource.getString((String)TimeDepositHelper.getInstance().getResourcePath(), (String)TimeDepositHelper.getInstance().getDateMsg()));
            this.dtpDateFrom.setFocusable(true);
            SysUtil.abort();
        }
        return true;
    }

    public void clear() {
        super.clear();
        try {
            this.initDate();
            this.initBillType();
            this.initCurrency();
            this.initStatus();
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
            this.kDLabelContainer2.setVisible(false);
            CompanyOrgUnitCollection coll = InAcctFactory.getRemoteInstance().getInAcctApplyCompany();
            this.setCompanyIdSet(AccessHelper.getIds((Object[])coll.toArray()));
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
    }

    protected Class getParamClass() {
        return CompDepositBillFilterParam.class;
    }
}

