/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.util.RptFmClientUtil;
import com.kingdee.eas.fm.fin.CreditLimitBillStatusEnum;
import com.kingdee.eas.fm.fin.FinClientHelper;
import com.kingdee.eas.fm.fin.LimitIsBankCreditEnum;
import com.kingdee.eas.fm.fin.LimitPropertyEnum;
import com.kingdee.eas.fm.fin.client.AbstractCreditLimitFilterUI;
import com.kingdee.eas.fm.fin.client.CreditLimitFilterParam;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.sql.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class CreditLimitFilterUI
extends AbstractCreditLimitFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CreditLimitFilterUI.class);
    public static final String RESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";
    private CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();

    public CreditLimitFilterUI() throws Exception {
        this.jbpOrganization.setEnabledMultiSelection(true);
    }

    private boolean isSelectAll(KDComboBox box) {
        if (box.getSelectedItem() == null) {
            return true;
        }
        Object obj = box.getSelectedItem();
        return obj.equals(FMSysDefinedEnum.SELECT_ALL);
    }

    public void onLoad() throws Exception {
        FinClientHelper.initFilterUI((CoreUIObject)this, this.prmtCompany, this.cboRelations);
        super.onLoad();
    }

    private void initKDComboBox(KDComboBox comboBox) {
        comboBox.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        comboBox.setSelectedIndex(comboBox.getItemCount() - 1);
    }

    protected Class getParamClass() {
        return CreditLimitFilterParam.class;
    }

    protected boolean isNeedEachSerializable() {
        return true;
    }

    public Object getParam() {
        Set gtSet;
        CreditLimitFilterParam param = new CreditLimitFilterParam();
        if (!this.isSelectAll(this.kDComboBoxCurrency)) {
            CurrencyInfo cur = (CurrencyInfo)this.kDComboBoxCurrency.getSelectedItem();
            param.setCurrencyId(cur.getId().toString());
        }
        if (!this.isSelectAll(this.kDComboBoxCreditLimitProperty)) {
            param.setLimitProperty((LimitPropertyEnum)((Object)this.kDComboBoxCreditLimitProperty.getSelectedItem()));
        }
        if (!this.isSelectAll(this.comboStatus)) {
            param.setBillStatus((CreditLimitBillStatusEnum)((Object)this.comboStatus.getSelectedItem()));
        } else {
            param.setBillStatus(null);
        }
        Set cuSet = this.getIdSetFromF7(this.prmtCreditUsage);
        if (cuSet.size() > 0) {
            param.setCreditUsageSet(cuSet);
        }
        if ((gtSet = this.getIdSetFromF7(this.prmtGuaranteeType)).size() > 0) {
            param.setGTSet(gtSet);
        }
        if (this.dpBeginDate.getValue() != null) {
            param.setDateBegin(DateTimeUtils.truncateDate((java.util.Date)this.dpBeginDate.getSqlDate()));
        }
        if (this.dpEndDate.getValue() != null) {
            param.setDateEnd(DateTimeUtils.truncateDate((java.util.Date)this.dpEndDate.getSqlDate()));
        }
        param.setClosed(this.kDCheckBoxIsClosed.isSelected());
        if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            param.setCompanyIdSet(this.getCompanyIdSet());
        }
        param.setCompanyIDs(this.getIdSetFromF7(this.prmtCompany));
        param.setBankIDs(this.getIdSetFromF7(this.jbpOrganization));
        Object selectedValue = this.cboRelations.getSelectedItem();
        if (selectedValue instanceof LimitIsBankCreditEnum) {
            param.setRelations((LimitIsBankCreditEnum)((Object)selectedValue));
        } else {
            param.setRelations(null);
        }
        return param;
    }

    public void setParam(Object param) {
        CreditLimitFilterParam clParam = (CreditLimitFilterParam)((Object)param);
        this.setCompanyIdSet(clParam.getCompanyIdSet());
        try {
            if (clParam.getCurrencyId() != null) {
                CurrencyInfo cur = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(clParam.getCurrencyId()));
                FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)cur);
            } else {
                FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (clParam.getLimitProperty() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCreditLimitProperty, (Object)((Object)clParam.getLimitProperty()));
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCreditLimitProperty, (Object)FMSysDefinedEnum.SELECT_ALL);
        }
        if (clParam.getBillStatus() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboStatus, (Object)((Object)clParam.getBillStatus()));
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.comboStatus, (Object)FMSysDefinedEnum.SELECT_ALL);
        }
        this.dpBeginDate.setValue((Object)clParam.getDateBegin());
        this.dpEndDate.setValue((Object)clParam.getDateEnd());
        this.kDCheckBoxIsClosed.setSelected(clParam.isClosed());
        try {
            this.prmtCreditUsage.setData((Object)this.getBaseInfoFromIdSet(clParam.getCreditUsageSet()));
            this.prmtGuaranteeType.setData((Object)this.getBaseInfoFromIdSet(clParam.getGTSet()));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        try {
            Set creditCompanySet = clParam.getCompanyIDs();
            CoreBaseInfo[] ccc = RptFmClientUtil.getBaseInfoFromIdSet((Set)creditCompanySet);
            this.prmtCompany.setData((Object)ccc);
            LimitIsBankCreditEnum relations = clParam.getRelations();
            if (relations == null) {
                this.cboRelations.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
            } else {
                this.cboRelations.setSelectedItem((Object)relations);
            }
            Set bankIds = clParam.getBankIDs();
            CoreBaseInfo[] c = RptFmClientUtil.getBaseInfoFromIdSet((Set)bankIds);
            this.jbpOrganization.setData((Object)c);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    public void clear() {
        super.clear();
        this.dpBeginDate.setValue((Object)DateUtil.getFirstDayOfCurYear());
        this.dpEndDate.setValue((Object)new java.util.Date());
        this.prmtCreditUsage.setData(null);
        this.prmtGuaranteeType.setData(null);
        this.kDComboBoxCreditLimitProperty.removeItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.kDComboBoxCurrency.removeItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.comboStatus.removeItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.initKDComboBox(this.kDComboBoxCreditLimitProperty);
        this.initKDComboBox(this.kDComboBoxCurrency);
        this.initKDComboBox(this.comboStatus);
        this.kDCheckBoxIsClosed.setSelected(false);
        this.cboRelations.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    protected void init() throws Exception {
        super.init();
        FMClientHelper.initComboCurrency((KDComboBox)this.kDComboBoxCurrency);
        this.initKDComboBox(this.kDComboBoxCreditLimitProperty);
        this.initKDComboBox(this.kDComboBoxCurrency);
        this.initKDComboBox(this.comboStatus);
        this.dpBeginDate.setValue((Object)DateUtil.getFirstDayOfCurYear());
        this.dpEndDate.setValue((Object)DateUtil.getDayBegin());
        this.cboRelations.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    public boolean verify() {
        Date startDate = this.dpBeginDate.getSqlDate();
        Date endDate = this.dpEndDate.getSqlDate();
        if (startDate == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"StartDateIsNull"));
            SysUtil.abort();
        }
        if (endDate == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"EndDateIsNull"));
            SysUtil.abort();
        }
        if (startDate.compareTo(endDate) > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"CreditLimitFilterDateCompare"));
            SysUtil.abort();
        }
        if (endDate == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"EndDateIsNull"));
            SysUtil.abort();
        }
        return super.verify();
    }

    @Override
    protected void kDCheckBoxIneffective_actionPerformed(ActionEvent e) throws Exception {
        super.kDCheckBoxIneffective_actionPerformed(e);
    }

    @Override
    protected void kDCheckBoxEffective_actionPerformed(ActionEvent e) throws Exception {
        super.kDCheckBoxEffective_actionPerformed(e);
    }

    @Override
    protected void kDCheckBoxExpired_actionPerformed(ActionEvent e) throws Exception {
        super.kDCheckBoxExpired_actionPerformed(e);
    }

    @Override
    protected void cboRelations_itemStateChanged(ItemEvent e) throws Exception {
        FinClientHelper.cboRelationsItemStateChanged((CoreUIObject)this, this.cboRelations, this.contBank, this.jbpOrganization, this.contCompany, this.prmtCompany);
    }
}

