/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.IRefChecker;
import com.kingdee.eas.common.RefCheckerFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.CreditUsageFactory;
import com.kingdee.eas.fm.fin.CreditUsageInfo;
import com.kingdee.eas.fm.fin.FinancingProductsInfo;
import com.kingdee.eas.fm.fin.client.AbstractCreditUsageEditUI;
import com.kingdee.eas.fm.fin.client.F7FinancingProductsTreeUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CreditUsageEditUI
extends AbstractCreditUsageEditUI {
    private static final Logger logger = CoreUIObject.getLogger(CreditUsageEditUI.class);

    @Override
    protected String getEditUIName() {
        return CreditUsageEditUI.class.getName();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.prmtfinacingProduct.setValue((Object)this.editData.getFinacingProduct());
        this.setFinacingProductState();
    }

    protected void initDataStatus() {
        super.initDataStatus();
        CoreBaseInfo info = (CoreBaseInfo)this.getDataObject();
        try {
            this.doCheck(info);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.prmtfinacingProduct.setRequired(false);
        this.setFinacingProductState();
    }

    public void doCheck(CoreBaseInfo info) throws BOSException, BizReferenceException {
        IRefChecker checker = RefCheckerFactory.getRemoteInstance();
        if (this.getOprtState().equals(OprtState.EDIT)) {
            if (checker.isReferenced(info.getId())) {
                this.txtNumber.setEnabled(false);
            }
        } else if (this.getOprtState().equals(OprtState.VIEW)) {
            this.actionEdit.setEnabled(false);
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return CreditUsageFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        CreditUsageInfo objectValue = new CreditUsageInfo();
        objectValue.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
        objectValue.setIsUsed(true);
        return objectValue;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDMultiLangBox)this.txtName);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.prmtfinacingProduct = new KDBizPromptBox();
        this.add((Component)this.prmtfinacingProduct);
        this.contfinacingProduct.setBoundEditor((JComponent)this.prmtfinacingProduct);
        this.dataBinder.registerBinding("finacingProduct", FinancingProductsInfo.class, (Component)this.prmtfinacingProduct, "data");
        this.prmtfinacingProduct.setName("prmtfinacingProduct");
        this.prmtfinacingProduct.setQueryInfo("com.kingdee.eas.fm.fin.app.F7FinancingProductsQuery");
        this.prmtfinacingProduct.setEditFormat("$number$");
        this.prmtfinacingProduct.setCommitFormat("$number$");
        this.prmtfinacingProduct.setDisplayFormat("$name$");
        this.prmtfinacingProduct.setRequired(true);
        this.prmtfinacingProduct.addSelectorListener(new SelectorListener(){
            F7FinancingProductsTreeUI prmtParent_F7ListUI = null;

            public void willShow(SelectorEvent e) {
                if (this.prmtParent_F7ListUI == null) {
                    try {
                        this.prmtParent_F7ListUI = new F7FinancingProductsTreeUI();
                    }
                    catch (Exception e1) {
                        logger.error((Object)e1.getMessage(), (Throwable)e1);
                    }
                    HashMap<String, Window> ctx = new HashMap<String, Window>();
                    ctx.put("bizUIOwner", SwingUtilities.getWindowAncestor((Component)((Object)this.prmtParent_F7ListUI)));
                    this.prmtParent_F7ListUI.setF7Use(true, ctx);
                    CreditUsageEditUI.this.prmtfinacingProduct.setSelector((KDPromptSelector)this.prmtParent_F7ListUI);
                }
            }
        });
    }

    @Override
    protected void chkcolligateCredit_itemStateChanged(ItemEvent e) throws Exception {
        this.setFinacingProductState();
    }

    private void setFinacingProductState() {
        if (this.chkcolligateCredit.isSelected()) {
            this.prmtfinacingProduct.setValue(null);
            this.prmtfinacingProduct.setEnabled(false);
        } else {
            this.prmtfinacingProduct.setEnabled(true);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtNumber.setMaxLength(40);
        this.txtName.setMaxLength(80);
        this.kDTextAreaRemark.setMaxLength(80);
    }
}

