/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fm.common.client.DefaultKDTCurrencyProvider;
import com.kingdee.eas.fm.common.client.DefaultKDTablePrecisionFormater;
import com.kingdee.eas.fm.common.client.IKDTPrecisionProvider;
import com.kingdee.eas.fm.common.client.IKDTablePrecisionFormater;
import com.kingdee.eas.fm.fin.client.AbstractFinancingBillListUI;
import org.apache.log4j.Logger;

public abstract class FinancingBillListUI
extends AbstractFinancingBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(FinancingBillListUI.class);
    private IKDTablePrecisionFormater precFormater = new DefaultKDTablePrecisionFormater();
    private IKDTPrecisionProvider currencyProvider = null;
    protected CompanyOrgUnitInfo companyInfo = null;

    public FinancingBillListUI() throws Exception {
        this.precFormater.setPrecProvider((IKDTPrecisionProvider)new DefaultKDTCurrencyProvider(this.getCurrencyIdColName()));
        this.companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    }

    public void onLoad() throws Exception {
        this.precFormater.init(this.getMainTable(), this.getPrecColName());
        super.onLoad();
        this.checkBizUnit();
        this.btnMultiapprove.setVisible(false);
        this.btnNextPerson.setVisible(false);
        this.menuItemMultiapprove.setVisible(false);
        this.menuItemNextPerson.setVisible(false);
    }

    protected void checkBizUnit() throws EASBizException, BOSException {
        if (ContextHelperFactory.getRemoteInstance().isOnlyUnion(this.companyInfo)) {
            this.btnVoucher.setVisible(false);
            this.btnDelVoucher.setVisible(false);
            this.btnAddNew.setVisible(false);
            this.menuItemAddNew.setVisible(false);
            this.btnEdit.setVisible(false);
            this.menuItemEdit.setVisible(false);
            this.btnRemove.setVisible(false);
            this.menuItemRemove.setVisible(false);
        }
    }

    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = super.getBOTPSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("Region"));
        sic.add(new SelectorItemInfo("Amount"));
        sic.add(new SelectorItemInfo("Balance"));
        sic.add(new SelectorItemInfo("LocalCurExRate"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("Institution.id"));
        sic.add(new SelectorItemInfo("Institution.number"));
        sic.add(new SelectorItemInfo("Institution.name"));
        sic.add(new SelectorItemInfo("Currency.id"));
        sic.add(new SelectorItemInfo("Currency.number"));
        sic.add(new SelectorItemInfo("Currency.name"));
        sic.add(new SelectorItemInfo("Currency.precision"));
        sic.add(new SelectorItemInfo("CreditLimit.id"));
        sic.add(new SelectorItemInfo("CreditLimit.number"));
        sic.add(new SelectorItemInfo("CreditLimit.name"));
        sic.add(new SelectorItemInfo("CreditCurrency.id"));
        sic.add(new SelectorItemInfo("CreditCurrency.number"));
        sic.add(new SelectorItemInfo("CreditCurrency.name"));
        return sic;
    }

    protected abstract String getCurrencyIdColName();

    protected abstract String[] getPrecColName();

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Balance", (Object)SysConstant.BIGZERO, CompareType.GREATER));
        filter.getFilterItems().add(this.getCompanyFilterItemInfo());
        return filter;
    }

    protected FilterItemInfo getCompanyFilterItemInfo() {
        return new FilterItemInfo("company.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString());
    }
}

