/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fin.FinancingFeeAmortizationEnum;
import com.kingdee.eas.fm.fin.FinancingFeeBillCollection;
import com.kingdee.eas.fm.fin.FinancingFeeBillFactory;
import com.kingdee.eas.fm.fin.FinancingFeeBillInfo;
import com.kingdee.eas.fm.fin.FinancingFeeBillStateEnum;
import com.kingdee.eas.fm.fin.FinancingFeeRourceEnum;
import com.kingdee.eas.fm.fin.FinancingShareMaintainFactory;
import com.kingdee.eas.fm.fin.IFinancingFeeBill;
import com.kingdee.eas.fm.fin.client.AbstractFinancingFeeBillListUI;
import com.kingdee.eas.fm.fin.client.FinancingFeeBillEditUI;
import com.kingdee.eas.fm.fin.client.FinancingFeeBillFilterParam;
import com.kingdee.eas.fm.fin.client.FinancingFeeBillFilterUI;
import com.kingdee.eas.fm.fin.client.FinancingFeeBillQueryProcessor;
import com.kingdee.eas.fm.sl.util.SLUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class FinancingFeeBillListUI
extends AbstractFinancingFeeBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(FinancingFeeBillListUI.class);
    private FinancingFeeBillFilterUI filter = null;
    public static final String RESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";
    FillListener fillListener = new FillListener();

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionAuditResult.setVisible(false);
        this.actionVoucher.setVisible(true);
        this.actionDelVoucher.setVisible(true);
        this.actionViewBdgBalance.setVisible(true);
        this.actionViewBdgBalance.setEnabled(true);
        this.setBtnDisplayInBizUnit();
        this.actionWorkFlowG.setVisible(true);
        this.actionWorkFlowG.setEnabled(true);
        this.menuWorkFlow.setVisible(true);
        this.menuWorkFlow.setEnabled(true);
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("AuditDate").getStyleAttributes().setNumberFormat(this.dformat);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    private void setBtnDisplayInBizUnit() {
        boolean isBizUnit = SLUtils.checkBizUnit();
        this.menuEdit.setVisible(!isBizUnit);
        this.menuBiz.setVisible(!isBizUnit);
        this.actionAddNew.setVisible(!isBizUnit);
        this.actionEdit.setVisible(!isBizUnit);
        this.actionRemove.setVisible(!isBizUnit);
        this.actionAudit.setVisible(!isBizUnit);
        this.actionAntiAudit.setVisible(!isBizUnit);
        this.actionGenPay.setVisible(!isBizUnit);
        this.actionVoucher.setEnabled(!isBizUnit);
        this.actionDelVoucher.setEnabled(!isBizUnit);
        this.actionVoucher.setVisible(!isBizUnit);
        this.actionDelVoucher.setVisible(!isBizUnit);
        this.tblMain.getColumn("company.name").getStyleAttributes().setHided(!isBizUnit);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionGenPay.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_releasebymodule"));
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_auditing"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.actionAudit.setEnabled(true);
        this.actionAntiAudit.setEnabled(true);
        this.actionGenPay.setEnabled(true);
        this.actionTDPrint.setEnabled(true);
        this.actionTDPrintPreview.setEnabled(true);
    }

    protected String getEditUIName() {
        return FinancingFeeBillEditUI.class.getName();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filter == null) {
            this.filter = new FinancingFeeBillFilterUI();
        }
        return this.filter;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FinancingFeeBillFactory.getRemoteInstance();
    }

    protected void execQuery() {
        this.mergeQueryFilter();
        super.execQuery();
        boolean isBizUnit = SLUtils.checkBizUnit();
        this.tblMain.getColumn("company.name").getStyleAttributes().setHided(!isBizUnit);
        this.setBtnDisplayInBizUnit();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.setBtnDisplayInBizUnit();
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            FinancingFeeBillFilterParam param = (FinancingFeeBillFilterParam)((Object)this.getFilterUI().getParam());
            if (this.tblMain.getFootManager() == null) {
                return;
            }
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrencyId() == null ? company.getBaseCurrency().getId().toString() : param.getCurrencyId();
            String[] columns = new String[]{"Amount", "localCurAmount"};
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    protected CommonQueryProcessor getQueryProcessor() {
        return new FinancingFeeBillQueryProcessor((IUIObject)this);
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        FinancingFeeBillInfo info = FinancingFeeBillFactory.getRemoteInstance().getFinancingFeeBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        Set idSet = FMHelper.getDestBillIdSet(null, (String)id);
        if (info.getState().equals((Object)FinancingFeeBillStateEnum.AUDIT) || idSet.size() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"FinFeeBillEdit"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        FinancingFeeBillInfo info = FinancingFeeBillFactory.getRemoteInstance().getFinancingFeeBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        Set idSet = FMHelper.getDestBillIdSet(null, (String)id);
        if (info.getState().equals((Object)FinancingFeeBillStateEnum.AUDIT) || idSet.size() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"FinFeeBillDel"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        IObjectPK[] pks = new IObjectPK[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            pks[i] = new ObjectUuidPK(ids.get(i).toString());
        }
        String[] idList = ids.toArray(new String[ids.size()]);
        IEnactmentService service2 = EnactmentServiceFactory.createRemoteEnactService();
        String[] idsInProcess = service2.checkBizObjInWfProcess(idList);
        if (idsInProcess != null && idsInProcess.length > 0) {
            this.actionMultiapprove_actionPerformed(e);
        } else {
            ((IFinancingFeeBill)this.getBizInterface()).audit(pks);
        }
        this.refreshList();
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        IObjectPK[] pks = new IObjectPK[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            pks[i] = new ObjectUuidPK(ids.get(i).toString());
            FinancingFeeBillInfo info = FinancingFeeBillFactory.getRemoteInstance().getFinancingFeeBillInfo(pks[i]);
            if (info.getSourceBillNm() == null || info.getSourceBillType() != FinancingFeeRourceEnum.Loan) continue;
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("loan.number", (Object)info.getSourceBillNm()));
            if (!FinancingShareMaintainFactory.getRemoteInstance().exists(filter) || !info.getIsloanshare().equals((Object)FinancingFeeAmortizationEnum.REALINTEREST)) continue;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"157_FinancingShare"));
            SysUtil.abort();
        }
        ((IFinancingFeeBill)this.getBizInterface()).antiAudit(pks);
        this.refreshList();
    }

    @Override
    public void actionGenPay_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashSet idSet = new HashSet(idList);
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("isGenPay"));
        sic.add(new SelectorItemInfo("PayBankAccount.id"));
        ev.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        FinancingFeeBillCollection colls = FinancingFeeBillFactory.getRemoteInstance().getFinancingFeeBillCollection(ev);
        if (EmptyUtil.isEmpty((AbstractObjectCollection)colls)) {
            SysUtil.abort();
        }
        String payBankAccountId = "";
        if (!EmptyUtil.isEmpty((CoreBaseInfo)colls.get(0).getPayBankAccount())) {
            payBankAccountId = colls.get(0).getPayBankAccount().getId().toString();
        }
        for (int i = 0; i < colls.size(); ++i) {
            FinancingFeeBillInfo info = colls.get(i);
            if (!info.getState().equals((Object)FinancingFeeBillStateEnum.AUDIT) || info.isIsGenPay()) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"FinFeeGenPay"));
                SysUtil.abort();
            }
            if (EmptyUtil.isEmpty((String)payBankAccountId) || EmptyUtil.isEmpty((CoreBaseInfo)info.getPayBankAccount()) || EmptyUtil.isEmpty((Object)info.getPayBankAccount().getId()) || payBankAccountId.equals(info.getPayBankAccount().getId().toString())) continue;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"connotGatherGenPayBill"));
            SysUtil.abort();
        }
        super.actionCreateTo_actionPerformed(e);
        this.refreshList();
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        FMClientHelper.viewBgBalance4ListUI((Component)((Object)this), (String)id);
    }

    private void mergeQueryFilter() {
        if (this.getBOTPViewStatus() != 1 || this.getUIContext().get("BTPEDITPARAMETER") == null) {
            return;
        }
        Object TargetBillTypeObj = ((HashMap)this.getUIContext().get("BTPEDITPARAMETER")).get("TargetBillType");
        if (this.getBOTPViewStatus() == 1 && TargetBillTypeObj != null && TargetBillTypeObj.toString().equals("PaymentBill")) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isGenPay", (Object)new Integer(0)));
            filter.getFilterItems().add(new FilterItemInfo("isGenPay", null, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(3)));
            filter.setMaskString("(#0 or #1) AND #2");
            try {
                this.mainQuery.getFilter().mergeFilter(filter, "and");
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fm.fin.app.FinancingFeeBillTDQuery");
    }

    protected String getTDFileName() {
        return "/FM/FIN/FEE";
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.IVT_MANAGE;
    }

    protected String getDateField() {
        return "bizDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionEdit", "actionRemove", "actionAntiAudit"};
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.checkSelected();
        super.tblMain_tableSelectChanged(e);
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        String id = (String)idList.get(0);
        FinancingFeeBillInfo sourceBill = ((IFinancingFeeBill)this.getBizInterface()).getFinancingFeeBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        this.actionVoucher.setEnabled(!sourceBill.isFivouchered() && FinancingFeeBillStateEnum.AUDIT.equals((Object)sourceBill.getState()));
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            IRow row = null;
            String currencyId = null;
            CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            if (e == null) {
                return;
            }
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = FinancingFeeBillListUI.this.tblMain.getRow(i);
                currencyId = (String)row.getCell("Currency.id").getValue();
                if (currencyId != null) {
                    FMClientHelper.setNumberFormat((IRow)row, (String)"Amount", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"Rate", (String)currencyId);
                }
                if (companyInfo == null || companyInfo.getBaseCurrency() == null) continue;
                String baseCurrency = companyInfo.getBaseCurrency().getId().toString();
                FMClientHelper.setNumberFormat((IRow)row, (String)"localCurAmount", (String)baseCurrency);
            }
        }
    }
}

