/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fin.FinancingShareEnum;
import com.kingdee.eas.fm.fin.FinancingShareMaintainCollection;
import com.kingdee.eas.fm.fin.FinancingShareMaintainFactory;
import com.kingdee.eas.fm.fin.FinancingShareMaintainInfo;
import com.kingdee.eas.fm.fin.client.AbstractFinancingShareMaintainListUI;
import com.kingdee.eas.fm.fin.client.FinancingShareMaintainFilterUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class FinancingShareMaintainListUI
extends AbstractFinancingShareMaintainListUI {
    private static final Logger logger = CoreUIObject.getLogger(FinancingShareMaintainListUI.class);
    FinancingShareMaintainFilterUI filter = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)currentCompany);
        super.onLoad();
        this.tblMain.checkParsed();
        this.actionAntiAudit.setVisible(true);
        this.actionAudit.setVisible(true);
        this.actionAudit.setEnabled(true);
        this.actionAntiAudit.setEnabled(true);
        this.actionGenPay.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.actionView.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.btnAntiAudit.setIcon(EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionVoucher.setEnabled(true);
        this.actionVoucher.setVisible(true);
        this.actionDelVoucher.setVisible(true);
        this.actionDelVoucher.setEnabled(true);
        this.actionGenPay.setVisible(true);
        this.actionGenPay.setEnabled(true);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionAttachment.setVisible(false);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int indexrow = e.getRowIndex();
        if (e.getClickCount() == 2) {
            if (e.getType() == 0) {
                return;
            }
            this.checkSelected();
            if (this.tblMain.getRow(indexrow).getCell("state").getValue().toString().equals(FinancingShareEnum.AUDIT.toString())) {
                this.tblMain.getRow(indexrow).getCell("adjust").getStyleAttributes().setLocked(true);
            } else {
                this.tblMain.getRow(indexrow).getCell("adjust").getStyleAttributes().setLocked(false);
            }
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        String keyValue = this.getSelectedKeyValue();
        if (keyValue == null) {
            return;
        }
        int index = e.getRowIndex();
        BigDecimal adjust = BigDecimal.ZERO;
        if (this.tblMain.getRow(index).getCell("adjust") != null && this.tblMain.getRow(index).getCell("adjust").getValue() != null) {
            adjust = new BigDecimal((String)this.tblMain.getRow(index).getCell("adjust").getValue());
        }
        try {
            FinancingShareMaintainInfo info = FinancingShareMaintainFactory.getRemoteInstance().getFinancingShareMaintainInfo((IObjectPK)new ObjectUuidPK(keyValue));
            info.setAdjust(adjust);
            if (this.tblMain.getRow(index).getCell("adjust") != null && this.tblMain.getRow(index).getCell("adjust").getValue() != null) {
                info.setActualAmortize(info.getAmortize().add(info.getAdjust()));
            } else {
                info.setActualAmortize(info.getAmortize());
            }
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("actualAmortize"));
            selector.add(new SelectorItemInfo("adjust"));
            FinancingShareMaintainFactory.getRemoteInstance().updatePartial((CoreBaseInfo)info, selector);
            this.tblMain.getRow(index).getCell("actualAmortize").setValue((Object)info.getActualAmortize());
        }
        catch (NumberFormatException nfe) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"653_FinancingShare"));
            this.tblMain.getRow(index).getCell("adjust").setValue(e.getOldValue());
        }
    }

    protected void menuItemImportData_actionPerformed(ActionEvent e) throws Exception {
        super.menuItemImportData_actionPerformed(e);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        this.tblMain.getGroupManager().setGroup(false);
        SorterItemInfo sortInfo = new SorterItemInfo("period.number");
        sortInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sortInfo);
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() <= 0) {
            return;
        }
        HashSet idSet = new HashSet(idList);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        FinancingShareMaintainCollection coll = FinancingShareMaintainFactory.getRemoteInstance().getFinancingShareMaintainCollection(evi);
        for (int i = 0; i < coll.size(); ++i) {
            FinancingShareMaintainInfo info = coll.get(i);
            IPermission iPermission = PermissionFactory.getRemoteInstance();
            iPermission.checkFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), "financingShare_voucher");
            if (info.getState().equals((Object)FinancingShareEnum.AUDIT)) continue;
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"654_FinancingShare"));
            this.abort();
        }
        super.actionVoucher_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() <= 0) {
            return;
        }
        HashSet idSet = new HashSet(idList);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        FinancingShareMaintainCollection coll = FinancingShareMaintainFactory.getRemoteInstance().getFinancingShareMaintainCollection(evi);
        for (int i = 0; i < coll.size(); ++i) {
            FinancingShareMaintainInfo info = coll.get(i);
            IPermission iPermission = PermissionFactory.getRemoteInstance();
            iPermission.checkFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), "financingShare_delvoucher");
        }
        super.actionDelVoucher_actionPerformed(e);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() <= 0) {
            return;
        }
        HashSet idSet = new HashSet(idList);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        FinancingShareMaintainCollection coll = FinancingShareMaintainFactory.getRemoteInstance().getFinancingShareMaintainCollection(evi);
        for (int i = 0; i < coll.size(); ++i) {
            FinancingShareMaintainInfo info = coll.get(i);
            IPermission iPermission = PermissionFactory.getRemoteInstance();
            iPermission.checkFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), "financingShare_audit");
            if (!info.getState().equals((Object)FinancingShareEnum.SUBMIT)) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"655_FinancingShare"));
                this.abort();
            }
            if (!info.isFivouchered()) continue;
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"656_FinancingShare"));
            this.abort();
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("bizdate"));
        selector.add(new SelectorItemInfo("auditor"));
        selector.add(new SelectorItemInfo("auditor.id"));
        selector.add(new SelectorItemInfo("auditor.*"));
        for (int i = 0; i < coll.size(); ++i) {
            FinancingShareMaintainInfo info = coll.get(i);
            info.setState(FinancingShareEnum.AUDIT);
            info.setBizDate(new Date());
            info.setAuditor(SysContext.getSysContext().getCurrentUserInfo());
            FinancingShareMaintainFactory.getRemoteInstance().updatePartial((CoreBaseInfo)info, selector);
        }
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"657_FinancingShare"));
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() <= 0) {
            return;
        }
        HashSet idSet = new HashSet(idList);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        FinancingShareMaintainCollection coll = FinancingShareMaintainFactory.getRemoteInstance().getFinancingShareMaintainCollection(evi);
        for (int i = 0; i < coll.size(); ++i) {
            FinancingShareMaintainInfo info = coll.get(i);
            IPermission iPermission = PermissionFactory.getRemoteInstance();
            iPermission.checkFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), "financingShare_antiaudit");
            if (!info.getState().equals((Object)FinancingShareEnum.AUDIT)) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"658_FinancingShare"));
                this.abort();
            }
            if (!info.isFivouchered()) continue;
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"656_FinancingShare"));
            this.abort();
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("bizdate"));
        selector.add(new SelectorItemInfo("auditor"));
        selector.add(new SelectorItemInfo("auditor.id"));
        selector.add(new SelectorItemInfo("auditor.*"));
        for (int i = 0; i < coll.size(); ++i) {
            FinancingShareMaintainInfo info = coll.get(i);
            info.setState(FinancingShareEnum.SUBMIT);
            info.setBizDate(null);
            info.setAuditor(null);
            FinancingShareMaintainFactory.getRemoteInstance().updatePartial((CoreBaseInfo)info, selector);
        }
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"659_FinancingShare"));
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionGenPay_actionPerformed(ActionEvent e) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() <= 0) {
            return;
        }
        HashSet idSet = new HashSet(idList);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        FinancingShareMaintainCollection coll = FinancingShareMaintainFactory.getRemoteInstance().getFinancingShareMaintainCollection(evi);
        for (int i = 0; i < coll.size(); ++i) {
            FinancingShareMaintainInfo info = coll.get(i);
            IPermission iPermission = PermissionFactory.getRemoteInstance();
            iPermission.checkFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), "financingShare_genpay");
            if (info.getActualAmortize() != null) {
                info.setAdjust(BigDecimal.ZERO.subtract(info.getAmortize()));
            }
            info.setActualAmortize(BigDecimal.ZERO);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("actualAmortize"));
            selector.add(new SelectorItemInfo("adjust"));
            FinancingShareMaintainFactory.getRemoteInstance().updatePartial((CoreBaseInfo)info, selector);
        }
        this.actionRefresh_actionPerformed(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FinancingShareMaintainFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected IObjectValue createNewData() {
        FinancingShareMaintainInfo objectValue = new FinancingShareMaintainInfo();
        return objectValue;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filter == null) {
            this.filter = new FinancingShareMaintainFilterUI();
        }
        return this.filter;
    }
}

