/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

public class IRRHelp {
    public static double getIRR(double[] cashFlows, double estimatedResult) {
        double result = Double.NaN;
        if (cashFlows != null && cashFlows.length > 0 && cashFlows[0] != 0.0) {
            double noOfCashFlows = cashFlows.length;
            double sumCashFlows = 0.0;
            int noOfNegativeCashFlows = 0;
            int noOfPositiveCashFlows = 0;
            int i = 0;
            while ((double)i < noOfCashFlows) {
                sumCashFlows += cashFlows[i];
                if (cashFlows[i] > 0.0) {
                    ++noOfPositiveCashFlows;
                } else if (cashFlows[i] < 0.0) {
                    ++noOfNegativeCashFlows;
                }
                ++i;
            }
            if (noOfNegativeCashFlows > 0 && noOfPositiveCashFlows > 0) {
                double irrGuess = 0.1;
                if (!Double.isNaN(estimatedResult) && (irrGuess = estimatedResult) <= 0.0) {
                    irrGuess = 0.5;
                }
                double irr = 0.0;
                irr = sumCashFlows < 0.0 ? -irrGuess : irrGuess;
                double minDistance = 1.0E-15;
                double cashFlowStart = cashFlows[0];
                int maxIteration = 100;
                boolean wasHi = false;
                double cashValue = 0.0;
                for (int i2 = 0; i2 <= 100; ++i2) {
                    cashValue = cashFlowStart;
                    int j = 1;
                    while ((double)j < noOfCashFlows) {
                        cashValue += cashFlows[j] / Math.pow(1.0 + irr, j);
                        ++j;
                    }
                    if (Math.abs(cashValue) < 0.01) {
                        result = irr;
                        break;
                    }
                    if (cashValue > 0.0) {
                        if (wasHi) {
                            irrGuess /= 2.0;
                        }
                        irr += irrGuess;
                        if (wasHi) {
                            irrGuess -= 1.0E-15;
                            wasHi = false;
                        }
                    } else {
                        irr -= (irrGuess /= 2.0);
                        wasHi = true;
                    }
                    if (!(irrGuess <= 1.0E-15)) continue;
                    result = irr;
                    break;
                }
            }
        }
        return result;
    }
}

