/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.InnerFinTotalLimitEntryCollection;
import com.kingdee.eas.fm.fin.InnerFinTotalLimitEntryInfo;
import com.kingdee.eas.fm.fin.InnerFinTotalLimitFactory;
import com.kingdee.eas.fm.fin.InnerFinTotalLimitInfo;
import com.kingdee.eas.fm.fin.client.AbstractInnerFinTotalLimitEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class InnerFinTotalLimitEditUI
extends AbstractInnerFinTotalLimitEditUI {
    private static final Logger logger = CoreUIObject.getLogger(InnerFinTotalLimitEditUI.class);
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();

    @Override
    public void loadFields() {
        this.initDetailTable();
        super.loadFields();
        FMClientHelper.setSelectObject((KDComboBox)this.cobCurrency, (Object)this.editData.getCurrency());
        if (!this.getOprtState().endsWith(OprtState.ADDNEW)) {
            this.txtexchangeRate.setValue((Object)this.editData.getExchangeRate());
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    public void storeFields() {
        this.editData.setCurrency((CurrencyInfo)this.cobCurrency.getSelectedItem());
        this.editData.setEffectDate(DateTimeUtils.truncateDate((Date)this.editData.getEffectDate()));
        super.storeFields();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return InnerFinTotalLimitFactory.getRemoteInstance();
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntrys;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return new InnerFinTotalLimitEntryInfo();
    }

    protected void initDetailTable() {
        KDBizPromptBox entryCompanyF7 = new KDBizPromptBox();
        F7SelectorFactory.initNewCompanyF7((IUIObject)this, (KDBizPromptBox)entryCompanyF7, (boolean)true);
        entryCompanyF7.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent arg0) {
                InnerFinTotalLimitEditUI.this.setCompanyFilter((EventObject)arg0);
            }
        });
        entryCompanyF7.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent arg0) {
                InnerFinTotalLimitEditUI.this.setCompanyFilter((EventObject)arg0);
            }
        });
        KDTDefaultCellEditor entryCompanyCellEditor = new KDTDefaultCellEditor((IKDEditor)entryCompanyF7);
        this.kdtEntrys.getColumn("company").setEditor((ICellEditor)entryCompanyCellEditor);
        this.kdtEntrys.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                InnerFinTotalLimitEditUI.this.dealWithCompany(e);
            }
        });
    }

    protected void setCompanyFilter(EventObject e) {
        FilterInfo filter;
        KDBizPromptBox prmt = (KDBizPromptBox)e.getSource();
        if (prmt == null) {
            return;
        }
        EntityViewInfo evi = prmt.getEntityViewInfo();
        if (evi == null) {
            evi = new EntityViewInfo();
        }
        if ((filter = evi.getFilter()) == null) {
            filter = new FilterInfo();
        }
        filter.getFilterItems().add(new FilterItemInfo("isCompanyOrgUnit", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)new Integer(0)));
        evi.setFilter(filter);
        prmt.setEntityViewInfo(evi);
    }

    protected void dealWithCompany(KDTEditEvent e) {
        if (e.getValue() == null || e.getOldValue() != null && e.getOldValue().equals(e.getValue())) {
            return;
        }
        IRow row = this.kdtEntrys.getRow(e.getRowIndex());
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex == this.kdtEntrys.getColumn("company").getColumnIndex() && e.getValue() instanceof Object[]) {
            Object[] companyArray = (Object[])e.getValue();
            for (int i = companyArray.length - 1; i >= 0; --i) {
                CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)companyArray[i];
                row.getCell("company").setValue((Object)companyInfo);
                if (i <= 0) break;
                row = this.kdtEntrys.addRow(rowIndex);
            }
        }
    }

    @Override
    protected IObjectValue createNewData() {
        InnerFinTotalLimitInfo objectValue = new InnerFinTotalLimitInfo();
        if (SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Company")) != null && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Company")).getBoolean("isBizUnit")) {
            objectValue.put("company", SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Company")));
        }
        objectValue.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        objectValue.setLastUpdateUser(objectValue.getCreator());
        Date currentDate = DateTimeUtils.truncateDate((Date)new Date());
        objectValue.setBizDate(new Date());
        objectValue.setEffectDate(currentDate);
        objectValue.setExchangeRate(new BigDecimal("1"));
        objectValue.setCurrency(this.currentCompany.getBaseCurrency());
        FMClientHelper.initNumber((CoreBaseInfo)objectValue, (KDTextField)this.txtNumber, (String)objectValue.getCompany().getId().toString());
        return objectValue;
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        if (this.txtNumber.isEnabled()) {
            this.txtNumber.requestFocusInWindow();
        } else {
            this.txtname.requestFocusInWindow();
        }
    }

    protected void initDataStatus() {
        this.actionSave.setVisible(false);
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.txtexchangeRate.setEnabled(false);
        }
        super.initDataStatus();
        this.actionAttachment.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.actionCopyRow.setEnabled(true);
        boolean view = this.getOprtState().equals(OprtState.VIEW);
        this.actionAddLine.setEnabled(!view);
        this.actionCopyRow.setEnabled(!view);
        this.actionInsertLine.setEnabled(!view);
        this.actionRemoveLine.setEnabled(!view);
    }

    public void onLoad() throws Exception {
        FinUtils.initCurrencyComboBox(this.cobCurrency);
        this.setTableToSumField(this.kdtEntrys, new String[]{"limitAmt"});
        super.onLoad();
        this.hidePanelButtons(this.kdtEntrys);
        this.actionAuditResult.setVisible(false);
        if (this.getOprtState().equals(OprtState.ADDNEW) && this.getUIContext().get("InitDataObject") == null) {
            this.kdtEntrys.addRow();
        }
        this.formatFootRow();
    }

    @Override
    protected void cobCurrency_actionPerformed(ActionEvent e) throws Exception {
        super.cobCurrency_actionPerformed(e);
        CurrencyInfo currency = (CurrencyInfo)this.cobCurrency.getSelectedItem();
        if (currency == null) {
            return;
        }
        this.txtexchangeRate.setPrecision(5);
        this.initKDTPrecesion(this.kdtEntrys, new String[]{"limitAmt"}, currency.getPrecision());
        this.formatFootRow();
        String baseCurrencyId = this.currentCompany.getBaseCurrency().getId().toString();
        if (baseCurrencyId.equals(currency.getId().toString())) {
            this.txtexchangeRate.setEnabled(false);
            this.txtexchangeRate.setEditable(false);
        } else {
            this.txtexchangeRate.setEnabled(true);
            this.txtexchangeRate.setEditable(true);
        }
    }

    @Override
    protected void cobCurrency_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 2) {
            return;
        }
        CurrencyInfo currency = (CurrencyInfo)this.cobCurrency.getSelectedItem();
        if (currency == null) {
            return;
        }
        this.txtexchangeRate.setPrecision(5);
        this.initKDTPrecesion(this.kdtEntrys, new String[]{"limitAmt"}, currency.getPrecision());
        this.formatFootRow();
        try {
            this.calcExRate(currency);
        }
        catch (EASBizException e1) {
            this.cobCurrency.setSelectedItem(null);
            throw e1;
        }
        String baseCurrencyId = this.currentCompany.getBaseCurrency().getId().toString();
        if (baseCurrencyId.equals(currency.getId().toString())) {
            this.txtexchangeRate.setEnabled(false);
            this.txtexchangeRate.setEditable(false);
        } else {
            this.txtexchangeRate.setEnabled(true);
            this.txtexchangeRate.setEditable(true);
        }
    }

    private void initKDTPrecesion(KDTable kdt, String[] cols, int prec) {
        String format = FMClientHelper.getKDTNumFormat((int)prec);
        int n = cols.length;
        for (int i = 0; i < n; ++i) {
            IColumn col = kdt.getColumn(cols[i]);
            col.getStyleAttributes().setNumberFormat(format);
            col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    private void formatFootRow() {
        CurrencyInfo currency = (CurrencyInfo)this.cobCurrency.getSelectedItem();
        if (currency == null) {
            return;
        }
        IRow footRow = null;
        if (this.kdtEntrys.getFootManager() != null) {
            footRow = this.kdtEntrys.getFootRow(0);
        }
        String format = FMClientHelper.getKDTNumFormat((int)currency.getPrecision());
        if (footRow != null) {
            footRow.getCell("limitAmt").getStyleAttributes().setNumberFormat(format);
        }
    }

    private void calcExRate(CurrencyInfo currency) throws EASBizException, BOSException {
        InnerFinTotalLimitInfo info = (InnerFinTotalLimitInfo)this.getDataObject();
        if (info == null) {
            return;
        }
        FinUtils.initExchangeRate(null, (BasicFormattedTextField)this.txtexchangeRate, this.currentCompany, currency, this.currentCompany.getBaseCurrency(), info.getBizDate(), null);
    }

    @Override
    public void actionCopyRow_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyLine_actionPerformed(e);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("currency.*"));
        return sic;
    }

    private void hidePanelButtons(KDTable table) {
        Container c = table.getParent().getParent();
        if (c instanceof DetailPanel) {
            DetailPanel panel = (DetailPanel)c;
            Component[] components = panel.getComponents();
            for (int i = 0; i < components.length; ++i) {
                Component component = components[i];
                if (!(component instanceof KDPanel)) continue;
                KDPanel kdPanel = (KDPanel)component;
                if ("controlPanel".equals(kdPanel.getName())) {
                    panel.remove((Component)kdPanel);
                }
                if (!"entryPanel".equals(kdPanel.getName())) continue;
                Rectangle entryRect = new Rectangle(0, 0, table.getWidth(), table.getHeight() + 29);
                kdPanel.setBounds(entryRect);
                kdPanel.putClientProperty((Object)"OriginalBounds", (Object)entryRect);
                panel.add((Component)kdPanel, (Object)new KDLayout.Constraints(15, entryRect));
            }
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.txtNumber.isEnabled()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtname);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkeffectDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.cobCurrency);
        super.verifyInput(e);
        InnerFinTotalLimitEntryCollection entryCol = this.editData.getEntrys();
        if (entryCol.size() > 0) {
            HashSet<CompanyOrgUnitInfo> set = new HashSet<CompanyOrgUnitInfo>();
            Iterator it = entryCol.iterator();
            while (it.hasNext()) {
                InnerFinTotalLimitEntryInfo entryInfo = (InnerFinTotalLimitEntryInfo)it.next();
                if (entryInfo.getCompany() == null) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"203_InnerFinTotalLimitEditUI"));
                    SysUtil.abort();
                }
                if (entryInfo.getLimitAmt() == null || entryInfo.getLimitAmt().compareTo(Constants.ZERO) <= 0) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"204_InnerFinTotalLimitEditUI"));
                    SysUtil.abort();
                }
                if (set.contains(entryInfo.getCompany())) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"205_InnerFinTotalLimitEditUI"));
                    SysUtil.abort();
                    continue;
                }
                set.add(entryInfo.getCompany());
            }
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.disposeUIWindow();
    }
}

