/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.fin.CompIntReceivedBillFactory;
import com.kingdee.eas.fm.fin.TimeDepositConstants;
import com.kingdee.eas.fm.fin.client.AbstractIntReceivePayDateChooseUI;
import com.kingdee.eas.fm.fin.client.IntReceivedBillListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class IntReceivePayDateChooseUI
extends AbstractIntReceivePayDateChooseUI {
    private CompanyOrgUnitInfo currentCompany;
    private Set createdIntReceivedID = new HashSet();

    public void onLoad() throws Exception {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        super.onLoad();
        this.customed_init();
    }

    private void customed_init() {
        this.initPrmtDeposit(this.prmtDeposit);
        this.initCurrency(this.cboCurrency);
        this.initData(this.dtpDate);
        this.initBeginDay();
    }

    private void initData(KDDatePicker dtpDate) {
        dtpDate.setValue((Object)new Date());
    }

    private void initBeginDay() {
        this.beginDay.setValue(null);
        this.beginDay.setEnabled(false);
    }

    private void initPrmtDeposit(KDBizPromptBox prmtDeposit) {
    }

    private void initCurrency(KDComboBox cboCurrency) {
        CashHelper.initCombCurrency((KDComboBox)cboCurrency, (boolean)false);
        cboCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    @Override
    protected void prmtDeposit_willCommit(CommitEvent e) throws Exception {
        this.filterDeposit();
    }

    @Override
    public void prmtDeposit_willShow(SelectorEvent e) {
        this.filterDeposit();
    }

    private void filterDeposit() {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        this.setFilterItems(filter);
        evi.setFilter(filter);
        this.prmtDeposit.setEntityViewInfo(evi);
        this.prmtDeposit.getQueryAgent().resetRuntimeEntityView();
    }

    private void setFilterItems(FilterInfo filter) {
        filter.getFilterItems().add(new FilterItemInfo("balance", (Object)Constants.ZERO, CompareType.GREATER));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("effectedStatus", (Object)new Integer(3), CompareType.EQUALS));
        Object obj = this.cboCurrency.getSelectedItem();
        if (obj instanceof CurrencyInfo) {
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)((CurrencyInfo)obj).getId().toString(), CompareType.EQUALS));
        }
    }

    public static Set showDialogeWindow(IntReceivedBillListUI listUI) {
        return null;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.createdIntReceivedID = null;
        super.disposeUIWindow();
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.createdIntReceivedID.clear();
        Set ids = null;
        ids = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtDeposit));
        if (ids == null || ids.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"206_IntReceiveDateChooseUI"));
            SysUtil.abort();
        }
        Map map = CompIntReceivedBillFactory.getRemoteInstance().addBatch(ids, (Date)this.beginDay.getValue(), (Date)this.dtpDate.getValue());
        this.createdIntReceivedID = (Set)map.get("createdIntReceivedID");
        String exceptionString = (String)map.get("exceptionString");
        if (this.createdIntReceivedID.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.TdResource", (String)"noIntReceiveBillCreated"));
        } else if (exceptionString != null && exceptionString.length() != 0) {
            String msgStr = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"525_IntReceivePayDateChooseUI"), exceptionString);
            MsgBox.showInfo((String)msgStr);
        }
        this.disposeUIWindow();
    }

    @Override
    protected void checkBeginDay_itemStateChanged(ItemEvent e) throws Exception {
        if (this.checkBeginDay.getSelected() == 32) {
            this.beginDay.setEnabled(true);
            this.beginDay.setValue((Object)new Date());
        } else {
            this.beginDay.setEnabled(false);
            this.beginDay.setValue(null);
        }
    }

    public Set getReturnValue() {
        return this.createdIntReceivedID;
    }

    public static Set showIntReceiveScopeChooseUI(IntReceivedBillListUI ui, CompanyOrgUnitInfo currentCompany) {
        Set returnValue = new HashSet();
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put(TimeDepositConstants.CURRENT_COMPANY, (Object)currentCompany);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(IntReceivePayDateChooseUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            returnValue = ((IntReceivePayDateChooseUI)uiWindow.getUIObject()).getReturnValue();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        return returnValue;
    }
}

