/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMBooleanEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.LetOfCreditAcctRecordFactory;
import com.kingdee.eas.fm.fin.LetOfCreditAcctRecordInfo;
import com.kingdee.eas.fm.fin.LetterOfCreditAcctRecStatusEnum;
import com.kingdee.eas.fm.fin.LetterOfCreditFactory;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.client.AbstractLetOfCreditAcctRecordEditUI;
import com.kingdee.eas.fm.nt.LetterOfCreditReachFactory;
import com.kingdee.eas.fm.nt.LetterOfCreditReachInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Date;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class LetOfCreditAcctRecordEditUI
extends AbstractLetOfCreditAcctRecordEditUI {
    private LetterOfCreditInfo info;
    private boolean isFromCredit = false;
    private BigDecimal ReachAmount = Constants.ZERO;
    private boolean isReachOperate = false;
    private static final Logger logger = CoreUIObject.getLogger(LetOfCreditAcctRecordEditUI.class);

    public void onLoad() throws Exception {
        FMClientHelper.initComboCurrency((KDComboBox)this.comboCurrency);
        this.pkBizDate.setRequired(true);
        this.pkpayDate.setRequired(true);
        this.txtamount.setRequired(true);
        this.txtDescription.setMaxLength(255);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtamount);
        FMClientHelper.initDecimalField((BasicFormattedTextField)this.txtAcceptRate);
        this.txtamount.setNegatived(false);
        super.onLoad();
        if (OprtState.EDIT.equals(this.getOprtState()) || OprtState.VIEW.equals(this.getOprtState())) {
            this.info = this.editData.getBill();
        }
        if (this.editData.getCurrency() != null) {
            this.txtamount.setPrecision(this.editData.getCurrency().getPrecision());
        }
        if (FMBooleanEnum.Yes.equals((Object)this.editData.getState())) {
            this.btnEdit.setEnabled(false);
        }
        this.actionAuditResult.setVisible(false);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.txtAcceptRate.setEnabled(true);
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            this.actionEdit.setEnabled(false);
        }
        if (LetterOfCreditAcctRecStatusEnum.SUBMITED != this.editData.getBillState()) {
            this.actionEdit.setEnabled(false);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        this.txtAcceptRate.setValue((Object)this.editData.getRate());
        this.txtamount.setValue((Object)this.editData.getAmount());
        this.chkisConform.setEnabled(true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setRate(this.txtAcceptRate.getBigDecimalValue());
        this.editData.setAmount(this.txtamount.getBigDecimalValue());
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        sic.add("bill.Currency.*");
        return sic;
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.actionAddNew.setVisible(false);
        this.actionSave.setVisible(false);
        this.actionAddLine.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionPre.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionLast.setVisible(false);
        this.actionInsertLine.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionRemoveLine.setVisible(false);
        this.actionNext.setVisible(false);
        this.actionNextPerson.setVisible(false);
        this.actionWorkFlowG.setVisible(false);
        this.actionWorkflowList.setVisible(false);
        this.actionCreateFrom.setVisible(false);
        this.actionCreateTo.setVisible(false);
        this.actionMultiapprove.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.actionTraceDown.setVisible(false);
        this.actionTraceUp.setVisible(false);
    }

    protected void initAddNewStatus() {
        super.initAddNewStatus();
        if (this.isFromCredit) {
            this.txtAcceptRate.setEnabled(false);
        }
        this.prmtbill.setEnabled(false);
        this.txtseq.setEnabled(false);
        this.state.setEnabled(false);
    }

    protected void initEditStatus() {
        super.initEditStatus();
        FMClientHelper.setComponentEnable((JComponent)((Object)this), (boolean)false);
        this.pkBizDate.setEnabled(true);
        this.pkpayDate.setEnabled(true);
        this.txtamount.setEnabled(true);
        this.txtDescription.setEnabled(true);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return LetOfCreditAcctRecordFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        LetOfCreditAcctRecordInfo objectValue = new LetOfCreditAcctRecordInfo();
        objectValue.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setBizDate(new java.util.Date());
        objectValue.setPayDate(new java.util.Date());
        String id = this.getUIContext().get("AcceptID").toString();
        String reachid = null;
        if (!EmptyUtil.isEmpty(this.getUIContext().get("ReachID"))) {
            reachid = (String)this.getUIContext().get("ReachID");
        }
        try {
            ObjectUuidPK pk = new ObjectUuidPK(id);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("Currency.*");
            this.info = LetterOfCreditFactory.getRemoteInstance().getLetterOfCreditInfo((IObjectPK)pk, sic);
            objectValue.setBill(this.info);
            objectValue.setBizDate(this.info.getIssueDate());
            objectValue.setCurrency(this.info.getCurrency());
            objectValue.setBillState(LetterOfCreditAcctRecStatusEnum.SUBMITED);
            objectValue.setSeq(LetOfCreditAcctRecordFactory.getRemoteInstance().getMaxSeqByID((IObjectPK)pk) + 1);
            if (!EmptyUtil.isEmpty((String)reachid)) {
                LetterOfCreditReachInfo reachinfo = LetterOfCreditReachFactory.getRemoteInstance().getLetterOfCreditReachInfo((IObjectPK)new ObjectUuidPK(reachid));
                objectValue.setReachId(reachid);
                objectValue.setPayDate(reachinfo.getActualPayDate());
                this.ReachAmount = reachinfo.getAmount();
                objectValue.setAmount(this.ReachAmount);
                if (!EmptyUtil.isEmpty((Object)this.info.getAmount())) {
                    objectValue.setRate(this.ReachAmount.divide(this.info.getAmount(), 7, 4).multiply(new BigDecimal("100")));
                }
                this.isReachOperate = true;
            } else {
                this.isFromCredit = true;
                if (this.isFromCredit && this.info != null && this.info.getLetterNumber() != null) {
                    objectValue.setNumber(this.info.getLetterNumber());
                }
                objectValue.setPayDate(this.info.getIntendPayDate());
                objectValue.setAmount(this.info.getBalance());
                objectValue.setRate(this.info.getBalance().divide(this.info.getAmount(), 7, 4).multiply(new BigDecimal("100")));
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return objectValue;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        LetterOfCreditReachInfo reachinfo;
        Date payDate;
        super.verifyInput(e);
        FMClientVerifyHelper.verifyRequire((CoreUIObject)this);
        FMClientVerifyHelper.verifyEmptyAndNoZero((CoreUIObject)this, (KDFormattedTextField)this.txtamount);
        Date bizDate = DateUtil.getSQLBegin((java.util.Date)this.pkBizDate.getSqlDate());
        Date openDate = DateUtil.getSQLBegin((java.util.Date)this.info.getIssueDate());
        if (bizDate.compareTo(openDate) < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"213_LetOfCreditAcctRecordEditUI"));
            this.pkBizDate.requestFocus();
            SysUtil.abort();
        }
        if ((payDate = DateUtil.getSQLBegin((java.util.Date)this.pkpayDate.getSqlDate())).compareTo(bizDate) < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"214_LetOfCreditAcctRecordEditUI"));
            this.pkpayDate.requestFocus();
            SysUtil.abort();
        }
        BigDecimal amount = this.txtamount.getBigDecimalValue();
        if (!this.info.isIsDYZ() && amount.compareTo(this.info.getBalance()) > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"215_LetOfCreditAcctRecordEditUI"));
            this.txtamount.requestFocus();
            SysUtil.abort();
        }
        if (!this.info.isIsDYZ() && !this.isFromCredit && this.isReachOperate && amount.compareTo(this.ReachAmount) > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"216_LetOfCreditAcctRecordEditUI"));
            this.txtamount.requestFocus();
            SysUtil.abort();
        }
        if (!EmptyUtil.isEmpty((String)this.editData.getReachId()) && (reachinfo = LetterOfCreditReachFactory.getRemoteInstance().getLetterOfCreditReachInfo((IObjectPK)new ObjectUuidPK(this.editData.getReachId()))) != null && amount.compareTo(reachinfo.getAmount()) > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"216_LetOfCreditAcctRecordEditUI"));
            this.txtamount.requestFocus();
            SysUtil.abort();
        }
        if (!this.isFromCredit && this.isReachOperate && amount.compareTo(this.ReachAmount) == 0) {
            this.editData.setRate(amount.divide(this.info.getAmount(), 7, 4).multiply(Constants.ONE_HUNDRED));
        }
    }

    @Override
    protected void txtAcceptRate_dataChanged(DataChangeEvent e) throws Exception {
        if (this.txtAcceptRate.getBigDecimalValue().compareTo(Constants.ZERO) != 0 && this.info != null) {
            this.txtamount.setValue((Object)this.info.getAmount().multiply(this.txtAcceptRate.getBigDecimalValue().divide(Constants.ONE_HUNDRED, 7, 4)), false);
        }
    }

    @Override
    protected void txtamount_dataChanged(DataChangeEvent e) throws Exception {
        if (this.txtamount.getBigDecimalValue().compareTo(Constants.ZERO) != 0 && this.info != null) {
            this.txtAcceptRate.setValue((Object)this.txtamount.getBigDecimalValue().divide(this.info.getAmount(), 7, 4).multiply(Constants.ONE_HUNDRED), false);
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.setOprtState(OprtState.VIEW);
        this.actionEdit.setEnabled(false);
        this.btnEdit.setEnabled(false);
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.NT_MANAGEMENT;
    }

    protected String getDateField() {
        return "bizDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionSave", "actionSubmit", "actionAntiAudit"};
    }
}

