/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fin.IsOrNoEnum;
import com.kingdee.eas.fm.fin.LoanAdjustInterestFactory;
import com.kingdee.eas.fm.fin.LoanAdjustInterestInfo;
import com.kingdee.eas.fm.fin.client.AbstractLoanAdjustInterestListUI;
import com.kingdee.eas.fm.fin.client.LoanAdjusitInterestFilterUI;
import com.kingdee.eas.fm.fin.client.LoanAdjustInterestEditUI;
import com.kingdee.eas.fm.fin.client.LoanAdjustInterestUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.service.LicenseService;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LoanAdjustInterestListUI
extends AbstractLoanAdjustInterestListUI {
    private static final Logger logger = CoreUIObject.getLogger(LoanAdjustInterestListUI.class);
    private CompanyOrgUnitInfo currentCompany;
    private LoanAdjusitInterestFilterUI filterUI = null;
    private LicenseService licenseService = new LicenseService((IUIObject)this);
    private Set setIDs;
    private Map hm = null;

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String keyValue = this.getSelectedKeyValue();
        if (keyValue == null) {
            return;
        }
        LoanAdjustInterestInfo info = LoanAdjustInterestFactory.getRemoteInstance().getLoanAdjustInterestInfo((IObjectPK)new ObjectUuidPK(keyValue));
        if (info.getIsUsed().equals((Object)IsOrNoEnum.IS)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"265_LoanAdjustInterestListUI"));
            this.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String keyValue = this.getSelectedKeyValue();
        if (keyValue == null) {
            return;
        }
        LoanAdjustInterestInfo info = LoanAdjustInterestFactory.getRemoteInstance().getLoanAdjustInterestInfo((IObjectPK)new ObjectUuidPK(keyValue));
        if (info.getIsUsed().equals((Object)IsOrNoEnum.IS)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"266_LoanAdjustInterestListUI"));
            this.abort();
        }
        Integer maxSeq = LoanAdjustInterestFactory.getRemoteInstance().getMaxSeq((IObjectPK)new ObjectUuidPK(info.getLoan().getId().toString()));
        if (info.getAdjustSeq() + 1 != maxSeq) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"267_LoanAdjustInterestListUI"));
            this.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    public LoanAdjustInterestListUI() throws Exception {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)new FillListener());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new LoanAdjusitInterestFilterUI();
        }
        return this.filterUI;
    }

    public void onLoad() throws Exception {
        String uiParam = (String)this.getUIContext().get("UIClassParam");
        if (this.getBOTPViewStatus() != 1) {
            this.licenseService.checkLicence();
            if (uiParam.equals("ADJUSTINTERESTUI")) {
                this.hm = LoanAdjustInterestUI.showLoanAdjustInterestUI((CoreUI)this);
                this.setIDs = (Set)this.hm.get("createdIdSet");
                this.getUIContext().put("BTPCreateMode", "1");
                if (this.setIDs == null) {
                    SysUtil.abort();
                }
            } else if (uiParam.equals("ADJUSTINTERESTLISTUI")) {
                // empty if block
            }
        }
        super.onLoad();
        this.CheckBizUnit();
        IColumn adjustSeqColumn = this.tblMain.getColumn("adjustSeq");
        adjustSeqColumn.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        IColumn yearDaysColumn = this.tblMain.getColumn("yearDays");
        yearDaysColumn.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        IColumn adjustAfterRateColumn = this.tblMain.getColumn("adjustAfterRate");
        adjustAfterRateColumn.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        IColumn penAccrualRateColumn = this.tblMain.getColumn("penAccrualRate");
        penAccrualRateColumn.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.actionAuditResult.setEnabled(false);
        this.actionAuditResult.setVisible(false);
        this.tblMain.getColumn("adjustDate").getStyleAttributes().setNumberFormat(this.dformat);
    }

    private void checkHasNumber() {
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            codingRuleManager.readNumber((IObjectValue)new LoanAdjustInterestInfo(), this.currentCompany.getId().toString());
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)e.getMessage());
            SysUtil.abort();
        }
    }

    protected void CheckBizUnit() throws EASBizException, BOSException {
        if (ContextHelperFactory.getRemoteInstance().isOnlyUnion(this.currentCompany)) {
            this.actionAddNew.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionRemove.setVisible(false);
            this.actionAdjust.setVisible(false);
        }
    }

    protected String getEditUIName() {
        return LoanAdjustInterestEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LoanAdjustInterestFactory.getRemoteInstance();
    }

    protected void execQuery() {
        if (this.setIDs != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.setIDs, CompareType.INCLUDE));
            this.mainQuery.setFilter(filter);
        }
        super.execQuery();
        this.setIDs = null;
    }

    private LoanAdjustInterestInfo getDeferInfo() throws Exception {
        return LoanAdjustInterestFactory.getRemoteInstance().getLoanAdjustInterestInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = null;
        if (this.setIDs == null) {
            filter = super.getDefaultFilterForQuery();
        } else {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.setIDs, CompareType.INCLUDE));
        }
        return filter;
    }

    @Override
    public void actionAdjust_actionPerformed(ActionEvent e) throws Exception {
        this.hm = LoanAdjustInterestUI.showLoanAdjustInterestUI((CoreUI)this);
        this.setIDs = (Set)this.hm.get("createdIdSet");
        if (this.setIDs != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.setIDs, CompareType.INCLUDE));
            this.mainQuery.setFilter(filter);
            this.refresh(e);
        }
    }

    public void setListUITable(KDTable tblMain, KDTDataRequestEvent e) {
        IRow row = null;
        if (e == null) {
            return;
        }
        for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
            String rateExpression;
            BizEnumValueInfo exp;
            String panaAccrualWay;
            String rateExpression2;
            row = tblMain.getRow(i);
            if (row.getCell("intRateTypeExpression").getValue() != null && (rateExpression2 = row.getCell("intRateTypeExpression").getValue().toString()) != null) {
                if (rateExpression2.equals(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"480_CompDepositAccountBillListUI"))) {
                    row.getCell("adjustAfterRate").getStyleAttributes().setNumberFormat("###,##0.00000000\\%");
                } else {
                    row.getCell("adjustAfterRate").getStyleAttributes().setNumberFormat("###,##0.00000000\\\u2030");
                }
            }
            if (row.getCell("penAccrualType").getValue() != null && (panaAccrualWay = row.getCell("penAccrualType").getValue().toString()) != null) {
                if (panaAccrualWay.equals(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"268_LoanAdjustInterestListUI"))) {
                    row.getCell("penAccrualRate").getStyleAttributes().setNumberFormat("###,##0.0000\\%");
                } else {
                    row.getCell("penAccrualRate").getStyleAttributes().setNumberFormat("###,##0.0000\\\u2030");
                }
            }
            if ((exp = (BizEnumValueInfo)row.getCell("intRateTypeExpression").getValue()) == null || (rateExpression = exp.getValue().toString()) == null) continue;
            if (rateExpression.equals("year")) {
                row.getCell("basePoints").getStyleAttributes().setNumberFormat("###,##0.000000\\%");
                row.getCell("basePoints").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                continue;
            }
            row.getCell("basePoints").getStyleAttributes().setNumberFormat("###,##0.000000\\\u2030");
            row.getCell("basePoints").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAdjust.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_budgetadjust"));
    }

    public boolean destroyWindow() {
        try {
            this.licenseService.releaseLicense();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return super.destroyWindow();
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            LoanAdjustInterestListUI.this.setListUITable(LoanAdjustInterestListUI.this.tblMain, e);
        }
    }
}

