/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.LoanApplyBillStatusEnum;
import com.kingdee.eas.fm.fin.LoanPropertyEnum;
import com.kingdee.eas.fm.fin.LoanTypeEnum;
import com.kingdee.eas.fm.fin.client.AbstractLoanApplyBillFilterUI;
import com.kingdee.eas.fm.fin.client.LoanApplyBillFilterParam;
import com.kingdee.eas.fm.fin.client.LoanApplyClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class LoanApplyBillFilterUI
extends AbstractLoanApplyBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(LoanApplyBillFilterUI.class);
    private LoanPropertyEnum loanProperty;

    public LoanApplyBillFilterUI() throws Exception {
    }

    public LoanApplyBillFilterUI(LoanPropertyEnum loanPro) throws Exception {
        this.loanProperty = loanPro;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.comboLoanType.removeItem((Object)LoanTypeEnum.NoBank);
        this.comboLoanType_itemStateChanged(null);
    }

    @Override
    protected void comboLoanProperty_itemStateChanged(ItemEvent e) throws Exception {
        LoanApplyClientHelper.loanPropertyChanged(this.comboLoanProperty, this.comboLoanType, true);
    }

    @Override
    protected void comboLoanType_itemStateChanged(ItemEvent e) throws Exception {
        LoanApplyClientHelper.loanTypeChanged(this.comboLoanProperty, this.comboLoanType, this.contFinancingOrg, this.contBank, this.contCustomer);
    }

    protected void init() throws Exception {
        super.init();
        this.dpStartDate.setSupportedEmpty(false);
        this.dpEndDate.setSupportedEmpty(false);
        this.prmtFinancingOrg.setEnabledMultiSelection(true);
        this.prmtBank.setEnabledMultiSelection(true);
        this.prmtCustomer.setEnabledMultiSelection(true);
        FMClientHelper.setCustomerF7(null, (KDBizPromptBox)this.prmtCustomer, (boolean)true, null);
        this.comboLoanProperty.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.comboStatus.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.comboLoanType.removeItem((Object)LoanTypeEnum.EntLoan);
        this.customInit();
        this.contCustomer.setVisible(false);
        this.contBank.setVisible(false);
    }

    private void customInit() {
        this.initDate();
        this.initLoanProperty();
        this.initCurrency();
    }

    private void initCurrency() {
        CashHelper.initCombCurrency((KDComboBox)this.cboCurrency, (boolean)false);
        this.cboCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    private void initLoanProperty() {
        this.comboLoanProperty.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.comboStatus.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    public void clear() {
        super.clear();
        this.customInit();
    }

    private void initDate() {
        Date now = new Date();
        this.dpStartDate.setValue((Object)this.getStartDate(now));
        this.dpEndDate.setValue((Object)now);
    }

    private Date getStartDate(Date now) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public Object getParam() {
        LoanApplyBillFilterParam labfp = new LoanApplyBillFilterParam();
        if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            labfp.setCompanyIdSet(this.getCompanyIdSet());
        }
        if (null != this.dpStartDate.getValue()) {
            labfp.setStartDate(DateTimeUtils.truncateDate((Date)((Date)this.dpStartDate.getValue())));
        }
        if (null != this.dpEndDate.getValue()) {
            labfp.setEndDate(DateTimeUtils.truncateDate((Date)((Date)this.dpEndDate.getValue())));
        }
        if (!(this.comboLoanProperty.getSelectedItem() instanceof LoanPropertyEnum)) {
            labfp.setLoanProperty(null);
        } else {
            labfp.setLoanProperty((LoanPropertyEnum)((Object)this.comboLoanProperty.getSelectedItem()));
        }
        if (this.loanProperty == null || this.loanProperty != LoanPropertyEnum.InGroup) {
            labfp.setNeedToFilterCompany(true);
        } else {
            labfp.setNeedToFilterCompany(false);
        }
        if (!(this.comboLoanType.getSelectedItem() instanceof LoanTypeEnum)) {
            labfp.setLoanType(null);
        } else {
            labfp.setLoanType((LoanTypeEnum)((Object)this.comboLoanType.getSelectedItem()));
        }
        if (!(this.comboStatus.getSelectedItem() instanceof LoanApplyBillStatusEnum)) {
            labfp.setStatus((LoanApplyBillStatusEnum)null);
        } else {
            labfp.setStatus((LoanApplyBillStatusEnum)((Object)this.comboStatus.getShowSelectedItem()));
        }
        if (null != this.cboCurrency.getSelectedItem()) {
            Object obj = this.cboCurrency.getSelectedItem();
            if (obj instanceof CurrencyInfo) {
                labfp.setCurrencyInfo((CurrencyInfo)this.cboCurrency.getSelectedItem());
            } else {
                labfp.setCurrencyInfo(null);
            }
        }
        labfp.setFinacingOrgIDs(AccessHelper.getF7Ids((KDBizPromptBox)this.prmtFinancingOrg));
        labfp.setBankIDs(AccessHelper.getF7Ids((KDBizPromptBox)this.prmtBank));
        labfp.setCustomerIDs(AccessHelper.getF7Ids((KDBizPromptBox)this.prmtCustomer));
        return labfp;
    }

    protected Class getParamClass() {
        return LoanApplyBillFilterParam.class;
    }

    protected boolean isNeedEachSerializable() {
        return true;
    }

    public void setParam(Object param) {
        LoanApplyBillFilterParam labfp = (LoanApplyBillFilterParam)param;
        if (labfp == null) {
            return;
        }
        this.setCompanyIdSet(labfp.getCompanyIdSet());
        this.dpStartDate.setValue((Object)labfp.getStartDate());
        this.dpEndDate.setValue((Object)labfp.getEndDate());
        if (labfp.getLoanProperty() == null) {
            this.comboLoanProperty.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            this.comboLoanProperty.setSelectedItem((Object)labfp.getLoanProperty());
        }
        if (labfp.getLoanType() == null) {
            this.comboLoanType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            this.comboLoanType.setSelectedItem((Object)labfp.getLoanType());
        }
        if (labfp.getStatus() == null) {
            this.comboStatus.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            this.comboStatus.setSelectedItem((Object)labfp.getStatus());
        }
        this.setBizPromtValues(labfp.getFinacingOrgIDs(), 1);
        this.setBizPromtValues(labfp.getCustomerIDs(), 2);
        this.setBizPromtValues(labfp.getBankIDs(), 3);
        if (labfp.getCurrencyInfo() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)labfp.getCurrencyInfo());
        } else {
            this.cboCurrency.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        }
    }

    private void setBizPromtValues(String[] ids, int paraType) {
        if (ids == null || ids.length <= 0) {
            return;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.asSet((String[])ids), CompareType.INCLUDE));
        ev.setFilter(filter);
        try {
            switch (paraType) {
                case 1: {
                    this.setFinacingOrg(ev);
                    break;
                }
                case 2: {
                    this.setCustomer(ev);
                    break;
                }
                case 3: {
                    this.setBank(ev);
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void setBank(EntityViewInfo ev) throws Exception {
        BankCollection bankCol = BankFactory.getRemoteInstance().getBankCollection(ev);
        this.prmtBank.setValue((Object)bankCol.toArray());
    }

    private void setCustomer(EntityViewInfo ev) throws Exception {
        CustomerCollection customCol = CustomerFactory.getRemoteInstance().getCustomerCollection(ev);
        this.prmtCustomer.setValue((Object)customCol.toArray());
    }

    private void setFinacingOrg(EntityViewInfo ev) throws Exception {
        CompanyOrgUnitCollection companyCol = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(ev);
        this.prmtFinancingOrg.setValue((Object)companyCol.toArray());
    }

    public boolean verify() {
        if (((Date)this.dpStartDate.getValue()).after((Date)this.dpEndDate.getValue())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"273_LoanApplyBillFilterUI"));
            Date d = new Date();
            this.dpStartDate.setValue((Object)this.getStartDate(d));
            this.dpStartDate.setFocusable(true);
            SysUtil.abort();
        }
        return true;
    }
}

