/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.CheckUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FinBillResult;
import com.kingdee.eas.fm.common.SumBillEnum;
import com.kingdee.eas.fm.common.SumFiledsInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMCommonSortedDataProvider;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fin.FinBillStatusEnum;
import com.kingdee.eas.fm.fin.LoanCollection;
import com.kingdee.eas.fm.fin.LoanContractActLoanSituationCollection;
import com.kingdee.eas.fm.fin.LoanContractActLoanSituationInfo;
import com.kingdee.eas.fm.fin.LoanContractCollection;
import com.kingdee.eas.fm.fin.LoanContractEnum;
import com.kingdee.eas.fm.fin.LoanContractFactory;
import com.kingdee.eas.fm.fin.LoanContractInfo;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.client.AbstractLoanContractListUI;
import com.kingdee.eas.fm.fin.client.LoanContractEditUI;
import com.kingdee.eas.fm.fin.client.LoanContractFilterParam;
import com.kingdee.eas.fm.fin.client.LoanContractFilterUI;
import com.kingdee.eas.fm.fin.client.RepaymentBathEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class LoanContractListUI
extends AbstractLoanContractListUI {
    private static final Logger logger = CoreUIObject.getLogger(LoanContractListUI.class);
    private LoanContractFilterUI filterUI = null;
    static final String tdTemplateFile = "/FM/FIN/LOANCONTRACT";
    private static boolean FIN022 = true;
    private static final String ERROR_KEY = "error";

    protected String getEditUIName() {
        return LoanContractEditUI.class.getName();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new LoanContractFilterUI();
        }
        return this.filterUI;
    }

    protected void execQuery() {
        super.execQuery();
        this.formatFootRow();
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.formatFootRow();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LoanContractFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        FIN022 = ContextHelperFactory.getRemoteInstance().getBooleanParam("FIN022", (IObjectPK)new ObjectUuidPK(ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId()));
        super.onLoad();
        this.initTableFormat();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAudit.setEnabled(true);
        this.actionAntiAudit.setEnabled(true);
        this.actionClose.setEnabled(true);
        this.actionUnClose.setEnabled(true);
        this.actionRepayment.setEnabled(true);
        this.actionUpdateHis.setEnabled(false);
        if (FIN022) {
            this.actionCreateTo.setEnabled(true);
        } else {
            this.actionCreateTo.setEnabled(false);
        }
        this.actionSubmit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionClose.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_discount"));
        this.actionUnClose.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_canceldiscount"));
        this.actionUpdateHis.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_moveup"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintView.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        this.actionRepayment.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_requite"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(false);
    }

    @Override
    public void actionTDPrintView_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(true);
    }

    private void tdPrint(boolean isPreview) {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        FMCommonSortedDataProvider data = new FMCommonSortedDataProvider((List)idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        if (isPreview) {
            appHlp.printPreview(tdTemplateFile, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.print(tdTemplateFile, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fm.fin.LoanContractTDQuery");
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        LoanContractInfo info = LoanContractFactory.getRemoteInstance().getLoanContractInfo((IObjectPK)new ObjectUuidPK(id));
        if (info.getStatus().equals((Object)LoanContractEnum.CLOSED)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"361_LoanContractListUI"));
            this.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)id);
        uiContext.put((Object)"COPY", (Object)"COPY");
        this.prepareUIContext(uiContext, e);
        uiContext.put((Object)"IDList", null);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        ArrayList resultList = LoanContractFactory.getRemoteInstance().batchSubmit(new HashSet(idList));
        this.showActionResult(resultList, this.btnSubmit.getText(), null);
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        LoanContractInfo info = LoanContractFactory.getRemoteInstance().getLoanContractInfo((IObjectPK)new ObjectUuidPK(id));
        if (!info.getStatus().equals((Object)LoanContractEnum.AUDITED)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"238_BondsContractListUI"));
            this.abort();
        }
        if (info.getConRemainAmount().compareTo(Constants.ZERO) <= 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"362_LoanContractListUI"));
            this.abort();
        }
        super.actionCreateTo_actionPerformed(e);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        ArrayList resultList = LoanContractFactory.getRemoteInstance().batchAudit(new HashSet(idList));
        this.showActionResult(resultList, this.btnAudit.getText(), null);
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        ArrayList resultList = LoanContractFactory.getRemoteInstance().batchAntiAudit(new HashSet(idList));
        this.showActionResult(resultList, this.btnAnitAudit.getText(), null);
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        ArrayList resultList = LoanContractFactory.getRemoteInstance().batchClose(new HashSet(idList));
        this.showActionResult(resultList, this.btnClose.getText(), null);
    }

    @Override
    public void actionUnClose_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        ArrayList resultList = LoanContractFactory.getRemoteInstance().batchUnClose(new HashSet(idList));
        this.showActionResult(resultList, this.btnUnClose.getText(), null);
        this.refreshList();
    }

    @Override
    public void actionUpdateHis_actionPerformed(ActionEvent e) throws Exception {
        LoanContractFactory.getRemoteInstance().updateHisData();
        MsgBox.showInfo((Component)((Object)this), (String)(this.btnUpdateHis.getText() + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"363_LoanContractListUI")));
        this.refreshList();
    }

    @Override
    public void actionAddHisLoanContract_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        this.prepareUIContext(uiContext, e);
        uiContext.put((Object)"IDList", null);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create("com.kingdee.eas.fm.fin.client.HisLoanContractEditUI", (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void actionRepayment_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() > 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"364_LoanContractListUI"));
            SysUtil.abort();
        }
        EntityViewInfo ev = new EntityViewInfo();
        ev.getSelector().add("LoanContractActLoanSituation.*");
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idList.get(0).toString()));
        LoanContractCollection coll = LoanContractFactory.getRemoteInstance().getLoanContractCollection(ev);
        if (coll.size() > 0) {
            HashSet<String> idSet = new HashSet<String>();
            HashSet<String> loanIdSet = new HashSet<String>();
            LoanContractInfo info = coll.get(0);
            LoanContractActLoanSituationCollection loanContractColl = info.getLoanContractActLoanSituation();
            for (int i = 0; i < loanContractColl.size(); ++i) {
                LoanContractActLoanSituationInfo loanContractInfo = loanContractColl.get(i);
                if (loanContractInfo.getBalance().compareTo(BigDecimal.ZERO) == 0) continue;
                idSet.add(loanContractInfo.getLoanId());
            }
            EntityViewInfo loanEv = new EntityViewInfo();
            loanEv.getSelector().add("id");
            loanEv.getSelector().add("status");
            FilterInfo loanFilter = new FilterInfo();
            loanEv.setFilter(loanFilter);
            loanFilter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            LoanCollection loanColl = LoanFactory.getRemoteInstance().getLoanCollection(loanEv);
            for (int n = 0; n < loanColl.size(); ++n) {
                LoanInfo loanInfo = loanColl.get(n);
                if (!loanInfo.getStatus().equals((Object)FinBillStatusEnum.AUDITED)) continue;
                loanIdSet.add(loanInfo.getId().toString());
            }
            if (loanIdSet.size() > 0) {
                String contractId = idList.get(0).toString();
                List loanList = FMHelper.set2List(loanIdSet);
                ArrayList appliedList = new ArrayList();
                IMutexServiceControl iMutexServiceControl = MutexServiceControlFactory.getRemoteInstance();
                boolean b = false;
                try {
                    Boolean boolResult;
                    int i;
                    b = iMutexServiceControl.requestObjIDForUpdate(contractId);
                    if (!b) {
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"198_PaymentBillControllerBean"));
                        SysUtil.abort();
                        return;
                    }
                    Map requestMap = iMutexServiceControl.batchRequestObjIDForUpdate(loanList);
                    for (i = 0; i < loanList.size(); ++i) {
                        boolResult = (Boolean)requestMap.get(loanList.get(i));
                        if (!boolResult.booleanValue()) continue;
                        appliedList.add(loanList.get(i));
                    }
                    for (i = 0; i < loanList.size(); ++i) {
                        boolResult = (Boolean)requestMap.get(loanList.get(i));
                        if (boolResult.booleanValue()) continue;
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"198_PaymentBillControllerBean"));
                        SysUtil.abort();
                    }
                    IUIWindow uiWindow = RepaymentBathEditUI.showDialogWindows((IUIObject)this, loanIdSet, idList.get(0).toString());
                    uiWindow.getUIObject();
                }
                catch (Exception ex) {
                    iMutexServiceControl.releaseObjIDForUpdate(contractId);
                    if (appliedList.size() > 0) {
                        iMutexServiceControl.batchReleaseObjIDForUpdate(appliedList);
                    }
                    throw ex;
                }
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"365_LoanContractListUI"));
                SysUtil.abort();
            }
        }
        this.refreshList();
    }

    private void initTableFormat() throws Exception {
        String numberFtm = "%r-[ ]{###,###,##0.00}15.2n";
        this.tblMain.getColumn("amount").getStyleAttributes().setNumberFormat(numberFtm);
        this.tblMain.getColumn("amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    private void formatFootRow() {
        try {
            LoanContractFilterParam param = (LoanContractFilterParam)((Object)this.getFilterUI().getParam());
            if (this.tblMain.getFootManager() == null) {
                return;
            }
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrencyId() == null ? this.currentCompanyCommon.getBaseCurrency().getId().toString() : AccessHelper.getId((Object)param.getCurrencyId());
            String[] columns = new SumFiledsInfo(SumBillEnum.FinLoan).getSumFileds();
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void showActionResult(List<FinBillResult> resultList, String title, String spentTimeHint) throws Exception {
        int size = resultList.size();
        if (resultList == null || size == 0) {
            return;
        }
        if (size == 1 && resultList.get(0).getId().equals(ERROR_KEY)) {
            FinBillResult bankPayResult = resultList.get(0);
            MsgBox.showInfo((Component)((Object)this), (String)bankPayResult.getDetailMsg());
            return;
        }
        StringBuilder hintBuilder = new StringBuilder();
        StringBuffer errorDetail = new StringBuffer();
        int fail = 0;
        String LINE_SEPARATOR = System.getProperty("line.separator");
        String numberTitle = EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"242_BondsContractListUI");
        String successTitle = EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"243_BondsContractListUI");
        String failureTitle = EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"244_BondsContractListUI");
        String recordTile = EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"245_BondsContractListUI");
        for (int j = 0; j < size; ++j) {
            FinBillResult resultInfo = resultList.get(j);
            if (!CheckUtils.exist((Object)resultInfo.getDetailMsg())) continue;
            errorDetail.append(numberTitle).append(resultInfo.getNumber()).append("\uff1a");
            errorDetail.append("\u3010" + resultInfo.getDetailMsg() + "\u3011").append(LINE_SEPARATOR);
            ++fail;
        }
        if (fail == 0) {
            hintBuilder.append(title + successTitle).append(" ").append(size).append(" ").append(recordTile);
            if (!EmptyUtil.isEmpty((String)spentTimeHint)) {
                hintBuilder.append(" , ").append(spentTimeHint);
            }
            MsgBox.showInfo((Component)((Object)this), (String)hintBuilder.toString());
            this.refreshList();
        } else {
            hintBuilder.append(title + successTitle).append(" ").append(size - fail).append(" ").append(recordTile).append(" , ");
            hintBuilder.append(failureTitle).append(fail).append(recordTile);
            if (!EmptyUtil.isEmpty((String)spentTimeHint)) {
                hintBuilder.append(" , ").append(spentTimeHint);
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)hintBuilder.toString(), (String)errorDetail.toString(), (int)0);
            if (size != fail) {
                this.refreshList();
            }
        }
    }

    public FilterInfo getFilterInfo() {
        FilterInfo listUIfilter = new FilterInfo();
        listUIfilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString()));
        listUIfilter.getFilterItems().add(new FilterItemInfo("status", (Object)2));
        listUIfilter.getFilterItems().add(new FilterItemInfo("conRemainAmount", (Object)Constants.ZERO, CompareType.GREATER));
        return listUIfilter;
    }

    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("BankAcct.name"));
        sic.add(new SelectorItemInfo("BankAcct.number"));
        sic.add(new SelectorItemInfo("GaranteeType.id"));
        sic.add(new SelectorItemInfo("GaranteeType.name"));
        sic.add(new SelectorItemInfo("GaranteeType.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.*"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.guaranteeType.id"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.guaranteeType.name"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.currency.id"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.currency.name"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.guaranteeComp.id"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.guaranteeComp.name"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.guaranteeCustomer.id"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.guaranteeCustomer.name"));
        return sic;
    }
}

