/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.freechart.util.Log;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.fm.cl.ConsignLoanExtBillFactory;
import com.kingdee.eas.fm.cl.ConsignLoanExtBillInfo;
import com.kingdee.eas.fm.cl.ConsignmentLoanBillCollection;
import com.kingdee.eas.fm.cl.ConsignmentLoanBillFactory;
import com.kingdee.eas.fm.cl.ConsignmentLoanBillInfo;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.LoanDeferFactory;
import com.kingdee.eas.fm.fin.LoanDeferInfo;
import com.kingdee.eas.fm.fin.LoanExhibitionFactory;
import com.kingdee.eas.fm.fin.LoanExhibitionInfo;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.client.AbstractLoanDeferEditUI;
import com.kingdee.eas.fm.ft.FundTransferBillFactory;
import com.kingdee.eas.fm.ft.FundTransferBillInfo;
import com.kingdee.eas.fm.ft.FundTransferExtBillFactory;
import com.kingdee.eas.fm.ft.FundTransferExtBillInfo;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.im.PenAccrualTypeEnum;
import com.kingdee.eas.fm.ivt.CHLoanExtendBillFactory;
import com.kingdee.eas.fm.ivt.CHLoanExtendBillInfo;
import com.kingdee.eas.fm.ivt.ChLoanFactory;
import com.kingdee.eas.fm.ivt.ChLoanInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class LoanDeferEditUI
extends AbstractLoanDeferEditUI {
    private static final Logger logger = CoreUIObject.getLogger(LoanDeferEditUI.class);
    private static final String RESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";
    private CompanyOrgUnitInfo CURRENT_COMPANY = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private UserInfo CURRENT_USER = ContextHelperFactory.getRemoteInstance().getCurrentUser();
    private Integer maxDeferSeq;
    private Date lastDeferDate;
    private LoanInfo loanInfo;
    private String type;
    private boolean isCreateFromCHLoanExtendBill = false;
    private Map createFromCHLoanExtendMap;
    private CHLoanExtendBillInfo chLoanExtendInfo;
    private ChLoanInfo chloanInfo;

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData.getCreditorAsBank() != null) {
            this.contCreditorAsBank.setVisible(true);
            this.contCreditorAsCompany.setVisible(false);
        } else {
            this.contCreditorAsBank.setVisible(false);
            this.contCreditorAsCompany.setVisible(true);
        }
        if (FinUtils.isBaseCurrency(this.editData.getCurrency(), this.CURRENT_COMPANY)) {
            this.txtExchangeRate.setEditable(false);
        } else {
            this.txtExchangeRate.setEditable(true);
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)this.editData.getCompany())) {
            this.destroyWindow();
            SysUtil.abort();
        }
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.editData.getCompany().getId().toString(), (FmRpcCacheInfo)this.rpcCacheInfo);
        FMClientHelper.setSelectObject((KDComboBox)this.comboRateExpression, (Object)this.editData.getRateExpression());
        FMClientHelper.setSelectObject((KDComboBox)this.comboPenaIntType, (Object)this.editData.getPenaIntType());
        this.txtDeferRate.setEnabled(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        if (this.getUIContext().get("company") != null) {
            this.CURRENT_COMPANY = (CompanyOrgUnitInfo)this.getUIContext().get("company");
        }
        if (this.CURRENT_COMPANY != null && "ADDNEW".equals(this.oprtState)) {
            IPermission iPermission = PermissionFactory.getRemoteInstance();
            iPermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(this.CURRENT_COMPANY.getId()), "fin_LoanDefer_addnew");
        }
        FMClientHelper.checkOnlyUnion((String)this.oprtState);
        this.loanInfo = (LoanInfo)this.getUIContext().get("chloanid");
        if (this.loanInfo == null) {
            if (this.isCreateFromCHLoanExtendBill) {
                if (this.getUIContext().get("InitDataObject") != null) {
                    String chLoanExtendID = ((LoanDeferInfo)this.getUIContext().get("InitDataObject")).getChLoanExtendBill().getId().toString();
                    this.createFromCHLoanExtendMap = LoanDeferFactory.getRemoteInstance().getMsgWhenCreateCHLoanExtendBill((IObjectPK)new ObjectUuidPK(chLoanExtendID));
                    if (!((Boolean)this.createFromCHLoanExtendMap.get("canRec")).booleanValue()) {
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"277_LoanDeferEditUI"));
                        SysUtil.abort();
                    }
                    this.chLoanExtendInfo = CHLoanExtendBillFactory.getRemoteInstance().getCHLoanExtendBillInfo((IObjectPK)new ObjectUuidPK(chLoanExtendID));
                    this.chloanInfo = ChLoanFactory.getRemoteInstance().getChLoanInfo((IObjectPK)new ObjectUuidPK((String)this.createFromCHLoanExtendMap.get("chLoanID")));
                    this.loanInfo = LoanFactory.getRemoteInstance().getLoanInfo((IObjectPK)new ObjectUuidPK((String)this.createFromCHLoanExtendMap.get("loanID")), this.getSelectors());
                }
            } else {
                String selectedValue = (String)this.getUIContext().get("viewObjectID");
                if (selectedValue != null) {
                    this.loanInfo = LoanFactory.getRemoteInstance().getLoanInfo((IObjectPK)new ObjectUuidPK(selectedValue));
                }
            }
        }
        this.type = (String)this.getUIContext().get("pull_or_push");
        this.init();
        this.txtExchangeRate.setPrecision(4);
        CurrencyInfo currency = (CurrencyInfo)this.prmtCurrency.getData();
        if (currency != null) {
            this.txtBalance.setPrecision(currency.getPrecision());
            this.txtLocalAmount.setPrecision(currency.getPrecision());
        }
        super.onLoad();
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtBalance);
        this.txtSeq.setHorizontalAlignment(4);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtExchangeRate);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtLocalAmount);
        this.txtYearDays.setHorizontalAlignment(4);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtDeferRate);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtPeneIntRate);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        if (this.isCreateFromCHLoanExtendBill) {
            this.pkAfterDeferDate.setEnabled(false);
        } else {
            this.pkAfterDeferDate.setEnabled(true);
        }
        this.txtDescription.setMaxLength(80);
        this.txtNumber.setMaxLength(50);
        this.contractNum.setMaxLength(50);
        this.actionMultiapprove.setEnabled(false);
        this.actionMultiapprove.setVisible(false);
        this.actionAuditResult.setEnabled(false);
        this.actionAuditResult.setVisible(false);
        this.actionNextPerson.setVisible(false);
        this.actionNextPerson.setEnabled(false);
        this.actionCreateFromCHLoanExtendBill.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_associatecreate"));
    }

    private boolean isPush() {
        return "push".equals(this.type);
    }

    private void init() {
        this.pkBizDate.setSupportedEmpty(false);
        this.pkAfterDeferDate.setSupportedEmpty(false);
        this.txtDeferRate.setPrecision(4);
        this.txtPeneIntRate.setPrecision(4);
        this.txtExchangeRate.setPrecision(4);
        if (this.prmtCurrency.getData() != null) {
            this.txtExchangeRate.setPrecision(((CurrencyInfo)this.prmtCurrency.getData()).getPrecision());
        }
    }

    protected IObjectValue createNewData() {
        LoanDeferInfo loanDeferInfo = new LoanDeferInfo();
        if (this.isPush()) {
            loanDeferInfo.setBizDate(DateUtil.getDayBegin());
            loanDeferInfo.setLoan(this.loanInfo);
            if (this.loanInfo.getInstitution() != null) {
                loanDeferInfo.setCreditorAsBank(this.loanInfo.getInstitution());
            }
            if (this.loanInfo.getGroupID() != null) {
                loanDeferInfo.setCreditorAsCompany(this.loanInfo.getGroupID());
            }
            loanDeferInfo.setAccount(this.loanInfo.getBankAcct());
            this.setDeferRecord(this.loanInfo);
            Date tmp = null;
            if (this.maxDeferSeq == 1) {
                tmp = DateTimeUtils.truncateDate((Date)loanDeferInfo.getLoan().getExpiredDate());
                loanDeferInfo.setBeforeDeferDate(tmp);
            } else {
                tmp = DateTimeUtils.truncateDate((Date)this.lastDeferDate);
                loanDeferInfo.setBeforeDeferDate(tmp);
            }
            loanDeferInfo.setAfterDeferDate(DateTimeUtils.addDay((Date)tmp, (long)1L));
            loanDeferInfo.setSeq(this.maxDeferSeq);
            loanDeferInfo.setLoan(this.loanInfo);
            loanDeferInfo.setBalance(this.loanInfo.getBalance());
            loanDeferInfo.setCurrency(this.loanInfo.getCurrency());
            loanDeferInfo.setYearDays(this.loanInfo.getYearDays());
            loanDeferInfo.setExchangeRate(this.loanInfo.getLocalCurExRate());
            loanDeferInfo.setDeferRate(this.loanInfo.getYieldRate());
            loanDeferInfo.setRateExpression(this.loanInfo.getIntRateTypeExpression());
            loanDeferInfo.setLocalAmount(this.loanInfo.getBalance().multiply(this.loanInfo.getLocalCurExRate()));
            loanDeferInfo.setPenaIntType(this.loanInfo.getPenAccrualType());
            loanDeferInfo.setPeneIntRate(this.loanInfo.getPenAccrualRate());
            loanDeferInfo.setCreator(this.CURRENT_USER);
            loanDeferInfo.setCompany(this.CURRENT_COMPANY);
        } else {
            loanDeferInfo.setBizDate(DateUtil.getDayBegin());
            loanDeferInfo.setSeq(1);
            loanDeferInfo.setCurrency(this.CURRENT_COMPANY.getBaseCurrency());
            loanDeferInfo.setLocalAmount(new BigDecimal(String.valueOf(0)));
            loanDeferInfo.setAfterDeferDate(DateUtil.getDayBegin());
            loanDeferInfo.setRateExpression(IntRateTypeExpressionEnum.YEAR);
            loanDeferInfo.setYearDays(360);
            loanDeferInfo.setDeferRate(new BigDecimal(String.valueOf(0)));
            loanDeferInfo.setPenaIntType(PenAccrualTypeEnum.ADD_PERCENT);
            loanDeferInfo.setPeneIntRate(new BigDecimal(String.valueOf(0)));
            loanDeferInfo.setCreator(this.CURRENT_USER);
            loanDeferInfo.setCompany(this.CURRENT_COMPANY);
        }
        return loanDeferInfo;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        LoanDeferInfo info = (LoanDeferInfo)dataObject;
        if (this.getBOTPViewStatus() == 1) {
            if (this.isCreateFromCHLoanExtendBill) {
                info.setLoan(this.loanInfo);
            } else {
                LoanDeferInfo loanDeferInfo = (LoanDeferInfo)this.getUIContext().get("InitDataObject");
                if (loanDeferInfo == null) {
                    return;
                }
                BOSUuid bisid = BOSUuid.read((String)loanDeferInfo.getSourceBillId());
                BOSObjectType idType = bisid.getType();
                if (idType.equals((Object)LoanExhibitionInfo.BOSTYPE)) {
                    try {
                        LoanExhibitionInfo exhInfo = LoanExhibitionFactory.getRemoteInstance().getLoanExhibitionInfo((IObjectPK)new ObjectUuidPK(loanDeferInfo.getSourceBillId()));
                        String sourceBillType = exhInfo.getSourceBillType().getValue();
                        String sourceBillNumber = exhInfo.getSourceBillNumber();
                        this.loanInfo = this.getLoanBill(sourceBillType, sourceBillNumber);
                    }
                    catch (EASBizException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (BOSException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                } else {
                    try {
                        this.loanInfo = this.getLoanBill(loanDeferInfo.getSourceBillId());
                    }
                    catch (EASBizException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (BOSException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                this.setDeferRecord(this.loanInfo);
                if (idType.equals((Object)ConsignLoanExtBillInfo.BOSTYPE) || idType.equals((Object)FundTransferExtBillInfo.BOSTYPE)) {
                    info.setDeferRate(new BigDecimal(String.valueOf(0)));
                } else {
                    info.setLocalAmount(this.loanInfo.getBalance().multiply(this.loanInfo.getLocalCurExRate()));
                    Date tmp = null;
                    if (this.maxDeferSeq == 1) {
                        tmp = DateTimeUtils.truncateDate((Date)this.loanInfo.getExpiredDate());
                        info.setBeforeDeferDate(tmp);
                    } else {
                        tmp = DateTimeUtils.truncateDate((Date)this.lastDeferDate);
                        info.setBeforeDeferDate(tmp);
                    }
                    if (info.getAfterDeferDate() == null) {
                        info.setAfterDeferDate(DateTimeUtils.addDay((Date)tmp, (long)1L));
                    }
                }
                info.setBizDate(DateHelper.getDayBegin());
                info.setLoan(this.loanInfo);
                if (this.loanInfo.getInstitution() != null) {
                    info.setCreditorAsBank(this.loanInfo.getInstitution());
                }
                if (this.loanInfo.getGroupID() != null) {
                    info.setCreditorAsCompany(this.loanInfo.getGroupID());
                }
                info.setAccount(this.loanInfo.getBankAcct());
                info.setSeq(this.maxDeferSeq);
                info.setLoan(this.loanInfo);
                info.setPenaIntType(this.loanInfo.getPenAccrualType());
                info.setPeneIntRate(this.loanInfo.getPenAccrualRate());
                info.setRateExpression(this.loanInfo.getIntRateTypeExpression());
                info.setDeferRate(this.loanInfo.getYieldRate());
                info.setYearDays(this.loanInfo.getYearDays());
            }
            info.setCreator(this.CURRENT_USER);
            info.setCompany(this.loanInfo.getCompany());
            FMClientHelper.initNumber((CoreBaseInfo)info, (KDTextField)this.txtNumber, (String)info.getCompany().getId().toString());
        }
    }

    private LoanInfo getLoanBill(String sourceBillType, String sourceBillNumber) throws EASBizException, BOSException {
        String id = this.getRelationLoanBillID(sourceBillType = this.transferBosType(sourceBillType).toString(), sourceBillNumber);
        if (StringUtil.isEmpty((String)id)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"499_LoanDeferEditUI"));
            SysUtil.abort();
            return null;
        }
        SelectorItemCollection selectors = this.getSelectors();
        return (LoanInfo)EJBAccessFactory.createRemoteInstance().getEntityInfo(id, selectors);
    }

    private BOSObjectType transferBosType(String sourceBillType) {
        if (sourceBillType == null) {
            return new LoanInfo().getBOSType();
        }
        if (sourceBillType.equals("0")) {
            return new ConsignmentLoanBillInfo().getBOSType();
        }
        if (sourceBillType.equals("1")) {
            return new FundTransferBillInfo().getBOSType();
        }
        if (sourceBillType.equals("2")) {
            return new ChLoanInfo().getBOSType();
        }
        return new LoanInfo().getBOSType();
    }

    private LoanInfo getLoanBill(String sourceBillId) throws EASBizException, BOSException {
        ConsignmentLoanBillCollection col;
        ConsignLoanExtBillInfo exhInfo;
        BOSUuid bisid = BOSUuid.read((String)sourceBillId);
        BOSObjectType idType = bisid.getType();
        String infoType = "";
        String number = "";
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        EntityViewInfo eviNew = new EntityViewInfo();
        FilterInfo filterNew = new FilterInfo();
        if (idType.equals((Object)new ConsignLoanExtBillInfo().getBOSType())) {
            exhInfo = ConsignLoanExtBillFactory.getRemoteInstance().getConsignLoanExtBillInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)exhInfo.getSourceBillId()));
            evi.setFilter(filter);
            col = ConsignmentLoanBillFactory.getRemoteInstance().getConsignmentLoanBillCollection(evi);
            ConsignmentLoanBillInfo info = col.get(0);
            if (FMHelper.isEmpty((CoreBaseInfo)info)) {
                filterNew.getFilterItems().add(new FilterItemInfo("Id", (Object)exhInfo.getLoan().getId()));
                eviNew.setFilter(filterNew);
                col = ConsignmentLoanBillFactory.getRemoteInstance().getConsignmentLoanBillCollection(eviNew);
                info = col.get(0);
            }
            infoType = info.getBOSType().toString();
            number = info.getNumber();
        } else if (idType.equals((Object)new FundTransferExtBillInfo().getBOSType())) {
            exhInfo = FundTransferExtBillFactory.getRemoteInstance().getFundTransferExtBillInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)exhInfo.getSourceBillId()));
            evi.setFilter(filter);
            col = FundTransferBillFactory.getRemoteInstance().getFundTransferBillCollection(evi);
            FundTransferBillInfo info = col.get(0);
            if (FMHelper.isEmpty((CoreBaseInfo)info)) {
                filterNew.getFilterItems().add(new FilterItemInfo("Id", (Object)exhInfo.getLoan().getId()));
                eviNew.setFilter(filterNew);
                col = FundTransferBillFactory.getRemoteInstance().getFundTransferBillCollection(eviNew);
                info = col.get(0);
            }
            infoType = info.getBOSType().toString();
            number = info.getNumber();
        } else if (idType.equals((Object)new LoanInfo().getBOSType())) {
            infoType = idType.toString();
            LoanInfo info = LoanFactory.getRemoteInstance().getLoanInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
            number = info.getNumber();
        }
        String id = this.getRelationLoanBillID(infoType, number);
        SelectorItemCollection selectors = this.getSelectors();
        if (FMHelper.isEmpty((String)id)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"499_LoanDeferEditUI"));
            SysUtil.abort();
        }
        return (LoanInfo)EJBAccessFactory.createRemoteInstance().getEntityInfo(id, selectors);
    }

    protected String getRelationLoanBillID(String type, String number) throws BOSException {
        String loanID = "";
        String sql = null;
        if (type.equals(new ChLoanInfo().getBOSType().toString())) {
            sql = "select loan.FID from T_IVT_ChLoan ch,T_FIN_Loan loan where loan.FEntLoanID=ch.FID and ch.FNumber='" + number + "'";
        } else if (type.equals(new ConsignmentLoanBillInfo().getBOSType().toString())) {
            sql = "select loan.FID from T_CL_ConsignmentLoanBill con,T_FIN_Loan loan where loan.FSourceBillID=con.FID  and con.FNumber='" + number + "'";
        } else if (type.equals(new FundTransferBillInfo().getBOSType().toString())) {
            sql = "select loan.FID from T_FT_FundTransferBill fund,T_FIN_Loan loan where loan.FTransBillID=fund.FID  and fund.FNumber='" + number + "'";
        } else if (type.equals(new LoanInfo().getBOSType().toString())) {
            sql = "select FID from T_FIN_Loan where FNumber='" + number + "'";
        }
        if (!StringUtil.isEmpty((String)sql)) {
            ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
            IRowSet set = exec.executeSQL();
            try {
                if (set != null && set.next()) {
                    loanID = set.getString(1);
                    set.close();
                }
            }
            catch (SQLException e) {
                Log.debug((Object)e.getMessage());
                return loanID;
            }
        }
        return loanID;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.txtNumber.isEnabled()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkBizDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtLoan);
        if (this.contCreditorAsBank.isVisible()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.creditorAsBank);
        } else {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.creditorAsCompany);
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkBeforeDeferDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkAfterDeferDate);
        Date dateBegin = DateTimeUtils.truncateDate((Date)this.pkBeforeDeferDate.getSqlDate());
        Date dateEnd = DateTimeUtils.truncateDate((Date)this.pkAfterDeferDate.getSqlDate());
        if (!dateEnd.after(dateBegin)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"deferDateError"));
            this.pkAfterDeferDate.requestFocus();
            this.abort();
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtSeq);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtBalance);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtCurrency);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtExchangeRate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtLocalAmount);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.comboRateExpression);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtYearDays);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtDeferRate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.comboPenaIntType);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtPeneIntRate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.creator);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.org);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("BankAcct.*"));
        sic.add(new SelectorItemInfo("Institution.*"));
        sic.add(new SelectorItemInfo("GroupID.*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        return sic;
    }

    private void setDeferRecord(LoanInfo loanInfo) {
        try {
            Map deferRecord = LoanDeferFactory.getRemoteInstance().getInitDate((IObjectPK)new ObjectUuidPK(loanInfo.getId().toString()));
            this.maxDeferSeq = (Integer)deferRecord.get("maxDeferSeq");
            this.lastDeferDate = (Date)deferRecord.get("lastDeferDate");
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    @Override
    protected void txtExchangeRate_dataChanged(DataChangeEvent e) throws Exception {
        if (this.txtBalance.getBigDecimalValue() == null) {
            return;
        }
        if (this.txtExchangeRate.getBigDecimalValue() == null) {
            return;
        }
        this.txtLocalAmount.setValue((Object)this.txtBalance.getBigDecimalValue().multiply(this.txtExchangeRate.getBigDecimalValue()));
    }

    @Override
    protected void comboPenaIntType_itemStateChanged(ItemEvent e) throws Exception {
        PenAccrualTypeEnum penTtpe = (PenAccrualTypeEnum)this.comboPenaIntType.getSelectedItem();
        if (penTtpe == PenAccrualTypeEnum.ADD_ACCRUAL) {
            this.contPeneIntRate.setBoundLabelText(EASResource.getString((String)RESOURCE, (String)"dailyrate"));
        } else if (penTtpe == PenAccrualTypeEnum.ADD_PERCENT) {
            this.contPeneIntRate.setBoundLabelText(EASResource.getString((String)RESOURCE, (String)"penerate"));
        }
    }

    @Override
    protected void comboRateExpression_itemStateChanged(ItemEvent e) throws Exception {
        IntRateTypeExpressionEnum intRateTypeExpressionEnum = (IntRateTypeExpressionEnum)this.comboRateExpression.getSelectedItem();
        if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.YEAR) {
            this.txtYearDays.setValue((Object)new Integer(360));
            this.contDeferRate.setBoundLabelText(EASResource.getString((String)RESOURCE, (String)"defer_rate"));
        } else if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.MONTH) {
            this.txtYearDays.setValue((Object)new Integer(30));
            this.contDeferRate.setBoundLabelText(EASResource.getString((String)RESOURCE, (String)"defer_per_rate"));
        } else {
            this.txtYearDays.setValue((Object)new Integer(1));
            this.contDeferRate.setBoundLabelText(EASResource.getString((String)RESOURCE, (String)"defer_per_rate"));
        }
    }

    public int getBtpCreateFromType() {
        return 0;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LoanDeferFactory.getRemoteInstance();
    }

    @Override
    protected void prmtCurrency_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtCurrency_dataChanged(e);
        CurrencyInfo currency = (CurrencyInfo)this.prmtCurrency.getData();
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("precision"));
        CurrencyInfo currency2 = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId()), evi.getSelector());
        if (currency2 != null) {
            this.txtBalance.setPrecision(currency2.getPrecision());
            this.txtLocalAmount.setPrecision(currency2.getPrecision());
        }
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        this.isCreateFromCHLoanExtendBill = false;
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put("showType", "Loan");
        ctx.put("fromLoanExhibition", "fromLoanExhibition");
        ctx.put("fromLoanDefer", "fromLoanDefer");
        this.getBillEdit().createFrom(null, ctx);
    }

    @Override
    public void actionCreateFromCHLoanExtendBill_actionPerformed(ActionEvent e) throws Exception {
        this.isCreateFromCHLoanExtendBill = true;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("loanAccount.applyUnit.id", (Object)this.CURRENT_COMPANY.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("effectedStatus", (Object)new Integer(2)));
        filterInfo.getFilterItems().add(new FilterItemInfo("chLoan.isDownLoaded", (Object)new Boolean(true)));
        filterInfo.getFilterItems().add(new FilterItemInfo("isDownLoaded", (Object)new Boolean(false)));
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("DefaultQueryFilter", filterInfo);
        ctx.put("showType", "CHLoanExtendBill");
        ctx.put("fromBankLoan", "1");
        this.getBillEdit().createFrom(null, ctx);
    }

    public List getSrcBosTypeForBotp(List srcBosTypeList) {
        if (this.isCreateFromCHLoanExtendBill) {
            if (srcBosTypeList.contains("64CC5ACC")) {
                srcBosTypeList.clear();
                srcBosTypeList.add("64CC5ACC");
            } else {
                srcBosTypeList.clear();
            }
        } else if (srcBosTypeList.contains("64CC5ACC")) {
            srcBosTypeList.remove("64CC5ACC");
        }
        return super.getSrcBosTypeForBotp(srcBosTypeList);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.pkBizDate.requestFocusInWindow();
    }

    protected void initDataStatus() {
        LoanDeferInfo deferInfo = (LoanDeferInfo)this.getDataObject();
        boolean isActionEnabled = this.getOprtState().equals(OprtState.VIEW) || "FINDVIEW".equals(this.getOprtState());
        this.actionCreateFrom.setEnabled(!isActionEnabled);
        this.actionCreateFrom.setVisible(!isActionEnabled);
    }

    private boolean isXieYi(IntRateTypeInfo intRateType) {
        return "lJlpCQEQEADgAAc+wKgSjiR9knQ=".equals(intRateType.getId().toString());
    }
}

