/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fin.LoanEntryCollection;
import com.kingdee.eas.fm.fin.LoanEntryFactory;
import com.kingdee.eas.fm.fin.LoanEntryInfo;
import com.kingdee.eas.fm.fin.LoanException;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.RepayIntTypeEnum;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.client.AbstractLoanRePaymentUI;
import com.kingdee.eas.fm.mnt.BlockingFlowTypeCollection;
import com.kingdee.eas.fm.mnt.BlockingFlowTypeFactory;
import com.kingdee.eas.fm.mnt.BlockingFlowTypeInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mobile.convert.util.EmptyUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class LoanRePaymentUI
extends AbstractLoanRePaymentUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(LoanRePaymentUI.class);
    private RepaymentInfo repaymentInfo;
    private LoanInfo loanInfo;
    private Map resultMap = new HashMap();
    private static final String COL_ID = "id";
    private static final String COL_DATE = "date";
    private static final String COL_AMOUNT = "amount";
    private static final String COL_REPAYINTTYPE = "repayIntType";
    private Map<String, LoanEntryInfo> entryMap = new HashMap<String, LoanEntryInfo>();

    public void onLoad() throws Exception {
        Map map = this.getUIContext();
        this.repaymentInfo = (RepaymentInfo)map.get("RepaymentInfo");
        super.onLoad();
        this.loanInfo = (LoanInfo)this.editData.clone();
        HashSet<BOSUuid> entryIds = new HashSet<BOSUuid>();
        for (int i = 0; i < this.editData.getEntrys().size(); ++i) {
            LoanEntryInfo entry = this.editData.getEntrys().get(i);
            entryIds.add(entry.getId());
            this.entryMap.put(entry.getId().toString(), entry);
        }
        this.setUITitle("\u8bf7\u6838\u5bf9\u8fd8\u6b3e\u8ba1\u5212");
        this.fillKdEntry(entryIds);
        String numberFtm = "%r-[ ]{###,###,##0.00}15.2n";
        this.kdtEntrys.getColumn(COL_AMOUNT).getStyleAttributes().setNumberFormat(numberFtm);
        this.kdtEntrys.getColumn(COL_AMOUNT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        KDComboBox comboRepayIntType = new KDComboBox();
        List stateList = RepayIntTypeEnum.getEnumList();
        Iterator it = stateList.iterator();
        while (it.hasNext()) {
            comboRepayIntType.addItem(it.next());
        }
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JComboBox)comboRepayIntType);
        this.kdtEntrys.getColumn(COL_REPAYINTTYPE).setEditor((ICellEditor)editor);
        this.btnAuditResult.setVisible(false);
        this.btnAuditResult.setEnabled(false);
        this.resultMap.put("success", false);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.txtNumber.setEditable(false);
        this.txtContractNum.setEditable(false);
        this.txtAmount.setEditable(false);
        this.txtAmount.setPrecision(2);
        this.txtAmount.setHorizontalAlignment(4);
        this.txtAmount.setRemoveingZeroInDispaly(false);
        this.txtBalance.setEditable(false);
        this.txtBalance.setPrecision(2);
        this.txtBalance.setHorizontalAlignment(4);
        this.txtBalance.setRemoveingZeroInDispaly(false);
        this.btnAttachment.setVisible(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LoanFactory.getRemoteInstance();
    }

    protected KDTable getDetailTable() {
        return this.kdtEntrys;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        LoanEntryInfo info = null;
        LoanEntryInfo entryInfo = new LoanEntryInfo();
        entryInfo.setDate(this.editData.getExpiredDate());
        entryInfo.setRepayIntType(RepayIntTypeEnum.REPAY_INT);
        entryInfo.setAmount(Constants.ZERO);
        info = entryInfo;
        return info;
    }

    private void fillKdEntry(Set entryIds) throws Exception {
        this.kdtEntrys.removeRows(false);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(COL_ID, (Object)entryIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isRepaid", (Object)false));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        SorterItemInfo sorter = new SorterItemInfo(COL_DATE);
        sorter.setSortType(SortType.ASCEND);
        evi.getSorter().add(sorter);
        LoanEntryCollection entryCol = LoanEntryFactory.getRemoteInstance().getLoanEntryCollection(evi);
        if (entryCol.size() > 0) {
            for (int i = 0; i < entryCol.size(); ++i) {
                LoanEntryInfo entryInfo = entryCol.get(i);
                IRow row = this.kdtEntrys.addRow();
                row.getCell(COL_ID).setValue((Object)entryInfo.getId());
                if (i == 0) {
                    row.getCell(COL_DATE).setValue((Object)this.repaymentInfo.getBizDate());
                    row.getCell(COL_AMOUNT).setValue((Object)this.repaymentInfo.getAmount());
                    RepayIntTypeEnum repayIntTypeEnum = this.repaymentInfo.isIsRepayInt() ? RepayIntTypeEnum.REPAY_INT : RepayIntTypeEnum.REPAY_NOINT;
                    row.getCell(COL_REPAYINTTYPE).setValue((Object)repayIntTypeEnum);
                    row.getStyleAttributes().setLocked(true);
                    continue;
                }
                row.getCell(COL_DATE).setValue((Object)entryInfo.getDate());
                row.getCell(COL_AMOUNT).setValue((Object)entryInfo.getAmount());
                row.getCell(COL_REPAYINTTYPE).setValue((Object)entryInfo.getRepayIntType());
                row.getStyleAttributes().setLocked(false);
            }
            this.setToalAmout(true, false);
        } else {
            IRow row = this.kdtEntrys.addRow();
            row.getCell(COL_DATE).setValue((Object)this.repaymentInfo.getBizDate());
            row.getCell(COL_AMOUNT).setValue((Object)this.repaymentInfo.getAmount());
            RepayIntTypeEnum repayIntTypeEnum = this.repaymentInfo.isIsRepayInt() ? RepayIntTypeEnum.REPAY_INT : RepayIntTypeEnum.REPAY_NOINT;
            row.getCell(COL_REPAYINTTYPE).setValue((Object)repayIntTypeEnum);
            row.getStyleAttributes().setLocked(true);
            this.setToalAmout(true, false);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        BigDecimal totalAmt = Constants.ZERO;
        if (this.kdtEntrys.getRowCount() > 0) {
            totalAmt = (BigDecimal)this.kdtEntrys.getRow(this.kdtEntrys.getRowCount() - 1).getCell(COL_AMOUNT).getValue();
        }
        if (totalAmt.compareTo(this.txtBalance.getBigDecimalValue()) != 0) {
            MsgBox.showWarning((Component)((Object)this), (String)"\u6240\u6709\u5206\u5f55\u7684\u9884\u8ba1\u8fd8\u672c\u91d1\u989d\u5408\u8ba1\u5fc5\u987b\u7b49\u4e8e\u501f\u6b3e\u4f59\u989d\uff01");
            this.abort();
        }
    }

    public boolean isModify() {
        return false;
    }

    protected void insertLine(KDTable table) {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetailData(table);
        IRow row = null;
        row = table.addRow();
        this.getUILifeCycleHandler().fireOnAddNewLine((Object)table, detailData);
        this.loadLineFields(table, row, detailData);
        this.afterInsertLine(table, detailData);
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntrys.getSelectManager().size() > 0) {
            KDTSelectManager selectManager = this.kdtEntrys.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (this.kdtEntrys.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            if (indexArr == null) {
                return;
            }
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                if (rowIndex == 0 || this.kdtEntrys.getRowCount() == 2) {
                    MsgBox.showInfo((Component)((Object)this), (String)"\u4e0d\u5141\u8bb8\u5220\u9664\u7b2c\u4e00\u884c\u7684\u8fd8\u6b3e\u8ba1\u5212\uff01");
                    return;
                }
                if (rowIndex != this.kdtEntrys.getRowCount() - 1) continue;
                return;
            }
        }
        super.actionRemoveLine_actionPerformed(e);
    }

    protected void afterAddLine(KDTable table, IObjectValue lineData) {
        this.setToalAmout(false, false);
    }

    protected void afterRemoveLine(KDTable table, IObjectValue lineData) {
        this.setToalAmout(false, true);
    }

    protected void afterInsertLine(KDTable table, IObjectValue lineData) {
        this.setToalAmout(false, false);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        LoanEntryInfo entry;
        int i;
        this.verifyInput(e);
        BlockingFlowTypeInfo defaultBlockingFlowTypeInfo = this.getDefaultBlockingFlowTypeInfo();
        LoanEntryCollection updateEntryCol = new LoanEntryCollection();
        LoanEntryCollection deleteEntryCol = new LoanEntryCollection();
        for (i = 0; i < this.kdtEntrys.getRowCount() - 1; ++i) {
            if (!EmptyUtil.isEmpty((Object)this.kdtEntrys.getRow(i).getCell(COL_ID).getValue()) && this.entryMap.containsKey(this.kdtEntrys.getRow(i).getCell(COL_ID).getValue().toString())) {
                entry = this.entryMap.get(this.kdtEntrys.getRow(i).getCell(COL_ID).getValue().toString());
                entry.setAmount((BigDecimal)this.kdtEntrys.getRow(i).getCell(COL_AMOUNT).getValue());
                entry.setDate((Date)this.kdtEntrys.getRow(i).getCell(COL_DATE).getValue());
                entry.setRepayIntType((RepayIntTypeEnum)((Object)this.kdtEntrys.getRow(i).getCell(COL_REPAYINTTYPE).getValue()));
                updateEntryCol.add(entry);
                continue;
            }
            entry = new LoanEntryInfo();
            entry.setRepayIntType((RepayIntTypeEnum)((Object)this.kdtEntrys.getRow(i).getCell(COL_REPAYINTTYPE).getValue()));
            entry.setBlockFlowType(defaultBlockingFlowTypeInfo);
            entry.setAmount((BigDecimal)this.kdtEntrys.getRow(i).getCell(COL_AMOUNT).getValue());
            entry.setDate((Date)this.kdtEntrys.getRow(i).getCell(COL_DATE).getValue());
            updateEntryCol.add(entry);
        }
        for (i = 0; i < this.loanInfo.getEntrys().size(); ++i) {
            entry = this.loanInfo.getEntrys().get(i);
            if (entry.isIsRepaid()) continue;
            deleteEntryCol.add(entry);
        }
        for (i = 0; i < deleteEntryCol.size(); ++i) {
            this.loanInfo.getEntrys().remove(deleteEntryCol.get(i));
        }
        for (i = 0; i < updateEntryCol.size(); ++i) {
            this.loanInfo.getEntrys().add(updateEntryCol.get(i));
        }
        this.resultMap.put("LoanInfo", this.loanInfo);
        this.resultMap.put("success", true);
        this.disposeUIWindow();
    }

    public Map getResultMap() {
        return this.resultMap;
    }

    @Override
    protected void kdtEntrys_editStopped(KDTEditEvent e) throws Exception {
        if (e.getOldValue() != null && e.getOldValue().equals(e.getValue())) {
            return;
        }
        if (e.getValue() == null) {
            return;
        }
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        IRow row = this.kdtEntrys.getRow(rowIndex);
        if (colIndex == this.kdtEntrys.getColumn(COL_AMOUNT).getColumnIndex()) {
            if (e.getValue() instanceof String) {
                row.getCell(COL_AMOUNT).setValue((Object)new BigDecimal(e.getValue().toString()));
            } else {
                row.getCell(COL_AMOUNT).setValue((Object)((BigDecimal)e.getValue()));
            }
            this.setToalAmout(false, false);
        }
    }

    private void setToalAmout(boolean isFirstOnload, boolean isDelete) {
        if (this.kdtEntrys.getRowCount() >= 1) {
            BigDecimal totalAmt = Constants.ZERO;
            int totalLine = 0;
            for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
                if (!(EmptyUtil.isEmpty((Object)this.kdtEntrys.getRow(i).getCell(COL_AMOUNT).getValue()) || this.kdtEntrys.getRow(i).getCell(COL_DATE).getValue().equals("\u5408\u8ba1") || this.kdtEntrys.getRow(i).getStyleAttributes().isHided())) {
                    totalAmt = totalAmt.add((BigDecimal)this.kdtEntrys.getRow(i).getCell(COL_AMOUNT).getValue());
                }
                if (!this.kdtEntrys.getRow(i).getCell(COL_DATE).getValue().equals("\u5408\u8ba1")) continue;
                totalLine = i;
            }
            if (isFirstOnload) {
                IRow row = this.kdtEntrys.addRow();
                row.getCell(COL_DATE).setValue((Object)"\u5408\u8ba1");
                row.getCell(COL_AMOUNT).setValue((Object)totalAmt);
                row.getStyleAttributes().setLocked(true);
                row.getStyleAttributes().setBackground(new Color(0xF6F6B6));
            } else if (isDelete && this.kdtEntrys.getRowCount() < 1) {
                this.kdtEntrys.removeRow(0);
            } else {
                this.kdtEntrys.removeRow(totalLine);
                IRow row = this.kdtEntrys.addRow();
                row.getCell(COL_DATE).setValue((Object)"\u5408\u8ba1");
                row.getCell(COL_AMOUNT).setValue((Object)totalAmt);
                row.getStyleAttributes().setLocked(true);
                row.getStyleAttributes().setBackground(new Color(0xF6F6B6));
            }
        }
    }

    private BlockingFlowTypeInfo getDefaultBlockingFlowTypeInfo() throws EASBizException, BOSException {
        EntityViewInfo vi = new EntityViewInfo();
        FilterInfo fInfo = new FilterInfo();
        fInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"001", CompareType.EQUALS));
        vi.setFilter(fInfo);
        BlockingFlowTypeCollection bftCollection = null;
        bftCollection = BlockingFlowTypeFactory.getRemoteInstance().getBlockingFlowTypeCollection(vi);
        if (bftCollection == null || bftCollection.size() == 0) {
            throw new LoanException(LoanException.BLOCKINGFLOWTYPENUMBER001NOTEXISTS);
        }
        BlockingFlowTypeInfo bftInfo = bftCollection.get(0);
        return bftInfo;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo(COL_ID));
        sic.add(new SelectorItemInfo("ExpiredDate"));
        sic.add(new SelectorItemInfo("entrys.seq"));
        return sic;
    }
}

