/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.AddBatchHelper;
import com.kingdee.eas.fi.cas.ControlTake;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.FinancingBillTypeEnum;
import com.kingdee.eas.fm.fin.ILoan;
import com.kingdee.eas.fm.fin.LimitPropertyEnum;
import com.kingdee.eas.fm.fin.LoanCollection;
import com.kingdee.eas.fm.fin.LoanContractCollection;
import com.kingdee.eas.fm.fin.LoanContractFactory;
import com.kingdee.eas.fm.fin.LoanContractInfo;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.LoanInterestInfo;
import com.kingdee.eas.fm.fin.RepaymentCollection;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.client.AbstractRepaymentBathEditUI;
import com.kingdee.eas.fm.fin.client.LoanInterestBathEditUI;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class RepaymentBathEditUI
extends AbstractRepaymentBathEditUI {
    private static final Logger logger = CoreUIObject.getLogger(RepaymentBathEditUI.class);
    private static final String ID_SET = "idSet";
    private static final String SOURCEBILLNUM = "sourceBillNum";
    private static final String STARTDATE = "startDate";
    private static final String ENDDATE = "endDate";
    private static final String INTRATEEXP = "intRateExp";
    private static final String RATELOAN = "rateLoan";
    private static final String CREDITORNAME = "Creditor.name";
    private static final String SOURCECURRENCY = "sourceCurrency";
    private static final String LOANAMOUNT = "loanAmount";
    private static final String LOANBALANCE = "loanBalance";
    private static final String NUMBER = "number";
    private static final String REPAYSEQ = "repaySeq";
    private static final String BIZDATE = "bizDate";
    private static final String CURRENCY = "Currency";
    private static final String SOURCEAMOUNT = "sourceAmount";
    private static final String SOURCECUREXRATE = "sourceCurExRate";
    private static final String AMOUNT = "Amount";
    private static final String ISCALINT = "isCalInt";
    private static final String ISREPAYINT = "isRepayInt";
    private static final String ISCALPUNISHINT = "isCalPunishInt";
    private static final String REMARK = "Remark";
    private static final String CREDITLIMITNUMBER = "creditLimitNumber";
    private static final String CREDITLIMITCURRENCY = "creditLimitCurrency";
    private static final String CREDITLIMITLOCALAMT = "creditLimitLocalAmt";
    private static final String BALANCE = "balance";
    private static final String LOANID = "loanId";
    private static CompanyOrgUnitInfo loanContractCompany;
    private static String contractNum;
    private Map loanMap = new HashMap();
    private boolean doAntiAssure = false;
    private boolean isDoAntiAssure = false;
    private boolean doAntiWage = false;
    private boolean isDoAntiWage = false;
    private boolean doAntiImpawn = false;
    private boolean isDoAntiImpawn = false;
    private List assureIdList = new ArrayList();
    private List wageIdList = new ArrayList();
    private Map lastRepayDateMap = new HashMap();
    private static String contractId;
    private static List loanIdList;

    public void onLoad() throws Exception {
        super.onLoad();
        Set idSet = (Set)this.getUIContext().get(ID_SET);
        this.initUIProp();
        this.fillData(idSet);
        this.prmtCompany.setData((Object)loanContractCompany);
        this.prmtCompany.setEnabled(false);
        this.txtContractNum.setText(contractNum);
        this.txtContractNum.setEnabled(false);
        this.actionSubmit.setEnabled(true);
        this.actionDelLine.setEnabled(true);
        this.actionSubmit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionDelLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    public static IUIWindow showDialogWindows(IUIObject ui, Set idSet, String LoanContractId) throws UIException {
        if (idSet == null || idSet.isEmpty()) {
            return null;
        }
        EntityViewInfo ev = new EntityViewInfo();
        ev.getSelector().add("contractNum");
        ev.getSelector().add("company.*");
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)LoanContractId));
        try {
            LoanContractCollection coll = LoanContractFactory.getRemoteInstance().getLoanContractCollection(ev);
            LoanContractInfo info = coll.get(0);
            loanContractCompany = info.getCompany();
            contractNum = info.getContractNum();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        loanIdList = new ArrayList();
        contractId = LoanContractId;
        loanIdList = FMHelper.set2List((Set)idSet);
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)ID_SET, (Object)idSet);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(RepaymentBathEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        return uiWindow;
    }

    public boolean destroyWindow() {
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        iMutex.releaseObjIDForUpdate(contractId);
        iMutex.batchReleaseObjIDForUpdate(loanIdList);
        return super.destroyWindow();
    }

    protected void initUIProp() throws EASBizException, BOSException {
        this.tblMain.checkParsed();
        KDTextField sourceBillNumEditor = new KDTextField();
        sourceBillNumEditor.setEnabled(false);
        KDTDefaultCellEditor sourceBillNumCellEditor = new KDTDefaultCellEditor((JTextField)sourceBillNumEditor);
        this.tblMain.getColumn(SOURCEBILLNUM).setEditor((ICellEditor)sourceBillNumCellEditor);
        this.tblMain.getColumn(SOURCEBILLNUM).getStyleAttributes().setLocked(true);
        KDTextField creditornameEditor = new KDTextField();
        creditornameEditor.setEnabled(false);
        KDTDefaultCellEditor creditornameCellEditor = new KDTDefaultCellEditor((JTextField)creditornameEditor);
        this.tblMain.getColumn(CREDITORNAME).setEditor((ICellEditor)creditornameCellEditor);
        this.tblMain.getColumn(CREDITORNAME).getStyleAttributes().setLocked(true);
        KDTextField creditLimitNumberEditor = new KDTextField();
        creditLimitNumberEditor.setEnabled(false);
        KDTDefaultCellEditor creditLimitNumberCellEditor = new KDTDefaultCellEditor((JTextField)creditLimitNumberEditor);
        this.tblMain.getColumn(CREDITLIMITNUMBER).setEditor((ICellEditor)creditLimitNumberCellEditor);
        this.tblMain.getColumn(CREDITLIMITNUMBER).getStyleAttributes().setLocked(true);
        KDFormattedTextField repaySeqEditor = new KDFormattedTextField();
        repaySeqEditor.setEnabled(false);
        repaySeqEditor.setHorizontalAlignment(4);
        KDTDefaultCellEditor repaySeqCellEditor = new KDTDefaultCellEditor((JTextField)repaySeqEditor);
        this.tblMain.getColumn(REPAYSEQ).setEditor((ICellEditor)repaySeqCellEditor);
        this.tblMain.getColumn(REPAYSEQ).getStyleAttributes().setLocked(true);
        KDFormattedTextField loanAmountEditor = new KDFormattedTextField();
        loanAmountEditor.setEnabled(false);
        loanAmountEditor.setPrecision(2);
        loanAmountEditor.setHorizontalAlignment(4);
        KDTDefaultCellEditor loanAmountCellEditor = new KDTDefaultCellEditor((JTextField)loanAmountEditor);
        this.tblMain.getColumn(LOANAMOUNT).setEditor((ICellEditor)loanAmountCellEditor);
        this.tblMain.getColumn(LOANAMOUNT).getStyleAttributes().setLocked(true);
        KDFormattedTextField loanBalanceEditor = new KDFormattedTextField();
        loanBalanceEditor.setEnabled(false);
        loanBalanceEditor.setPrecision(2);
        loanBalanceEditor.setHorizontalAlignment(4);
        KDTDefaultCellEditor loanBalanceCellEditor = new KDTDefaultCellEditor((JTextField)loanBalanceEditor);
        this.tblMain.getColumn(LOANBALANCE).setEditor((ICellEditor)loanBalanceCellEditor);
        this.tblMain.getColumn(LOANBALANCE).getStyleAttributes().setLocked(true);
        String amountFtm = "%r-[ ]{###,###,##0.00}15.2n";
        KDFormattedTextField sourceAmountEditor = new KDFormattedTextField();
        sourceAmountEditor.setEnabled(false);
        sourceAmountEditor.setDataType(1);
        sourceAmountEditor.setPrecision(2);
        sourceAmountEditor.setHorizontalAlignment(4);
        KDTDefaultCellEditor sourceAmountCellEditor = new KDTDefaultCellEditor((JTextField)sourceAmountEditor);
        this.tblMain.getColumn(SOURCEAMOUNT).setEditor((ICellEditor)sourceAmountCellEditor);
        this.tblMain.getColumn(SOURCEAMOUNT).getStyleAttributes().setNumberFormat(amountFtm);
        this.tblMain.getColumn(SOURCEAMOUNT).getStyleAttributes().setLocked(true);
        KDFormattedTextField sourceCurExRateEditor = new KDFormattedTextField();
        sourceCurExRateEditor.setEnabled(true);
        sourceCurExRateEditor.setHorizontalAlignment(4);
        sourceCurExRateEditor.setDataType(1);
        sourceCurExRateEditor.setPrecision(3);
        sourceCurExRateEditor.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    RepaymentBathEditUI.this.sourceCurExRate_dataChanged(e);
                }
                catch (Exception exc) {
                    RepaymentBathEditUI.this.handUIException(exc);
                }
            }
        });
        KDTDefaultCellEditor sourceCurExRateCellEditor = new KDTDefaultCellEditor((JTextField)sourceCurExRateEditor);
        this.tblMain.getColumn(SOURCECUREXRATE).setEditor((ICellEditor)sourceCurExRateCellEditor);
        String sourceCurFtm = "%r-[ ]{###,###,##0.000}15.2n";
        this.tblMain.getColumn(SOURCECUREXRATE).getStyleAttributes().setNumberFormat(sourceCurFtm);
        KDDatePicker editor1 = new KDDatePicker();
        editor1.setEnabled(false);
        KDTDefaultCellEditor cellEditor1 = new KDTDefaultCellEditor(editor1);
        this.tblMain.getColumn(STARTDATE).setEditor((ICellEditor)cellEditor1);
        this.tblMain.getColumn(STARTDATE).getStyleAttributes().setNumberFormat("yyyy-MM-dd");
        KDDatePicker editor2 = new KDDatePicker();
        editor2.setEnabled(false);
        KDTDefaultCellEditor cellEditor2 = new KDTDefaultCellEditor(editor2);
        this.tblMain.getColumn(ENDDATE).setEditor((ICellEditor)cellEditor2);
        this.tblMain.getColumn(ENDDATE).getStyleAttributes().setNumberFormat("yyyy-MM-dd");
        KDDatePicker editor3 = new KDDatePicker();
        editor3.setEnabled(true);
        editor3.setRequired(true);
        KDTDefaultCellEditor cellEditor3 = new KDTDefaultCellEditor(editor3);
        this.tblMain.getColumn(BIZDATE).setEditor((ICellEditor)cellEditor3);
        this.tblMain.getColumn(BIZDATE).getStyleAttributes().setNumberFormat("yyyy-MM-dd");
        KDComboBox editor8 = new KDComboBox();
        editor8.removeAllItems();
        editor8.setEnabled(false);
        Object[] intRateEnum = IntRateTypeExpressionEnum.getEnumList().toArray();
        if (intRateEnum != null && intRateEnum.length >= 0) {
            editor8.addItems(intRateEnum);
        }
        KDTDefaultCellEditor cellEditor8 = new KDTDefaultCellEditor((JComboBox)editor8);
        this.tblMain.getColumn(INTRATEEXP).setEditor((ICellEditor)cellEditor8);
        KDFormattedTextField txtRate = new KDFormattedTextField();
        txtRate.setDataType(1);
        txtRate.setPrecision(4);
        txtRate.setHorizontalAlignment(4);
        txtRate.setEditable(false);
        this.tblMain.getColumn(RATELOAN).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtRate));
        String numberFtm = "%r-[ ]{###,###,##0.0000%}15.2n";
        this.tblMain.getColumn(RATELOAN).getStyleAttributes().setNumberFormat(numberFtm);
        this.tblMain.getColumn(RATELOAN).getStyleAttributes().setLocked(true);
        KDBizPromptBox editor4 = new KDBizPromptBox();
        editor4.setEditable(false);
        editor4.setDisplayFormat("$name$");
        editor4.setEditFormat("$name$");
        editor4.setCommitFormat("$name$");
        editor4.setMaxLength(80);
        editor4.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$name$", editor4));
        editor4.getQueryAgent().resetRuntimeEntityView();
        editor4.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
        editor4.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    RepaymentBathEditUI.this.currency_dataChanged(e);
                }
                catch (Exception exc) {
                    RepaymentBathEditUI.this.handUIException(exc);
                }
            }
        });
        KDTDefaultCellEditor cellEditor4 = new KDTDefaultCellEditor((IKDEditor)editor4);
        this.tblMain.getColumn(CURRENCY).setEditor((ICellEditor)cellEditor4);
        KDBizPromptBox sourceCurrencyEditor = new KDBizPromptBox();
        sourceCurrencyEditor.setEditable(false);
        sourceCurrencyEditor.setEnabled(false);
        sourceCurrencyEditor.setDisplayFormat("$name$");
        sourceCurrencyEditor.setEditFormat("$name$");
        sourceCurrencyEditor.setCommitFormat("$name$");
        sourceCurrencyEditor.setMaxLength(80);
        sourceCurrencyEditor.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$name$", editor4));
        sourceCurrencyEditor.getQueryAgent().resetRuntimeEntityView();
        sourceCurrencyEditor.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
        KDTDefaultCellEditor sourceCurrencyEditorCellEditor = new KDTDefaultCellEditor((IKDEditor)sourceCurrencyEditor);
        this.tblMain.getColumn(SOURCECURRENCY).setEditor((ICellEditor)sourceCurrencyEditorCellEditor);
        KDCheckBox chkIsCalInt = new KDCheckBox();
        chkIsCalInt.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    RepaymentBathEditUI.this.chkIsCalInt_itemStateChanged(e);
                }
                catch (Exception exc) {
                    RepaymentBathEditUI.this.handUIException(exc);
                }
            }
        });
        KDTDefaultCellEditor isCalIntEditor = new KDTDefaultCellEditor((JCheckBox)chkIsCalInt);
        this.tblMain.getColumn(ISCALINT).setEditor((ICellEditor)isCalIntEditor);
        KDCheckBox chkIsRepayIntedit = new KDCheckBox();
        KDTDefaultCellEditor isRepayIntEditor = new KDTDefaultCellEditor((JCheckBox)chkIsRepayIntedit);
        this.tblMain.getColumn(ISREPAYINT).setEditor((ICellEditor)isRepayIntEditor);
        KDBizPromptBox editor6 = new KDBizPromptBox();
        editor6.setEnabled(false);
        editor6.setDisplayFormat("$name$");
        editor6.setEditFormat("$name$");
        editor6.setCommitFormat("$name$");
        editor6.setMaxLength(80);
        editor6.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$name$", editor6));
        editor6.getQueryAgent().resetRuntimeEntityView();
        editor6.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
        KDTDefaultCellEditor cellEditor6 = new KDTDefaultCellEditor((IKDEditor)editor6);
        this.tblMain.getColumn(CREDITLIMITCURRENCY).setEditor((ICellEditor)cellEditor6);
        this.tblMain.getColumn(CREDITLIMITCURRENCY).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(AMOUNT).getStyleAttributes().setNumberFormat(amountFtm);
        KDFormattedTextField creditLimitLocalAmt = new KDFormattedTextField();
        creditLimitLocalAmt.setDataType(1);
        creditLimitLocalAmt.setPrecision(4);
        creditLimitLocalAmt.setHorizontalAlignment(4);
        KDTDefaultCellEditor creditLimitLocalCellEditor = new KDTDefaultCellEditor((JTextField)creditLimitLocalAmt);
        this.tblMain.getColumn(CREDITLIMITLOCALAMT).setEditor((ICellEditor)creditLimitLocalCellEditor);
        this.tblMain.getColumn(CREDITLIMITLOCALAMT).getStyleAttributes().setNumberFormat(amountFtm);
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                RepaymentBathEditUI.this.tableValueChanged4KDPrediction(e);
            }
        });
    }

    protected void tableValueChanged4KDPrediction(KDTEditEvent e) {
        if (this.tblMain.getRowCount() > 1) {
            BigDecimal sourceAmountTotal = Constants.ZERO;
            BigDecimal amountTotal = Constants.ZERO;
            BigDecimal creditLimitLocalAmtTotal = BigDecimal.ZERO;
            int size = this.tblMain.getRowCount() - 1;
            for (int i = 0; i < size; ++i) {
                if (this.tblMain.getRow(i).getCell(SOURCEAMOUNT).getValue() != null) {
                    BigDecimal sourceAmount = (BigDecimal)this.tblMain.getRow(i).getCell(SOURCEAMOUNT).getValue();
                    sourceAmountTotal = sourceAmountTotal.add(sourceAmount);
                }
                if (this.tblMain.getRow(i).getCell(AMOUNT).getValue() != null) {
                    BigDecimal amount = (BigDecimal)this.tblMain.getRow(i).getCell(AMOUNT).getValue();
                    amountTotal = amountTotal.add(amount);
                }
                if (this.tblMain.getRow(i).getCell(CREDITLIMITLOCALAMT).getValue() == null) continue;
                BigDecimal creditLimitLocalAmt = (BigDecimal)this.tblMain.getRow(i).getCell(CREDITLIMITLOCALAMT).getValue();
                creditLimitLocalAmtTotal = creditLimitLocalAmtTotal.add(creditLimitLocalAmt);
            }
            this.tblMain.getRow(this.tblMain.getRowCount() - 1).getCell(SOURCEAMOUNT).setValue((Object)sourceAmountTotal);
            this.tblMain.getRow(this.tblMain.getRowCount() - 1).getCell(AMOUNT).setValue((Object)amountTotal);
            this.tblMain.getRow(this.tblMain.getRowCount() - 1).getCell(CREDITLIMITLOCALAMT).setValue((Object)creditLimitLocalAmtTotal);
        } else if (this.tblMain.getRowCount() == 1 && this.tblMain.getCell(0, SOURCEBILLNUM).getValue().toString().equals(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"313_LoanEditUI"))) {
            this.tblMain.getCell(0, SOURCEAMOUNT).setValue((Object)Constants.ZERO);
            this.tblMain.getCell(0, AMOUNT).setValue((Object)Constants.ZERO);
            this.tblMain.getCell(0, CREDITLIMITLOCALAMT).setValue((Object)Constants.ZERO);
        }
    }

    protected void sourceCurExRate_dataChanged(DataChangeEvent e) {
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        CurrencyInfo currency = FMClientHelper.getCurrencyInfo((BOSUuid)((CurrencyInfo)row.getCell(CURRENCY).getValue()).getId());
        BigDecimal convertRate = (BigDecimal)e.getNewValue();
        BigDecimal amount = (BigDecimal)row.getCell(AMOUNT).getValue();
        this.calcsourceAmount(currency, convertRate, row, amount);
    }

    protected void amount_dataChanged(DataChangeEvent e) {
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        CurrencyInfo currency = FMClientHelper.getCurrencyInfo((BOSUuid)((CurrencyInfo)row.getCell(CURRENCY).getValue()).getId());
        BigDecimal convertRate = (BigDecimal)row.getCell(SOURCECUREXRATE).getValue();
        BigDecimal amount = (BigDecimal)e.getNewValue();
        this.calcsourceAmount(currency, convertRate, row, amount);
        row.getCell(LOANBALANCE).setValue((Object)((BigDecimal)row.getCell(BALANCE).getValue()).subtract(amount));
        row.getCell(CREDITLIMITLOCALAMT).setValue((Object)amount);
    }

    private void chkIsCalInt_itemStateChanged(ItemEvent e) {
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        row.getCell(ISREPAYINT).setValue((Object)false);
    }

    private void currency_dataChanged(DataChangeEvent e) {
        if (!e.getNewValue().equals(e.getOldValue())) {
            try {
                int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
                IRow row = this.tblMain.getRow(rowIndex);
                if (row.getCell(CURRENCY).getValue() != null) {
                    CurrencyInfo currency = FMClientHelper.getCurrencyInfo((BOSUuid)((CurrencyInfo)e.getNewValue()).getId());
                    CurrencyInfo sourceCurrency = (CurrencyInfo)row.getCell(SOURCECURRENCY).getValue();
                    ExchangeRateInfo exchangeRate = FMClientHelper.findExchangeRate((String)currency.getId().toString(), (String)sourceCurrency.getId().toString());
                    BigDecimal convertRate = BigDecimal.ONE;
                    if (exchangeRate != null) {
                        convertRate = exchangeRate.getConvertRate();
                    }
                    row.getCell(SOURCECUREXRATE).setValue((Object)convertRate);
                    BigDecimal amount = (BigDecimal)row.getCell(AMOUNT).getValue();
                    this.calcsourceAmount(currency, convertRate, row, amount);
                    if (!currency.getId().toString().equals(sourceCurrency.getId().toString())) {
                        row.getCell(SOURCECUREXRATE).getStyleAttributes().setLocked(false);
                    } else {
                        row.getCell(SOURCECUREXRATE).getStyleAttributes().setLocked(true);
                    }
                }
            }
            catch (EASBizException e1) {
                e1.printStackTrace();
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
        }
    }

    protected void calcsourceAmount(CurrencyInfo currency, BigDecimal convertRate, IRow row, BigDecimal amount) {
        CurrencyInfo currencyInfo = FMClientHelper.getCurrencyInfo((BOSUuid)currency.getId());
        int precision = currencyInfo.getPrecision();
        CurrencyInfo sourceCurrency = (CurrencyInfo)row.getCell(SOURCECURRENCY).getValue();
        ICellEditor sourceAmountCellEditor = ControlTake.getKDFormattedTextFieldEditor((int)1);
        AddBatchHelper.bindContents((IRow)row, (String)SOURCEAMOUNT, (ICellEditor)sourceAmountCellEditor);
        KDFormattedTextField sourceAmount = AddBatchHelper.getKDFormattedTextField((IRow)row, (String)SOURCEAMOUNT);
        sourceAmount.setHorizontalAlignment(4);
        sourceAmount.setPrecision(2);
        if (!currency.getId().toString().equals(sourceCurrency.getId().toString())) {
            sourceAmount.setEnabled(true);
            row.getCell(SOURCEAMOUNT).getStyleAttributes().setLocked(false);
        } else {
            sourceAmount.setEnabled(false);
            row.getCell(SOURCEAMOUNT).getStyleAttributes().setLocked(true);
        }
        sourceAmount.setMaximumValue((Comparable)((BigDecimal)row.getCell(BALANCE).getValue()).divide(convertRate, precision));
        sourceAmount.setMinimumValue((Comparable)BigDecimal.ZERO);
        row.getCell(SOURCEAMOUNT).setValue((Object)amount.divide(convertRate, precision));
    }

    protected void fillData(Set idSet) throws BOSException, EASBizException {
        LoanCollection coll = this.getColl(idSet);
        IRow row = null;
        LoanInfo info = null;
        BigDecimal sourceAmountTotal = BigDecimal.ZERO;
        BigDecimal amountTotal = BigDecimal.ZERO;
        BigDecimal creditLimitLocalAmtTotal = BigDecimal.ZERO;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            this.loanMap.put(info.getId().toString(), info);
            row = this.tblMain.addRow();
            row.getCell(LOANID).setValue((Object)info.getId().toString());
            row.getCell(SOURCEBILLNUM).setValue((Object)info.getNumber());
            row.getCell(STARTDATE).setValue((Object)info.getIssueDate());
            row.getCell(ENDDATE).setValue((Object)info.getExpiredDate());
            row.getCell(INTRATEEXP).setValue((Object)info.getIntRateTypeExpression());
            row.getCell(RATELOAN).setValue((Object)info.getYieldRate());
            String loanCurrencyID = info.getCurrency().getId().toString();
            if (info.getInstitution() != null) {
                row.getCell(CREDITORNAME).setValue((Object)info.getInstitution().getName());
            } else {
                row.getCell(CREDITORNAME).setValue((Object)info.getGroupID().getName());
            }
            row.getCell(SOURCECURRENCY).setValue((Object)info.getCurrency());
            row.getCell(LOANAMOUNT).setValue((Object)info.getAmount());
            row.getCell(LOANBALANCE).setValue((Object)SysConstant.BIGZERO);
            FMClientHelper.setNumberFormat((IRow)row, (String)LOANAMOUNT, (String)loanCurrencyID);
            FMClientHelper.setNumberFormat((IRow)row, (String)LOANBALANCE, (String)loanCurrencyID);
            KDTextField txtNumber = new KDTextField();
            txtNumber.setMaxLength(80);
            RepaymentInfo newRecord = new RepaymentInfo();
            newRecord.setCompany(info.getCompany());
            FMClientHelper.initNumber((CoreBaseInfo)newRecord, (KDTextField)txtNumber, (String)info.getCompany().getId().toString());
            row.getCell(NUMBER).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtNumber));
            row.getCell(NUMBER).setValue((Object)txtNumber.getText());
            String loanId = info.getId().toString();
            Map repayRecord = this.getSeq(loanId);
            row.getCell(REPAYSEQ).setValue((Object)((Integer)repayRecord.get("maxseq")));
            Date lastrepaydate = (Date)repayRecord.get("lastrepaydate");
            if (lastrepaydate != null) {
                row.getCell(BIZDATE).setValue((Object)lastrepaydate);
            } else {
                row.getCell(BIZDATE).setValue((Object)new Date());
            }
            row.getCell(CURRENCY).setValue((Object)info.getCurrency());
            row.getCell(BALANCE).setValue((Object)info.getBalance());
            row.getCell(AMOUNT).setValue((Object)info.getBalance());
            ICellEditor amountCellEditor = ControlTake.getKDFormattedTextFieldEditor((int)1);
            AddBatchHelper.bindContents((IRow)row, (String)AMOUNT, (ICellEditor)amountCellEditor);
            KDFormattedTextField amount = AddBatchHelper.getKDFormattedTextField((IRow)row, (String)AMOUNT);
            amount.setHorizontalAlignment(4);
            amount.setPrecision(2);
            amount.setMaximumValue((Comparable)info.getBalance());
            amount.setMinimumValue((Comparable)BigDecimal.ZERO);
            amount.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        RepaymentBathEditUI.this.amount_dataChanged(e);
                    }
                    catch (Exception exc) {
                        RepaymentBathEditUI.this.handUIException(exc);
                    }
                }
            });
            FMClientHelper.setNumberFormat((IRow)row, (String)AMOUNT, (String)loanContractCompany.getBaseCurrency().getId().toString());
            amountTotal = amountTotal.add((BigDecimal)row.getCell(AMOUNT).getValue());
            row.getCell(SOURCEAMOUNT).setValue((Object)info.getBalance());
            FMClientHelper.setNumberFormat((IRow)row, (String)SOURCEAMOUNT, (String)info.getCurrency().getId().toString());
            row.getCell(SOURCECUREXRATE).setValue((Object)BigDecimal.ONE);
            row.getCell(SOURCECUREXRATE).getStyleAttributes().setLocked(true);
            sourceAmountTotal = sourceAmountTotal.add((BigDecimal)row.getCell(SOURCEAMOUNT).getValue());
            row.getCell(ISCALINT).setValue((Object)true);
            row.getCell(ISREPAYINT).setValue((Object)true);
            row.getCell(ISCALPUNISHINT).setValue((Object)false);
            row.getCell(REMARK).setValue((Object)(info.getNumber() + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"375_RepaymentBathEditUI")));
            if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getCreditLimit())) {
                row.getCell(CREDITLIMITNUMBER).setValue((Object)info.getCreditLimit().getNumber());
                row.getCell(CREDITLIMITCURRENCY).setValue((Object)info.getCreditCurrency());
                String creditCurrencyID = info.getCreditCurrency().getId().toString();
                KDFormattedTextField creditLimitLocalAmt = (KDFormattedTextField)((KDTDefaultCellEditor)this.tblMain.getColumn(CREDITLIMITLOCALAMT).getEditor()).getComponent();
                if (info.getCreditLimit() != null && info.getCreditLimit().getProperty().equals((Object)LimitPropertyEnum.FIXED_AMOUNT)) {
                    creditLimitLocalAmt.setEnabled(false);
                    row.getCell(CREDITLIMITLOCALAMT).setValue((Object)SysConstant.BIGZERO);
                } else {
                    row.getCell(CREDITLIMITLOCALAMT).setValue((Object)info.getBalance());
                }
                FMClientHelper.setNumberFormat((IRow)row, (String)CREDITLIMITLOCALAMT, (String)creditCurrencyID);
                creditLimitLocalAmtTotal = creditLimitLocalAmtTotal.add((BigDecimal)row.getCell(CREDITLIMITLOCALAMT).getValue());
                continue;
            }
            row.getCell(CREDITLIMITLOCALAMT).getStyleAttributes().setLocked(true);
        }
        this.setTotal(sourceAmountTotal, amountTotal, creditLimitLocalAmtTotal);
    }

    private void setTotal(BigDecimal sourceAmountTotal, BigDecimal amountTotal, BigDecimal creditLimitLocalAmtTotal) {
        IRow rowTotal = this.tblMain.addRow();
        rowTotal.getStyleAttributes().setLocked(true);
        rowTotal.getCell(SOURCEBILLNUM).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"313_LoanEditUI"));
        rowTotal.getCell(SOURCEAMOUNT).setValue((Object)sourceAmountTotal);
        rowTotal.getCell(AMOUNT).setValue((Object)amountTotal);
        rowTotal.getCell(CREDITLIMITLOCALAMT).setValue((Object)creditLimitLocalAmtTotal);
        rowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
    }

    protected Map getSeq(String loanId) throws BOSException {
        Map repayRecord = null;
        try {
            repayRecord = RepaymentFactory.getRemoteInstance().getInitEditData((IObjectPK)new ObjectUuidPK(loanId));
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.lastRepayDateMap.put(loanId, (Date)repayRecord.get("lastrepaydate"));
        return repayRecord;
    }

    protected LoanCollection getColl(Set idSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("groupID.name"));
        evi.getSelector().add(new SelectorItemInfo("creditLimit.*"));
        evi.getSelector().add(new SelectorItemInfo("Currency.*"));
        evi.getSelector().add(new SelectorItemInfo("BankAcct.id"));
        evi.getSelector().add(new SelectorItemInfo("BankAcct.name"));
        evi.getSelector().add(new SelectorItemInfo("BankAcct.number"));
        evi.getSelector().add(new SelectorItemInfo("intAcctView.id"));
        evi.getSelector().add(new SelectorItemInfo("intAcctView.name"));
        evi.getSelector().add(new SelectorItemInfo("intAcctView.number"));
        evi.getSelector().add(new SelectorItemInfo("cautionAcctBank.id"));
        evi.getSelector().add(new SelectorItemInfo("cautionAcctBank.number"));
        evi.getSelector().add(new SelectorItemInfo("cautionAcctBank.name"));
        evi.getSelector().add(new SelectorItemInfo("Creditor.id"));
        evi.getSelector().add(new SelectorItemInfo("Creditor.number"));
        evi.getSelector().add(new SelectorItemInfo(CREDITORNAME));
        evi.getSelector().add(new SelectorItemInfo("CreditCurrency.*"));
        evi.getSelector().add(new SelectorItemInfo("Institution.id"));
        evi.getSelector().add(new SelectorItemInfo("Institution.number"));
        evi.getSelector().add(new SelectorItemInfo("Institution.name"));
        ILoan iLoan = LoanFactory.getRemoteInstance();
        return iLoan.getLoanCollection(evi);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        CoreBaseCollection reColl = new CoreBaseCollection();
        RepaymentCollection genLoanInterestColl = new RepaymentCollection();
        if (this.tblMain.getRowCount() > 0) {
            RepaymentInfo newRecord = new RepaymentInfo();
            newRecord.setCompany(loanContractCompany);
            boolean rst = FMClientHelper.hasNumber((CoreBaseInfo)newRecord, (String)loanContractCompany.getId().toString());
            boolean isCommitCreditLimit = false;
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                IRow row = this.tblMain.getRow(i);
                if (row.getCell(SOURCEBILLNUM).getValue().toString().equals(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"313_LoanEditUI"))) continue;
                if (!rst && EmptyUtil.isEmpty((Object)row.getCell(NUMBER).getValue())) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"376_RepaymentBathEditUI"));
                    SysUtil.abort();
                }
                String loanId = (String)row.getCell(LOANID).getValue();
                LoanInfo loanInfo = (LoanInfo)this.loanMap.get(loanId);
                boolean canOp = FMClientHelper.checkFinalCheckout((SystemEnum)SystemEnum.IVT_MANAGE, (String)loanContractCompany.getId().toString(), (Date)((Date)row.getCell(BIZDATE).getValue()));
                if (!canOp) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.recon.FmSettleResource", (String)"36_SETTLED"));
                    SysUtil.abort();
                }
                if (!EmptyUtil.isEmpty((String)((String)row.getCell(CREDITLIMITNUMBER).getValue())) && !isCommitCreditLimit) {
                    int re = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"365_RepaymentEditUI"));
                    if (re != 0) {
                        return;
                    }
                    isCommitCreditLimit = true;
                }
                if ((Date)row.getCell(BIZDATE).getValue() != null && ((Date)row.getCell(BIZDATE).getValue()).before(loanInfo.getIssueDate())) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"502_RepaymentEditUI"));
                    SysUtil.abort();
                }
                RepaymentInfo repaymentInfo = new RepaymentInfo();
                repaymentInfo.setId(BOSUuid.create((BOSObjectType)new RepaymentInfo().getBOSType()));
                if (EmptyUtil.isEmpty((Object)row.getCell(BIZDATE).getValue())) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"377_RepaymentBathEditUI"));
                    SysUtil.abort();
                }
                if (((BigDecimal)row.getCell(SOURCEAMOUNT).getValue()).compareTo(BigDecimal.ZERO) <= 0) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"378_RepaymentBathEditUI"));
                    SysUtil.abort();
                }
                Date bizDate = (Date)row.getCell(BIZDATE).getValue();
                this.verifyInput(loanId, bizDate);
                repaymentInfo.setBizDate(bizDate);
                repaymentInfo.setEndDate((Date)row.getCell(ENDDATE).getValue());
                repaymentInfo.setRepaySeq((Integer)row.getCell(REPAYSEQ).getValue());
                repaymentInfo.setCurrency((CurrencyInfo)row.getCell(CURRENCY).getValue());
                repaymentInfo.setSourceAmount((BigDecimal)row.getCell(SOURCEAMOUNT).getValue());
                repaymentInfo.setSourceCurExRate((BigDecimal)row.getCell(SOURCECUREXRATE).getValue());
                repaymentInfo.setAmount((BigDecimal)row.getCell(AMOUNT).getValue());
                repaymentInfo.setLocalCurExRate(loanInfo.getLocalCurExRate());
                repaymentInfo.setLocalAmount(((BigDecimal)row.getCell(AMOUNT).getValue()).multiply(loanInfo.getLocalCurExRate()));
                repaymentInfo.setIsCalInt((Boolean)row.getCell(ISCALINT).getValue());
                repaymentInfo.setIsRepayInt((Boolean)row.getCell(ISREPAYINT).getValue());
                repaymentInfo.setIsCalPunishInt((Boolean)row.getCell(ISCALPUNISHINT).getValue());
                repaymentInfo.setDescription((String)row.getCell(REMARK).getValue());
                if (!EmptyUtil.isEmpty((Object)row.getCell(NUMBER).getValue())) {
                    repaymentInfo.setNumber((String)row.getCell(NUMBER).getValue());
                }
                repaymentInfo.setPayment((BigDecimal)row.getCell(AMOUNT).getValue());
                repaymentInfo.setSourceBillNum(loanInfo.getNumber());
                repaymentInfo.setCreditLimit(loanInfo.getCreditLimit());
                repaymentInfo.setCreditCurrency(loanInfo.getCreditCurrency());
                repaymentInfo.setCreditCurExRate(loanInfo.getCreditCurExRate());
                repaymentInfo.setReturnedQuota((BigDecimal)row.getCell(CREDITLIMITLOCALAMT).getValue());
                repaymentInfo.setUseAssureBill(loanInfo.isUseAssureBill());
                repaymentInfo.setAssureBill(loanInfo.getAssureBill());
                repaymentInfo.setAssExRate(loanInfo.getAssExRate());
                repaymentInfo.setIsIncredit(loanInfo.isIsInCredit());
                repaymentInfo.setLoan(loanInfo);
                repaymentInfo.setCTLCancel(false);
                repaymentInfo.setCreditor(loanInfo.getInstitution());
                repaymentInfo.setStartDate(loanInfo.getIssueDate());
                repaymentInfo.setCreditorCompany(loanInfo.getGroupID());
                repaymentInfo.setSourceCurrency(loanInfo.getCurrency());
                repaymentInfo.setRegion(loanInfo.getRegion());
                repaymentInfo.setCreditPercetage(Constants.ONE_HUNDRED);
                repaymentInfo.setAcutionAcctBank(loanInfo.getCautionAcctBank());
                repaymentInfo.setMarginCurrency(loanInfo.getCurrency());
                repaymentInfo.setMarginBalance(FMHelper.subtract((BigDecimal)loanInfo.getCautionAmt(), (BigDecimal)loanInfo.getCautionAmtRepay()));
                repaymentInfo.setSourceBillId(loanInfo.getId().toString());
                repaymentInfo.setLoanInfo(loanInfo);
                repaymentInfo.setCU(loanContractCompany.getCU());
                repaymentInfo.setCompany(loanContractCompany);
                repaymentInfo.setSourceType(FinancingBillTypeEnum.Loan);
                repaymentInfo.setAddAmount(repaymentInfo.getAmount().add(loanInfo.getAmount().subtract(loanInfo.getBalance())));
                repaymentInfo.setRepaySeq((Integer)this.getSeq(loanId).get("maxseq"));
                repaymentInfo.setIsPerformanced(false);
                if (!repaymentInfo.isIsRepayInt()) {
                    reColl.add((CoreBaseInfo)repaymentInfo);
                    this.doAntiWage(loanId);
                    continue;
                }
                genLoanInterestColl.add(repaymentInfo);
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"379_RepaymentBathEditUI"));
            SysUtil.abort();
        }
        if (genLoanInterestColl.size() > 0) {
            Map map = ((LoanInterestBathEditUI)LoanInterestBathEditUI.showDialogWindows((IUIObject)this, genLoanInterestColl).getUIObject()).getEditData();
            if (EmptyUtil.isEmpty((Object)map)) {
                this.getUIWindow().close();
            }
            for (Map.Entry entry : map.entrySet()) {
                RepaymentInfo repaymentInfo = (RepaymentInfo)entry.getKey();
                LoanInterestInfo info = (LoanInterestInfo)entry.getValue();
                if (!repaymentInfo.isIsCalPunishInt()) {
                    this.doAntiWage(repaymentInfo.getLoan().getId().toString());
                    if (info.getInterest().compareTo(Constants.ZERO) > 0) continue;
                    reColl.add((CoreBaseInfo)repaymentInfo);
                    continue;
                }
                if (info.getInterest().compareTo(Constants.ZERO) > 0) continue;
                this.doAntiWage(repaymentInfo.getLoan().getId().toString());
                reColl.add((CoreBaseInfo)repaymentInfo);
            }
        }
        StringBuilder errorBuilder = new StringBuilder();
        int error = 0;
        if (reColl.size() > 0) {
            for (int i = 0; i < reColl.size(); ++i) {
                try {
                    RepaymentFactory.getRemoteInstance().submit(reColl.get(i));
                    continue;
                }
                catch (Exception e2) {
                    errorBuilder.append(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"273_BondsInterestBathEditUI") + (i + 1) + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"380_RepaymentBathEditUI") + e2.getMessage());
                    ++error;
                }
            }
            if (errorBuilder.length() > 0) {
                MsgBox.showDetailAndOK(null, (String)(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"381_RepaymentBathEditUI") + (reColl.size() - error) + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"75_BondApplyBillWebFacadeControllerBean") + error + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"276_BondsInterestBathEditUI")), (String)errorBuilder.toString(), (int)1);
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"382_RepaymentBathEditUI"));
            }
        }
        if (this.assureIdList.size() != 0 || this.wageIdList.size() != 0) {
            RepaymentFactory.getRemoteInstance().doAntiWage(this.assureIdList, this.wageIdList);
        }
        this.getUIWindow().close();
    }

    protected void verifyInput(String loanId, Date bizDate) throws Exception {
        Date lastRepayDate = (Date)this.lastRepayDateMap.get(loanId);
        if (lastRepayDate != null && bizDate.before(DateTimeUtils.truncateDate((Date)lastRepayDate))) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"360_RepaymentEditUI"));
            SysUtil.abort();
        }
    }

    private void doAntiWage(String LoanId) throws EASBizException, BOSException {
        int j;
        int result;
        Map antiMap = new HashMap();
        antiMap = RepaymentFactory.getRemoteInstance().checkCanDoAnti((IObjectPK)new ObjectUuidPK(LoanId));
        if (antiMap == null) {
            return;
        }
        ArrayList assureList = (ArrayList)antiMap.get("assureList");
        ArrayList pledgeList = (ArrayList)antiMap.get("pledgeList");
        ArrayList impawnList = (ArrayList)antiMap.get("impawnList");
        for (int i = 0; i < assureList.size(); ++i) {
            String[] assures = (String[])assureList.get(i);
            if (!this.isDoAntiAssure) {
                this.isDoAntiAssure = true;
                result = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"493_RepaymentEditUI"));
                if (result == 0) {
                    this.doAntiAssure = true;
                }
            }
            if (!this.doAntiAssure) continue;
            this.assureIdList.add(assures[0]);
        }
        for (j = 0; j < pledgeList.size(); ++j) {
            String[] pledges = (String[])pledgeList.get(j);
            if (!this.isDoAntiWage) {
                this.isDoAntiWage = true;
                result = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"494_RepaymentEditUI"));
                if (result == 0) {
                    this.doAntiWage = true;
                }
            }
            if (!this.doAntiWage) continue;
            this.wageIdList.add(pledges[0]);
        }
        for (j = 0; j < impawnList.size(); ++j) {
            String[] impawns = (String[])impawnList.get(j);
            if (!this.isDoAntiImpawn) {
                this.isDoAntiImpawn = true;
                result = MsgBox.showConfirm2((String)(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"495_RepaymentEditUI") + impawns[1] + "?"));
                if (result == 0) {
                    this.doAntiImpawn = true;
                }
            }
            if (!this.doAntiImpawn) continue;
            this.wageIdList.add(impawns[0]);
        }
    }

    @Override
    public void actionDelLine_actionPerformed(ActionEvent e) throws Exception {
        this.removeLine(this.tblMain);
        this.tableValueChanged4KDPrediction(null);
    }

    private void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0 || this.isTableColumnSelected(table)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        int top = table.getSelectManager().get().getBeginRow();
        int bottom = table.getSelectManager().get().getEndRow();
        for (int i = top; i <= bottom; ++i) {
            if (table.getRow(top) == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                return;
            }
            table.removeRow(top);
        }
    }

    private boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    static {
        contractId = null;
        loanIdList = null;
    }
}

