/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AccountBankException;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyFactory;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.OverdraftCtrlEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCostCenterF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.cl.ConsingnRepaymentBillInfo;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.FinancingBillTypeEnum;
import com.kingdee.eas.fm.fin.LoanRepaymentApplyInfo;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fs.InAcctDataTypeEnum;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.InnerAcctGroupEntryCollection;
import com.kingdee.eas.fm.fs.InnerAcctGroupEntryFactory;
import com.kingdee.eas.fm.fs.InnerAcctGroupEntryInfo;
import com.kingdee.eas.fm.fs.InnerAcctGroupFactory;
import com.kingdee.eas.fm.fs.InnerAcctGroupInfo;
import com.kingdee.eas.fm.fs.InnerFrozenDepositFactory;
import com.kingdee.eas.fm.fs.SettlementBillRpcCacheInfo;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.ft.FundTransferRepayBillInfo;
import com.kingdee.eas.fm.nt.LetterOfCreditReachCollection;
import com.kingdee.eas.fm.nt.LetterOfCreditReachFactory;
import com.kingdee.eas.fm.nt.LetterOfCreditReachInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;

public class RepaymentHandler {
    public static final String BIZTYPE = "BizType";
    private static final String resourcePath = "com.kingdee.eas.fm.fin.RepaymentEditUIResource";

    public static String getUITitle(FinancingBillTypeEnum bizType) {
        if (bizType == null) {
            return "";
        }
        switch (bizType.getValue()) {
            case 1: {
                return EASResource.getString((String)resourcePath, (String)"loanRepayment");
            }
            case 3: {
                return EASResource.getString((String)resourcePath, (String)"letterOfCreditRepay");
            }
            case 4: {
                return EASResource.getString((String)resourcePath, (String)"letterOfGuaranteeRepay");
            }
            case 2: {
                return EASResource.getString((String)resourcePath, (String)"payableRepay");
            }
        }
        return EASResource.getString((String)resourcePath, (String)"REPAYMENT");
    }

    public void setCostCenterF7(KDBizPromptBox comp, IUIObject ui) {
        NewCostCenterF7 costCenterF7 = new NewCostCenterF7(ui);
        costCenterF7.setIsCUFilter(true);
        costCenterF7.setNeedAddOrgRange(false);
        costCenterF7.setMultiSelect(false);
        costCenterF7.setContainSealUp(false);
        costCenterF7.setCurrentCUID(ContextHelperFactory.getRemoteInstance().getCurrentCompany().getCU().getId().toString());
        comp.setSelector((KDPromptSelector)costCenterF7);
    }

    public void SetAcctBankF7(KDBizPromptBox comp, String companyid, Object bank) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        comp.setEntityViewInfo(evi);
        comp.getQueryAgent().resetRuntimeEntityView();
    }

    public LetterOfCreditReachInfo getLetterOfCreditReachByCredit(String creditid) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("credit.id", (Object)creditid));
        evi.setFilter(fi);
        LetterOfCreditReachCollection coll = LetterOfCreditReachFactory.getRemoteInstance().getLetterOfCreditReachCollection(evi);
        if (coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    public FinancingBillInfo getFinancingBill(String id) throws EASBizException, BOSException {
        BOSUuid bisid = BOSUuid.read((String)id);
        BOSObjectType idType = bisid.getType();
        if (idType.equals((Object)FundTransferRepayBillInfo.BOSTYPE) || idType.equals((Object)ConsingnRepaymentBillInfo.BOSTYPE) || idType.equals((Object)LoanRepaymentApplyInfo.BOSTYPE) || idType.equals((Object)LetterOfCreditReachInfo.BOSTYPE)) {
            id = RepaymentFactory.getRemoteInstance().getRelationLoanBillID(id);
        }
        SelectorItemCollection selectors = this.getFinBillSelector();
        CoreBaseInfo info = EJBAccessFactory.createRemoteInstance().getEntityInfo(id, selectors);
        return (FinancingBillInfo)info;
    }

    private SelectorItemCollection getFinBillSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("Type.id"));
        selector.add(new SelectorItemInfo("Type.number"));
        selector.add(new SelectorItemInfo("Type.name"));
        selector.add(new SelectorItemInfo("Currency.id"));
        selector.add(new SelectorItemInfo("Currency.number"));
        selector.add(new SelectorItemInfo("Currency.name"));
        selector.add(new SelectorItemInfo("CreditCurrency.id"));
        selector.add(new SelectorItemInfo("CreditCurrency.number"));
        selector.add(new SelectorItemInfo("CreditCurrency.name"));
        selector.add(new SelectorItemInfo("GaranteeType.id"));
        selector.add(new SelectorItemInfo("GaranteeType.number"));
        selector.add(new SelectorItemInfo("GaranteeType.name"));
        selector.add(new SelectorItemInfo("CreditLimit.id"));
        selector.add(new SelectorItemInfo("CreditLimit.number"));
        selector.add(new SelectorItemInfo("CreditLimit.name"));
        selector.add(new SelectorItemInfo("Institution.id"));
        selector.add(new SelectorItemInfo("Institution.number"));
        selector.add(new SelectorItemInfo("Institution.name"));
        selector.add(new SelectorItemInfo("Institution.BankAreaType"));
        selector.add(new SelectorItemInfo("CreditLimit.Property"));
        selector.add(new SelectorItemInfo("assureBill.*"));
        selector.add(new SelectorItemInfo("assCurrency.*"));
        selector.add("*");
        return selector;
    }

    public void vervifyOverDraftInnerAcct(CoreUIObject ui, RepaymentInfo editData, SettlementBillRpcCacheInfo rpcCacheInfo) throws BOSException, EASBizException, AccountBankException {
        InnerAccountInfo inAcct = editData.getInnerAccount();
        if (inAcct != null) {
            CurrencyInfo currency = editData.getCurrency();
            BigDecimal billAmount = null;
            billAmount = editData.getInterest() != null ? FMHelper.add((BigDecimal)editData.getSourceAmount(), (BigDecimal)editData.getInterest()) : editData.getSourceAmount();
            if (inAcct != null) {
                String msg;
                inAcct = InnerAccountFactory.getRemoteInstance().getInnerAccountInfo("select * , ctrlParam.* where id ='" + inAcct.getId() + "'");
                ObjectUuidPK chCompanyPk = new ObjectUuidPK(inAcct.getCompany().getId());
                CompanyOrgUnitInfo chCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)chCompanyPk);
                String companyNumber = chCompany.getNumber();
                AccountMgrStrategyInfo ctrlStrategy = inAcct.getCtrlParam();
                if (ctrlStrategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTCONTROL) && ctrlStrategy.isRemind()) {
                    BigDecimal totalFrozenAmt;
                    BankInfo clearhouse = null;
                    clearhouse = rpcCacheInfo != null ? rpcCacheInfo.getClearingHouse() : FSClientHelper.getClearingHouse();
                    Date unSettleDate = clearhouse.getSettleDate();
                    BigDecimal currentBalance = InAcctFactory.getRemoteInstance().inAcct(companyNumber, inAcct.getNumber(), currency.getNumber(), unSettleDate, unSettleDate, InAcctDataTypeEnum.K);
                    BigDecimal kValue = currentBalance.subtract(totalFrozenAmt = InnerFrozenDepositFactory.getRemoteInstance().getTotalFrozenAmt(currency.getId().toString(), inAcct.getId().toString()));
                    if (kValue.compareTo(billAmount) < 0 && MsgBox.showConfirm2((Component)ui, (String)(msg = MessageFormat.format(EASResource.getString((String)resourcePath, (String)"overDraftFrozen"), inAcct.getName(), kValue, billAmount.subtract(kValue)))) == 2) {
                        SysUtil.abort();
                    }
                }
                if (ctrlStrategy.getOverdraftCtrl() == OverdraftCtrlEnum.INLIMITCANOVERDRAFT && ctrlStrategy.isRemind()) {
                    BigDecimal totalFrozenAmt;
                    Date unSettleDate = FSClientHelper.getClearingHouse().getSettleDate();
                    BigDecimal currentBalance = InAcctFactory.getRemoteInstance().inAcct(companyNumber, inAcct.getNumber(), currency.getNumber(), unSettleDate, unSettleDate, InAcctDataTypeEnum.K);
                    BigDecimal kValue = currentBalance.subtract(totalFrozenAmt = InnerFrozenDepositFactory.getRemoteInstance().getTotalFrozenAmt(currency.getId().toString(), inAcct.getId().toString()));
                    BigDecimal preAmount = kValue.subtract(billAmount);
                    if (preAmount.signum() == -1 && preAmount.compareTo(ctrlStrategy.getOverDraftAmount().negate()) >= 0 && MsgBox.showConfirm2((Component)ui, (String)(msg = MessageFormat.format(EASResource.getString((String)resourcePath, (String)"inSafeDraftFrozen"), inAcct.getName(), kValue, ctrlStrategy.getOverDraftAmount(), billAmount.subtract(kValue)))) == 2) {
                        SysUtil.abort();
                    }
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("innerAcct.id", (Object)inAcct.getId().toString()));
                InnerAcctGroupEntryCollection coll = InnerAcctGroupEntryFactory.getRemoteInstance().getInnerAcctGroupEntryCollection(view);
                if (coll != null && coll.size() > 0) {
                    InnerAcctGroupEntryInfo innerAcctGroupEntryInfo = coll.get(0);
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add("*");
                    selector.add("ctrlParam.*");
                    selector.add("entrys.*");
                    selector.add("entrys.innerAcct.*");
                    InnerAcctGroupInfo innerAcctGroupInfo = InnerAcctGroupFactory.getRemoteInstance().getInnerAcctGroupInfo((IObjectPK)new ObjectUuidPK(innerAcctGroupEntryInfo.getParent().getId()), selector);
                    AccountMgrStrategyInfo ctrlParamGroup = innerAcctGroupInfo.getCtrlParam();
                    if (ctrlParamGroup != null) {
                        AccountMgrStrategyInfo ctrlStrategyNew = AccountMgrStrategyFactory.getRemoteInstance().getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(ctrlParamGroup.getId()));
                        if (ctrlStrategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTCONTROL) && ctrlStrategy.isRemind()) {
                            String msg2;
                            Date unSettleDate = FSClientHelper.getClearingHouse().getSettleDate();
                            StringBuffer allInnerAcctNumber = new StringBuffer();
                            String allInnerAcctNumberString = null;
                            for (int i = 0; i < innerAcctGroupInfo.getEntrys().size(); ++i) {
                                InnerAcctGroupEntryInfo entryInfo = innerAcctGroupInfo.getEntrys().get(i);
                                allInnerAcctNumber.append(entryInfo.getInnerAcct().getNumber());
                                allInnerAcctNumber.append(",");
                            }
                            allInnerAcctNumberString = allInnerAcctNumber.substring(0, allInnerAcctNumber.length() - 1);
                            BigDecimal curBalance = InAcctFactory.getRemoteInstance().inAcct(companyNumber, allInnerAcctNumberString, currency.getNumber(), unSettleDate, unSettleDate, InAcctDataTypeEnum.K);
                            StringBuffer allInnerAcctId = new StringBuffer();
                            String allInnerAcctIdString = null;
                            for (int i = 0; i < innerAcctGroupInfo.getEntrys().size(); ++i) {
                                InnerAcctGroupEntryInfo entryInfo = innerAcctGroupInfo.getEntrys().get(i);
                                allInnerAcctId.append(entryInfo.getInnerAcct().getId());
                                allInnerAcctId.append(",");
                            }
                            allInnerAcctIdString = allInnerAcctId.substring(0, allInnerAcctId.length() - 1);
                            BigDecimal totalFrozenAmt = InnerFrozenDepositFactory.getRemoteInstance().getTotalFrozenAmt(allInnerAcctIdString, currency.getId().toString());
                            BigDecimal kValue = curBalance.subtract(totalFrozenAmt);
                            if (kValue.compareTo(billAmount) < 0 && MsgBox.showConfirm2((Component)ui, (String)(msg2 = MessageFormat.format(EASResource.getString((String)resourcePath, (String)"overDraftFrozen"), innerAcctGroupInfo.getName(), kValue, billAmount.subtract(kValue)))) == 2) {
                                SysUtil.abort();
                            }
                        }
                    }
                }
            }
        }
    }
}

