/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.EditorFactory;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.SumBillEnum;
import com.kingdee.eas.fm.common.SumFiledsInfo;
import com.kingdee.eas.fm.common.client.DefaultKDTCurrencyProvider;
import com.kingdee.eas.fm.common.client.DefaultKDTablePrecisionFormater;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.IKDTPrecisionProvider;
import com.kingdee.eas.fm.common.client.IKDTablePrecisionFormater;
import com.kingdee.eas.fm.common.util.MsgPromtUtil;
import com.kingdee.eas.fm.fin.FinancingBillTypeEnum;
import com.kingdee.eas.fm.fin.ILoanInterest;
import com.kingdee.eas.fm.fin.IRepayment;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.LoanInterestCollection;
import com.kingdee.eas.fm.fin.LoanInterestFactory;
import com.kingdee.eas.fm.fin.LoanInterestInfo;
import com.kingdee.eas.fm.fin.RepaymentCollection;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.StatusExtEnum;
import com.kingdee.eas.fm.fin.client.AbstractRepaymentListUI;
import com.kingdee.eas.fm.fin.client.FMBTPMakeBillUIWithoutGrp;
import com.kingdee.eas.fm.fin.client.FinListProcessUtils;
import com.kingdee.eas.fm.fin.client.RepaymentBillDataProvider;
import com.kingdee.eas.fm.fin.client.RepaymentBillQueryProcessor;
import com.kingdee.eas.fm.fin.client.RepaymentFilterParam;
import com.kingdee.eas.fm.fin.client.RepaymentFilterUI;
import com.kingdee.eas.fm.fin.client.RepaymentHandler;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.IBatchOrgListBiz;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.context.IDelegationSupport;
import com.kingdee.eas.framework.client.service.LicenseService;
import com.kingdee.eas.framework.client.workflow.MultiAssignmentUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class RepaymentListUI
extends AbstractRepaymentListUI
implements IDelegationSupport,
IBatchOrgListBiz {
    private static final Logger logger = CoreUIObject.getLogger(RepaymentListUI.class);
    public static final String RESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";
    private IKDTablePrecisionFormater precFormater = null;
    protected CompanyOrgUnitInfo currentCompany;
    private RepaymentFilterUI filterUI = null;
    private FinancingBillTypeEnum bizType = null;
    private int bookType;
    static final String tdTemplateFile = "/FM/FIN/REPAYMENT";
    private boolean isGenPayBill = false;
    private static final String NOT_SAME_CURRENCY = EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"376_RepaymentListUI");
    private static final String NOT_EXIST_ACCT = EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"377_RepaymentListUI");
    private static final String ISBOOKED = EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"378_RepaymentListUI");
    private static final String HAD_CREATED_VOUCHER = EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"379_RepaymentListUI");
    private static final String HAD_NOT_BOOKED = EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"380_RepaymentListUI");
    FillListener fillListener = new FillListener();

    public RepaymentListUI() throws Exception {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.precFormater = new DefaultKDTablePrecisionFormater();
        this.precFormater.setPrecProvider((IKDTPrecisionProvider)new DefaultKDTCurrencyProvider(this.getCurrencyIdColName()));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_handworkcollate"));
        this.actionCancelBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fallotpopedomforbid"));
        this.actionSubmit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        IContextHelper ctxHelper = ContextHelperFactory.getRemoteInstance();
        int val = ctxHelper.getIntParam("CS001", (IObjectPK)new ObjectUuidPK(ctxHelper.getCurrentCompany().getId()));
        boolean isBillBook = val == 0;
        this.bookType = val;
        this.actionBook.setVisible(isBillBook);
        this.actionCancelBook.setVisible(isBillBook);
        this.btnCancelBook.setVisible(false);
        this.actionBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_discount"));
        this.actionCancelBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_canceldiscount"));
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionGenPayBill.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_releasebymodule"));
        this.actionViewBgBalance.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_inquirebudget"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnTDPrint.setEnabled(true);
        this.btnTDPrintPreview.setEnabled(true);
        this.menuItemTDPrint.setEnabled(true);
        this.menuItemTDPrintPreview.setEnabled(true);
        if (!FMHelper.isEmpty((Object)this.bizType)) {
            if (this.bizType.equals((Object)FinancingBillTypeEnum.LetterOfCredit)) {
                this.actionCreateTo.setVisible(false);
            } else if (this.bizType.equals((Object)FinancingBillTypeEnum.LetterOfGuarantee)) {
                this.actionBook.setVisible(false);
                this.actionCancelBook.setVisible(false);
            }
        }
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    protected void CheckBizUnit() throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (ContextHelperFactory.getRemoteInstance().isOnlyUnion(company)) {
            this.btnBook.setEnabled(false);
            this.menuItemBook.setEnabled(false);
            this.btnCancelBook.setEnabled(false);
            this.menuItemCancelBook.setEnabled(false);
            this.btnGenPayBill.setEnabled(false);
            this.menuItemGenPayBill.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            this.btnCancel.setEnabled(false);
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.checkSelected();
        super.tblMain_tableSelectChanged(e);
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        String id = (String)idList.get(0);
        RepaymentInfo sourceBill = ((IRepayment)this.getBizInterface()).getRepaymentInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        boolean Notconfirmed = sourceBill.getConfirmer() == null;
        boolean bCurCompany = true;
        this.actionRemove.setEnabled(bCurCompany && Notconfirmed);
        this.actionEdit.setEnabled(bCurCompany && Notconfirmed);
        this.actionVoucher.setEnabled(bCurCompany && !sourceBill.isFiVouchered());
        this.actionDelVoucher.setEnabled(bCurCompany && sourceBill.isFiVouchered());
        boolean isBook = sourceBill.getCashier() == null && this.bookType == 0;
        this.actionBook.setEnabled(isBook);
        this.btnBook.setEnabled(isBook);
        this.actionCancelBook.setEnabled(!isBook);
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        int selectdRow = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = null;
        BizEnumValueDTO billstatus = null;
        row = this.tblMain.getRow(selectdRow);
        billstatus = (BizEnumValueDTO)row.getCell("statusExtEnum").getValue();
        if (-1 == billstatus.getInt()) {
            this.actionSubmit.setEnabled(true);
        } else {
            this.actionSubmit.setEnabled(false);
        }
        this.CheckBizUnit();
    }

    public void onLoad() throws Exception {
        this.precFormater.init(this.getMainTable(), this.getPrecColName());
        String param = (String)this.getUIContext().get("UIClassParam");
        if (param != null && param.indexOf(";") != -1) {
            String[] s = param.split(";");
            this.bizType = FinancingBillTypeEnum.getEnum((String)s[0]);
            this.getUIContext().put(LicenseService.MODULENAME, s[1]);
        } else {
            this.bizType = FinancingBillTypeEnum.getEnum((String)param);
        }
        super.onLoad();
        this.initUIProp();
        this.btnBook.setEnabled(false);
        this.btnCancelBook.setEnabled(false);
        if (!FSClientHelper.isClearingHouseCompanyId((String)this.currentCompany.getId().toString())) {
            FMClientHelper.hideIfBizUnitCompany((KDTable)this.tblMain, (String)"company.name");
        }
        this.btnMultiapprove.setVisible(false);
        this.btnNextPerson.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.menuWorkFlow.setVisible(false);
        this.CheckBizUnit();
        this.confirm.setVisible(false);
        if (this.isInMsgCenter()) {
            this.initMsgCenterTable();
        }
        this.actionViewBgBalance.setEnabled(true);
        this.actionSubmit.setEnabled(true);
        this.actionAddNew.setEnabled(true);
        this.actionEdit.setEnabled(true);
        this.actionRemove.setEnabled(true);
        this.actionGenPayBill.setEnabled(true);
        this.actionVoucher.setEnabled(true);
        this.actionDelVoucher.setEnabled(true);
        this.btnVoucher.setEnabled(true);
        this.btnDelVoucher.setEnabled(true);
        this.actionAddNew.setVisible(true);
        this.actionEdit.setVisible(true);
        this.actionRemove.setVisible(true);
        this.actionGenPayBill.setVisible(true);
        this.actionVoucher.setVisible(true);
        this.actionDelVoucher.setVisible(true);
        this.btnVoucher.setVisible(true);
        this.btnDelVoucher.setVisible(true);
        this.tblMain.getColumn("startDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("endDate").getStyleAttributes().setNumberFormat(this.dformat);
    }

    private void initUIProp() {
        String title = this.getUITitle();
        title = RepaymentHandler.getUITitle(this.bizType);
        this.setUITitle(title);
    }

    private void initMsgCenterTable() {
        this.tblMain.getSelectManager().setSelectMode(1);
        this.tblMain.setEditable(true);
        this.tblMain.getColumn("dispositAccount").getStyleAttributes().setHided(false);
        KDBizPromptBox prmtAccount = new KDBizPromptBox();
        ExtendParser parserAccount = new ExtendParser(prmtAccount);
        prmtAccount.setCommitParser((IParser)parserAccount);
        prmtAccount.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        evi.setFilter(filterInfo);
        prmtAccount.setEntityViewInfo(evi);
        prmtAccount.setVisible(true);
        prmtAccount.setEditable(true);
        prmtAccount.setDisplayFormat("$name$");
        prmtAccount.setEditFormat("$number$");
        prmtAccount.setCommitFormat("$number$");
        prmtAccount.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$", prmtAccount));
        ObjectValueRender avrAccount = new ObjectValueRender();
        avrAccount.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.tblMain.getColumn("dispositAccount").setRenderer((IBasicRender)avrAccount);
        this.tblMain.setRequired(true);
        this.tblMain.getColumn("dispositAccount").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtAccount));
        this.tblMain.getColumn("dispositAccount").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("BankAcct").setRenderer((IBasicRender)avrAccount);
        this.tblMain.getColumn("BankAcct").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtAccount));
        this.tblMain.getColumn("BankAcct").getStyleAttributes().setLocked(false);
        EditorFactory.DatePickerEditor dateEditor = new EditorFactory.DatePickerEditor();
        this.tblMain.getColumn("bizDate").setEditor((ICellEditor)dateEditor);
        this.tblMain.getColumn("bizDate").getStyleAttributes().setLocked(false);
    }

    protected boolean isInMsgCenter() {
        Boolean wf = (Boolean)this.getUIContext().get("IsBatchDispose");
        if (wf == null) {
            return false;
        }
        return wf;
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.isInMsgCenter()) {
            ((IBlock)this.tblMain.getSelectManager().getBlocks().get(0)).setMode(8);
            CoreBillBaseCollection coll = super.getBillList();
            for (RepaymentInfo element : coll) {
                int index = this.getRowIndexById(element.getId().toString());
                if (index == -1) continue;
                this.tblMain.getCell(index, "BankAcct").setValue((Object)this.getAccountBankByInnerAccount(element.getInnerAccount()));
            }
        }
    }

    private AccountBankInfo getAccountBankByInnerAccount(InnerAccountInfo innerAcctInfo) throws BOSException {
        if (innerAcctInfo == null) {
            return null;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("InnerAcct.id", (Object)innerAcctInfo.getId().toString()));
        evi.setFilter(filter);
        AccountBankCollection coll = AccountBankFactory.getRemoteInstance().getAccountBankCollection(evi);
        if (coll.size() <= 0) {
            return null;
        }
        if (coll.size() > 1) {
            return null;
        }
        return coll.get(0);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return RepaymentFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new RepaymentFilterUI(this.bizType);
        }
        return this.filterUI;
    }

    @Override
    public String[] getMergeColumnKeys() {
        return new String[0];
    }

    protected String getCurrencyIdColName() {
        return "CurrencyId";
    }

    protected String[] getPrecColName() {
        return new String[]{"Amount", "Interest", "Payment", "LocalAmount", "sourceAmount", "sourceCurExRate", "totalPayedAmt"};
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("commercialDraft.*"));
        sic.add(new SelectorItemInfo("payee.*"));
        return sic;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        ((IBlock)this.tblMain.getSelectManager().getBlocks().get(0)).setMode(8);
        CoreBillBaseCollection coll = super.getBillList();
        for (RepaymentInfo element : coll) {
            int index = this.getRowIndexById(element.getId().toString());
            if (index == -1) continue;
            element.setBizDate((Date)this.tblMain.getCell(index, "bizDate").getValue());
            if (this.tblMain.getCell(index, "dispositAccount").getValue() instanceof AccountBankInfo) {
                element.setDepositAccount((AccountBankInfo)this.tblMain.getCell(index, "dispositAccount").getValue());
            }
            if (!(this.tblMain.getCell(index, "BankAcct").getValue() instanceof AccountBankInfo)) continue;
            element.setBankAcct((AccountBankInfo)this.tblMain.getCell(index, "BankAcct").getValue());
        }
        RepaymentFactory.getRemoteInstance().batchConfirm((IObjectCollection)coll);
        ((MultiAssignmentUI)this.getParent().getParent()).getUIWindow().close();
    }

    private int getRowIndexById(String id) {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            if (!id.equals((String)row.getCell("id").getValue())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String keyValue = this.getSelectedKeyValue();
        if (keyValue == null) {
            return;
        }
        RepaymentInfo info = RepaymentFactory.getRemoteInstance().getRepaymentInfo((IObjectPK)new ObjectUuidPK(keyValue));
        if (info.getCashier() != null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"371_RepaymentListUI"));
            this.abort();
        }
        if (info.getStatusExtEnum() == StatusExtEnum.AUDIT) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"372_RepaymentListUI"));
            this.abort();
        }
        if (info.isIsGenPayBill()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"373_RepaymentListUI"));
            this.abort();
        }
        if (info.isIsGenPayBill()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"373_RepaymentListUI"));
            this.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("company.number");
        sic.add("Currency.number");
        sic.add("fpItem.number");
        sic.add("fpItem.id");
        sic.add("fpItem.name");
        sic.add("project.name");
        sic.add("project.number");
        sic.add("outBgItemId");
        sic.add("outBgItemNumber");
        sic.add("outBgItemName");
        sic.add("SourceType");
        sic.add("*");
        return sic;
    }

    protected CommonQueryProcessor getQueryProcessor() {
        return new RepaymentBillQueryProcessor((IUIObject)this);
    }

    @Override
    public void actionViewBgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        FMClientHelper.viewBgBalance4ListUI((Component)((Object)this), (String)id);
    }

    @Override
    public void actionBook_actionPerformed(ActionEvent e) throws Exception {
        int result;
        this.checkSelected();
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        ArrayList<String> ids = new ArrayList<String>();
        BizEnumValueDTO SourceType = null;
        StringBuffer msg = new StringBuffer();
        for (int i = 0; i < indexs.length; ++i) {
            row = this.tblMain.getRow(indexs[i]);
            SourceType = (BizEnumValueDTO)row.getCell("SourceType").getValue();
            if (SourceType.getInt() != 1 && SourceType.getInt() != 2 && SourceType.getInt() != 3) continue;
            if (1 == ((BizEnumValueDTO)row.getCell("statusExtEnum").getValue()).getInt()) {
                if (!this.verifyBookingRePayment(row.getCell("id").getValue().toString(), msg)) continue;
                ids.add(row.getCell("id").getValue().toString());
                continue;
            }
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"374_RepaymentListUI"));
            SysUtil.abort();
        }
        int val = ContextHelperFactory.getRemoteInstance().getIntParam("CS001", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        if (val == 1) {
            return;
        }
        if (ids.size() == 0) {
            String noRecordMsg = EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"375_RepaymentListUI");
            noRecordMsg = MessageFormat.format(noRecordMsg, msg.toString());
            MsgBox.showWarning((Component)((Object)this), (String)noRecordMsg);
            SysUtil.abort();
        } else if (ids.size() == indexs.length) {
            this.checkLoanInterest(ids);
            ((IRepayment)this.getBizInterface()).book(ids);
            this.showMsg(e);
        } else if (ids.size() < indexs.length && (result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"343_LoanListUI"))) == 0) {
            this.checkLoanInterest(ids);
            ((IRepayment)this.getBizInterface()).book(ids);
            this.showMsg(e);
        }
        if (msg.length() > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)msg.toString());
        }
    }

    private void checkLoanInterest(List ids) throws Exception {
        int result;
        if (!this.isRepayInt(ids)) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("repayment.id", new HashSet(ids), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("cashier", null, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isGenPayBill", (Object)Boolean.FALSE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("account", null, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("statusExtEnum", (Object)new Integer(1), CompareType.EQUALS));
        view.setFilter(filter);
        ILoanInterest loanIntlocalInstance = LoanInterestFactory.getRemoteInstance();
        LoanInterestCollection intCol = loanIntlocalInstance.getLoanInterestCollection(view);
        if (intCol != null && intCol.size() < ids.size() && (result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"544_RepaymentListUI"))) != 0) {
            SysUtil.abort();
        }
    }

    private boolean isRepayInt(List ids) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("isRepayInt");
        view.setSelector(sic);
        view.setFilter(filter);
        RepaymentCollection repayCol = RepaymentFactory.getRemoteInstance().getRepaymentCollection(view);
        RepaymentInfo info = null;
        int size = repayCol.size();
        for (int i = 0; i < size; ++i) {
            info = repayCol.get(i);
            if (!info.isIsRepayInt()) continue;
            return true;
        }
        return false;
    }

    private boolean verifyBookingRePayment(String id, StringBuffer msg) throws Exception {
        boolean flag;
        if (id == null) {
            return false;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("number");
        sic.add(new SelectorItemInfo("BankAcct.Currency.*"));
        sic.add(new SelectorItemInfo("Currency.*"));
        RepaymentInfo repaymentInfo = RepaymentFactory.getRemoteInstance().getRepaymentInfo((IObjectPK)new ObjectUuidPK(id), sic);
        if (repaymentInfo.getCurrency() != null && repaymentInfo.getBankAcct() != null && repaymentInfo.getBankAcct().getCurrency() != null && !repaymentInfo.getCurrency().getId().equals((Object)repaymentInfo.getBankAcct().getCurrency().getId())) {
            msg.append(MessageFormat.format(NOT_SAME_CURRENCY, repaymentInfo.getNumber()));
            return false;
        }
        if (repaymentInfo.getBankAcct() == null) {
            msg.append(MessageFormat.format(NOT_EXIST_ACCT, repaymentInfo.getNumber()));
            return false;
        }
        boolean bl = flag = repaymentInfo.getCashier() != null;
        if (flag) {
            msg.append(MessageFormat.format(ISBOOKED, repaymentInfo.getNumber()));
            return false;
        }
        return true;
    }

    private boolean verifyCancelBookingRePayment(String id, StringBuffer msg) throws Exception {
        if (id == null) {
            return false;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("number");
        sic.add("Cashier");
        sic.add("isFiVouchered");
        RepaymentInfo repaymentInfo = RepaymentFactory.getRemoteInstance().getRepaymentInfo((IObjectPK)new ObjectUuidPK(id), sic);
        if (repaymentInfo.isFiVouchered()) {
            msg.append(MessageFormat.format(HAD_CREATED_VOUCHER, repaymentInfo.getNumber()));
            return false;
        }
        if (repaymentInfo.getCashier() == null) {
            msg.append(MessageFormat.format(HAD_NOT_BOOKED, repaymentInfo.getNumber()));
            return false;
        }
        return true;
    }

    @Override
    public void actionCancelBook_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        ArrayList<String> ids = new ArrayList<String>();
        StringBuffer msg = new StringBuffer();
        for (int i = 0; i < indexs.length; ++i) {
            row = this.tblMain.getRow(indexs[i]);
            if (!this.verifyCancelBookingRePayment(row.getCell("id").getValue().toString(), msg)) continue;
            ids.add(row.getCell("id").getValue().toString());
        }
        if (ids.size() > 0) {
            ((IRepayment)this.getBizInterface()).cancelBook(ids);
            this.showMsg(e);
        }
        if (msg.length() > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)msg.toString());
        }
    }

    private void showMsg(ActionEvent e) throws Exception {
        this.refresh(e);
        FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e);
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    @Override
    protected void recycleNumberByOrg(IObjectValue editData, String orgType, String number) {
    }

    @Override
    protected boolean isFootVisible() {
        return true;
    }

    protected void execQuery() {
        FilterInfo filter;
        FilterInfo extFilter;
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (!currentCompany.isIsBizUnit()) {
            this.actionGenPayBill.setEnabled(false);
        }
        if ((extFilter = this.getBillCanbePayed()) != null && extFilter.getFilterItems().size() > 0) {
            try {
                if (this.mainQuery.getFilter().getFilterItems().size() == 0) {
                    this.mainQuery.setFilter(extFilter);
                } else {
                    this.mainQuery.getFilter().mergeFilter(extFilter, "AND");
                }
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e.getCause());
            }
        }
        if (!FMHelper.isEmpty((Object)this.bizType)) {
            filter = new FilterInfo();
            if (this.bizType.equals((Object)FinancingBillTypeEnum.LetterOfCredit)) {
                filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(3)));
                filter.getFilterItems().add(new FilterItemInfo("isDirect", (Object)new Integer("0")));
            } else if (this.bizType.equals((Object)FinancingBillTypeEnum.Loan)) {
                filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(1)));
            } else if (this.bizType.equals((Object)FinancingBillTypeEnum.CommercialDraft)) {
                filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(2)));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(4)));
            }
            try {
                this.mainQuery.getFilter().mergeFilter(filter, "and");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e.getCause());
            }
        }
        if (this.getBOTPViewStatus() == 1 && this.getUIContext().get("BTPCreateMode") != null) {
            filter = new FilterInfo();
            if ((Map)this.getUIContext().get("BTPEDITPARAMETER") != null && "PaymentBill".equals(((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("TargetBillType"))) {
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("ARAPCOMPANY");
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString(), CompareType.EQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentCompany.getId()));
            }
            try {
                this.mainQuery.getFilter().mergeFilter(filter, "and");
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (this.bizType == null) {
            this.addFilterWithPaymentBill();
        }
        super.execQuery();
        this.formatFootRow();
    }

    private void addFilterWithPaymentBill() {
        EntityViewInfo evi;
        if (this.getBOTPViewStatus() == 1 && this.getUIContext().get("BOTPFilter") != null && (evi = (EntityViewInfo)this.getUIContext().get("BOTPFilter")) != null) {
            try {
                this.mainQuery.getFilter().mergeFilter(evi.getFilter(), "and");
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean filterCondition(Map btpMap) {
        return btpMap.get("TargetBillType") != null && btpMap.get("TargetBillType").toString().equals("PaymentBill") && btpMap.get("FromFinRepayment") != null && btpMap.get("FromFinRepayment").toString().equals("FromFinRepayment");
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    private void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            RepaymentFilterParam param = (RepaymentFilterParam)((Object)this.getFilterUI().getParam());
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrencyId() == null ? company.getBaseCurrency().getId().toString() : AccessHelper.getId((Object)param.getCurrencyId());
            String[] columns = new SumFiledsInfo(SumBillEnum.FinLoanRepay).getSumFileds();
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private FilterInfo getBillCanbePayed() {
        Map btpeditparameter;
        String targetBillType;
        FilterInfo f = new FilterInfo();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null && (targetBillType = (String)(btpeditparameter = (Map)this.getUIContext().get("BTPEDITPARAMETER")).get("FromFinRepayment")) != null && "FromFinRepayment".equals(targetBillType)) {
            f.getFilterItems().add(new FilterItemInfo("cashier.id", null, CompareType.EQUALS));
            f.getFilterItems().add(new FilterItemInfo("isGenPayBill", (Object)Boolean.FALSE));
            f.getFilterItems().add(new FilterItemInfo("statusExtEnum", (Object)new Integer(1)));
        }
        return f;
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.formatFootRow();
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() == 0 || idList == null) {
            return;
        }
        Set idSet = FMHelper.list2Set((List)idList);
        Map map = RepaymentFactory.getRemoteInstance().batchAntiAudit(idSet);
        if (map.size() > 0) {
            ArrayList unValids = new ArrayList();
            ArrayList unValidsMessage = new ArrayList();
            for (Map.Entry entry : map.entrySet()) {
                unValids.add(entry.getKey());
                unValidsMessage.add(entry.getValue());
            }
            StringBuffer detail = new StringBuffer();
            detail.append(EASResource.getString((String)RESOURCE, (String)"BillNumber")).append("\t\t").append(EASResource.getString((String)RESOURCE, (String)"ErrorReason")).append("\n");
            int size = unValids.size();
            for (int i = 0; i < size; ++i) {
                detail.append(unValids.get(i)).append("\t").append(unValidsMessage.get(i)).append("\n");
            }
            String error = EASResource.getString((String)RESOURCE, (String)"BillCancelAuditFailure");
            error = MessageFormat.format(error, idSet.size(), unValids.size());
            MsgBox.showDetailAndOK((Component)((Object)this), (String)error, (String)detail.toString(), (int)1);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"CancelAuditSuccess"));
        }
        this.refresh(e);
    }

    private void checkCanAntiAudit(RepaymentCollection coll, StringBuffer detail, Set idSet) throws Exception {
        for (int i = 0; i < coll.size(); ++i) {
            BOTRelationCollection colls;
            RepaymentInfo info = coll.get(i);
            if (info != null && info.getStatusExtEnum() != StatusExtEnum.AUDIT) {
                detail.append(info.getNumber()).append("\t").append(EASResource.getString((String)RESOURCE, (String)"auditCanAntiaudit")).append("\n");
                idSet.remove(info.getId().toString());
            }
            if ((colls = this.getBOTRelation(info.getId().toString())).size() <= 0) continue;
            detail.append(info.getNumber()).append("\t").append(EASResource.getString((String)RESOURCE, (String)"canAntiAudit")).append("\n");
            idSet.remove(info.getId().toString());
        }
    }

    private BOTRelationCollection getBOTRelation(String billId) throws BTPException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        view.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)billId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)new LoanInterestInfo().getBOSType().toString(), CompareType.NOTEQUALS));
        IBOTRelation iBOTRelation = BOTRelationFactory.getRemoteInstance();
        BOTRelationCollection relateColl = iBOTRelation.getCollection(view);
        return relateColl;
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        boolean hasWf = FMHelper.hasWFInstance(null, (List)this.getSelectedIdValues());
        if (hasWf) {
            this.actionMultiapprove_actionPerformed(e);
        } else {
            FinListProcessUtils.audit((ListUI)this, this.tblMain, this.getSelectedIdValues());
        }
        this.refresh(e);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String keyValue = this.getSelectedKeyValue();
        if (keyValue == null) {
            return;
        }
        RepaymentInfo info = RepaymentFactory.getRemoteInstance().getRepaymentInfo((IObjectPK)new ObjectUuidPK(keyValue));
        String srcBillId = info.getSourceBillId();
        super.actionRemove_actionPerformed(e);
        if (srcBillId != null) {
            BOSObjectType bt = BOSUuid.read((String)srcBillId).getType();
            if (new LoanInfo().getBOSType().equals((Object)bt)) {
                int j;
                Map antiMap = RepaymentFactory.getRemoteInstance().checkCanCancelAnti((IObjectPK)new ObjectUuidPK(srcBillId));
                if (antiMap == null) {
                    return;
                }
                ArrayList assureList = (ArrayList)antiMap.get("assureList");
                ArrayList pledgeList = (ArrayList)antiMap.get("pledgeList");
                ArrayList impawnList = (ArrayList)antiMap.get("impawnList");
                ArrayList<String> assureIdList = new ArrayList<String>();
                ArrayList<String> wageIdList = new ArrayList<String>();
                for (int i = 0; i < assureList.size(); ++i) {
                    String[] assures = (String[])assureList.get(i);
                    assureIdList.add(assures[0]);
                }
                for (j = 0; j < pledgeList.size(); ++j) {
                    String[] pledges = (String[])pledgeList.get(j);
                    wageIdList.add(pledges[0]);
                }
                for (j = 0; j < impawnList.size(); ++j) {
                    String[] impawns = (String[])impawnList.get(j);
                    wageIdList.add(impawns[0]);
                }
                if (assureIdList.size() != 0 || wageIdList.size() != 0) {
                    RepaymentFactory.getRemoteInstance().doCancelAntiWage(assureIdList, wageIdList);
                }
            }
        }
    }

    @Override
    public void actionGenPayBill_actionPerformed(ActionEvent e) throws Exception {
        this.isGenPayBill = false;
        this.checkSelected();
        ArrayList selectedIdList = this.getSelectedIdValues();
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getSelectorsExt());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(selectedIdList), CompareType.INCLUDE));
        view.setFilter(filter);
        RepaymentCollection coll = RepaymentFactory.getRemoteInstance().getRepaymentCollection(view);
        String srcBillId = coll.get(0).getSourceBillId();
        boolean isFromLoanOrPayableBill = false;
        if (srcBillId != null) {
            String srcBosType = BOSUuid.read((String)srcBillId).getType().toString();
            if (new PayableBillInfo().getBOSType().toString().equals(srcBosType) || new LoanInfo().getBOSType().toString().equals(srcBosType)) {
                isFromLoanOrPayableBill = true;
            }
        }
        coll = this.checkGenPayBill(coll, isFromLoanOrPayableBill);
        if (selectedIdList.size() == 1) {
            ArrayList idList = new ArrayList();
            ArrayList entriesKey = new ArrayList();
            this.getBillIdList(idList, entriesKey);
            this.checkEntryNumber(entriesKey);
            String[] idArray = new String[idList.size()];
            idList.toArray(idArray);
            this.isGenPayBill = true;
            FMBTPMakeBillUIWithoutGrp.show((CoreUI)this, (CoreBillListUI)this, idArray, new String[]{this.getEntriesName()}, entriesKey, RepaymentInfo.BOSTYPE.toString(), ContextHelperFactory.getRemoteInstance().getCurrentCtrlUnit(), this.getBOTPSelectors());
            this.isGenPayBill = false;
        } else if (isFromLoanOrPayableBill) {
            ((IRepayment)this.getBizInterface()).gatherGenPaymentBill(coll);
        } else {
            FMClientHelper.generateDestBill((CoreBillListUI)this, (String)RepaymentInfo.BOSTYPE.toString(), (String)new PaymentBillInfo().getBOSType().toString(), (String)this.getSelectedKeyValue());
        }
        this.refresh(e);
    }

    private RepaymentCollection checkGenPayBill(RepaymentCollection coll, boolean isFromLoanOrPayableBill) throws Exception {
        RepaymentInfo repayment = null;
        Object lastPayerAcctId = null;
        String payerAcctId = coll.get(0).getBankAcct() == null ? null : coll.get(0).getBankAcct().getId().toString();
        Object lastAcutionAcctBankId = null;
        String acutionAcctBankId = coll.get(0).getAcutionAcctBank() == null ? null : coll.get(0).getAcutionAcctBank().getId().toString();
        boolean isTotalPay = coll.size() > 1;
        boolean hasAutionAcct = false;
        boolean hasAutionAmt = false;
        for (int i = 0; i < coll.size(); ++i) {
            repayment = coll.get(i);
            if (isTotalPay && isFromLoanOrPayableBill) {
                if (repayment.getCautionAmt() != null && repayment.getCautionAmt().compareTo(BigDecimal.ZERO) > 0) {
                    hasAutionAmt = true;
                }
                if (repayment.isIsGenPayBill()) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"522_RepaymentListUI"));
                    SysUtil.abort();
                }
                if (payerAcctId != null) {
                    if (repayment.getBankAcct() != null && !payerAcctId.equals(repayment.getBankAcct().getId().toString()) || repayment.getBankAcct() == null) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"521_RepaymentListUI"));
                        SysUtil.abort();
                    }
                } else if (repayment.getBankAcct() != null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"521_RepaymentListUI"));
                    SysUtil.abort();
                }
                if (acutionAcctBankId != null) {
                    if (repayment.getAcutionAcctBank() != null && !acutionAcctBankId.equals(repayment.getAcutionAcctBank().getId().toString()) || repayment.getAcutionAcctBank() == null) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"520_RepaymentListUI"));
                        SysUtil.abort();
                    }
                } else if (repayment.getAcutionAcctBank() != null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"520_RepaymentListUI"));
                    SysUtil.abort();
                }
                if (repayment.getAcutionAcctBank() != null) {
                    hasAutionAcct = true;
                }
            }
            if (repayment.getCashier() != null) {
                MsgPromtUtil.showInfo((CoreUI)this, (String)RESOURCE, (String)"haveBeenBooked_repayment");
            }
            if (repayment.isIsGenPayBill() && repayment.isIsPayCompleted()) {
                MsgPromtUtil.showInfo((CoreUI)this, (String)RESOURCE, (String)"haveBeenRec_repayment");
            }
            if (repayment.getStatusExtEnum() == StatusExtEnum.AUDIT) continue;
            MsgPromtUtil.showInfo((CoreUI)this, (String)RESOURCE, (String)"auditFirst_repayment");
        }
        if (hasAutionAmt && !hasAutionAcct && isTotalPay) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"572_RepaymentListUI"));
            SysUtil.abort();
        }
        return coll;
    }

    public SelectorItemCollection getSelectorsExt() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("BankAcct.id");
        sic.add("BankAcct.name");
        sic.add("BankAcct.number");
        sic.add("BankAcct.bankaccountnumber");
        sic.add("acutionAcctBank.id");
        sic.add("acutionAcctBank.name");
        sic.add("acutionAcctBank.number");
        sic.add("acutionAcctBank.bankaccountnumber");
        sic.add("loan.isGenRecBill");
        return sic;
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(false);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(true);
    }

    private void tdPrint(boolean isPreview) {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        RepaymentBillDataProvider data = new RepaymentBillDataProvider(idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        if (isPreview) {
            appHlp.printPreview(tdTemplateFile, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.print(tdTemplateFile, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    @Override
    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fm.fin.app.RepaymentTDQuery");
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        if (this.bizType != null) {
            uiContext.put((Object)"BizType", (Object)this.bizType.getName());
        }
    }

    protected String[] getQueryShowField() {
        switch (this.bizType.getValue()) {
            case 1: {
                return new String[]{"company.name", "number", "bizDate", "BankAcct", "depositAccount.name", "SourceType", "SourceBillNum", "startDate", "endDate", "days", "isPerformanced", "intRateExp", "rateLoan", "repaySeq", "payee.Name", "sourceAmount", "Currency", "sourceCurrency", "sourceCurExRate", "Amount", "LocalCurExRate", "LocalAmount", "Interest", "Payment", "creditLimitNumber", "creditLimitCurrency", "creditLimitExhRate", "creditLimitPercentage", "creditLimitLocalAmt", "acutionAcctBank.name", "marginCurrency.name", "cautionAmt", "intFeeAcctView.name", "ApplyCompany", "Remark", "statusExtEnum", "creator", "cashier.name", "accountant.name", "Desc", "BankAcct", "LoanAcct", "InterestAcct", "CTLCancel", "bgItem", "isGenPayBill", "fivouchered", "voucherType", "voucherNumber"};
            }
            case 3: {
                return new String[]{"company.name", "number", "bizDate", "BankAcct", "depositAccount.name", "SourceType", "SourceBillNum", "endDate", "isPerformanced", "repaySeq", "payee.Name", "sourceAmount", "Currency", "sourceCurrency", "sourceCurExRate", "Amount", "LocalCurExRate", "LocalAmount", "creditLimitNumber", "creditLimitCurrency", "creditLimitExhRate", "creditLimitPercentage", "creditLimitLocalAmt", "acutionAcctBank.name", "marginCurrency.name", "cautionAmt", "InnerAccount.Name", "intFeeAcctView.name", "ApplyCompany", "Remark", "statusExtEnum", "creator", "cashier.name", "accountant.name", "Desc", "BankAcct", "LoanAcct", "CTLCancel", "bgItem", "isGenPayBill", "fivouchered", "voucherType", "voucherNumber"};
            }
            case 4: {
                return new String[]{"company.name", "number", "bizDate", "BankAcct", "depositAccount.name", "SourceType", "SourceBillNum", "endDate", "isPerformanced", "repaySeq", "payee.Name", "sourceAmount", "Currency", "sourceCurrency", "sourceCurExRate", "Amount", "LocalCurExRate", "LocalAmount", "creditLimitNumber", "creditLimitCurrency", "creditLimitExhRate", "creditLimitPercentage", "creditLimitLocalAmt", "acutionAcctBank.name", "marginCurrency.name", "cautionAmt", "InnerAccount.Name", "ApplyCompany", "Remark", "statusExtEnum", "creator", "cashier.name", "accountant.name", "Desc", "BankAcct", "LoanAcct", "InterestAcct", "CTLCancel", "bgItem", "isGenPayBill", "fivouchered", "voucherType", "voucherNumber"};
            }
        }
        return new String[]{"company.name", "number", "bizDate", "BankAcct", "depositAccount.name", "SourceType", "SourceBillNum", "startDate", "endDate", "days", "isPerformanced", "intRateExp", "rateLoan", "repaySeq", "payee.Name", "sourceAmount", "Currency", "sourceCurrency", "sourceCurExRate", "Amount", "LocalCurExRate", "LocalAmount", "Interest", "Payment", "creditLimitNumber", "creditLimitCurrency", "creditLimitExhRate", "creditLimitPercentage", "creditLimitLocalAmt", "acutionAcctBank.name", "marginCurrency.name", "cautionAmt", "InnerAccount.Name", "intFeeAcctView.name", "ApplyCompany", "Confirmer", "Remark", "statusExtEnum", "creator", "cashier.name", "accountant.name", "Desc", "BankAcct", "LoanAcct", "InterestAcct", "CTLCancel", "bgItem", "isGenPayBill", "fivouchered", "voucherType", "voucherNumber", "settleMethod"};
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        int selectdRow = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = null;
        BizEnumValueDTO billstatus = null;
        row = this.tblMain.getRow(selectdRow);
        billstatus = (BizEnumValueDTO)row.getCell("statusExtEnum").getValue();
        if (-1 == billstatus.getInt()) {
            RepaymentInfo info = RepaymentFactory.getRemoteInstance().getRepaymentInfo((IObjectPK)new ObjectUuidPK(row.getCell("id").getValue().toString()));
            RepaymentFactory.getRemoteInstance().submit((CoreBaseInfo)info);
            this.refresh(e);
            FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e);
        }
    }

    public String getMainBizOrgColumnName() {
        return "company.id";
    }

    public String getMainBizOrgPropertyName() {
        return "company";
    }

    public String getPropertyOfBizOrg(OrgType orgType) {
        return "company.id";
    }

    public String[] getPropertyOfCopOrg() {
        return null;
    }

    protected SystemEnum getSystemEnum() {
        if (FinancingBillTypeEnum.Loan == this.bizType) {
            return SystemEnum.IVT_MANAGE;
        }
        if (FinancingBillTypeEnum.LetterOfCredit == this.bizType) {
            return SystemEnum.NT_MANAGEMENT;
        }
        return SystemEnum.IVT_MANAGE;
    }

    protected String getDateField() {
        return "bizDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionSubmit", "actionEdit", "actionRemove", "actionAntiAudit"};
    }

    public List getDestBosTypeForBotp(CoreBillBaseCollection srcBillInfos, List destBosTypeList) {
        if (this.isGenPayBill) {
            if (destBosTypeList.contains("40284E81")) {
                destBosTypeList.removeAll(destBosTypeList);
                destBosTypeList.add("40284E81");
            } else {
                destBosTypeList.removeAll(destBosTypeList);
            }
            return destBosTypeList;
        }
        return destBosTypeList;
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(RepaymentListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            IRow row = null;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = tblMain.getRow(i);
                this.setRow(row);
            }
        }

        private void setRow(IRow row) {
            BizEnumValueInfo exp = (BizEnumValueInfo)row.getCell("intRateExp").getValue();
            if (exp != null) {
                Object enu = exp.getValue();
                if ("year".equalsIgnoreCase(enu.toString())) {
                    row.getCell("rateLoan").getStyleAttributes().setNumberFormat("#,##0.0000000000\\%");
                } else {
                    row.getCell("rateLoan").getStyleAttributes().setNumberFormat("#,##0.0000000000\\\u2030");
                }
                row.getCell("rateLoan").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
            row.getCell("creditLimitPercentage").getStyleAttributes().setNumberFormat("#,##0.00000\\%");
            row.getCell("creditLimitPercentage").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            if (row.getCell("startDate").getValue() != null && row.getCell("endDate").getValue() != null) {
                Date startDate = (Date)row.getCell("startDate").getValue();
                Date endDate = (Date)row.getCell("endDate").getValue();
                row.getCell("days").setValue((Object)this.calcDaysBetweenTwoDate(startDate, endDate));
                row.getCell("days").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
            row.getCell("creditLimitExhRate").getStyleAttributes().setNumberFormat("%r{#,##0.00000}f");
            row.getCell("creditLimitExhRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            String currencyId = row.getCell("CurrencyId").getValue().toString();
            FMClientHelper.setNumberFormat((IRow)row, (String)"cautionAmt", (String)currencyId);
            if (row.getCell("creditCurrencyId").getValue() != null) {
                currencyId = row.getCell("creditCurrencyId").getValue().toString();
            }
            FMClientHelper.setNumberFormat((IRow)row, (String)"creditLimitLocalAmt", (String)currencyId);
        }

        private Integer calcDaysBetweenTwoDate(Date startDate, Date endDate) {
            long endTime = endDate.getTime();
            long beginTime = startDate.getTime();
            long betweenDays = (long)((double)((endTime - beginTime) / 86400000L) + 0.5);
            long days = new Long(betweenDays).intValue();
            return Integer.valueOf(days + "".trim());
        }
    }
}

