/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.LoanStatisticalUnitEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.util.RptFmClientUtil;
import com.kingdee.eas.fm.fin.FinClientHelper;
import com.kingdee.eas.fm.fin.LimitIsBankCreditEnum;
import com.kingdee.eas.fm.fin.client.AbstractRptCreditLimitUsedFilterUI;
import com.kingdee.eas.fm.fin.client.RptCreditLimitUsedFilterParam;
import com.kingdee.eas.fm.ft.RptFundTransferConstants;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ItemEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptCreditLimitUsedFilterUI
extends AbstractRptCreditLimitUsedFilterUI {
    private static final long serialVersionUID = 6414271893140576123L;
    private static final Logger logger = CoreUIObject.getLogger(RptCreditLimitUsedFilterUI.class);

    public void onLoad() throws Exception {
        FinClientHelper.initFilterUI((CoreUIObject)this, this.prmtCompany, this.cboRelations);
        super.onLoad();
    }

    protected void init() throws Exception {
        super.init();
        this.customInit();
    }

    public void clear() {
        super.clear();
        this.customInit();
    }

    private void customInit() {
        this.initDate();
        this.byCompany.setSelected(true);
        this.chkCludeZero.setSelected(false);
        this.ckIncludeClose.setSelected(false);
        this.cboUnit.setSelectedItem((Object)LoanStatisticalUnitEnum.TEN_THOUSAND);
        this.prmtCreditUsage.setEnabledMultiSelection(true);
        this.prmtCreditUsage.setData(null);
        this.cboRelations.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.kdtHistory.setSelected(true);
        this.kdtCurrent.setSelected(false);
        this.prmtCurrency.setEnabled(false);
        this.prmtCurrency.setData(null);
        try {
            if (ContextHelperFactory.getRemoteInstance().isOnlyUnion(this.currentCompany)) {
                this.companyIds = null;
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void initDate() {
        this.dpStartDate.setValue(null);
        this.dpEndDate.setValue((Object)DateUtil.getDayBegin());
        this.dpEndDate.setSupportedEmpty(false);
    }

    public Object getParam() {
        RptCreditLimitUsedFilterParam filterParam = new RptCreditLimitUsedFilterParam();
        if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            filterParam.setCompanyIdSet(this.getCompanyIdSet());
        }
        filterParam.setStartDate(this.dpStartDate.getSqlDate());
        filterParam.setEndDate(this.dpEndDate.getSqlDate());
        filterParam.setCreditUsage(AccessHelper.getF7Ids((KDBizPromptBox)this.prmtCreditUsage));
        filterParam.setCompanyIDs(this.getIdSetFromF7(this.prmtCompany));
        filterParam.setBankIDs(this.getIdSetFromF7(this.jbpOrganization));
        Object selectedValue = this.cboRelations.getSelectedItem();
        if (selectedValue instanceof LimitIsBankCreditEnum) {
            filterParam.setRelations((LimitIsBankCreditEnum)((Object)selectedValue));
        } else {
            filterParam.setRelations(null);
        }
        filterParam.setUnit((LoanStatisticalUnitEnum)this.cboUnit.getSelectedItem());
        if (this.byCompany.isSelected()) {
            filterParam.setQueryType(1);
        } else if (this.byInstitution.isSelected()) {
            filterParam.setQueryType(2);
        } else if (this.byUsage.isSelected()) {
            filterParam.setQueryType(3);
        }
        filterParam.setIncludeZero(this.chkCludeZero.isSelected());
        filterParam.setIncludeClose(this.ckIncludeClose.isSelected());
        filterParam.setCurrency((CurrencyInfo)this.prmtCurrency.getData());
        return filterParam;
    }

    public void setParam(Object param) {
        RptCreditLimitUsedFilterParam filterParam = (RptCreditLimitUsedFilterParam)((Object)param);
        if (filterParam != null) {
            this.setCompanyIdSet(filterParam.getCompanyIdSet());
            this.dpStartDate.setValue((Object)filterParam.getStartDate());
            this.dpEndDate.setValue((Object)filterParam.getEndDate());
            try {
                Set creditCompanySet = filterParam.getCompanyIDs();
                CoreBaseInfo[] ccc = RptFmClientUtil.getBaseInfoFromIdSet((Set)creditCompanySet);
                this.prmtCompany.setData((Object)ccc);
                LimitIsBankCreditEnum relations = filterParam.getRelations();
                if (relations == null) {
                    this.cboRelations.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
                } else {
                    this.cboRelations.setSelectedItem((Object)relations);
                }
                Set bankIds = filterParam.getBankIDs();
                CoreBaseInfo[] c = RptFmClientUtil.getBaseInfoFromIdSet((Set)bankIds);
                this.jbpOrganization.setData((Object)c);
                this.prmtCreditUsage.setValue((Object)this.getBaseInfoFromIdSet(FMHelper.asSet((String[])filterParam.getCreditUsage())));
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
                SysUtil.abort();
            }
            this.chkCludeZero.setSelected(filterParam.isIncludeZero());
            this.ckIncludeClose.setSelected(filterParam.isIncludeClose());
            FMClientHelper.setSelectObject((KDComboBox)this.cboUnit, (Object)filterParam.getUnit());
            switch (filterParam.getQueryType()) {
                case 1: {
                    this.byCompany.setSelected(true);
                    break;
                }
                case 2: {
                    this.byInstitution.setSelected(true);
                    break;
                }
                case 3: {
                    this.byUsage.setSelected(true);
                    break;
                }
                default: {
                    this.byCompany.setSelected(true);
                }
            }
            if (EmptyUtil.isEmpty((CoreBaseInfo)filterParam.getCurrency())) {
                this.kdtHistory.setSelected(true);
                this.prmtCurrency.setData(null);
            } else {
                this.kdtCurrent.setSelected(true);
                this.prmtCurrency.setData((Object)filterParam.getCurrency());
            }
        }
    }

    public boolean verify() {
        super.verify();
        if (this.dpStartDate.getValue() != null && this.dpStartDate.getSqlDate().after(this.dpEndDate.getSqlDate())) {
            MsgBox.showWarning((String)RptFundTransferConstants.REOURCE_READER.getKeyValue("enddate_error"));
            Date d = new Date();
            this.dpStartDate.setValue((Object)this.getStartDate(d));
            this.dpStartDate.setFocusable(true);
            return false;
        }
        return true;
    }

    private Date getStartDate(Date now) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    protected boolean isCheckCompanyNullWhenOnlyUnion() {
        return true;
    }

    @Override
    protected void cboRelations_itemStateChanged(ItemEvent e) throws Exception {
        FinClientHelper.cboRelationsItemStateChanged((CoreUIObject)this, this.cboRelations, this.contBank, this.jbpOrganization, this.contCompany, this.prmtCompany);
    }

    protected Class getParamClass() {
        return RptCreditLimitUsedFilterParam.class;
    }

    @Override
    protected void kdtHistory_itemStateChanged(ItemEvent e) throws Exception {
        this.prmtCurrency.setEnabled(false);
        this.prmtCurrency.setData(null);
    }

    @Override
    protected void kdtCurrent_itemStateChanged(ItemEvent e) throws Exception {
        this.prmtCurrency.setEnabled(true);
        BOSUuid id = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getBaseCurrency().getId();
        CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(id));
        this.prmtCurrency.setData((Object)currency);
    }
}

