/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.LoanStatisticalUnitEnum;
import com.kingdee.eas.fm.common.client.AliasTextValueProvider;
import com.kingdee.eas.fm.common.client.ColumnUserCellDisplayParser;
import com.kingdee.eas.fm.common.client.DefaultKDTCurrencyProvider;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMDetailRptBaseHandler;
import com.kingdee.eas.fm.common.client.FMRptBaseUI;
import com.kingdee.eas.fm.common.client.IFMDetailRptHandler;
import com.kingdee.eas.fm.common.client.IValueProvider;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeInfo;
import com.kingdee.eas.fm.fin.FinBaseDataException;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LimitIsBankCreditEnum;
import com.kingdee.eas.fm.fin.LimitPropertyEnum;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.client.RptCreditLimitUsedFilterParam;
import com.kingdee.eas.fm.ibt.BillRediscountOutInfo;
import com.kingdee.eas.fm.ibt.CreditAssetsTransferOutInfo;
import com.kingdee.eas.fm.ibt.InnerFinancingBorrowingInInfo;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public abstract class RptCreditLimitUsedUIHandler
extends FMDetailRptBaseHandler
implements IFMDetailRptHandler {
    protected static final String FINPRO_NAME = "FinproName";
    protected static final String USING_FACT_QUOTA = "UsingFactQuota";
    protected static final String RETURN_QUOTA = "ReturnQuota";
    protected static final String USING_ORG = "UsingOrg";
    protected static final String USED_QUOTA = "UsedQuota";
    protected static final String CREDIT_LIMIT_USED_COMPANY = "CreditLimitUsedCompany";
    protected static final String BILL_NUMBER = "BillNumber";
    protected static final String BILL_TYPE = "BillType";
    protected static final String CREDIT_LIMIT_BALANCE_LOCAL = "CreditLimitBalanceLocal";
    protected static final String CREDIT_LIMIT_USED_I_D = "CreditLimitUsedID";
    protected static final String BILL_I_D = "BillID";
    protected static final String CREDIT_LIMIT_BALANCE = "CreditLimitBalance";
    protected static final String CREDIT_L_IMIT_QUOTA_LOCAL = "CreditLImitQuotaLocal";
    protected static final String CREDIT_L_IMIT_QUOTA = "CreditLImitQuota";
    protected static final String CURRENCY_I_D = "CurrencyID";
    protected static final String CURRENCY_NAME = "CurrencyName";
    protected static final String EXPIRED_DATE = "ExpiredDate";
    protected static final String ISSUE_DATE = "IssueDate";
    protected static final String GUARANTEETYPE = "Guaranteetype";
    protected static final String CREDIT_USAGE_I_D = "CreditUsageID";
    protected static final String CREDIT_USAGE = "CreditUsage";
    protected static final String PROPERTY = "Property";
    protected static final String CREDIT_INSTITUTION = "CreditInstitution";
    protected static final String CREDIT_LIMIT_NUMBER = "CreditLimitNumber";
    protected static final String CREDIT_COMPANY_NAME = "CreditCompanyName";
    protected static final String CREDIT_COMPANY_I_D = "CreditCompanyID";
    protected static final String CREDIT_LIMIT_I_D = "CreditLimitID";
    private CurrencyInfo rateCurrency = null;
    protected static String[] columnKeys = new String[]{"CreditCompanyName", "CreditLimitNumber", "CreditInstitution", "CreditUsage", "CreditLimitID", "CreditCompanyID", "Property", "CreditUsageID", "Guaranteetype", "IssueDate", "ExpiredDate", "CurrencyID", "CurrencyName", "CreditLImitQuota", "CreditLImitQuotaLocal", "CreditLimitBalance", "CreditLimitBalanceLocal", "CreditLimitUsedID", "BillID", "BillType", "FinproName", "BillNumber", "CreditLimitUsedCompany", "UsingOrg", "UsedQuota", "ReturnQuota", "UsingFactQuota"};
    private CompanyOrgUnitInfo currentCompany;
    private Date endDate;
    private Date startDate;
    private LoanStatisticalUnitEnum amountUnit;
    private String loc;
    private boolean includeZero;
    private RptCreditLimitUsedFilterParam params;
    private String unit = "1";
    private int precisionLocalCurrency = 2;
    private Set companyIDs;
    private DefaultKDTCurrencyProvider currencyProvider;

    public RptCreditLimitUsedUIHandler(FilterInfo filterInfo, SorterItemCollection sorter, KDTable kdt) {
        super(filterInfo, sorter, kdt);
    }

    public RptCreditLimitUsedUIHandler(FilterInfo filterInfo, KDTable kdt) {
        super(filterInfo, kdt);
    }

    public RptCreditLimitUsedUIHandler(KDTable tblMain, FilterInfo filter) {
        super(filter, tblMain);
    }

    public RptCreditLimitUsedUIHandler(FMRptBaseUI fmRptUI, FilterInfo filter, RptCreditLimitUsedFilterParam filterParam) {
        super(filter, fmRptUI);
        this.setChloanDetailFilterParam(filterParam);
        this.prepare();
        this.rateCurrency = filterParam.getCurrency();
    }

    private void setLocalString() {
        this.loc = "_" + LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
    }

    protected void prepare() {
        this.currencyProvider = new DefaultKDTCurrencyProvider(CURRENCY_I_D);
        this.setLocalString();
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            CurrencyInfo baseCurrency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.currentCompany);
            baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrency.getId()));
            this.precisionLocalCurrency = baseCurrency.getPrecision();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.startDate = this.params.getStartDate();
        if (this.startDate != null) {
            this.startDate = new Date(DateTimeUtils.truncateDate((java.util.Date)new Date(this.startDate.getTime())).getTime());
        }
        this.endDate = this.params.getEndDate();
        if (this.endDate != null) {
            this.endDate = new Date(DateTimeUtils.truncateDate((java.util.Date)new Date(this.endDate.getTime())).getTime());
        }
        this.amountUnit = this.params.getUnit();
        this.includeZero = this.params.isIncludeZero();
        this.companyIDs = this.params.getCompanyIdSet();
        if (this.amountUnit.equals((Object)LoanStatisticalUnitEnum.THOUSAND)) {
            this.unit = "1000";
        } else if (this.amountUnit.equals((Object)LoanStatisticalUnitEnum.TEN_THOUSAND)) {
            this.unit = "10000";
        } else if (this.amountUnit.equals((Object)LoanStatisticalUnitEnum.MILLION)) {
            this.unit = "1000000";
        } else if (this.amountUnit.equals((Object)LoanStatisticalUnitEnum.HUNDRED_THOUSAND)) {
            this.unit = "10000000";
        } else if (this.amountUnit.equals((Object)LoanStatisticalUnitEnum.HUNDRED_MILLION)) {
            this.unit = "100000000";
        }
    }

    protected abstract String getStatColumn();

    public void setChloanDetailFilterParam(RptCreditLimitUsedFilterParam rptChloanDetailFilterParam) {
        this.params = rptChloanDetailFilterParam;
    }

    protected String getQueryPath() {
        return "";
    }

    public void setTableStateRow() {
        this.kdt.getColumn(this.getStatColumn()).setStat(true);
        IRow rowLongTime = this.kdt.getGroupManager().getStatRowTemplate(0);
        rowLongTime.getCell(1).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"383_RptCreditLimitUsedUIHandler"));
        rowLongTime.getCell(1).getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        rowLongTime.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        rowLongTime.getCell(CREDIT_L_IMIT_QUOTA_LOCAL).setExpressions("SUM");
        rowLongTime.getCell(CREDIT_LIMIT_BALANCE_LOCAL).setExpressions("SUM");
        this.initDecimalCol(rowLongTime.getCell(CREDIT_L_IMIT_QUOTA_LOCAL), this.precisionLocalCurrency);
        this.initDecimalCol(rowLongTime.getCell(CREDIT_LIMIT_BALANCE_LOCAL), this.precisionLocalCurrency);
        IRow rowLongTime0 = this.kdt.getGroupManager().getStatRowTemplate(-1);
        rowLongTime0.getCell(CREDIT_L_IMIT_QUOTA_LOCAL).setExpressions("SUM");
        rowLongTime0.getCell(CREDIT_LIMIT_BALANCE_LOCAL).setExpressions("SUM");
        this.initDecimalCol(rowLongTime0.getCell(CREDIT_L_IMIT_QUOTA_LOCAL), this.precisionLocalCurrency);
        this.initDecimalCol(rowLongTime0.getCell(CREDIT_LIMIT_BALANCE_LOCAL), this.precisionLocalCurrency);
        rowLongTime0.getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"384_RptCreditLimitUsedUIHandler"));
        rowLongTime0.getCell(0).getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        rowLongTime0.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
    }

    public void initHeader() {
        super.initHeader();
        this.initTable();
    }

    protected void initTable() {
        this.kdt.getGroupManager().setTotalize(true);
        this.initCustomHeader();
        this.initCommonColumn();
        IRow row = this.formatCommonHeadRow();
        this.formatCustomerHeadRow(row);
        this.kdt.getColumn(0).setGroup(true);
        String[] mergeCol = this.getMergeColumn();
        for (int i = 0; i < mergeCol.length; ++i) {
            this.kdt.getColumn(mergeCol[i]).setMergeable(true);
            this.kdt.getColumn(mergeCol[i]).setGroup(true);
        }
        ColumnUserCellDisplayParser displayParser = new ColumnUserCellDisplayParser(this.kdt);
        AliasTextValueProvider provider = new AliasTextValueProvider();
        provider.add((Object)new LoanInfo().getBOSType().toString(), this.getResString("Loan"));
        provider.add((Object)new PayableBillInfo().getBOSType().toString(), this.getResString("CommercialDraft"));
        provider.add((Object)new LetterOfCreditInfo().getBOSType().toString(), this.getResString("LetterOfCredit"));
        provider.add((Object)new LetterOfGuaranteeInfo().getBOSType().toString(), this.getResString("LetterOfGuarantee"));
        provider.add((Object)new InnerFinancingBorrowingInInfo().getBOSType().toString(), this.getResString("InnerFinancingBorrowingIn"));
        provider.add((Object)new BillRediscountOutInfo().getBOSType().toString(), this.getResString("BillRediscountOut"));
        provider.add((Object)new CreditAssetsTransferOutInfo().getBOSType().toString(), this.getResString("CreditAssetsTransferOut"));
        displayParser.addValueProvider(BILL_TYPE, (IValueProvider)provider);
    }

    private String getResString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)key);
    }

    private String[] getOriCurrencyPrecColumns() {
        return new String[]{CREDIT_L_IMIT_QUOTA, CREDIT_LIMIT_BALANCE, USED_QUOTA, RETURN_QUOTA, USING_FACT_QUOTA};
    }

    private String[] getMergeColumn() {
        return new String[]{FINPRO_NAME, CREDIT_COMPANY_NAME, CREDIT_LIMIT_NUMBER, CREDIT_INSTITUTION, CREDIT_USAGE, CREDIT_LIMIT_I_D, CREDIT_COMPANY_I_D, PROPERTY, CREDIT_USAGE_I_D, GUARANTEETYPE, ISSUE_DATE, EXPIRED_DATE, CURRENCY_I_D, CURRENCY_NAME, CREDIT_L_IMIT_QUOTA, CREDIT_L_IMIT_QUOTA_LOCAL, CREDIT_LIMIT_BALANCE, CREDIT_LIMIT_BALANCE_LOCAL, BILL_TYPE};
    }

    protected void initCustomHeader() {
    }

    protected void formatCustomerHeadRow(IRow row) {
    }

    protected IRow formatCommonHeadRow() {
        IRow headRow = this.kdt.addHeadRow();
        headRow.getCell(CREDIT_COMPANY_NAME).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"385_RptCreditLimitUsedUIHandler"));
        headRow.getCell(CREDIT_LIMIT_NUMBER).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"386_RptCreditLimitUsedUIHandler"));
        headRow.getCell(CREDIT_INSTITUTION).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"387_RptCreditLimitUsedUIHandler"));
        headRow.getCell(PROPERTY).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"388_RptCreditLimitUsedUIHandler"));
        headRow.getCell(CREDIT_USAGE).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"389_RptCreditLimitUsedUIHandler"));
        headRow.getCell(GUARANTEETYPE).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"390_RptCreditLimitUsedUIHandler"));
        headRow.getCell(ISSUE_DATE).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"391_RptCreditLimitUsedUIHandler"));
        headRow.getCell(EXPIRED_DATE).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"392_RptCreditLimitUsedUIHandler"));
        headRow.getCell(CURRENCY_NAME).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"393_RptCreditLimitUsedUIHandler"));
        headRow.getCell(CREDIT_L_IMIT_QUOTA).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"394_RptCreditLimitUsedUIHandler"));
        headRow.getCell(CREDIT_L_IMIT_QUOTA_LOCAL).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"395_RptCreditLimitUsedUIHandler"));
        headRow.getCell(CREDIT_LIMIT_BALANCE).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"396_RptCreditLimitUsedUIHandler"));
        headRow.getCell(CREDIT_LIMIT_BALANCE_LOCAL).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"397_RptCreditLimitUsedUIHandler"));
        headRow.getCell(BILL_TYPE).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"398_RptCreditLimitUsedUIHandler"));
        headRow.getCell(BILL_NUMBER).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"399_RptCreditLimitUsedUIHandler"));
        headRow.getCell(CREDIT_LIMIT_USED_COMPANY).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"400_RptCreditLimitUsedUIHandler"));
        headRow.getCell(FINPRO_NAME).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"166_F7FinancingProductsTreeUI"));
        headRow.getCell(USING_ORG).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"401_RptCreditLimitUsedUIHandler"));
        headRow.getCell(USED_QUOTA).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"402_RptCreditLimitUsedUIHandler"));
        headRow.getCell(RETURN_QUOTA).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"403_RptCreditLimitUsedUIHandler"));
        headRow.getCell(USING_FACT_QUOTA).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"404_RptCreditLimitUsedUIHandler"));
        return headRow;
    }

    public void endDataFill() {
        super.endDataFill();
        this.kdt.getSelectManager().setSelectMode(2);
    }

    protected void initCommonColumn() {
        String[] hideColKeys = new String[]{CREDIT_LIMIT_I_D, CREDIT_COMPANY_I_D, CREDIT_USAGE_I_D, CURRENCY_I_D, CREDIT_LIMIT_USED_I_D, BILL_I_D};
        HashSet<String> hideColSet = new HashSet<String>(Arrays.asList(hideColKeys));
        for (int i = 4; i < columnKeys.length; ++i) {
            IColumn col = this.kdt.addColumn();
            col.setKey(columnKeys[i]);
            if (!hideColSet.contains(columnKeys[i])) continue;
            col.getStyleAttributes().setHided(true);
        }
    }

    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        super.filldata(rs);
        BigDecimal used = Constants.ZERO;
        BigDecimal returned = Constants.ZERO;
        BigDecimal usedFact = Constants.ZERO;
        String CreditLimitID = null;
        boolean flagEmptyUsed = false;
        String dformat = FMHelper.getDateFormatString();
        this.kdt.getColumn(ISSUE_DATE).getStyleAttributes().setNumberFormat(dformat);
        this.kdt.getColumn(EXPIRED_DATE).getStyleAttributes().setNumberFormat(dformat);
        while (rs.next()) {
            String clUID = rs.getString(CREDIT_LIMIT_I_D);
            if (!flagEmptyUsed && CreditLimitID != null && !CreditLimitID.equals(clUID)) {
                this.addSubTotalRow(used, returned, usedFact);
                used = Constants.ZERO;
                returned = Constants.ZERO;
                usedFact = Constants.ZERO;
            }
            CreditLimitID = clUID;
            if (rs.getString(CREDIT_LIMIT_USED_I_D) != null) {
                flagEmptyUsed = false;
                used = used.add(rs.getBigDecimal(USED_QUOTA));
                returned = returned.add(rs.getBigDecimal(RETURN_QUOTA));
                usedFact = usedFact.add(rs.getBigDecimal(USING_FACT_QUOTA));
            } else {
                flagEmptyUsed = true;
            }
            IRow row = this.kdt.addRow();
            for (int i = 0; i < columnKeys.length; ++i) {
                row.getCell(columnKeys[i]).setValue(rs.getObject(columnKeys[i]));
                if (columnKeys[i].equals(PROPERTY)) {
                    int property = rs.getInt(columnKeys[i]);
                    row.getCell(columnKeys[i]).setValue((Object)LimitPropertyEnum.getEnum(property).getAlias());
                } else if (columnKeys[i].equals(ISSUE_DATE) || columnKeys[i].equals(EXPIRED_DATE)) {
                    row.getCell(columnKeys[i]).setValue((Object)rs.getDate(columnKeys[i]));
                }
                HashMap<String, BigDecimal> rateMap = new HashMap<String, BigDecimal>();
                BigDecimal creditLImitQuotaLocal = Constants.ZERO;
                BigDecimal creditLimitBalanceLocal = Constants.ZERO;
                CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
                if (EmptyUtil.isEmpty((CoreBaseInfo)this.rateCurrency)) continue;
                String currencyid = rs.getString(CURRENCY_I_D);
                BigDecimal rate = null;
                if (rateMap.containsKey(currencyid)) {
                    rate = (BigDecimal)rateMap.get(currencyid);
                } else {
                    if (currencyid.equals(this.rateCurrency.getId().toString())) {
                        rate = Constants.ONE;
                    } else {
                        CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyid));
                        ExchangeRateInfo rateInfo = FMHelper.getExRateInfo((CurrencyInfo)currency, (CurrencyInfo)this.rateCurrency, (CompanyOrgUnitInfo)company, (java.util.Date)this.endDate);
                        if (EmptyUtil.isEmpty((CoreBaseInfo)rateInfo)) {
                            throw new FinBaseDataException(FinBaseDataException.EXCEPTIONEXHANGERATE, new Object[]{currency.getName(), this.rateCurrency.getName()});
                        }
                        rate = ConvertModeEnum.INDIRECTEXCHANGERATE.equals((Object)rateInfo.getConvertMode()) ? Constants.ONE.divide(rateInfo.getConvertRate(), 20, 4) : rateInfo.getConvertRate();
                    }
                    rateMap.put(currencyid, rate);
                }
                creditLImitQuotaLocal = rs.getBigDecimal(CREDIT_L_IMIT_QUOTA).multiply(rate);
                row.getCell(CREDIT_L_IMIT_QUOTA_LOCAL).setValue((Object)creditLImitQuotaLocal);
                creditLimitBalanceLocal = rs.getBigDecimal(CREDIT_LIMIT_BALANCE).multiply(rate);
                row.getCell(CREDIT_LIMIT_BALANCE_LOCAL).setValue((Object)creditLimitBalanceLocal);
            }
            this.formatPrecByRow(row);
        }
        if (!flagEmptyUsed && rs.size() > 0) {
            this.addSubTotalRow(used, returned, usedFact);
        }
    }

    private void addSubTotalRow(BigDecimal used, BigDecimal returned, BigDecimal usedFact) throws EASBizException, BOSException {
        IRow rowSubT = this.kdt.addRow();
        IRow rowUp = this.kdt.getRow(rowSubT.getRowIndex() - 1);
        for (int i = 0; i < this.kdt.getColumnIndex(CREDIT_LIMIT_USED_I_D); ++i) {
            rowSubT.getCell(i).setValue(rowUp.getCell(i).getValue());
        }
        rowSubT.getCell(USED_QUOTA).setValue((Object)used);
        rowSubT.getCell(RETURN_QUOTA).setValue((Object)returned);
        rowSubT.getCell(USING_FACT_QUOTA).setValue((Object)usedFact);
        rowSubT.getCell(BILL_TYPE).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"302_LoanEditUI"));
        rowSubT.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        this.formatPrecByRow(rowSubT);
    }

    private void formatPrecByRow(IRow row) throws EASBizException, BOSException {
        String[] precCol = this.getOriCurrencyPrecColumns();
        int m = precCol.length;
        for (int j = 0; j < m; ++j) {
            int prec = this.currencyProvider.getPrecision(row, 1999, precCol[j]);
            row.getCell(precCol[j]).getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)prec));
            row.getCell(precCol[j]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
        row.getCell(CREDIT_L_IMIT_QUOTA_LOCAL).getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)this.precisionLocalCurrency));
        row.getCell(CREDIT_L_IMIT_QUOTA_LOCAL).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell(CREDIT_LIMIT_BALANCE_LOCAL).getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)this.precisionLocalCurrency));
        row.getCell(CREDIT_LIMIT_BALANCE_LOCAL).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    private void initDecimalCol(ICell cell, int precision) {
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        cell.getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)precision));
    }

    public IRowSet getRowSet() throws BOSException {
        String sql = "";
        try {
            sql = this.getDetailSQLExt();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
    }

    private String getDetailSQLExt() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        String loc = LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
        sql.append("SELECT ").append("CREDITLIMIT.FID                                               AS CreditLimitID, ").append("CREDITCOMPANY.FID                                             AS CreditCompanyID, ").append("CREDITCOMPANY.FNAME_").append(loc).append("                                         AS CreditCompanyName, ").append("CREDITLIMIT.FNumber                                           AS CreditLimitNumber, ").append("ISNULL(CREDITCOMPANY1.FNAME_").append(loc).append(" ,CREDITINSTITUTION.FNAME_").append(loc).append(" )    AS CreditInstitution, ").append("CREDITLIMIT.FProperty                                     AS Property, ").append("CREDITUSAGE.FNAME_").append(loc).append("                                           AS CreditUsage, ").append("CREDITLIMITUSED.FCreditUsageID                                AS CreditUsageID, ").append("GUARANTEETYPE.FNAME_").append(loc).append("                                         AS Guaranteetype, ").append("CREDITLIMIT.FIssueDate                                        AS IssueDate, ").append("CREDITLIMIT.FExpiredDate                                      AS ExpiredDate, ").append("CURRENCY.FID                                                  AS CurrencyID, ").append("CURRENCY.FNAME_").append(loc).append("                                              AS CurrencyName, ").append("CREDITLIMIT.FQuotaAmount/").append(this.unit).append("                                \t\tAS CreditLImitQuota, ").append("(CREDITLIMIT.FQuotaAmount *CREDITLIMIT.FExchangeRate )/").append(this.unit).append("        AS CreditLImitQuotaLocal, ").append("CREDITLIMIT.FBalance/").append(this.unit).append("                                          AS CreditLimitBalance, ").append("(CREDITLIMIT.FBalance *CREDITLIMIT.FExchangeRate )/").append(this.unit).append("            AS CreditLimitBalanceLocal, ").append("CREDITLIMITUSED.FID                                           AS CreditLimitUsedID, ").append("CREDITLIMITUSED.FBillId                                       AS BillID, ").append("CREDITLIMITUSED.FBillType                                     AS BillType, ").append("CREDITLIMITUSED.FBillNumber                                   AS BillNumber, ").append("CLUSED_COMPANY.FNAME_").append(loc).append("                                        AS CreditLimitUsedCompany, ").append("ISNULL(USINGCOMPANY.FNAME_").append(loc).append(" , USINGBANK.FNAME_").append(loc).append(" )             AS UsingOrg, ").append("CREDITLIMITUSED.FUsedQuota/").append(this.unit).append("                                    AS UsedQuota, ").append("CREDITLIMITUSED.FReturnedQuota/").append(this.unit).append("                                AS ReturnQuota, ").append("(CREDITLIMITUSED.FUsedQuota - CREDITLIMITUSED.FReturnedQuota)/").append(this.unit).append(" AS UsingFactQuota, ").append("FINPRO.FNAME_").append(loc).append("  AS FinproName ").append(" FROM T_FIN_CreditLimit AS CREDITLIMIT  ").append(" LEFT OUTER JOIN    T_FIN_CreditLimitUsed AS CREDITLIMITUSED              ON         CREDITLIMITUSED.FCreditLimitId = CREDITLIMIT.FID  ").append(" LEFT OUTER JOIN    T_BD_Currency AS CURRENCY         ON         CREDITLIMIT.FCurrencyID = CURRENCY.FID  ").append(" LEFT OUTER JOIN    T_ORG_Company AS CLUSED_COMPANY         ON         CREDITLIMITUSED.FCompanyID = CLUSED_COMPANY.FID  ").append(" LEFT OUTER JOIN    T_BD_Bank AS USINGBANK         ON         CREDITLIMITUSED.FUsingBankID = USINGBANK.FID  ").append(" LEFT OUTER JOIN    T_FIN_CreditUsage AS CREDITUSAGE         ON         CREDITLIMIT.FCreditUsageID = CREDITUSAGE.FID  ").append(" LEFT OUTER JOIN    T_ORG_Company AS USINGCOMPANY         ON         CREDITLIMITUSED.FUsingCompanyID = USINGCOMPANY.FID  ").append(" LEFT OUTER JOIN    T_ORG_Company AS CREDITCOMPANY        ON         CREDITLIMIT.FCompanyID = CREDITCOMPANY.FID  ").append(" LEFT OUTER JOIN    T_ORG_Company AS CREDITCOMPANY1         ON         CREDITLIMIT.FcreditCompanyID = CREDITCOMPANY1.FID  ").append(" LEFT OUTER JOIN    T_BD_Bank AS CREDITINSTITUTION         ON         CREDITLIMIT.FCreditInstitutionId = CREDITINSTITUTION.FID  ").append(" LEFT OUTER JOIN    T_FIN_GuaranteeType AS GUARANTEETYPE         ON         CREDITLIMIT.FGuaranteeTypeID = GUARANTEETYPE.FID  ").append(" LEFT OUTER JOIN    T_FIN_FinancingProducts AS FINPRO   ON CREDITLIMITUSED.FFinProID = FINPRO.FID ");
        if (!this.params.isIncludeClose()) {
            sql.append(" WHERE CREDITLIMIT.FIsClosed = 0 ");
            sql.append(" AND CREDITLIMIT.FLimitType = 1 ");
        } else {
            sql.append(" WHERE CREDITLIMIT.FLimitType = 1 ");
        }
        if (!ContextHelperFactory.getRemoteInstance().isOnlyUnion(this.currentCompany) || this.companyIDs == null) {
            sql.append(" AND CREDITLIMIT.FCompanyID='").append(this.currentCompany.getId().toString()).append("' ");
        } else {
            sql.append(" AND ").append(FMHelper.buildIn((String)"CREDITLIMIT.FCompanyID", (Object[])this.companyIDs.toArray()));
        }
        if (this.params.getRelations() != null) {
            if (this.params.getRelations().equals((Object)LimitIsBankCreditEnum.INNER)) {
                if (this.params.getCompanyIDs() != null && this.params.getCompanyIDs().size() > 0) {
                    sql.append(" AND ").append(FMHelper.buildIn((String)"CREDITLIMIT.FcreditCompanyID", (Object[])this.params.getCompanyIDs().toArray()));
                }
                sql.append(" AND CREDITLIMIT.FCreditInstitutionId IS NULL ");
            } else {
                sql.append(" AND CREDITLIMIT.FcreditCompanyID IS NULL ");
                if (this.params.getRelations().equals((Object)LimitIsBankCreditEnum.TRUE)) {
                    sql.append(" AND CREDITINSTITUTION.FIsBank=1 ");
                } else {
                    sql.append(" AND CREDITINSTITUTION.FIsBank=0 ");
                }
                if (this.params.getBankIDs() != null && this.params.getBankIDs().size() > 0) {
                    sql.append(" AND ").append(FMHelper.buildIn((String)"CREDITLIMIT.FCreditInstitutionId", (Object[])this.params.getBankIDs().toArray()));
                }
            }
        }
        if (this.params.getStartDate() != null) {
            sql.append(" AND CREDITLIMIT.FIssueDate >={").append(FMConstants.FORMAT_DAY.format(this.params.getStartDate())).append("} ");
        }
        if (this.params.getEndDate() != null) {
            sql.append(" AND CREDITLIMIT.FIssueDate <={").append(FMConstants.FORMAT_DAY.format(this.params.getEndDate())).append("} ");
        }
        sql.append(" AND ((").append(" CREDITLIMITUSED.FBillType <> '18180D81' ");
        if (this.params.getCreditUsage() != null && this.params.getCreditUsage().length > 0) {
            sql.append(" AND ").append(FMHelper.buildIn((String)"CREDITLIMITUSED.FCreditUsageID", (Object[])this.params.getCreditUsage()));
        }
        if (!this.includeZero) {
            sql.append(" AND (CREDITLIMITUSED.FUsedQuota - CREDITLIMITUSED.FReturnedQuota)<>0 ");
        }
        sql.append(") OR   CREDITLIMITUSED.FID IS NULL) ");
        sql.append(" ORDER BY ");
        switch (this.params.getQueryType()) {
            case 1: {
                sql.append(" CREDITLIMIT.FCompanyID, ");
                break;
            }
            case 2: {
                sql.append(" CREDITLIMIT.FCreditInstitutionId, ");
                break;
            }
            case 3: {
                sql.append(" CREDITLIMIT.FCreditUsageID, ");
                break;
            }
            default: {
                sql.append(" CREDITLIMIT.FCompanyID, ");
            }
        }
        sql.append("CREDITLIMIT.FID,CREDITLIMITUSED.FBillType ,FINPRO.FNAME_l2");
        return sql.toString();
    }
}

