/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.client.FMDetailRptBaseHandler;
import com.kingdee.eas.fm.ctl.RptLetterOfGuaranteeDetailFacadeFactory;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;

public abstract class RptLetterOfCreditDetailBaseHandler
extends FMDetailRptBaseHandler {
    public static final String resourcePath = "com.kingdee.eas.fm.fin.client.RptLetterOfCreditDetailResource";
    private static String yes = EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"Yes");
    private static String no = EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"No");
    protected BigDecimal amountUnit = null;
    private HashMap GuaranteeMap = new HashMap();

    protected String getResString(String key) {
        return EASResource.getString((String)resourcePath, (String)key);
    }

    public RptLetterOfCreditDetailBaseHandler(FilterInfo filterInfo, SorterItemCollection sorter, KDTable kdt, AmountUnitEnum unit) {
        super(filterInfo, sorter, kdt);
        this.amountUnit = new BigDecimal(String.valueOf(unit.getValue()));
        try {
            this.GuaranteeMap = this.getGurantee();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public RptLetterOfCreditDetailBaseHandler(FilterInfo filterInfo, KDTable kdt, AmountUnitEnum unit) {
        super(filterInfo, kdt);
        this.amountUnit = new BigDecimal(String.valueOf(unit.getValue()));
        try {
            this.GuaranteeMap = this.getGurantee();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void endDataFill() {
        super.endDataFill();
        this.setMergeTotalValue();
    }

    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        super.filldata(rs);
        while (rs.next()) {
            String id = rs.getString("id");
            IRow row = this.kdt.addRow();
            DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
            SimpleDateFormat sdtformat = new SimpleDateFormat("yyyy-MM-dd");
            row.getCell("company").setValue((Object)rs.getString("company.name"));
            row.getCell("number").setValue((Object)rs.getString("number"));
            row.getCell("letterNumber").setValue((Object)rs.getString("letterNumber"));
            row.getCell("Beneficiary").setValue((Object)rs.getString("Beneficiary"));
            row.getCell("bank").setValue((Object)rs.getString("Institution.name"));
            row.getCell("currency").setValue((Object)rs.getString("Currency.name"));
            row.getCell("amount").setValue((Object)(rs.getBigDecimal("Amount") == null ? BigDecimal.ZERO : rs.getBigDecimal("Amount").divide(this.amountUnit, 10, 4)));
            row.getCell("exRate").setValue((Object)rs.getBigDecimal("LocalCurExRate"));
            row.getCell("amountLocal").setValue((Object)(rs.getBigDecimal("AmountLocalCur") == null ? BigDecimal.ZERO : rs.getBigDecimal("AmountLocalCur").divide(this.amountUnit, 10, 4)));
            try {
                if (EmptyUtil.isEmpty((String)rs.getString("IssueDate"))) {
                    row.getCell("issueDate").setValue(null);
                } else {
                    row.getCell("issueDate").setValue((Object)dtformat.format(sdtformat.parse(rs.getString("IssueDate"))));
                }
                if (EmptyUtil.isEmpty((String)rs.getString("ExpiredDate"))) {
                    row.getCell("expiredDate").setValue(null);
                } else {
                    row.getCell("expiredDate").setValue((Object)dtformat.format(sdtformat.parse(rs.getString("ExpiredDate"))));
                }
                if (EmptyUtil.isEmpty((String)rs.getString("intendPayDate"))) {
                    row.getCell("intendPayDate").setValue(null);
                } else {
                    row.getCell("intendPayDate").setValue((Object)dtformat.format(sdtformat.parse(rs.getString("intendPayDate"))));
                }
                if (EmptyUtil.isEmpty((String)rs.getString("repay.bizDate"))) {
                    row.getCell("repayDate").setValue(null);
                } else {
                    row.getCell("repayDate").setValue((Object)dtformat.format(sdtformat.parse(rs.getString("repay.bizDate"))));
                }
            }
            catch (ParseException e) {
                Logger.error((Throwable)e, (String)e.getMessage());
            }
            row.getCell("payBankAcct").setValue((Object)rs.getString("payBankAcct.name"));
            row.getCell("marginRate").setValue((Object)rs.getBigDecimal("marginRate"));
            row.getCell("limitMargin").setValue((Object)(rs.getBigDecimal("limitMargin") == null ? BigDecimal.ZERO : rs.getBigDecimal("limitMargin").divide(this.amountUnit, 10, 4)));
            row.getCell("marginCurrency").setValue((Object)rs.getString("marginCurrency.name"));
            row.getCell("marginAcct").setValue((Object)rs.getString("marginAcct.name"));
            BigDecimal marginEx = rs.getBigDecimal("marginEx");
            BigDecimal marginBalance = rs.getBigDecimal("marginBalance");
            if (marginEx != null && marginBalance != null) {
                BigDecimal marginRepay = marginEx.subtract(marginBalance);
                row.getCell("marginRepay").setValue((Object)marginRepay.divide(this.amountUnit, 10, 4));
            } else if (marginEx != null && marginBalance == null) {
                row.getCell("marginRepay").setValue((Object)marginEx.divide(this.amountUnit, 10, 4));
            }
            row.getCell("marginEx").setValue((Object)(marginEx == null ? BigDecimal.ZERO : marginEx.divide(this.amountUnit, 10, 4)));
            row.getCell("marginBalance").setValue((Object)(marginBalance == null ? BigDecimal.ZERO : marginBalance.divide(this.amountUnit, 10, 4)));
            BigDecimal repayAmount = rs.getBigDecimal("repay.LocalAmount");
            if (repayAmount != null) {
                row.getCell("repayAmountLocal").setValue((Object)repayAmount.divide(this.amountUnit, 10, 4));
            } else {
                repayAmount = new BigDecimal(0);
                row.getCell("repayAmountLocal").setValue((Object)repayAmount);
            }
            row.getCell("balanceLocal").setValue((Object)(rs.getBigDecimal("BalanceLocal") == null ? BigDecimal.ZERO : rs.getBigDecimal("BalanceLocal").divide(this.amountUnit, 10, 4)));
            row.getCell("gt").setValue((Object)rs.getString("GaranteeType.name"));
            row.getCell("guarantee").setValue(this.GuaranteeMap.get(rs.getString("id")));
            row.getCell("isInCredit").setValue((Object)(rs.getBoolean("IsInCredit") ? yes : no));
            row.setUserObject((Object)id);
        }
    }

    protected String getQueryPath() {
        return "com.kingdee.eas.fm.fin.app.RptLetterOfCreditDetailQuery";
    }

    protected void formatHeadRow() {
        IRow headRow = this.kdt.addHeadRow();
        headRow.getCell("company").setValue((Object)this.getResString("company"));
        headRow.getCell("bank").setValue((Object)this.getResString("bank"));
        headRow.getCell("number").setValue((Object)this.getResString("number"));
        headRow.getCell("letterNumber").setValue((Object)this.getResString("letterNumber"));
        headRow.getCell("Beneficiary").setValue((Object)this.getResString("Beneficiary"));
        headRow.getCell("currency").setValue((Object)this.getResString("currency"));
        headRow.getCell("amount").setValue((Object)this.getResString("amount"));
        headRow.getCell("exRate").setValue((Object)this.getResString("exRate"));
        headRow.getCell("amountLocal").setValue((Object)this.getResString("amountLocal"));
        headRow.getCell("payBankAcct").setValue((Object)this.getResString("payBankAcct"));
        headRow.getCell("marginRate").setValue((Object)this.getResString("marginRate"));
        headRow.getCell("limitMargin").setValue((Object)this.getResString("limitMargin"));
        headRow.getCell("marginCurrency").setValue((Object)this.getResString("marginCurrency"));
        headRow.getCell("marginEx").setValue((Object)this.getResString("marginEx"));
        headRow.getCell("marginAcct").setValue((Object)this.getResString("marginAcct"));
        headRow.getCell("marginRepay").setValue((Object)this.getResString("marginRepay"));
        headRow.getCell("marginBalance").setValue((Object)this.getResString("marginBalance"));
        headRow.getCell("issueDate").setValue((Object)this.getResString("issueDate"));
        headRow.getCell("expiredDate").setValue((Object)this.getResString("expiredDate_new"));
        headRow.getCell("intendPayDate").setValue((Object)this.getResString("intendPayDate"));
        headRow.getCell("repayDate").setValue((Object)this.getResString("repayDate"));
        headRow.getCell("repayAmountLocal").setValue((Object)this.getResString("repayAmountLocal"));
        headRow.getCell("balanceLocal").setValue((Object)this.getResString("balanceLocal"));
        headRow.getCell("gt").setValue((Object)this.getResString("gt"));
        headRow.getCell("guarantee").setValue((Object)this.getResString("guarantee"));
        headRow.getCell("isInCredit").setValue((Object)this.getResString("isInCredit"));
    }

    protected abstract void insertHeadRow();

    protected void insertHeadRow2() {
        IColumn letterNumber = this.kdt.addColumn();
        letterNumber.setKey("letterNumber");
        letterNumber.setGroup(true);
        IColumn beneficiary = this.kdt.addColumn();
        beneficiary.setKey("Beneficiary");
        beneficiary.setGroup(true);
    }

    public void initHeader() {
        super.initHeader();
        this.insertHeadRow();
        this.formatHeadRow();
    }

    protected static void initDecimalCol(IColumn col) {
        col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        col.getStyleAttributes().setNumberFormat("##,###,###,###,###,##0.00");
    }

    protected static void initDecimalCol4Pre(IColumn col) {
        col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        col.getStyleAttributes().setNumberFormat("##,###,###,###,###,##0.00");
    }

    protected static void initDecimalCell(ICell cell) {
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        cell.getStyleAttributes().setNumberFormat("##,###,###,###,###,##0.00");
    }

    protected void setMergeTotalValue() {
        BigDecimal amountLocalSubTotal = new BigDecimal(String.valueOf(0));
        BigDecimal amountLocalTotal = new BigDecimal(String.valueOf(0));
        BigDecimal balanceLocalSubTotal = new BigDecimal(String.valueOf(0));
        BigDecimal balanceLocalTotal = new BigDecimal(String.valueOf(0));
        int n = this.kdt.getRowCount();
        if (this.kdt.getRow(0) != null) {
            IRow firstRow = this.kdt.getRow(0);
            BigDecimal amountLocalTemp = new BigDecimal(firstRow.getCell("amountLocal").getValue().toString());
            BigDecimal balanceLocalTemp = new BigDecimal(firstRow.getCell("balanceLocal").getValue().toString());
            amountLocalSubTotal = amountLocalSubTotal.add(amountLocalTemp);
            amountLocalTotal = amountLocalTotal.add(amountLocalTemp);
            balanceLocalSubTotal = balanceLocalSubTotal.add(balanceLocalTemp);
            balanceLocalTotal = balanceLocalTotal.add(balanceLocalTemp);
            for (int i = 1; i < n; ++i) {
                IRow iRow = this.kdt.getRow(i);
                Object s = null;
                if (iRow.getCell(2).getValue() != null) {
                    String s1 = iRow.getCell(2).getValue().toString();
                    String s2 = iRow.getUserObject().toString();
                    amountLocalTemp = new BigDecimal(iRow.getCell("amountLocal").getValue().toString());
                    balanceLocalTemp = new BigDecimal(iRow.getCell("balanceLocal").getValue().toString());
                    Object s3 = this.kdt.getRow(i - 1).getCell(2).getValue();
                    Object s4 = this.kdt.getRow(i - 1).getUserObject();
                    if (s3 != null && s4.equals(s2)) continue;
                    amountLocalSubTotal = amountLocalSubTotal.add(amountLocalTemp);
                    amountLocalTotal = amountLocalTotal.add(amountLocalTemp);
                    balanceLocalSubTotal = balanceLocalSubTotal.add(balanceLocalTemp);
                    balanceLocalTotal = balanceLocalTotal.add(balanceLocalTemp);
                    continue;
                }
                Object s5 = this.kdt.getRow(i - 1).getCell(2).getValue();
                if (this.kdt.getRow(i - 2) == null) continue;
                Object s6 = this.kdt.getRow(i - 2).getCell(2).getValue();
                if (s5 != null) continue;
                iRow.getCell("amountLocal").setValue((Object)amountLocalSubTotal);
                iRow.getCell("balanceLocal").setValue((Object)balanceLocalSubTotal);
                amountLocalSubTotal = new BigDecimal(String.valueOf(0));
                balanceLocalSubTotal = new BigDecimal(String.valueOf(0));
                if (s6 != null) continue;
                iRow.getCell("amountLocal").setValue((Object)amountLocalTotal);
                iRow.getCell("balanceLocal").setValue((Object)balanceLocalTotal);
            }
        }
    }

    public HashMap getGurantee() throws BOSException {
        HashMap GuaranteeMap = RptLetterOfGuaranteeDetailFacadeFactory.getRemoteInstance().ReturnGuarantee(this.filterInfo, this.sorter, "t_fin_letterofcredit", this.getQueryPath());
        return GuaranteeMap;
    }
}

