/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.RptLetterOfCreditDetailFilterParam;
import com.kingdee.eas.fm.fin.client.AbstractRptLetterOfCreditDetailFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.sql.Date;

public class RptLetterOfCreditDetailFilterUI
extends AbstractRptLetterOfCreditDetailFilterUI {
    public static final String RESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";

    public Object getParam() {
        RptLetterOfCreditDetailFilterParam param = new RptLetterOfCreditDetailFilterParam();
        param.setCompanyIdSet(this.getCompanyIdSet());
        param.setAmount(this.txtAmount.getBigDecimalValue());
        param.setBankIdSet(this.getIdSetFromF7(this.prmtBank));
        if (this.dpBegin.getValue() != null) {
            param.setDateFrom(this.dpBegin.getSqlDate());
        }
        if (this.dpEnd.getValue() != null) {
            param.setDateTo(this.dpEnd.getSqlDate());
        }
        param.setUnit((AmountUnitEnum)this.comboUnit.getSelectedItem());
        param.setDimType(this.kDButtonGroupDim.getValue() + 1);
        return param;
    }

    protected Class getParamClass() {
        return RptLetterOfCreditDetailFilterParam.class;
    }

    protected boolean isNeedEachSerializable() {
        return true;
    }

    public void setParam(Object param) {
        RptLetterOfCreditDetailFilterParam lcParam = (RptLetterOfCreditDetailFilterParam)param;
        this.setCompanyIdSet(lcParam.getCompanyIdSet());
        this.txtAmount.setValue((Object)lcParam.getAmount());
        try {
            this.prmtBank.setData((Object)this.getBaseInfoFromIdSet(lcParam.getBankIdSet()));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.dpBegin.setValue((Object)lcParam.getDateFrom());
        this.dpEnd.setValue((Object)lcParam.getDateTo());
        FMClientHelper.setSelectObject((KDComboBox)this.comboUnit, (Object)lcParam.getUnit());
        this.kDButtonGroupDim.setValue(lcParam.getDimType() - 1);
    }

    protected void init() throws Exception {
        super.init();
        this.doInit();
    }

    public void clear() {
        super.clear();
        this.doInit();
    }

    protected void doInit() {
        this.dpBegin.setSupportedEmpty(false);
        this.dpEnd.setSupportedEmpty(false);
        this.prmtBank.setEditable(true);
        this.initFirstDayOfMonth(this.dpBegin);
        this.initLastDayOfMonth(this.dpEnd);
        this.txtAmount.setSupportedEmpty(true);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmount);
        this.txtAmount.setPrecision(2);
        this.txtAmount.setValue((Object)Constants.TEN);
        this.prmtBank.setData(null);
        FMClientHelper.setSelectObject((KDComboBox)this.comboUnit, (Object)AmountUnitEnum.wan_yuan);
        this.kDButtonGroupDim.setValue(0);
    }

    private void initFirstDayOfMonth(KDDatePicker kdDate) {
        this.dpBegin.setValue((Object)DateUtil.getFirstDayOfCurYear());
    }

    private void initLastDayOfMonth(KDDatePicker kdDate) {
        kdDate.setValue((Object)DateUtil.getDayBegin());
    }

    public boolean verify() {
        Date startDate = this.dpBegin.getSqlDate();
        Date endDate = this.dpEnd.getSqlDate();
        if (startDate == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"StartDateIsNull"));
            SysUtil.abort();
        }
        if (endDate == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"EndDateIsNull"));
            SysUtil.abort();
        }
        if (startDate.compareTo(endDate) > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"CreditLimitFilterDateCompare"));
            SysUtil.abort();
        }
        return super.verify();
    }
}

