/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.LoanBalanceDetailsQueryTypeEnum;
import com.kingdee.eas.fm.fin.RelationWithDebteeEnum;
import com.kingdee.eas.fm.fin.RptLoanBalanceDetailsParam;
import com.kingdee.eas.fm.fin.RptLoanBalanceDetailsUnitEnum;
import com.kingdee.eas.fm.fin.client.AbstractRptLoanBalanceDetailsFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Date;
import org.apache.log4j.Logger;

public class RptLoanBalanceDetailsFilterUI
extends AbstractRptLoanBalanceDetailsFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RptLoanBalanceDetailsFilterUI.class);
    private CompanyOrgUnitInfo currentCompany = null;
    public static final String resourcePath = "com.kingdee.eas.fm.fin.client.RptLoanBalanceDetailResource";

    public CompanyOrgUnitInfo getCurrentCompany() {
        if (null == this.currentCompany) {
            this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        }
        return this.currentCompany;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void init() throws Exception {
        this.jtCurrency.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
        this.jtCurrency.setDisplayFormat("$name$");
        this.jtCurrency.setCommitFormat("$number$");
        this.jtCurrency.setEditFormat("$name$");
        this.jtCurrency.setEnabledMultiSelection(true);
        this.jtCurrency.setData(null);
        this.jtEndDate.setValue((Object)new Date());
        boolean isVirtualBody = this.isVirtualBody();
        if (isVirtualBody) {
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        } else {
            this.btnCompanySelect.setEnabled(false);
            this.btnCompanySelect.setVisible(false);
        }
        if (!isVirtualBody) {
            this.jrbCompanyDebtee.setEnabled(false);
            this.jrbDebteeCompany.setEnabled(false);
            this.jrbDebtee.setSelected(true);
        } else {
            this.jrbCompanyDebtee.setEnabled(true);
            this.jrbDebteeCompany.setEnabled(true);
            this.jrbCompanyDebtee.setSelected(true);
        }
        this.jtDebteeRelations.setSelectedItem((Object)RelationWithDebteeEnum.All);
        this.jtDebtee.setData(null);
        this.jtAmountUnit.setSelectedItem((Object)RptLoanBalanceDetailsUnitEnum.TEN_THOUSAND);
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    public Object getParam() {
        int i;
        CompanyOrgUnitInfo[] orgInfos;
        Object[] debtees;
        RptLoanBalanceDetailsParam param = new RptLoanBalanceDetailsParam();
        param.setEndDate(this.jtEndDate.getSqlDate());
        param.setDebteeRelations((RelationWithDebteeEnum)((Object)this.jtDebteeRelations.getSelectedItem()));
        if (null != this.jtDebtee.getData() && RelationWithDebteeEnum.InGroup.equals((Object)param.getDebteeRelations())) {
            debtees = (Object[])this.jtDebtee.getData();
            orgInfos = new CompanyOrgUnitInfo[debtees.length];
            for (i = 0; i < debtees.length; ++i) {
                orgInfos[i] = (CompanyOrgUnitInfo)debtees[i];
            }
            param.setDebteeOrg(orgInfos);
        } else if (null != this.jtDebtee.getData() && RelationWithDebteeEnum.OutGroup.equals((Object)param.getDebteeRelations())) {
            debtees = (Object[])this.jtDebtee.getData();
            orgInfos = new BankInfo[debtees.length];
            for (i = 0; i < debtees.length; ++i) {
                orgInfos[i] = (BankInfo)debtees[i];
            }
            param.setDebteeBankInfo((BankInfo[])orgInfos);
        }
        Object[] obj = (Object[])this.jtCurrency.getData();
        if (null == obj) {
            param.setSelectedAllCurrency(true);
            try {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                CurrencyCollection currencyColl = iCurrency.getCurrencyCollection(true);
                obj = currencyColl.toArray();
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        } else {
            param.setSelectedAllCurrency(false);
        }
        CurrencyInfo[] currencyInfos = new CurrencyInfo[obj.length];
        for (int i2 = 0; i2 < obj.length; ++i2) {
            currencyInfos[i2] = (CurrencyInfo)obj[i2];
        }
        param.setCurrencys(currencyInfos);
        param.setAmountUnit((RptLoanBalanceDetailsUnitEnum)((Object)this.jtAmountUnit.getSelectedItem()));
        if (this.jrbCompanyDebtee.isSelected()) {
            param.setQueryType(LoanBalanceDetailsQueryTypeEnum.CompanyDebtee);
        } else if (this.jrbDebteeCompany.isSelected()) {
            param.setQueryType(LoanBalanceDetailsQueryTypeEnum.DebteeCompany);
        } else if (this.jrbDebtee.isSelected()) {
            param.setQueryType(LoanBalanceDetailsQueryTypeEnum.Debtee);
        } else if (this.jrbCurrency.isSelected()) {
            param.setQueryType(LoanBalanceDetailsQueryTypeEnum.Currency);
        } else if (this.jrbFinancingType.isSelected()) {
            param.setQueryType(LoanBalanceDetailsQueryTypeEnum.FinancingType);
        } else if (this.jrbAmountRange.isSelected()) {
            param.setQueryType(LoanBalanceDetailsQueryTypeEnum.AmountRange);
        } else if (this.jrbVouchType.isSelected()) {
            param.setQueryType(LoanBalanceDetailsQueryTypeEnum.VouchType);
        }
        if (!this.isVirtualBody()) {
            param.setCompanyIds(new String[]{this.getCurrentCompany().getId().toString()});
        } else {
            param.setCompanyIds(this.companyIds);
        }
        return param;
    }

    public void setParam(Object p) {
        RptLoanBalanceDetailsParam param = (RptLoanBalanceDetailsParam)p;
        this.jtEndDate.setValue((Object)param.getEndDate());
        this.jtDebteeRelations.setSelectedItem((Object)param.getDebteeRelations());
        if (RelationWithDebteeEnum.InGroup.equals((Object)param.getDebteeRelations())) {
            this.jtDebtee.setData((Object)param.getDebteeOrg());
        } else if (RelationWithDebteeEnum.OutGroup.equals((Object)param.getDebteeRelations())) {
            this.jtDebtee.setData((Object)param.getDebteeBankInfo());
        } else {
            this.jtDebtee.setData(null);
        }
        if (param.isSelectedAllCurrency()) {
            this.jtCurrency.setData(null);
        } else {
            this.jtCurrency.setData((Object)param.getCurrencys());
        }
        this.jtAmountUnit.setSelectedItem((Object)param.getAmountUnit());
        if (LoanBalanceDetailsQueryTypeEnum.CompanyDebtee.equals((Object)param.getQueryType())) {
            this.jrbCompanyDebtee.setSelected(true);
        } else if (LoanBalanceDetailsQueryTypeEnum.DebteeCompany.equals((Object)param.getQueryType())) {
            this.jrbDebteeCompany.setSelected(true);
        } else if (LoanBalanceDetailsQueryTypeEnum.Debtee.equals((Object)param.getQueryType())) {
            this.jrbDebtee.setSelected(true);
        } else if (LoanBalanceDetailsQueryTypeEnum.Currency.equals((Object)param.getQueryType())) {
            this.jrbCurrency.setSelected(true);
        } else if (LoanBalanceDetailsQueryTypeEnum.FinancingType.equals((Object)param.getQueryType())) {
            this.jrbFinancingType.setSelected(true);
        } else if (LoanBalanceDetailsQueryTypeEnum.AmountRange.equals((Object)param.getQueryType())) {
            this.jrbAmountRange.setSelected(true);
        } else if (LoanBalanceDetailsQueryTypeEnum.VouchType.equals((Object)param.getQueryType())) {
            this.jrbAmountRange.setSelected(true);
        }
        this.companyIds = param.getCompanyIds();
    }

    public boolean verify() {
        if (null == this.jtEndDate.getSqlDate()) {
            MsgBox.showWarning((Component)this.jtEndDate, (String)EASResource.getString((String)resourcePath, (String)"endDateCannotBeBlank"));
            SysUtil.abort();
        }
        if (this.isVirtualBody() && this.companyIds == null) {
            MsgBox.showWarning((Component)this.jtEndDate, (String)EASResource.getString((String)resourcePath, (String)"selectCompany"));
            SysUtil.abort();
        }
        return super.verify();
    }

    public void clear() {
        super.clear();
        try {
            this.init();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    protected void jtDebtee_willShow(SelectorEvent e) throws Exception {
    }

    @Override
    protected void jtDebteeRelations_itemStateChanged(ItemEvent e) throws Exception {
        if (RelationWithDebteeEnum.InGroup.equals(this.jtDebteeRelations.getSelectedItem())) {
            this.jtDebtee.setSelector(null);
            this.jtDebtee.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
            this.jtDebtee.setEntityViewInfo(FinUtils.getPrmtGroupF7Filter());
            this.jtDebtee.setEnabled(true);
            this.jtDebtee.setData(null);
        } else if (RelationWithDebteeEnum.OutGroup.equals(this.jtDebteeRelations.getSelectedItem())) {
            this.jtDebtee.setSelector(null);
            this.jtDebtee.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7BankQuery");
            F7SelectorFactory.initBankTree((IUIObject)this, (KDBizPromptBox)this.jtDebtee);
            this.jtDebtee.setEnabled(true);
            this.jtDebtee.setData(null);
        } else {
            this.jtDebtee.setEnabled(false);
            this.jtDebtee.setData(null);
        }
        this.jtDebtee.setDisplayFormat("$name$");
        this.jtDebtee.setEditFormat("$number$");
        this.jtDebtee.setCommitFormat("$number$");
        this.jtDebtee.setEnabledMultiSelection(true);
    }

    public boolean isVirtualBody() {
        try {
            return ContextHelperFactory.getRemoteInstance().isOnlyUnion(this.getCurrentCompany());
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            return false;
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            return false;
        }
    }

    protected Class getParamClass() {
        return RptLoanBalanceDetailsParam.class;
    }
}

