/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.RptLoanRepaymentDetailFilterParam;
import com.kingdee.eas.fm.fin.client.IRptLoanRepaymentDetailHandler;
import com.kingdee.eas.framework.report.util.CellMatrix;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.List;

public abstract class RptLoanRepaymentDetailHandlerBase
implements IRptLoanRepaymentDetailHandler {
    public static final String resourcePath = "com.kingdee.eas.fm.fin.client.RptLoanRepaymentResource";
    protected RptLoanRepaymentDetailFilterParam filterParam = null;
    protected KDTable kdt = null;
    protected BigDecimal LocalLoanRepaymentAmountTotal = SysConstant.BIGZERO;
    protected BigDecimal LocalLoanAmountTotal = SysConstant.BIGZERO;
    protected BigDecimal LocalLoanBalanceTotal = SysConstant.BIGZERO;
    protected int amountUnit;

    public RptLoanRepaymentDetailHandlerBase(RptLoanRepaymentDetailFilterParam param, KDTable kdt) {
        this.filterParam = param;
        this.kdt = kdt;
    }

    @Override
    public void initHeader() {
        this.kdt.removeRows();
        this.kdt.removeHeadRows();
        this.kdt.removeColumns();
        this.kdt.getGroupManager().removeGroup();
        this.kdt.setEditable(false);
        this.kdt.getGroupManager().setGroup(true);
        this.kdt.getGroupManager().setOrientation(1);
    }

    protected String getResString(String key) {
        return EASResource.getString((String)resourcePath, (String)key);
    }

    @Override
    public IRowSet getRowSet() throws BOSException {
        IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.fin.RptLoanRepaymentDetailQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(this.filterParam.getFilter());
        ev.getSorter().addObjectCollection((IObjectCollection)this.filterParam.getSorterItems());
        exec.setObjectView(ev);
        return exec.executeQuery();
    }

    protected void initHeadRows() {
        IRow headRow = this.kdt.addHeadRow();
        headRow.getCell("PlanRepaymentDate").setValue((Object)this.getResString("PlanRepaymentDate"));
        headRow.getCell("Currency").setValue((Object)this.getResString("Currency"));
        headRow.getCell("RepaymentNO").setValue((Object)this.getResString("RepaymentNO"));
        headRow.getCell("Company").setValue((Object)this.getResString("Company"));
        headRow.getCell("LoanAmount").setValue((Object)this.getResString("LoanAmount"));
        headRow.getCell("LoanLocalAmount").setValue((Object)this.getResString("LoanLocalAmount"));
        headRow.getCell("RepaymentAmount").setValue((Object)this.getResString("RepaymentAmount"));
        headRow.getCell("LocalRepaymentAmount").setValue((Object)this.getResString("LocalRepaymentAmount"));
        headRow.getCell("LoanBalance").setValue((Object)this.getResString("LoanBalance"));
        headRow.getCell("LoanLocalBalance").setValue((Object)this.getResString("LoanLocalBalance"));
    }

    @Override
    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        this.kdt.getColumn("PlanRepaymentDate").getStyleAttributes().setNumberFormat(FMHelper.getDateFormatString());
        this.kdt.getColumn("LoanAmount").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)2));
        this.kdt.getColumn("LoanLocalAmount").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)2));
        this.kdt.getColumn("RepaymentAmount").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)2));
        this.kdt.getColumn("LocalRepaymentAmount").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)2));
        this.kdt.getColumn("LoanBalance").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)2));
        this.kdt.getColumn("LoanLocalBalance").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)2));
        this.amountUnit = this.filterParam.getUnit().getValue();
        this.LocalLoanRepaymentAmountTotal = SysConstant.BIGZERO;
        this.LocalLoanAmountTotal = SysConstant.BIGZERO;
        this.LocalLoanBalanceTotal = SysConstant.BIGZERO;
        this.kdt.setRefresh(false);
        while (rs.next()) {
            IRow row = this.kdt.addRow();
            this.LocalLoanRepaymentAmountTotal = this.LocalLoanRepaymentAmountTotal.add(rs.getBigDecimal("LocalAmount").divide(new BigDecimal(String.valueOf(this.amountUnit)), 10, 4));
            if (this.LocalLoanAmountTotal.signum() == 0) {
                this.LocalLoanAmountTotal = this.LocalLoanAmountTotal.add(rs.getBigDecimal("Loan.LocalAmount").divide(new BigDecimal(String.valueOf(this.amountUnit)), 10, 4));
                this.LocalLoanBalanceTotal = this.LocalLoanBalanceTotal.add(rs.getBigDecimal("Loan.LocalBalance").divide(new BigDecimal(String.valueOf(this.amountUnit)), 10, 4));
            }
            row.getCell("PlanRepaymentDate").setValue((Object)rs.getString("bizDate"));
            row.getCell("Currency").setValue((Object)rs.getString("Currency.name"));
            row.getCell("RepaymentNO").setValue((Object)rs.getString("Repaymentnumber"));
            row.getCell("Company").setValue((Object)rs.getString("company.name"));
            row.getCell("LoanAmount").setValue((Object)rs.getBigDecimal("Loan.Amount").divide(new BigDecimal(String.valueOf(this.amountUnit)), 10, 4));
            row.getCell("LoanLocalAmount").setValue((Object)rs.getBigDecimal("Loan.LocalAmount").divide(new BigDecimal(String.valueOf(this.amountUnit)), 10, 4));
            row.getCell("RepaymentAmount").setValue((Object)rs.getBigDecimal("Amount").divide(new BigDecimal(String.valueOf(this.amountUnit)), 10, 4));
            row.getCell("LocalRepaymentAmount").setValue((Object)rs.getBigDecimal("LocalAmount").divide(new BigDecimal(String.valueOf(this.amountUnit)), 10, 4));
            row.getCell("LoanBalance").setValue((Object)rs.getBigDecimal("Loan.Balance").divide(new BigDecimal(String.valueOf(this.amountUnit)), 10, 4));
            row.getCell("LoanLocalBalance").setValue((Object)rs.getBigDecimal("Loan.LocalBalance").divide(new BigDecimal(String.valueOf(this.amountUnit)), 10, 4));
        }
        this.kdt.setRefresh(true);
        this.kdt.repaint();
        this.kdt.getGroupManager().group();
        this.kdt.getGroupManager().setGroup(false);
        Object[][] cc = new Object[][]{new Object[this.kdt.getRowCount()], new Object[this.kdt.getRowCount()]};
        int n = cc[0].length;
        for (int i = 0; i < n; ++i) {
            cc[0][i] = this.kdt.getCell(i, 4).getValue();
            cc[0][i] = this.kdt.getCell(i, 5).getValue();
        }
        List mergeListFirst = CellMatrix.parseAutoMatchMergeRegion((Object[][])cc, (boolean)true, (boolean)false, (boolean)false);
        int n2 = mergeListFirst.size();
        for (int i = 0; i < n2; ++i) {
            int[] r = (int[])mergeListFirst.get(i);
            this.kdt.getMergeManager().mergeBlock(r[0], r[1] + 4, r[2], r[3] + 4);
        }
        Object[][] dd = new Object[][]{new Object[this.kdt.getRowCount()], new Object[this.kdt.getRowCount()]};
        int n3 = dd[0].length;
        for (int i = 0; i < n3; ++i) {
            dd[0][i] = this.kdt.getCell(i, 8).getValue();
            dd[0][i] = this.kdt.getCell(i, 9).getValue();
        }
        List mergeListSecondly = CellMatrix.parseAutoMatchMergeRegion((Object[][])dd, (boolean)true, (boolean)false, (boolean)false);
        int n4 = mergeListSecondly.size();
        for (int i = 0; i < n4; ++i) {
            int[] r = (int[])mergeListSecondly.get(i);
            this.kdt.getMergeManager().mergeBlock(r[0], r[1] + 8, r[2], r[3] + 8);
        }
    }

    @Override
    public void insertAbsractFlowRow() {
        String text = this.getResString("AllLocalLoanRepaymentAmount");
        IRow row = this.kdt.addRow();
        row.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        row.getCell("LoanLocalAmount").setValue((Object)this.LocalLoanAmountTotal);
        row.getCell("LocalRepaymentAmount").setValue((Object)this.LocalLoanRepaymentAmountTotal);
        row.getCell("LoanLocalBalance").setValue((Object)this.LocalLoanBalanceTotal);
        int r = this.kdt.getRowCount() - 1;
        this.kdt.getMergeManager().mergeBlock(r, 0, r, 4);
        row.getCell(0).setValue((Object)text);
        row.getCell(0).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
    }
}

