/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fin.CycleTypeEnum;
import com.kingdee.eas.fm.fin.FinClientHelper;
import com.kingdee.eas.fm.fin.LoanPropertyEnum;
import com.kingdee.eas.fm.fin.RptRepaymentDetailFilterParam;
import com.kingdee.eas.fm.fin.client.AbstractRptRepaymentFilterUI_Bond;
import com.kingdee.eas.fm.nt.client.util.ChequeUtil;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.Date;

public class RptRepaymentFilterUI_Bond
extends AbstractRptRepaymentFilterUI_Bond {
    public RptRepaymentFilterUI_Bond() throws Exception {
        F7SelectorFactory.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtLoaner);
        this.btnCompanySelect.setVisible(true);
    }

    public Object getParam() {
        RptRepaymentDetailFilterParam param = new RptRepaymentDetailFilterParam();
        param.setCurrentDate(DateTimeUtils.truncateDate((Date)this.dpCurrentDate.getSqlDate()));
        param.setCompanyIdSet(this.getCompanyIdSet());
        param.setTimeType((CycleTypeEnum)((Object)this.jtTimeType.getSelectedItem()));
        param.setTimeNumber(this.jtTime.getIntegerVlaue());
        param.setAmount(this.jtAmount.getBigDecimalValue());
        param.setUnit((AmountUnitEnum)this.jtAmountUnit.getSelectedItem());
        Object selectedItem = this.comboLoanProperty.getSelectedItem();
        if (selectedItem instanceof LoanPropertyEnum) {
            param.setLoanProperty((LoanPropertyEnum)((Object)selectedItem));
        } else {
            param.setLoanProperty(null);
        }
        param.setProjectIds(FMHelper.asSet((String[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtProject)));
        param.setFinancingProductIds(FMHelper.asSet((String[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtFinancingProducts)));
        if (param.getLoanProperty() == LoanPropertyEnum.InGroup) {
            param.setLoanerIds(FMHelper.asSet((String[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtLoaner)));
        } else {
            param.setLoanerIds(FMHelper.asSet((String[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtLoaner)));
        }
        param.setForcastType(this.comboForcastType.getSelectedIndex());
        param.setContainBond(this.kDCheckBoxIsContainBond.isSelected());
        return param;
    }

    public void setParam(Object param) {
        RptRepaymentDetailFilterParam newparam = (RptRepaymentDetailFilterParam)param;
        this.dpCurrentDate.setValue((Object)DateTimeUtils.truncateDate((Date)newparam.getCurrentDate()));
        this.setCompanyIdSet(newparam.getCompanyIdSet());
        FMClientHelper.setSelectObject((KDComboBox)this.jtTimeType, (Object)((Object)newparam.getTimeType()));
        this.jtTime.setValue((Object)newparam.getTimeNumber());
        this.jtAmount.setValue((Object)newparam.getAmount());
        FMClientHelper.setSelectObject((KDComboBox)this.jtAmountUnit, (Object)newparam.getUnit());
        this.comboForcastType.setSelectedIndex(newparam.getForcastType());
        this.kDCheckBoxIsContainBond.setSelected(newparam.isContainBond());
        if (newparam.getLoanProperty() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboLoanProperty, (Object)((Object)newparam.getLoanProperty()));
        } else if (newparam.isContainBond()) {
            this.comboLoanProperty.setSelectedItem(null);
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.comboLoanProperty, (Object)FMSysDefinedEnum.SELECT_ALL);
        }
        try {
            this.prmtFinancingProducts.setData((Object)this.getBaseInfoFromIdSet(newparam.getFinancingProductIds()));
            this.prmtProject.setData((Object)this.getBaseInfoFromIdSet(newparam.getProjectIds()));
            this.prmtLoaner.setData((Object)this.getBaseInfoFromIdSet(newparam.getLoanerIds()));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    protected void init() throws Exception {
        super.init();
        this.dpCurrentDate.setSupportedEmpty(false);
        this.jtTimeType.setSelectedItem((Object)CycleTypeEnum.MONTH);
        this.jtTime.setValue((Object)new Integer(3));
        FMClientHelper.setSelectObject((KDComboBox)this.jtAmountUnit, (Object)AmountUnitEnum.wan_yuan);
        this.jtAmount.setSupportedEmpty(true);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.jtAmount);
        this.jtAmount.setPrecision(2);
        this.jtAmount.setValue((Object)new BigDecimal("10.00"));
        this.comboLoanProperty.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        FMClientHelper.setSelectObject((KDComboBox)this.comboLoanProperty, (Object)((Object)LoanPropertyEnum.OutGroup));
        this.comboForcastType.setSelectedIndex(0);
        this.kDCheckBoxIsContainBond.setSelected(false);
    }

    public boolean verify() {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)currentCompany) && this.getCompanyIdSet().size() <= 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"406_RptGrantCreditFundFilterUI"));
            SysUtil.abort();
            return false;
        }
        FMClientVerifyHelper.verifyFilterCompanyIdSet((FMFilterBaseUI)this);
        return super.verify();
    }

    @Override
    protected void jtTimeType_itemStateChanged(ItemEvent e) throws Exception {
        CycleTypeEnum obj = (CycleTypeEnum)((Object)this.jtTimeType.getSelectedItem());
        if (obj.getName().equals(CycleTypeEnum.YEAR.getName())) {
            SpinnerUtil.manageAccountLevelRange((int)1, (int)100, (KDSpinner)this.jtTime, (KDSpinner)this.jtTime);
            this.jtTime.setValue((Object)new Integer(1));
        } else if (obj.getName().equals(CycleTypeEnum.QUARTER.getName())) {
            SpinnerUtil.manageAccountLevelRange((int)1, (int)4, (KDSpinner)this.jtTime, (KDSpinner)this.jtTime);
            this.jtTime.setValue((Object)new Integer(1));
        } else if (obj.getName().equals(CycleTypeEnum.MONTH.getName())) {
            SpinnerUtil.manageAccountLevelRange((int)1, (int)12, (KDSpinner)this.jtTime, (KDSpinner)this.jtTime);
            this.jtTime.setValue((Object)new Integer(3));
        } else {
            SpinnerUtil.manageAccountLevelRange((int)1, (int)54, (KDSpinner)this.jtTime, (KDSpinner)this.jtTime);
            this.jtTime.setValue((Object)new Integer(4));
        }
    }

    @Override
    protected void comboLoanProperty_itemStateChanged(ItemEvent e) throws Exception {
        super.comboLoanProperty_itemStateChanged(e);
        this.prmtLoaner.setValue(null);
        Object value = this.comboLoanProperty.getSelectedItem();
        if (value instanceof LoanPropertyEnum) {
            LoanPropertyEnum enumeration = (LoanPropertyEnum)((Object)value);
            if (enumeration == LoanPropertyEnum.OutGroup) {
                F7SelectorFactory.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtLoaner);
                this.prmtLoaner.setEnabled(true);
            } else if (enumeration == LoanPropertyEnum.InGroup) {
                ChequeUtil.initCompanyOrgF7((IUIObject)this, (KDBizPromptBox)this.prmtLoaner);
                this.prmtLoaner.setEnabled(true);
            }
        } else {
            this.prmtLoaner.setEnabled(false);
        }
    }

    @Override
    protected void kDCheckBoxIsContainBond_itemStateChanged(ItemEvent e) throws Exception {
        if (this.kDCheckBoxIsContainBond.isSelected()) {
            this.comboLoanProperty.setEnabled(false);
            this.comboLoanProperty.setSelectedItem(null);
            this.prmtLoaner.setEnabled(false);
            this.prmtLoaner.setValue(null);
        } else {
            this.comboLoanProperty.setEnabled(true);
            this.comboLoanProperty.setSelectedIndex(0);
            this.prmtLoaner.setEnabled(true);
        }
        super.kDCheckBoxIsContainBond_itemStateChanged(e);
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        FMClientHelper.setSelectObject((KDComboBox)this.comboLoanProperty, (Object)((Object)LoanPropertyEnum.OutGroup));
        this.dpCurrentDate.setSupportedEmpty(false);
        this.jtTimeType.setSelectedItem((Object)CycleTypeEnum.MONTH);
        this.jtTime.setValue((Object)new Integer(3));
        FMClientHelper.setSelectObject((KDComboBox)this.jtAmountUnit, (Object)AmountUnitEnum.wan_yuan);
        this.jtAmount.setSupportedEmpty(true);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.jtAmount);
        this.jtAmount.setPrecision(2);
        this.jtAmount.setValue((Object)new BigDecimal("10.00"));
        this.comboForcastType.setSelectedIndex(0);
        this.prmtLoaner.setData(null);
        FinClientHelper.initFinProduct(this.prmtFinancingProducts);
        this.prmtProject.setData(null);
        this.dpCurrentDate.setValue((Object)new Date());
        this.kDCheckBoxIsContainBond.setSelected(false);
    }

    protected Class getParamClass() {
        return RptRepaymentDetailFilterParam.class;
    }
}

