/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fin.client.RptTimeDepositDetailFilterParam;
import com.kingdee.eas.fm.fin.client.RptTimeDepositHandlerAdapter;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class RptTimeDepositDetailByCurrencyHandler
extends RptTimeDepositHandlerAdapter {
    public RptTimeDepositDetailByCurrencyHandler(KDTable tblMain, FilterInfo filter, RptTimeDepositDetailFilterParam filterParam) {
        super(tblMain, filter);
        this.setChloanDetailFilterParam(filterParam);
        this.prepare();
    }

    @Override
    public void initHeader() {
        super.initHeader();
        this.initTable();
    }

    @Override
    protected void initCustomHeader() {
        IColumn cCurrecny = this.kdt.addColumn();
        cCurrecny.setKey("currency");
        this.formatCol(cCurrecny);
        cCurrecny.setGroup(true);
        IColumn cCompany = this.kdt.addColumn();
        cCompany.setKey("company");
        this.formatCol(cCompany);
        IColumn cDepCompany = this.kdt.addColumn();
        cDepCompany.setKey("depcompany");
        this.formatCol(cDepCompany);
        IColumn cDepositType = this.kdt.addColumn();
        cDepositType.setKey("depositType");
        this.formatCol(cDepositType);
    }

    @Override
    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        super.filldata(rs);
        this.kdt.setRefresh(false);
        while (rs.next()) {
            IRow row = this.kdt.addRow();
            row.getCell("currency").setValue(rs.getObject("fcurrencyName"));
            row.getCell("company").setValue(rs.getObject("companyName"));
            row.getCell("depcompany").setValue(rs.getObject("depcompanyName"));
            row.getCell("depositType").setValue(rs.getObject("fdeposittype"));
            super.setContentToCommonColumn(row, rs);
        }
    }

    @Override
    protected void formatCustomerHeadRow(IRow headRow) {
        headRow.getCell("currency").setValue((Object)this.getResString("rpt_balance_currency"));
        headRow.getCell("company").setValue((Object)this.getResString("rpt_balance_company"));
        headRow.getCell("depcompany").setValue((Object)this.getResString("rpt_balance_depcompany"));
        headRow.getCell("depositType").setValue((Object)this.getResString("rpt_balance_depositType"));
    }
}

