/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fin.client.RptTimeDepositDetailFilterParam;
import com.kingdee.eas.fm.fin.client.RptTimeDepositHandlerAdapter;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class RptTimeDepositDetailByDeCompanyHandler
extends RptTimeDepositHandlerAdapter {
    public RptTimeDepositDetailByDeCompanyHandler(KDTable tblMain, FilterInfo filter, RptTimeDepositDetailFilterParam filterParam) {
        super(tblMain, filter);
        this.setChloanDetailFilterParam(filterParam);
        this.prepare();
    }

    @Override
    public void initHeader() {
        super.initHeader();
        this.initTable();
    }

    @Override
    protected void initCustomHeader() {
        IColumn cdepcompany = this.kdt.addColumn();
        cdepcompany.setKey("depcompany");
        this.formatCol(cdepcompany);
        cdepcompany.setGroup(true);
        IColumn cCompany = this.kdt.addColumn();
        cCompany.setKey("company");
        this.formatCol(cCompany);
        IColumn cDepositType = this.kdt.addColumn();
        cDepositType.setKey("depositType");
        this.formatCol(cDepositType);
        IColumn cCurrecny = this.kdt.addColumn();
        cCurrecny.setKey("currency");
        this.formatCol(cCurrecny);
    }

    @Override
    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        super.filldata(rs);
        this.kdt.setRefresh(false);
        while (rs.next()) {
            IRow row = this.kdt.addRow();
            row.getCell("depcompany").setValue(rs.getObject("depcompanyName"));
            row.getCell("company").setValue(rs.getObject("companyName"));
            row.getCell("depositType").setValue(rs.getObject("fdeposittype"));
            row.getCell("currency").setValue(rs.getObject("fcurrencyName"));
            super.setContentToCommonColumn(row, rs);
        }
    }

    @Override
    protected void formatCustomerHeadRow(IRow headRow) {
        headRow.getCell("depcompany").setValue((Object)this.getResString("rpt_balance_depcompany"));
        headRow.getCell("company").setValue((Object)this.getResString("rpt_balance_company"));
        headRow.getCell("depositType").setValue((Object)this.getResString("rpt_balance_depositType"));
        headRow.getCell("currency").setValue((Object)this.getResString("rpt_balance_currency"));
    }
}

