/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fin.CreditLimitFactory;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.client.AbstractSetCreditQuotaAmountUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class SetCreditQuotaAmountUI
extends AbstractSetCreditQuotaAmountUI {
    private static final Logger logger = CoreUIObject.getLogger(SetCreditQuotaAmountUI.class);

    public CreditLimitInfo getInfo() throws EASBizException, BOSException {
        String creditLimitID = this.getUIContext().get("ID").toString();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("Currency.precision"));
        CreditLimitInfo info = CreditLimitFactory.getRemoteInstance().getCreditLimitInfo((IObjectPK)new ObjectUuidPK(creditLimitID), sic);
        return info;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        CreditLimitInfo info = this.getInfo();
        CurrencyInfo currency = info.getCurrency();
        int precision = 2;
        if (currency != null) {
            precision = currency.getPrecision();
        }
        this.txtQuotaAmount.setDataType(1);
        this.txtQuotaAmount.setPrecision(precision);
        this.txtQuotaAmount.setHorizontalAlignment(4);
        this.kDNumberTextFieldUsedAmount.setDataType(1);
        this.kDNumberTextFieldUsedAmount.setPrecision(precision);
        this.kDNumberTextFieldUsedAmount.setHorizontalAlignment(4);
        this.txtBalance.setDataType(1);
        this.txtBalance.setPrecision(precision);
        this.txtBalance.setHorizontalAlignment(4);
        this.txtQuotaAmount.setValue((Object)info.getQuotaAmount());
        this.kDNumberTextFieldUsedAmount.setValue((Object)info.getUsedAmount());
        this.kDNumberTextFieldUsedAmount.setEnabled(false);
        this.txtBalance.setValue((Object)info.getBalance());
        this.txtBalance.setEnabled(false);
    }

    public void txtQuotaAmount_dataChanged(ActionEvent e) throws Exception {
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.txtQuotaAmount.getBigDecimalValue().subtract(this.kDNumberTextFieldUsedAmount.getBigDecimalValue()).compareTo(new BigDecimal("0")) < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)"balance_notLessZero"));
            SysUtil.abort();
        }
        CreditLimitInfo info = this.getInfo();
        info.setQuotaAmount(this.txtQuotaAmount.getBigDecimalValue());
        info.setUsedAmount(this.kDNumberTextFieldUsedAmount.getBigDecimalValue());
        info.setBalance(this.txtQuotaAmount.getBigDecimalValue().subtract(this.kDNumberTextFieldUsedAmount.getBigDecimalValue()));
        BigDecimal bdExRate = info.getExchangeRate();
        info.setLocalAmount(bdExRate.multiply(this.txtQuotaAmount.getBigDecimalValue()));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("QuotaAmount"));
        sic.add(new SelectorItemInfo("UsedAmount"));
        sic.add(new SelectorItemInfo("Balance"));
        sic.add(new SelectorItemInfo("LocalAmount"));
        CreditLimitFactory.getRemoteInstance().updatePartial((CoreBaseInfo)info, sic);
        this.uiWindow.close();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.uiWindow.close();
    }
}

