/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.KDTableUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.edrafent.DraftCollateralizationRequestInfo;
import com.kingdee.eas.fm.fin.FinBillStatusEnum;
import com.kingdee.eas.fm.fin.IWage;
import com.kingdee.eas.fm.fin.WageFactory;
import com.kingdee.eas.fm.fin.WageInfo;
import com.kingdee.eas.fm.fin.client.AbstractWageListUI;
import com.kingdee.eas.fm.fin.client.WageEditUI;
import com.kingdee.eas.fm.fin.client.WageFilterUI;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class WageListUI
extends AbstractWageListUI {
    public static final String RESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";
    private static final Logger logger = CoreUIObject.getLogger(WageListUI.class);
    private WageFilterUI FilterUI;
    FillListener fillListener = new FillListener();

    public String[] getMergeColumnKeys() {
        this.tblMain.checkParsed();
        int beginIndex = this.tblMain.getColumn("company.name").getColumnIndex();
        int endIndex = this.tblMain.getColumn("WageAmount").getColumnIndex();
        int beginIndex2 = this.tblMain.getColumn("issuedate").getColumnIndex();
        int endIndex2 = this.tblMain.getColumn("voucherCreator.number").getColumnIndex();
        String[] keys = new String[endIndex - beginIndex + endIndex2 - beginIndex2 + 2];
        int j = 0;
        int i = beginIndex;
        while (i <= endIndex) {
            keys[j] = this.tblMain.getColumn(i).getKey();
            ++i;
            ++j;
        }
        i = beginIndex2;
        while (i <= endIndex2) {
            keys[j] = this.tblMain.getColumn(i).getKey();
            ++i;
            ++j;
        }
        return keys;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.ationAntiWage.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionUnantiWage.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_auditing"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.kDMenu1.setVisible(false);
        this.kDMenu1.setEnabled(false);
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        if (this.getSelectObject().getBillStatus() == FinBillStatusEnum.AUDITED) {
            boolean isAntiWage = this.getSelectObject().isIsAntiWage();
            this.ationAntiWage.setEnabled(!isAntiWage);
            this.actionUnantiWage.setEnabled(isAntiWage);
        } else {
            this.ationAntiWage.setEnabled(false);
            this.actionUnantiWage.setEnabled(false);
        }
        FinBillStatusEnum billStatus = this.getSelectObject().getBillStatus();
        this.actionAudit.setEnabled(FinBillStatusEnum.SUBMIT.equals((Object)billStatus));
        this.actionAntiAudit.setEnabled(FinBillStatusEnum.AUDITED.equals((Object)billStatus));
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionEdit_actionPerformed(e);
    }

    private WageInfo getSelectedInfo(String id) throws EASBizException, BOSException {
        return WageFactory.getRemoteInstance().getWageInfo((IObjectPK)new ObjectStringPK(this.getSelectedKeyValue()));
    }

    @Override
    public void ationAntiWage_actionPerformed(ActionEvent e) throws Exception {
        if (this.getSelectObject().isIsRelationRec()) {
            WageFactory.getRemoteInstance().antiWage((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()), new ReceivableBillInfo().getBOSType());
        } else {
            WageFactory.getRemoteInstance().antiWage((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()), null);
        }
        this.refreshList();
    }

    @Override
    public void actionUnantiWage_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String keyValue = this.getSelectedKeyValue();
        if (keyValue == null) {
            return;
        }
        if (this.getSelectObject().isIsRelationRec()) {
            WageFactory.getRemoteInstance().unAntiWage((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()), new ReceivableBillInfo().getBOSType());
        } else {
            WageFactory.getRemoteInstance().unAntiWage((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()), null);
        }
        this.refreshList();
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String keyValue = this.getSelectedKeyValue();
        if (keyValue == null) {
            return;
        }
        WageInfo wageInfo = this.getSelectedInfo(this.getSelectedKeyValue());
        if (null != wageInfo && wageInfo.getBillStatus() == FinBillStatusEnum.AUDITED) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"444_WageListUI"));
            SysUtil.abort();
        }
        if (this.getSelectObject().isIsRelationRec()) {
            WageFactory.getRemoteInstance().delete((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()), new ReceivableBillInfo().getBOSType());
        } else {
            BOSObjectType type;
            BOSObjectType bosType;
            super.actionRemove_actionPerformed(e);
            if (wageInfo.getSourceBillId() != null && (bosType = BOSUuid.read((String)wageInfo.getSourceBillId()).getType()).equals((Object)(type = new DraftCollateralizationRequestInfo().getBOSType()))) {
                WageFactory.getRemoteInstance().updateCollateral((IObjectPK)new ObjectUuidPK(wageInfo.getSourceBillId()), false);
            }
        }
        this.refreshList();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.FilterUI == null) {
            this.FilterUI = new WageFilterUI();
        }
        return this.FilterUI;
    }

    @Override
    protected String getEditUIName() {
        return WageEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return WageFactory.getRemoteInstance();
    }

    private WageInfo getSelectObject() throws Exception {
        this.checkSelected();
        WageInfo info = ((IWage)this.getBizInterface()).getWageInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        return info;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn("issuedate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("expireddate").getStyleAttributes().setNumberFormat(this.dformat);
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList pks = this.getSelectedIdValues();
        Set set = FMHelper.list2Set((List)pks);
        WageFactory.getRemoteInstance().antiAudit(set);
        this.showMessage();
        this.refresh(e);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList pks = this.getSelectedIdValues();
        Set set = FMHelper.list2Set((List)pks);
        boolean hasWfInstance = FMHelper.hasWFInstance(null, (List)pks);
        if (hasWfInstance) {
            this.actionMultiapprove_actionPerformed(e);
            return;
        }
        WageFactory.getRemoteInstance().audit(set);
        this.refresh(e);
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    protected void execQuery() {
        super.execQuery();
    }

    protected boolean isFootVisible() {
        return false;
    }

    protected boolean isIgnoreBizUnit() {
        return false;
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.IVT_MANAGE;
    }

    protected String getDateField() {
        return "issuedate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionEdit", "actionRemove", "actionAntiAudit"};
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(WageListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            IRow row = null;
            String currencyId = null;
            Object billtype = null;
            Object billtype1 = null;
            HashSet<String> revokeSet = new HashSet<String>();
            HashSet<String> nonRevokeSet = new HashSet<String>();
            String billNumber = null;
            for (int i = e.getLastRow(); i >= e.getFirstRow(); --i) {
                row = tblMain.getRow(i);
                currencyId = (String)row.getCell("Currency.id").getValue();
                billNumber = (String)row.getCell("number").getValue();
                boolean entryRevoked = false;
                if (row.getCell("entryRevoked").getValue() != null) {
                    entryRevoked = (Boolean)row.getCell("entryRevoked").getValue();
                } else {
                    nonRevokeSet.add(billNumber);
                }
                if (entryRevoked) {
                    if (revokeSet.contains(billNumber)) {
                        row.getStyleAttributes().setHided(true);
                    } else {
                        revokeSet.add(billNumber);
                    }
                } else {
                    nonRevokeSet.add(billNumber);
                }
                if (currencyId == null) continue;
                FMClientHelper.setNumberFormat((IRow)row, (String)"Amount", (String)currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)"amountlocalcur", (String)currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)"WageAmount", (String)currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)"entrys.realWage", (String)currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)"billamount", (String)currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)"billbalance", (String)currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)"fee", (String)currencyId);
                StyleAttributes styleAttributes = row.getCell("wagerate").getStyleAttributes();
                styleAttributes.setNumberFormat("###,##0.0000\\%");
                styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                StyleAttributes horizon = row.getCell("horizon").getStyleAttributes();
                horizon.setNumberFormat("###,##0.0");
                horizon.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
            HashSet<String> onlyRevokeSet = new HashSet<String>();
            onlyRevokeSet.addAll(revokeSet);
            onlyRevokeSet.removeAll(nonRevokeSet);
            revokeSet.retainAll(nonRevokeSet);
            for (int i = e.getLastRow(); i >= e.getFirstRow(); --i) {
                row = tblMain.getRow(i);
                if (row.getStyleAttributes().isHided()) continue;
                billNumber = (String)row.getCell("number").getValue();
                boolean entryRevoked = false;
                if (row.getCell("entryRevoked").getValue() != null) {
                    entryRevoked = (Boolean)row.getCell("entryRevoked").getValue();
                }
                if (!entryRevoked) continue;
                if (onlyRevokeSet.contains(billNumber)) {
                    KDTableUtil.clearCells((KDTable)tblMain, (int)i, (String[])new String[]{"Type.name", "entrys.billnumber", "entrys.realWage"});
                    row.getCell("billamount").setValue((Object)BigDecimal.ZERO);
                    row.getCell("billbalance").setValue((Object)BigDecimal.ZERO);
                    continue;
                }
                if (!revokeSet.contains(billNumber)) continue;
                row.getStyleAttributes().setHided(true);
            }
        }
    }
}

