/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.rpcoptimize;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.fm.common.app.BatchFetcher;
import com.kingdee.eas.fm.fin.CreditorGroupCollection;
import com.kingdee.eas.fm.fin.CreditorGroupFactory;
import com.kingdee.eas.fm.fin.CreditorGroupInfo;
import com.kingdee.eas.fm.fin.GuaranteeTypeCollection;
import com.kingdee.eas.fm.fin.GuaranteeTypeFactory;
import com.kingdee.eas.fm.fin.GuaranteeTypeInfo;
import com.kingdee.eas.fm.fin.GuaranteeTypePropertyEnum;
import com.kingdee.eas.fm.fin.LoanException;
import com.kingdee.eas.fm.fin.rpcoptimize.LoanEditUIEnvirRpc;
import com.kingdee.eas.fm.im.IntRateTypeCollection;
import com.kingdee.eas.fm.im.IntRateTypeFactory;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.mnt.BlockingFlowTypeCollection;
import com.kingdee.eas.fm.mnt.BlockingFlowTypeFactory;
import com.kingdee.eas.fm.mnt.BlockingFlowTypeInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class LoanEditUIEnvirRpcFetcher
extends BatchFetcher {
    private static Map<String, CompanyOrgUnitCollection> comOrgUnitMap = new ConcurrentHashMap<String, CompanyOrgUnitCollection>();

    private IntRateTypeInfo getLprRate(Context ctx) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        IntRateTypeCollection rateColl = IntRateTypeFactory.getLocalInstance((Context)ctx).getIntRateTypeCollection(view);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)rateColl)) {
            for (int i = 0; i < rateColl.size(); ++i) {
                IntRateTypeInfo info = rateColl.get(i);
                if (info.getName() != null && info.getName().toLowerCase().contains("lpr")) {
                    return info;
                }
                if (info.getNumber() == null || !info.getNumber().toLowerCase().contains("lpr")) continue;
                return info;
            }
        }
        return IntRateTypeFactory.getLocalInstance((Context)ctx).getIntRateTypeInfo((IObjectPK)new ObjectUuidPK("lJlpCQEQEADgAAc+wKgSjiR9knQ="));
    }

    public BlockingFlowTypeInfo getDefaultBlockingFlowTypeInfo(Context ctx) throws EASBizException, BOSException {
        EntityViewInfo vi = new EntityViewInfo();
        FilterInfo fInfo = new FilterInfo();
        fInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"001", CompareType.EQUALS));
        vi.setFilter(fInfo);
        BlockingFlowTypeCollection bftCollection = null;
        bftCollection = BlockingFlowTypeFactory.getLocalInstance((Context)ctx).getBlockingFlowTypeCollection(vi);
        if (bftCollection == null || bftCollection.size() == 0) {
            throw new LoanException(LoanException.BLOCKINGFLOWTYPENUMBER001NOTEXISTS);
        }
        BlockingFlowTypeInfo bftInfo = bftCollection.get(0);
        return bftInfo;
    }

    public CreditorGroupInfo getDefaultCreditorGroupInfo(Context ctx) throws EASBizException, BOSException {
        EntityViewInfo vi = new EntityViewInfo();
        FilterInfo fInfo = new FilterInfo();
        fInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"001", CompareType.EQUALS));
        vi.setFilter(fInfo);
        CreditorGroupCollection cgCollection = CreditorGroupFactory.getLocalInstance(ctx).getCreditorGroupCollection(vi);
        if (cgCollection == null || cgCollection.size() == 0) {
            throw new LoanException(LoanException.CREDITORGROUPNUMBER001NOTEXISTS);
        }
        CreditorGroupInfo cgInfo = cgCollection.get(0);
        return cgInfo;
    }

    protected CompanyOrgUnitInfo getCurrentCompany(Context ctx, FmRpcCacheInfo paramInfo) throws BOSException, EASBizException {
        if (paramInfo.getCurrentCompany() == null) {
            return ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        }
        return paramInfo.getCurrentCompany();
    }

    protected void appendCacheValue(Context ctx, FmRpcCacheInfo paramInfo) throws EASBizException, BOSException {
        LoanEditUIEnvirRpc rpcCacheInfo_Loan = (LoanEditUIEnvirRpc)paramInfo;
        rpcCacheInfo_Loan.setDefaultBlockingFlowTypeInfo(this.getDefaultBlockingFlowTypeInfo(ctx));
        rpcCacheInfo_Loan.setLprRate(this.getLprRate(ctx));
        rpcCacheInfo_Loan.setParam_FIN001(this.getSysParam(ctx, "FIN001", paramInfo));
        rpcCacheInfo_Loan.setDefaultCreditorGroupInfo(this.getDefaultCreditorGroupInfo(ctx));
        EntityViewInfo vi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        GuaranteeTypePropertyEnum gtpEnum = GuaranteeTypePropertyEnum.assure;
        filter.getFilterItems().add(new FilterItemInfo("property", (Object)gtpEnum));
        vi.setFilter(filter);
        vi.getSelector().add(new SelectorItemInfo("*"));
        vi.getSelector().add(new SelectorItemInfo("name"));
        GuaranteeTypeCollection gtCol = null;
        gtCol = GuaranteeTypeFactory.getLocalInstance(ctx).getGuaranteeTypeCollection(vi);
        if (gtCol != null && gtCol.size() > 0) {
            GuaranteeTypeInfo gtInfo = gtCol.get(0);
            rpcCacheInfo_Loan.put("GuaranteeTypeInfo", gtInfo);
        }
        String permissionItem = "fin_Loan_addnew";
        CompanyOrgUnitCollection orgs = this.getUserOrgRangesWithRange(ctx, permissionItem);
        rpcCacheInfo_Loan.setUserOrgRang(orgs);
    }

    public CompanyOrgUnitCollection getUserOrgRangesWithRange(Context ctx, String permissionItem) throws BOSException, EASBizException {
        IPermission permission;
        UserInfo userInfo = null;
        if (ctx == null) {
            userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
            permission = PermissionFactory.getRemoteInstance();
        } else {
            userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            permission = PermissionFactory.getLocalInstance((Context)ctx);
        }
        String userPermissionKey = userInfo.getId().toString() + permissionItem;
        if (comOrgUnitMap.get(userPermissionKey) != null) {
            return comOrgUnitMap.get(userPermissionKey);
        }
        Set idSet = permission.getAuthorizedOrgIds((IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.Company, null, permissionItem);
        if (idSet == null || idSet.size() == 0) {
            return new CompanyOrgUnitCollection();
        }
        ICompanyOrgUnit iCompanyOrgUnit = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter2 = new FilterInfo();
        view.setFilter(filter2);
        filter2.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)1, CompareType.EQUALS));
        filter2.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)0, CompareType.EQUALS));
        filter2.getFilterItems().add(new FilterItemInfo("accountTable", null, CompareType.NOTEQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("baseCurrency.id");
        sic.add("baseCurrency.number");
        sic.add("baseCurrency.name");
        sic.add("accountTable.id");
        sic.add("accountTable.name");
        view.setSelector(sic);
        ArrayList allPerList = new ArrayList(idSet);
        int toIndex = 100;
        CompanyOrgUnitCollection subCompanyCollection = new CompanyOrgUnitCollection();
        int size = allPerList.size();
        for (int i = 0; i < size; i += toIndex) {
            if (i + toIndex > size) {
                toIndex = size - i;
            }
            List subList = allPerList.subList(i, i + toIndex);
            HashSet subIdSet = new HashSet(subList);
            FilterItemInfo filterItemInfo = new FilterItemInfo("id", subIdSet, CompareType.INCLUDE);
            filter2.getFilterItems().add(filterItemInfo);
            CompanyOrgUnitCollection companyOrgUnitCollection = iCompanyOrgUnit.getCompanyOrgUnitCollection(view);
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)companyOrgUnitCollection)) {
                subCompanyCollection.add(companyOrgUnitCollection.get(0));
                comOrgUnitMap.put(userPermissionKey, subCompanyCollection);
                return subCompanyCollection;
            }
            filter2.getFilterItems().remove(filterItemInfo);
        }
        return new CompanyOrgUnitCollection();
    }
}

