/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.KDTableUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyFactory;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountMgrStrategy;
import com.kingdee.eas.basedata.assistant.KAClassficationInfo;
import com.kingdee.eas.basedata.assistant.OverdraftCtrlEnum;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.cl.CLRateAdjustmentBillCollection;
import com.kingdee.eas.fm.cl.CLRateAdjustmentBillFactory;
import com.kingdee.eas.fm.cl.ConsignmentLoanBillCollection;
import com.kingdee.eas.fm.cl.ConsignmentLoanBillFactory;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.fm.ctl.AssureBillFactory;
import com.kingdee.eas.fm.ctl.AssureBillInfo;
import com.kingdee.eas.fm.ctl.AssureBillUsedCollection;
import com.kingdee.eas.fm.ctl.AssureBillUsedFactory;
import com.kingdee.eas.fm.ctl.AssureBillUsedInfo;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.FinBillStatusEnum;
import com.kingdee.eas.fm.fin.FloatActionEnum;
import com.kingdee.eas.fm.fin.GuaranteeDetailCollection;
import com.kingdee.eas.fm.fin.GuaranteeDetailFactory;
import com.kingdee.eas.fm.fin.GuaranteeDetailInfo;
import com.kingdee.eas.fm.fin.LoanAdjustInterestCollection;
import com.kingdee.eas.fm.fin.LoanAdjustInterestFactory;
import com.kingdee.eas.fm.fin.LoanCollection;
import com.kingdee.eas.fm.fin.LoanDeferCollection;
import com.kingdee.eas.fm.fin.LoanDeferFactory;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.LoanInterestCollection;
import com.kingdee.eas.fm.fin.LoanInterestFactory;
import com.kingdee.eas.fm.fin.LoanInterestInfo;
import com.kingdee.eas.fm.fin.RepaymentCollection;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.client.BondInterestEditUI;
import com.kingdee.eas.fm.fin.client.LoanDeferEditUI;
import com.kingdee.eas.fm.fin.client.LoanInterestEditUI;
import com.kingdee.eas.fm.fin.util.FinHorizon;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.IInAcct;
import com.kingdee.eas.fm.fs.IInnerAccount;
import com.kingdee.eas.fm.fs.InAcctDataTypeEnum;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.InnerFrozenDepositFactory;
import com.kingdee.eas.fm.ft.FundTransferExtBillCollection;
import com.kingdee.eas.fm.ft.FundTransferExtBillFactory;
import com.kingdee.eas.fm.ft.FundTransferInterestBillCollection;
import com.kingdee.eas.fm.ft.FundTransferInterestBillFactory;
import com.kingdee.eas.fm.ft.FundTransferRepayBillCollection;
import com.kingdee.eas.fm.ft.FundTransferRepayBillFactory;
import com.kingdee.eas.fm.im.IIntRateBase;
import com.kingdee.eas.fm.im.IMException;
import com.kingdee.eas.fm.im.IntRateBaseCollection;
import com.kingdee.eas.fm.im.IntRateBaseFactory;
import com.kingdee.eas.fm.im.IntRateStateEnum;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.im.util.IntCalHelper;
import com.kingdee.eas.fm.ivt.ChLoanCollection;
import com.kingdee.eas.fm.ivt.ChLoanFactory;
import com.kingdee.eas.fm.ivt.ChLoanRateAdjustBillCollection;
import com.kingdee.eas.fm.ivt.ChLoanRateAdjustBillFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.bireport.util.BirtUtils;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FinHelper {
    private static FinHelper finHelper;
    public static final String XIE_YI_LI_LV_ID = "lJlpCQEQEADgAAc+wKgSjiR9knQ=";
    public static final String GU_DING_LI_LV_ID = "QYYAAAAKQTYkfZJ0";
    public static final String TO_INTRATETYPE_FROM_LOAN = "fromLoan";
    public static final String ADJUSTINTERESTUI = "ADJUSTINTERESTUI";
    public static final String ADJUSTINTERESTLISTUI = "ADJUSTINTERESTLISTUI";
    public static final String LOAN = "com.kingdee.eas.fm.fin.app.Loan";
    public static final String BO_NAME_LOAN_APPLY = "com.kingdee.eas.fm.fin.app.LoanApplyBill";
    public static final String FinancingFeeBill = "com.kingdee.eas.fm.fin.app.FinancingFeeBill";
    public static final String LOANINTEREST = "com.kingdee.eas.fm.fin.app.LoanInterest";
    public static final String LOANEDIT = "LoanEdit";
    public static final String CHLOANEDIT = "ChLoanEdit";
    public static final String FROMREPAYMENT = "fromRepayment";
    public static final String FROMLOANDEFER = "fromLoanDefer";
    private static Logger logger;
    public static final Integer ZERO_INT;
    public static final int ERROR_UISTATE = 0;
    public static final int USER_ADDNEW = 1;
    public static final int USER_EDIT = 2;
    public static final int USER_VIEW = 3;
    public static final int USER_FINDVIEW = 4;
    public static final int BOTP_ADDNEW = 5;
    public static final int BOTP_EDIT = 6;

    public static FinHelper getInstance() {
        if (finHelper == null) {
            finHelper = new FinHelper();
        }
        return finHelper;
    }

    public int showBondsIntReceiveEditUI(CoreUIObject ui, RepaymentInfo editData) {
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"repaymentid", (Object)editData);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BondInterestEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            LoanInterestInfo info = (LoanInterestInfo)((BondInterestEditUI)uiWindow.getUIObject()).getEditData();
            if (info.getInterest().compareTo(Constants.ZERO) == 0) {
                uiWindow.close();
                return 1;
            }
            uiWindow.show();
            boolean success = ((BondInterestEditUI)uiWindow.getUIObject()).getSuccessFlag();
            if (success) {
                uiWindow.close();
            }
            return 2;
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
            return 0;
        }
    }

    public int showIntReceiveEditUI(CoreUIObject ui, RepaymentInfo editData) {
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"repaymentid", (Object)editData);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(LoanInterestEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            LoanInterestInfo info = (LoanInterestInfo)((LoanInterestEditUI)uiWindow.getUIObject()).getEditData();
            if (info.getInterest().compareTo(Constants.ZERO) <= 0) {
                uiWindow.close();
                return 1;
            }
            uiWindow.show();
            boolean success = ((LoanInterestEditUI)uiWindow.getUIObject()).getSuccessFlag();
            if (success) {
                return 2;
            }
            uiWindow.close();
            return 3;
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
            return 0;
        }
    }

    public void showExtendBillEditUI(CoreUI ui, LoanInfo loanInfo) {
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"chloanid", (Object)loanInfo);
            uiContext.put((Object)"pull_or_push", (Object)"push");
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(LoanDeferEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
        catch (BOSException e) {
            ui.handUIExceptionAndAbort((Exception)((Object)e));
        }
    }

    public LoanInfo getLoanPassByRepayment(RepaymentInfo repaymentInfo) {
        if (repaymentInfo == null) {
            return null;
        }
        String id = repaymentInfo.getSourceBillId();
        LoanInfo loanInfo = null;
        try {
            loanInfo = LoanFactory.getRemoteInstance().getLoanInfo((IObjectPK)new ObjectUuidPK(id));
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return loanInfo;
    }

    public static void setConTable(KDTable tbl, IObjectPK pk, String number, BasicFormattedTextField txt, BasicFormattedTextField conRemainAmount, BigDecimal amount, KDFormattedTextField conSeq, String oprtState) {
        String sql = null;
        ArrayList<String> paramList = new ArrayList<String>();
        if (pk != null) {
            sql = " select FID,FSeqMulCon,FIssueDate,FAmount,(FAmount-FBalance) FRepayedAmount,FBalance,FRemark from T_FIN_Loan where FMainConLoanID = ? ";
            paramList.add(pk.toString());
        } else {
            sql = "select FID,FSeqMulCon,FIssueDate,FAmount,(FAmount-FBalance) FRepayedAmount,FBalance,FRemark from T_FIN_Loan where FContractNum = ?";
            paramList.add(number);
        }
        IRowSet rs = null;
        try {
            rs = FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sql, paramList.toArray());
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        tbl.checkParsed();
        tbl.setRefresh(false);
        tbl.removeRows();
        BigDecimal amountTotal = new BigDecimal(String.valueOf(0));
        BigDecimal repayedAmountTotal = new BigDecimal(String.valueOf(0));
        BigDecimal balanceTotal = new BigDecimal(String.valueOf(0));
        if (rs.size() == 0) {
            txt.setValue((Object)amount);
        }
        try {
            while (rs.next()) {
                IRow row = tbl.addRow();
                row.setUserObject((Object)rs.getString("FID"));
                row.getCell("seq").setValue((Object)rs.getString("FSeqMulCon"));
                row.getCell("startDate").setValue((Object)rs.getDate("FIssueDate"));
                row.getCell("amount").setValue((Object)rs.getBigDecimal("FAmount"));
                amountTotal = amountTotal.add(rs.getBigDecimal("FAmount"));
                row.getCell("amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                row.getCell("amount").getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
                row.getCell("repayAmount").setValue((Object)rs.getBigDecimal("FRepayedAmount"));
                repayedAmountTotal = repayedAmountTotal.add(rs.getBigDecimal("FRepayedAmount"));
                row.getCell("repayAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                row.getCell("repayAmount").getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
                row.getCell("balance").setValue((Object)rs.getBigDecimal("FBalance"));
                balanceTotal = balanceTotal.add(rs.getBigDecimal("FBalance"));
                row.getCell("balance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                row.getCell("balance").getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
                row.getCell("remark").setValue((Object)rs.getString("FRemark"));
            }
        }
        catch (SQLException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (oprtState.equals(OprtState.ADDNEW)) {
            BigDecimal conamountTotal = amountTotal.add(amount);
            conSeq.setValue((Object)(rs.size() + 1));
            txt.setValue((Object)conamountTotal);
        } else {
            txt.setValue((Object)amountTotal);
        }
        IRow rowEnd = tbl.addRow();
        rowEnd.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowEnd.setUserObject((Object)"cabal online");
        rowEnd.getCell("seq").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"313_LoanEditUI"));
        rowEnd.getCell("amount").setValue((Object)amountTotal);
        rowEnd.getCell("amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        rowEnd.getCell("amount").getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
        rowEnd.getCell("repayAmount").setValue((Object)repayedAmountTotal);
        rowEnd.getCell("repayAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        rowEnd.getCell("repayAmount").getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
        rowEnd.getCell("balance").setValue((Object)balanceTotal);
        rowEnd.getCell("balance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        rowEnd.getCell("balance").getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
    }

    public static void setConTable(KDTable tbl, IObjectPK pk) {
        String sql = null;
        ArrayList<String> paramList = new ArrayList<String>();
        sql = " select FID,FSeqMulCon,FIssueDate,FAmount,(FAmount-FBalance) FRepayedAmount,FBalance,FRemark from T_FIN_Loan where FMainConLoanID = ?  order by FSeqMulCon asc";
        paramList.add(pk.toString());
        IRowSet rs = null;
        try {
            rs = FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sql, paramList.toArray());
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        tbl.checkParsed();
        tbl.setRefresh(false);
        tbl.removeRows();
        BigDecimal amountTotal = new BigDecimal(String.valueOf(0));
        BigDecimal repayedAmountTotal = new BigDecimal(String.valueOf(0));
        BigDecimal balanceTotal = new BigDecimal(String.valueOf(0));
        try {
            while (rs.next()) {
                IRow row = tbl.addRow();
                row.setUserObject((Object)rs.getString("FID"));
                row.getCell("seq").setValue((Object)rs.getString("FSeqMulCon"));
                row.getCell("startDate").setValue((Object)rs.getDate("FIssueDate"));
                row.getCell("amount").setValue((Object)rs.getBigDecimal("FAmount"));
                amountTotal = amountTotal.add(rs.getBigDecimal("FAmount"));
                row.getCell("amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                row.getCell("amount").getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
                row.getCell("repayAmount").setValue((Object)rs.getBigDecimal("FRepayedAmount"));
                repayedAmountTotal = repayedAmountTotal.add(rs.getBigDecimal("FRepayedAmount"));
                row.getCell("repayAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                row.getCell("repayAmount").getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
                row.getCell("balance").setValue((Object)rs.getBigDecimal("FBalance"));
                balanceTotal = balanceTotal.add(rs.getBigDecimal("FBalance"));
                row.getCell("balance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                row.getCell("balance").getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
                row.getCell("remark").setValue((Object)rs.getString("FRemark"));
            }
        }
        catch (SQLException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        IRow rowEnd = tbl.addRow();
        rowEnd.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowEnd.setUserObject((Object)"cabal online");
        rowEnd.getCell("seq").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"313_LoanEditUI"));
        rowEnd.getCell("amount").setValue((Object)amountTotal);
        rowEnd.getCell("amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        rowEnd.getCell("amount").getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
        rowEnd.getCell("repayAmount").setValue((Object)repayedAmountTotal);
        rowEnd.getCell("repayAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        rowEnd.getCell("repayAmount").getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
        rowEnd.getCell("balance").setValue((Object)balanceTotal);
        rowEnd.getCell("balance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        rowEnd.getCell("balance").getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
    }

    public static void setLockRow(KDTable kdt, int rowIndex, String[] colNames, boolean isLock) {
        IRow row = kdt.getRow(rowIndex);
        if (row == null) {
            return;
        }
        if (colNames != null) {
            int n = colNames.length;
            for (int i = 0; i < n; ++i) {
                ICell cell = row.getCell(colNames[i]);
                if (isLock) {
                    cell.getStyleAttributes().setLocked(true);
                    continue;
                }
                cell.getStyleAttributes().setLocked(false);
            }
        } else {
            int n = kdt.getColumnCount();
            for (int i = 0; i < n; ++i) {
                ICell cell = row.getCell(i);
                if (isLock) {
                    cell.getStyleAttributes().setLocked(true);
                    continue;
                }
                cell.getStyleAttributes().setLocked(false);
            }
        }
    }

    public static void setLockColumn(KDTable kdt, String[] colNames, boolean isLock) {
        if (colNames != null) {
            int n = colNames.length;
            for (int i = 0; i < n; ++i) {
                if (isLock) {
                    kdt.getColumn(colNames[i]).getStyleAttributes().setLocked(true);
                    continue;
                }
                kdt.getColumn(colNames[i]).getStyleAttributes().setLocked(false);
            }
        } else {
            int n = kdt.getColumnCount();
            for (int i = 0; i < n; ++i) {
                if (isLock) {
                    kdt.getColumn(i).getStyleAttributes().setLocked(true);
                    continue;
                }
                kdt.getColumn(i).getStyleAttributes().setLocked(false);
            }
        }
    }

    public static void clearCells(KDTable kdt, int rowIndex, String[] colNames) {
        KDTableUtil.clearCells((KDTable)kdt, (int)rowIndex, (String[])colNames);
    }

    public static void loadGuaranteeTypeOfLoan(LoanInfo info, KDTable tbl) throws BOSException {
        if (info == null) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("parentBillId", (Object)info.getId().toString()));
        GuaranteeDetailCollection gdCollection = GuaranteeDetailFactory.getRemoteInstance().getGuaranteeDetailCollection(evi);
        if (tbl == null) {
            return;
        }
        tbl.removeRows();
        for (int i = 0; i < gdCollection.size(); ++i) {
            GuaranteeDetailInfo gdInfo = gdCollection.get(i);
            EntityViewInfo evi2 = new EntityViewInfo();
            evi2.getSelector().add(new SelectorItemInfo("*"));
            evi2.getSelector().add(new SelectorItemInfo("guaranteeType.id"));
            evi2.getSelector().add(new SelectorItemInfo("guaranteeType.name"));
            evi2.getSelector().add(new SelectorItemInfo("amount"));
            evi2.getSelector().add(new SelectorItemInfo("billid"));
            evi2.getSelector().add(new SelectorItemInfo("billnumber"));
            evi2.getSelector().add(new SelectorItemInfo("currency.id"));
            evi2.getSelector().add(new SelectorItemInfo("currency.name"));
            evi2.getSelector().add(new SelectorItemInfo("scale"));
            evi2.getSelector().add(new SelectorItemInfo("guarantee"));
            evi2.getSelector().add(new SelectorItemInfo("guaranteeComp.id"));
            evi2.getSelector().add(new SelectorItemInfo("guaranteeComp.name"));
            evi2.getSelector().add(new SelectorItemInfo("exchangeRate"));
            GuaranteeDetailInfo cInfo = null;
            try {
                cInfo = GuaranteeDetailFactory.getRemoteInstance().getGuaranteeDetailInfo((IObjectPK)new ObjectUuidPK(gdInfo.getId()), evi2.getSelector());
            }
            catch (EASBizException e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
            catch (BOSException e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
            IRow curRow = tbl.addRow();
            if (curRow == null) continue;
            curRow.getCell("guaranteetype").setValue((Object)cInfo.getGuaranteeType());
            curRow.getCell("guarantee").setValue((Object)cInfo.getGuaranteeName());
            curRow.getCell("scale").setValue((Object)cInfo.getScale());
            curRow.getCell("billNumber").setValue((Object)cInfo.getBillNumber());
            curRow.getCell("guaranCompany").setValue((Object)cInfo.getGuaranteeComp());
            curRow.getCell("amount").setValue((Object)cInfo.getAmount());
            curRow.getCell("currency").setValue((Object)cInfo.getCurrency());
            curRow.getCell("exchangeRate").setValue((Object)cInfo.getExchangeRate());
        }
    }

    public static AccountViewInfo getAccountViewInfoByAccountBankInfo(AccountBankInfo accBankInfo) {
        if (accBankInfo == null) {
            return null;
        }
        KAClassficationInfo kAClassficationInfo = null;
        AccountViewInfo accViewInfo = null;
        kAClassficationInfo = accBankInfo.getClassificatio();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("accountingcurrency"));
        try {
            accViewInfo = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(accBankInfo.getAccount().getId()), sic);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return accViewInfo;
    }

    public static boolean hasDeferRecordOfLoan(String loanId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("loan.id", (Object)loanId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        LoanDeferCollection col = LoanDeferFactory.getRemoteInstance().getLoanDeferCollection(evi);
        return col == null || col.size() <= 0;
    }

    public static boolean hasDeferRecordOfFundTransfer(String loanId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("loan.id", (Object)loanId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        FundTransferExtBillCollection col = FundTransferExtBillFactory.getRemoteInstance().getFundTransferExtBillCollection(evi);
        return col == null || col.size() <= 0;
    }

    public static boolean hasDeferRecordOfLoan(Context ctx, String loanId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("loan.id", (Object)loanId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        LoanDeferCollection col = LoanDeferFactory.getLocalInstance(ctx).getLoanDeferCollection(evi);
        return col == null || col.size() <= 0;
    }

    public static boolean hasIntRecordOfFundTransfer(String loanId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("transBill.id", (Object)loanId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        FundTransferInterestBillCollection col = FundTransferInterestBillFactory.getRemoteInstance().getFundTransferInterestBillCollection(evi);
        return col == null || col.size() <= 0;
    }

    public static boolean hasIntRecordOfLoan(String loanId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("loan.id", (Object)loanId));
        filter.getFilterItems().add(new FilterItemInfo("isPrediction", (Object)new Boolean(false)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        LoanInterestCollection col = LoanInterestFactory.getRemoteInstance().getLoanInterestCollection(evi);
        return col == null || col.size() <= 0;
    }

    public static boolean hasIntRecordOfLoan(Context ctx, String loanId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("loan.id", (Object)loanId));
        filter.getFilterItems().add(new FilterItemInfo("isPrediction", (Object)new Boolean(false)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        LoanInterestCollection col = LoanInterestFactory.getLocalInstance(ctx).getLoanInterestCollection(evi);
        return col == null || col.size() <= 0;
    }

    public static boolean hasIntRecordOfRepayment(String repaymentId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("repayment.id", (Object)repaymentId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        LoanInterestCollection col = LoanInterestFactory.getRemoteInstance().getLoanInterestCollection(evi);
        return col == null || col.size() <= 0;
    }

    public static boolean hasIntRecordOfRepayment(Context ctx, String repaymentId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("repayment.id", (Object)repaymentId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        LoanInterestCollection col = LoanInterestFactory.getLocalInstance(ctx).getLoanInterestCollection(evi);
        return col == null || col.size() <= 0;
    }

    public static CurrencyInfo getBaseCurrencyName(CompanyOrgUnitInfo company) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("name"));
        CurrencyInfo baseCurrency1 = company.getBaseCurrency();
        CurrencyInfo baseCurrency2 = null;
        try {
            baseCurrency2 = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrency1.getId()), sic);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return baseCurrency2;
    }

    public static IObjectCollection botpTransfromSubmit(Context ctx, CoreBillBaseCollection srcBillColl, BOSObjectType destObjType) throws BOSException, EASBizException {
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BTPTransformResult result = iBTPManager.transformMultiBill(srcBillColl, destObjType.toString());
        IObjectCollection destBillColl = result.getBills();
        return destBillColl;
    }

    public static String getGuranteeRowSet(String id, String tableName) throws BOSException, SQLException {
        StringBuffer guaranteeName = new StringBuffer(" ");
        int property = 0;
        String sql = " select b.FProperty as ASFProperty from " + tableName + " as a left join T_FIN_GuaranteeType as b on a.FGaranteeTypeID = b.FID where a.fid = ? ";
        IRowSet rs = null;
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(id);
        try {
            rs = FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sql, paramList.toArray());
            while (rs.next()) {
                property = rs.getInt(1);
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        String loc = LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
        String sql2 = null;
        if (property == 1) {
            sql2 = " select isnull(a.FGuaranteeCompHand,b.fname_" + loc + " ) from T_FIN_GuaranteeDetail a left join t_org_company b  on a.FGuaranteeCompID = b.fid where a.FParentBillId = ? and a.FGuaranteeTypeProperty = 1 ";
        } else if (property == 2) {
            sql2 = " select FGuaranteeName from T_FIN_GuaranteeDetail where FParentBillId = ? and FGuaranteeTypeProperty = 2 ";
        } else if (property == 3) {
            sql2 = " select FGuaranteeName from T_FIN_GuaranteeDetail where FParentBillId = ? and FGuaranteeTypeProperty = 3 ";
        } else if (property == 4) {
            sql2 = " select FGuaranteeCompHand from T_FIN_GuaranteeDetail where FParentBillId = ? and FGuaranteeTypeProperty = 4 ";
        }
        if (sql2 != null) {
            IRowSet rs2 = null;
            try {
                rs2 = FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sql2, paramList.toArray());
                while (rs2.next()) {
                    if (rs2.getString(1) == null) continue;
                    guaranteeName.append(rs2.getString(1) + ",");
                }
                return guaranteeName.toString().substring(0, guaranteeName.length() - 1);
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
                SysUtil.abort();
            }
        }
        return guaranteeName.toString();
    }

    public static Map getRateMap(Context ctx, Set idSet) {
        HashMap<String, BigDecimal> intRateMap;
        block37: {
            LoanCollection loanColl;
            block36: {
                logger.error((Object)"\u501f\u6b3e\u5355 \u8ba1\u7b97\u6700\u65b0\u5229\u7387\u65e5\u5fd7 \u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
                StringBuffer sql = new StringBuffer();
                String billState = IntRateStateEnum.AUDITED.getValue();
                Timestamp time = new Timestamp(new Date().getTime());
                sql.append(" select newRate.FID,newRate.IntRate from ( \n").append(" select A.FID,case when FIntRateTypeID ='lJlpCQEQEADgAAc+wKgSjiR9knQ=' then B.FAdjustAfterRate else C.FYearRate end as IntRate \n").append(" from T_Fin_Loan as A left join ( \n").append(" select A.FID,C.FAdjustAfterRate \n").append(" from T_Fin_Loan as A ,(select  max(FAdjustSeq)  as FAdjustSeq ,A.FID from T_Fin_LoanAdjustInterest as B, T_Fin_Loan as A \n").append(" where A.FID = B.FLoanId group by A.FID) as B ,T_Fin_LoanAdjustInterest as C \n").append(" where A.FID = B.FID and C.FAdjustSeq = B.FAdjustSeq and C.FLoanID = B.FID  and C.FADJUSTDATE<= ? \n").append(" ) as B on A.FID = B.FID left join ( \n").append(" select A.FID,C.FYearRate from T_Fin_Loan as A,( \n").append(" select max(Base.FEffectiveDate) as FEffectiveDate,Base.FCurrencyID,Type.FID from T_INT_IntRateBase as Base,T_INT_IntRateType as Type \n").append(" where Base.FTypeID = Type.FID ").append(" and Base.FbillState = '" + billState + "'").append(" group by Base.FCurrencyID,Type.FID) as B,T_INT_IntRateBase as C \n").append(" where A.FIntRateTypeID = B.FID and A.FCurrencyID = B.FCurrencyID and C.FTypeID = B.FID and C.FEffectiveDate = B.FEffectiveDate \n").append(" and C.FbillState = '" + billState + "'").append(" ) as C on A.FID = C.FID ) as newRate where 1=1 \n");
                if (idSet.size() > 0) {
                    sql.append("\n and FID in(");
                    sql.append(BirtUtils.idListToInClause((Collection)idSet)).append(")\n");
                }
                logger.error((Object)"sql\u7ed3\u675f  \u501f\u6b3e\u5355 \u8ba1\u7b97\u6700\u65b0\u5229\u7387\u65e5\u5fd7 \u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
                intRateMap = new HashMap<String, BigDecimal>();
                IRowSet rs = null;
                try {
                    rs = FMIsqlFacadeFactory.getLocalInstance((Context)ctx).executeQuery(sql.toString(), new Object[]{time});
                    while (rs.next()) {
                        intRateMap.put(rs.getString(1), rs.getBigDecimal(2));
                    }
                }
                catch (EASBizException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (SQLException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                logger.error((Object)" \u5229\u7387\u7c7b\u578b\u4e3alpr\u7684\u501f\u6b3e\u5355  \u7684\u6700\u65b0\u5229\u7387 \u501f\u6b3e\u5355 \u8ba1\u7b97\u6700\u65b0\u5229\u7387\u65e5\u5fd7 \u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
                loanColl = null;
                FilterInfo loanfilter = new FilterInfo();
                SelectorItemCollection loanSic = new SelectorItemCollection();
                loanSic.add(new SelectorItemInfo("id"));
                loanSic.add(new SelectorItemInfo("BasePoints"));
                loanSic.add(new SelectorItemInfo("firstRateAdjustDate"));
                loanSic.add(new SelectorItemInfo("rateAdjustPeriod"));
                loanSic.add(new SelectorItemInfo("currency.id"));
                loanSic.add(new SelectorItemInfo("IntRateType.id"));
                loanSic.add(new SelectorItemInfo("IntRateType.name"));
                loanSic.add(new SelectorItemInfo("IntRateType.number"));
                loanSic.add(new SelectorItemInfo("IntRateType.isLPR"));
                loanSic.add(new SelectorItemInfo("IssueDate"));
                loanSic.add(new SelectorItemInfo("ExpiredDate"));
                loanSic.add(new SelectorItemInfo("FloatAction"));
                loanfilter.getFilterItems().add(new FilterItemInfo("IntRateType.isLPR", (Object)Constants.ONE));
                loanfilter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
                EntityViewInfo loanEvi = new EntityViewInfo();
                loanEvi.setSelector(loanSic);
                loanEvi.setFilter(loanfilter);
                logger.error((Object)("loanEvi = " + loanEvi.toString()));
                try {
                    loanColl = LoanFactory.getLocalInstance(ctx).getLoanCollection(loanEvi);
                    logger.error((Object)("loanColl.size() = " + loanColl.size()));
                    if (loanColl.size() <= 0) break block36;
                    IntRateBaseCollection adjuIntRateBaseColl = null;
                    HashMap<String, IntRateBaseCollection> intRateBaseMap = new HashMap<String, IntRateBaseCollection>();
                    int count = loanColl.size();
                    for (int index = 0; index < count; ++index) {
                        BigDecimal intRateAfterAdj;
                        BigDecimal intRateBase;
                        Date currenDate = new Date();
                        String intRateTypeId = loanColl.get(index).getIntRateType().getId().toString();
                        String loanId = loanColl.get(index).getId().toString();
                        Date firstRateAdjustDate = loanColl.get(index).getFirstRateAdjustDate();
                        String currencyId = loanColl.get(index).getCurrency().getId().toString();
                        String rateAndCur = intRateTypeId + currencyId;
                        if (intRateBaseMap.containsKey(rateAndCur)) {
                            adjuIntRateBaseColl = (IntRateBaseCollection)intRateBaseMap.get(rateAndCur);
                        } else {
                            try {
                                adjuIntRateBaseColl = FinHelper.getIntRateBaseColl(ctx, intRateTypeId, currencyId);
                            }
                            catch (IMException ime) {
                                logger.error((Object)("\u5bf9\u5e94\u5229\u7387\u7c7b\u578b" + intRateTypeId + "\u6ca1\u6709\u57fa\u51c6\u5229\u7387"));
                                continue;
                            }
                            intRateBaseMap.put(rateAndCur, adjuIntRateBaseColl);
                        }
                        int rateAdjustPeriod = loanColl.get(index).getRateAdjustPeriod();
                        if (rateAdjustPeriod == 0) {
                            if (currenDate.compareTo(loanColl.get(index).getIssueDate()) < 0 || currenDate.compareTo(loanColl.get(index).getExpiredDate()) > 0) continue;
                            intRateBase = IntCalHelper.getIntRateBase((Date)currenDate, (IntRateBaseCollection)adjuIntRateBaseColl);
                            intRateAfterAdj = FinHelper.getNewRateByFloatAction(intRateBase, loanColl.get(index).getBasePoints(), loanColl.get(index).getFloatAction());
                            intRateMap.put(loanId, intRateAfterAdj);
                            logger.error((Object)(" \u5f53\u524d\u65e5\u671f\u4ecb\u4e8e\u501f\u6b3e\u5355\u8d77\u59cb\u65e5\u548c\u9996\u4e2a\u8c03\u6574\u65e5\u4e4b\u95f4 -->\u53d6\u5f53\u524d\u65e5\u671f\u7684\u5229\u7387 \u501f\u6b3e\u5355id = " + loanColl.get(index).getId().toString() + "intRateBase = " + intRateBase + "basePoint" + loanColl.get(index).getBasePoints()));
                            continue;
                        }
                        if (rateAdjustPeriod <= 0) continue;
                        if (currenDate.compareTo(loanColl.get(index).getIssueDate()) >= 0 && currenDate.compareTo(loanColl.get(index).getFirstRateAdjustDate()) < 0) {
                            intRateBase = IntCalHelper.getIntRateBase((Date)loanColl.get(index).getIssueDate(), (IntRateBaseCollection)adjuIntRateBaseColl);
                            intRateAfterAdj = FinHelper.getNewRateByFloatAction(intRateBase, loanColl.get(index).getBasePoints(), loanColl.get(index).getFloatAction());
                            intRateMap.put(loanId, intRateAfterAdj);
                            logger.error((Object)(" \u5f53\u524d\u65e5\u671f\u5728\u8c03\u6574\u65e5\u4e4b\u524d\uff08\u4e0d\u5305\u62ec\u8c03\u6574\u65e5\uff09 -->\u53d6\u8d77\u59cb\u65e5\u7684\u5229\u7387 \u501f\u6b3e\u5355id = " + loanColl.get(index).getId().toString() + "intRateBase = " + intRateBase + "basePoint" + loanColl.get(index).getBasePoints()));
                            continue;
                        }
                        if (currenDate.compareTo(loanColl.get(index).getFirstRateAdjustDate()) == 0) {
                            intRateBase = IntCalHelper.getIntRateBase((Date)loanColl.get(index).getFirstRateAdjustDate(), (IntRateBaseCollection)adjuIntRateBaseColl);
                            intRateAfterAdj = FinHelper.getNewRateByFloatAction(intRateBase, loanColl.get(index).getBasePoints(), loanColl.get(index).getFloatAction());
                            intRateMap.put(loanId, intRateAfterAdj);
                            logger.error((Object)(" \u5f53\u524d\u65e5\u671f\u7b49\u4e8e\u8c03\u6574\u65e5  -->\u53d6\u8c03\u6574\u65e5\u7684\u5229\u7387   \u501f\u6b3e\u5355id = " + loanColl.get(index).getId().toString() + "intRateBase = " + intRateBase + "basePoint" + loanColl.get(index).getBasePoints()));
                            continue;
                        }
                        if (currenDate.compareTo(loanColl.get(index).getFirstRateAdjustDate()) <= 0) continue;
                        BigDecimal hoziron = FinHorizon.getHorizon(firstRateAdjustDate, loanColl.get(index).getExpiredDate());
                        BigDecimal round = hoziron.divide(new BigDecimal(rateAdjustPeriod), 0, RoundingMode.CEILING);
                        int size = round.intValue();
                        for (int i = 0; i < size; ++i) {
                            Date nextPeriodDate = FinHelper.getNextPeriodDate(firstRateAdjustDate, loanColl.get(index).getRateAdjustPeriod());
                            if (currenDate.compareTo(nextPeriodDate) < 0) {
                                currenDate = firstRateAdjustDate;
                                break;
                            }
                            if (currenDate.compareTo(nextPeriodDate) == 0) {
                                currenDate = nextPeriodDate;
                                break;
                            }
                            if (currenDate.compareTo(nextPeriodDate) <= 0) continue;
                            firstRateAdjustDate = nextPeriodDate;
                        }
                        BigDecimal intRateBase2 = IntCalHelper.getIntRateBase((Date)currenDate, (IntRateBaseCollection)adjuIntRateBaseColl);
                        BigDecimal intRateAfterAdj2 = FinHelper.getNewRateByFloatAction(intRateBase2, loanColl.get(index).getBasePoints(), loanColl.get(index).getFloatAction());
                        intRateMap.put(loanId, intRateAfterAdj2);
                        logger.error((Object)("\u5f53\u524d\u65e5\u671f\u5927\u4e8e\u8c03\u6574\u65e5\u5c0f\u4e8e\u7b49\u4e8e\u5230\u671f\u65e5  -->\u53d6\u5f53\u524d\u65e5\u671f\u6240\u5904\u5468\u671f\u7684\u5229\u7387  \u501f\u6b3e\u5355id = " + loanColl.get(index).getId().toString() + "intRateBase = " + intRateBase2 + "basePoint" + loanColl.get(index).getBasePoints()));
                    }
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                    logger.error((Object)("BOSException \u83b7\u53d6\u501f\u6b3e\u5355\u7684\u6700\u65b0\u5229\u7387\u62a5\u9519\u4e86" + e1.getMessage()));
                    throw new RuntimeException();
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                    logger.error((Object)("EASBizException \u83b7\u53d6\u501f\u6b3e\u5355\u7684\u6700\u65b0\u5229\u7387\u62a5\u9519\u4e86" + e.getMessage()));
                    throw new RuntimeException();
                }
            }
            logger.error((Object)"  \u8c03\u606f\u5355   \u501f\u6b3e\u5355 \u8ba1\u7b97\u6700\u65b0\u5229\u7387\u65e5\u5fd7 \u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
            FilterInfo filter = new FilterInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("contractNum"));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            evi.setSelector(sic);
            try {
                loanColl = LoanFactory.getLocalInstance(ctx).getLoanCollection(evi);
                if (EmptyUtil.isEmpty((AbstractObjectCollection)loanColl)) break block37;
                HashSet<String> loanIdSet = new HashSet<String>();
                int count = loanColl.size();
                for (int index = 0; index < count; ++index) {
                    loanIdSet.add(loanColl.get(index).getId().toString());
                }
                Date currenDate = new Date();
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("adjustDate"));
                sic.add(new SelectorItemInfo("firstRateAdjustDate"));
                sic.add(new SelectorItemInfo("rateAdjustPeriod"));
                sic.add(new SelectorItemInfo("BasePoints"));
                sic.add(new SelectorItemInfo("adjustAfterRate"));
                sic.add(new SelectorItemInfo("IntRateType.id"));
                sic.add(new SelectorItemInfo("IntRateType.name"));
                sic.add(new SelectorItemInfo("IntRateType.number"));
                sic.add(new SelectorItemInfo("loan.*"));
                sic.add(new SelectorItemInfo("loan.currency.id"));
                sic.add(new SelectorItemInfo("floatAction"));
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("loan", loanIdSet, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("modifyRateType", (Object)"2", CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("adjustDate", (Object)currenDate, CompareType.LESS_EQUALS));
                evi = new EntityViewInfo();
                evi.setSelector(sic);
                evi.setFilter(filter);
                evi.getSorter().add(new SorterItemInfo("adjustDate"));
                LoanAdjustInterestCollection loanAdjColl = LoanAdjustInterestFactory.getLocalInstance(ctx).getLoanAdjustInterestCollection(evi);
                if (EmptyUtil.isEmpty((AbstractObjectCollection)loanAdjColl)) break block37;
                HashMap<String, IntRateBaseCollection> intRateBaseMap = new HashMap<String, IntRateBaseCollection>();
                IntRateBaseCollection adjuIntRateBaseColl = null;
                int count2 = loanAdjColl.size();
                for (int index = 0; index < count2; ++index) {
                    currenDate = new Date();
                    IntRateTypeInfo intRateType = loanAdjColl.get(index).getIntRateType();
                    String intRateTypeId = "";
                    if (intRateType != null) {
                        intRateTypeId = intRateType.getId().toString();
                    }
                    String loanId = loanAdjColl.get(index).getLoan().getId().toString();
                    String contractNum = loanAdjColl.get(index).getLoan().getContractNum();
                    System.out.println(contractNum);
                    if (GU_DING_LI_LV_ID.equals(intRateTypeId) || EmptyUtil.isEmpty((String)intRateTypeId)) {
                        BigDecimal adjustAfterRate = loanAdjColl.get(index).getAdjustAfterRate();
                        intRateMap.put(loanId, adjustAfterRate);
                        continue;
                    }
                    Date adjustDate = loanAdjColl.get(index).getAdjustDate();
                    Date firstRateAdjustDate = loanAdjColl.get(index).getFirstRateAdjustDate();
                    String currencyId = loanAdjColl.get(index).getLoan().getCurrency().getId().toString();
                    String rateAndCur = intRateTypeId + currencyId;
                    if (intRateBaseMap.containsKey(rateAndCur)) {
                        adjuIntRateBaseColl = (IntRateBaseCollection)intRateBaseMap.get(rateAndCur);
                    } else {
                        try {
                            adjuIntRateBaseColl = FinHelper.getIntRateBaseColl(ctx, intRateTypeId, currencyId);
                        }
                        catch (IMException ime) {
                            logger.error((Object)("\u5bf9\u5e94\u5229\u7387\u7c7b\u578b" + intRateTypeId + "\u6ca1\u6709\u57fa\u51c6\u5229\u7387   \u5e01\u522b = " + currencyId));
                            continue;
                        }
                        intRateBaseMap.put(rateAndCur, adjuIntRateBaseColl);
                    }
                    if (currenDate.compareTo(adjustDate) >= 0 && currenDate.compareTo(firstRateAdjustDate) <= 0) {
                        BigDecimal intRateBase = IntCalHelper.getIntRateBase((Date)currenDate, (IntRateBaseCollection)adjuIntRateBaseColl);
                        BigDecimal intRateAfterAdj = FinHelper.getNewRateByFloatAction(intRateBase, loanAdjColl.get(index).getBasePoints(), loanAdjColl.get(index).getFloatAction());
                        intRateMap.put(loanId, intRateAfterAdj);
                        continue;
                    }
                    if (currenDate.compareTo(firstRateAdjustDate) <= 0) continue;
                    int rateAdjustPeriod = loanAdjColl.get(index).getRateAdjustPeriod();
                    if (rateAdjustPeriod > 0) {
                        BigDecimal hoziron = FinHorizon.getHorizon(firstRateAdjustDate, loanAdjColl.get(index).getLoan().getExpiredDate());
                        BigDecimal round = hoziron.divide(new BigDecimal(rateAdjustPeriod), 0, RoundingMode.CEILING);
                        int size = round.intValue();
                        for (int i = 0; i < size; ++i) {
                            Date nextPeriodDate = FinHelper.getNextPeriodDate(firstRateAdjustDate, loanAdjColl.get(index).getRateAdjustPeriod());
                            if (currenDate.compareTo(nextPeriodDate) < 0) {
                                currenDate = firstRateAdjustDate;
                                break;
                            }
                            if (currenDate.compareTo(nextPeriodDate) == 0) {
                                currenDate = nextPeriodDate;
                                break;
                            }
                            if (currenDate.compareTo(nextPeriodDate) <= 0) continue;
                            currenDate = nextPeriodDate;
                        }
                    }
                    BigDecimal intRateBase = IntCalHelper.getIntRateBase((Date)currenDate, (IntRateBaseCollection)adjuIntRateBaseColl);
                    BigDecimal intRateAfterAdj = FinHelper.getNewRateByFloatAction(intRateBase, loanAdjColl.get(index).getBasePoints(), loanAdjColl.get(index).getFloatAction());
                    intRateMap.put(loanId, intRateAfterAdj);
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
        return intRateMap;
    }

    public static Map getChLoanRateMap(Set idSet) {
        HashMap<String, BigDecimal> intRateMap;
        block39: {
            ChLoanCollection chLoanColl;
            block38: {
                intRateMap = new HashMap<String, BigDecimal>();
                if (idSet.isEmpty()) {
                    return intRateMap;
                }
                logger.error((Object)"\u501f\u6b3e\u5355 \u8ba1\u7b97\u6700\u65b0\u5229\u7387\u65e5\u5fd7 \u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
                StringBuffer sql = new StringBuffer();
                Timestamp time = new Timestamp(new Date().getTime());
                String billState = IntRateStateEnum.AUDITED.getValue();
                sql.append(" select newRate.FID,newRate.IntRate,newRate.FFLOATPOINT,newRate.FFLOATACTION ,newRate.FISLPR from ( \n").append(" select A.FID,case when FRateTypeID ='lJlpCQEQEADgAAc+wKgSjiR9knQ=' then B.FRateAfterAdjt else C.FYearRate end as IntRate,A.FFLOATPOINT,A.FFLOATACTION,C.FISLPR \n").append(" from T_IVT_ChLoan as A left join ( \n").append(" select A.FID,C.FRateAfterAdjt \n").append(" from T_IVT_ChLoan as A ,(select  max(FAdjustSeq)  as FAdjustSeq ,A.FID from T_IVT_ChLoanRateAdjustBill as B, T_IVT_ChLoan as A \n").append(" where A.FID = B.FLoanId and B.FADJUSTDATE<=? group by A.FID) as B ,T_IVT_ChLoanRateAdjustBill as C \n").append(" where A.FID = B.FID and C.FAdjustSeq = B.FAdjustSeq and C.FLoanID = B.FID and C.FADJUSTDATE<= ? \n").append(" ) as B on A.FID = B.FID left join ( \n").append(" select A.FID,C.FYearRate,B.FISLPR from T_IVT_ChLoan as A,( \n").append(" select max(Base.FEffectiveDate) as FEffectiveDate,Base.FCurrencyID,Type.FID,Type.FISLPR from T_INT_IntRateBase as Base,T_INT_IntRateType as Type \n").append(" where Base.FTypeID = Type.FID and Base.FEffectiveDate<=? ").append(" and Base.FbillState = '" + billState + "'").append(" group by Base.FCurrencyID,Type.FID,Type.FISLPR) as B,T_INT_IntRateBase as C \n").append(" where A.FRateTypeID = B.FID and A.FCurrencyID = B.FCurrencyID and C.FTypeID = B.FID and C.FEffectiveDate = B.FEffectiveDate \n").append(" and C.FbillState = '" + billState + "'").append(" ) as C on A.FID = C.FID ) as newRate where 1=1 \n");
                if (idSet.size() > 0) {
                    sql.append("\n and FID in(");
                    sql.append(BirtUtils.idListToInClause((Collection)idSet)).append(")\n");
                }
                logger.error((Object)"sql\u7ed3\u675f  \u501f\u6b3e\u5355 \u8ba1\u7b97\u6700\u65b0\u5229\u7387\u65e5\u5fd7 \u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
                IRowSet rs = null;
                try {
                    rs = FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sql.toString(), new Object[]{time, time, time});
                    while (rs.next()) {
                        if (rs.getInt(5) == 1) {
                            BigDecimal lprNewRate = FinHelper.getNewRateByFloatAction(rs.getBigDecimal(2), rs.getBigDecimal(3), FloatActionEnum.getEnum(rs.getInt(4)));
                            intRateMap.put(rs.getString(1), lprNewRate);
                            continue;
                        }
                        intRateMap.put(rs.getString(1), rs.getBigDecimal(2));
                    }
                }
                catch (EASBizException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (SQLException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                logger.error((Object)" \u5229\u7387\u7c7b\u578b\u4e3alpr\u7684\u501f\u6b3e\u5355  \u7684\u6700\u65b0\u5229\u7387 \u501f\u6b3e\u5355 \u8ba1\u7b97\u6700\u65b0\u5229\u7387\u65e5\u5fd7 \u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
                chLoanColl = null;
                FilterInfo loanfilter = new FilterInfo();
                SelectorItemCollection loanSic = new SelectorItemCollection();
                loanSic.add(new SelectorItemInfo("id"));
                loanSic.add(new SelectorItemInfo("floatPoint"));
                loanSic.add(new SelectorItemInfo("firstRateAdjustDate"));
                loanSic.add(new SelectorItemInfo("rateAdjustPeriod"));
                loanSic.add(new SelectorItemInfo("currency.id"));
                loanSic.add(new SelectorItemInfo("rateType.id"));
                loanSic.add(new SelectorItemInfo("rateType.name"));
                loanSic.add(new SelectorItemInfo("rateType.number"));
                loanSic.add(new SelectorItemInfo("rateType.isLPR"));
                loanSic.add(new SelectorItemInfo("startDate"));
                loanSic.add(new SelectorItemInfo("endDate"));
                loanSic.add(new SelectorItemInfo("FloatAction"));
                loanfilter.getFilterItems().add(new FilterItemInfo("rateType.isLPR", (Object)Constants.ONE));
                loanfilter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
                EntityViewInfo loanEvi = new EntityViewInfo();
                loanEvi.setSelector(loanSic);
                loanEvi.setFilter(loanfilter);
                logger.error((Object)("loanEvi = " + loanEvi.toString()));
                try {
                    chLoanColl = ChLoanFactory.getRemoteInstance().getChLoanCollection(loanEvi);
                    logger.error((Object)("loanColl.size() = " + chLoanColl.size()));
                    if (chLoanColl.size() <= 0) break block38;
                    IntRateBaseCollection adjuIntRateBaseColl = null;
                    HashMap<String, IntRateBaseCollection> intRateBaseMap = new HashMap<String, IntRateBaseCollection>();
                    int count = chLoanColl.size();
                    for (int index = 0; index < count; ++index) {
                        BigDecimal intRateAfterAdj;
                        BigDecimal intRateBase;
                        Date currenDate = new Date();
                        String intRateTypeId = chLoanColl.get(index).getIntRateType().getId().toString();
                        String loanId = chLoanColl.get(index).getId().toString();
                        Date firstRateAdjustDate = chLoanColl.get(index).getFirstRateAdjustDate();
                        String currencyId = chLoanColl.get(index).getCurrency().getId().toString();
                        String rateAndCur = intRateTypeId + currencyId;
                        if (intRateBaseMap.containsKey(rateAndCur)) {
                            adjuIntRateBaseColl = (IntRateBaseCollection)intRateBaseMap.get(rateAndCur);
                        } else {
                            try {
                                adjuIntRateBaseColl = FinHelper.getIntRateBaseColl(intRateTypeId, currencyId);
                            }
                            catch (IMException ime) {
                                logger.error((Object)("\u5bf9\u5e94\u5229\u7387\u7c7b\u578b" + intRateTypeId + "\u6ca1\u6709\u57fa\u51c6\u5229\u7387"));
                                continue;
                            }
                            intRateBaseMap.put(rateAndCur, adjuIntRateBaseColl);
                        }
                        int rateAdjustPeriod = chLoanColl.get(index).getRateAdjustPeriod();
                        if (rateAdjustPeriod == 0) {
                            if (currenDate.compareTo(chLoanColl.get(index).getStartDate()) < 0 || currenDate.compareTo(chLoanColl.get(index).getExpiredDate()) > 0) continue;
                            intRateBase = IntCalHelper.getIntRateBase((Date)currenDate, (IntRateBaseCollection)adjuIntRateBaseColl);
                            intRateAfterAdj = FinHelper.getNewRateByFloatAction(intRateBase, chLoanColl.get(index).getFloatPoint(), chLoanColl.get(index).getFloatAction());
                            intRateMap.put(loanId, intRateAfterAdj);
                            logger.error((Object)(" \u5f53\u524d\u65e5\u671f\u4ecb\u4e8e\u501f\u6b3e\u5355\u8d77\u59cb\u65e5\u548c\u9996\u4e2a\u8c03\u6574\u65e5\u4e4b\u95f4 -->\u53d6\u5f53\u524d\u65e5\u671f\u7684\u5229\u7387 \u501f\u6b3e\u5355id = " + chLoanColl.get(index).getId().toString() + "intRateBase = " + intRateBase + "basePoint" + chLoanColl.get(index).getFloatPoint()));
                            continue;
                        }
                        if (rateAdjustPeriod <= 0) continue;
                        if (currenDate.compareTo(chLoanColl.get(index).getStartDate()) >= 0 && currenDate.compareTo(chLoanColl.get(index).getFirstRateAdjustDate()) < 0) {
                            intRateBase = IntCalHelper.getIntRateBase((Date)chLoanColl.get(index).getStartDate(), (IntRateBaseCollection)adjuIntRateBaseColl);
                            intRateAfterAdj = FinHelper.getNewRateByFloatAction(intRateBase, chLoanColl.get(index).getFloatPoint(), chLoanColl.get(index).getFloatAction());
                            intRateMap.put(loanId, intRateAfterAdj);
                            logger.error((Object)(" \u5f53\u524d\u65e5\u671f\u5728\u8c03\u6574\u65e5\u4e4b\u524d\uff08\u4e0d\u5305\u62ec\u8c03\u6574\u65e5\uff09 -->\u53d6\u8d77\u59cb\u65e5\u7684\u5229\u7387 \u501f\u6b3e\u5355id = " + chLoanColl.get(index).getId().toString() + "intRateBase = " + intRateBase + "basePoint" + chLoanColl.get(index).getFloatPoint()));
                            continue;
                        }
                        if (currenDate.compareTo(chLoanColl.get(index).getFirstRateAdjustDate()) == 0) {
                            intRateBase = IntCalHelper.getIntRateBase((Date)chLoanColl.get(index).getFirstRateAdjustDate(), (IntRateBaseCollection)adjuIntRateBaseColl);
                            intRateAfterAdj = FinHelper.getNewRateByFloatAction(intRateBase, chLoanColl.get(index).getFloatPoint(), chLoanColl.get(index).getFloatAction());
                            intRateMap.put(loanId, intRateAfterAdj);
                            logger.error((Object)(" \u5f53\u524d\u65e5\u671f\u7b49\u4e8e\u8c03\u6574\u65e5  -->\u53d6\u8c03\u6574\u65e5\u7684\u5229\u7387   \u501f\u6b3e\u5355id = " + chLoanColl.get(index).getId().toString() + "intRateBase = " + intRateBase + "basePoint" + chLoanColl.get(index).getFloatPoint()));
                            continue;
                        }
                        if (currenDate.compareTo(chLoanColl.get(index).getFirstRateAdjustDate()) <= 0) continue;
                        BigDecimal hoziron = FinHorizon.getHorizon(firstRateAdjustDate, chLoanColl.get(index).getExpiredDate());
                        BigDecimal round = hoziron.divide(new BigDecimal(rateAdjustPeriod), 0, RoundingMode.CEILING);
                        int size = round.intValue();
                        for (int i = 0; i < size; ++i) {
                            Date nextPeriodDate = FinHelper.getNextPeriodDate(firstRateAdjustDate, chLoanColl.get(index).getRateAdjustPeriod());
                            if (currenDate.compareTo(nextPeriodDate) < 0) {
                                currenDate = firstRateAdjustDate;
                                break;
                            }
                            if (currenDate.compareTo(nextPeriodDate) == 0) {
                                currenDate = nextPeriodDate;
                                break;
                            }
                            if (currenDate.compareTo(nextPeriodDate) <= 0) continue;
                            firstRateAdjustDate = nextPeriodDate;
                        }
                        BigDecimal intRateBase2 = IntCalHelper.getIntRateBase((Date)currenDate, (IntRateBaseCollection)adjuIntRateBaseColl);
                        BigDecimal intRateAfterAdj2 = FinHelper.getNewRateByFloatAction(intRateBase2, chLoanColl.get(index).getFloatPoint(), chLoanColl.get(index).getFloatAction());
                        intRateMap.put(loanId, intRateAfterAdj2);
                        logger.error((Object)("\u5f53\u524d\u65e5\u671f\u5927\u4e8e\u8c03\u6574\u65e5\u5c0f\u4e8e\u7b49\u4e8e\u5230\u671f\u65e5  -->\u53d6\u5f53\u524d\u65e5\u671f\u6240\u5904\u5468\u671f\u7684\u5229\u7387  \u501f\u6b3e\u5355id = " + chLoanColl.get(index).getId().toString() + "intRateBase = " + intRateBase2 + "basePoint" + chLoanColl.get(index).getFloatPoint()));
                    }
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                    logger.error((Object)("BOSException \u83b7\u53d6\u501f\u6b3e\u5355\u7684\u6700\u65b0\u5229\u7387\u62a5\u9519\u4e86" + e1.getMessage()));
                    throw new RuntimeException();
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                    logger.error((Object)("EASBizException \u83b7\u53d6\u501f\u6b3e\u5355\u7684\u6700\u65b0\u5229\u7387\u62a5\u9519\u4e86" + e.getMessage()));
                    throw new RuntimeException();
                }
            }
            logger.error((Object)"  \u8c03\u606f\u5355   \u501f\u6b3e\u5355 \u8ba1\u7b97\u6700\u65b0\u5229\u7387\u65e5\u5fd7 \u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("contractNum"));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            evi.setSelector(sic);
            try {
                chLoanColl = ChLoanFactory.getRemoteInstance().getChLoanCollection(evi);
                if (EmptyUtil.isEmpty((AbstractObjectCollection)chLoanColl)) break block39;
                HashSet<String> loanIdSet = new HashSet<String>();
                int count = chLoanColl.size();
                for (int index = 0; index < count; ++index) {
                    loanIdSet.add(chLoanColl.get(index).getId().toString());
                }
                Date currenDate = new Date();
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("adjustDate"));
                sic.add(new SelectorItemInfo("firstRateAdjustDate"));
                sic.add(new SelectorItemInfo("rateAdjustPeriod"));
                sic.add(new SelectorItemInfo("BasePoints"));
                sic.add(new SelectorItemInfo("rateAfterAdjt"));
                sic.add(new SelectorItemInfo("adjustAfterRate"));
                sic.add(new SelectorItemInfo("IntRateType.id"));
                sic.add(new SelectorItemInfo("IntRateType.name"));
                sic.add(new SelectorItemInfo("IntRateType.number"));
                sic.add(new SelectorItemInfo("loan.*"));
                sic.add(new SelectorItemInfo("loan.currency.id"));
                sic.add(new SelectorItemInfo("floatAction"));
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("loan", loanIdSet, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("modifyRateType", (Object)"2", CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("adjustDate", (Object)currenDate, CompareType.LESS_EQUALS));
                evi = new EntityViewInfo();
                evi.setSelector(sic);
                evi.setFilter(filter);
                evi.getSorter().add(new SorterItemInfo("adjustDate"));
                ChLoanRateAdjustBillCollection loanAdjColl = ChLoanRateAdjustBillFactory.getRemoteInstance().getChLoanRateAdjustBillCollection(evi);
                if (EmptyUtil.isEmpty((AbstractObjectCollection)loanAdjColl)) break block39;
                HashMap<String, IntRateBaseCollection> intRateBaseMap = new HashMap<String, IntRateBaseCollection>();
                IntRateBaseCollection adjuIntRateBaseColl = null;
                int count2 = loanAdjColl.size();
                for (int index = 0; index < count2; ++index) {
                    currenDate = new Date();
                    IntRateTypeInfo intRateType = loanAdjColl.get(index).getIntRateType();
                    String intRateTypeId = "";
                    if (intRateType != null) {
                        intRateTypeId = intRateType.getId().toString();
                    }
                    String loanId = loanAdjColl.get(index).getLoan().getId().toString();
                    if (GU_DING_LI_LV_ID.equals(intRateTypeId) || EmptyUtil.isEmpty((String)intRateTypeId)) {
                        BigDecimal adjustAfterRate = loanAdjColl.get(index).getRateAfterAdjt();
                        intRateMap.put(loanId, adjustAfterRate);
                        continue;
                    }
                    Date adjustDate = loanAdjColl.get(index).getAdjustDate();
                    Date firstRateAdjustDate = loanAdjColl.get(index).getFirstRateAdjustDate();
                    String currencyId = loanAdjColl.get(index).getLoan().getCurrency().getId().toString();
                    String rateAndCur = intRateTypeId + currencyId;
                    if (intRateBaseMap.containsKey(rateAndCur)) {
                        adjuIntRateBaseColl = (IntRateBaseCollection)intRateBaseMap.get(rateAndCur);
                    } else {
                        try {
                            adjuIntRateBaseColl = FinHelper.getIntRateBaseColl(intRateTypeId, currencyId);
                        }
                        catch (IMException ime) {
                            logger.error((Object)("\u5bf9\u5e94\u5229\u7387\u7c7b\u578b" + intRateTypeId + "\u6ca1\u6709\u57fa\u51c6\u5229\u7387   \u5e01\u522b = " + currencyId));
                            continue;
                        }
                        intRateBaseMap.put(rateAndCur, adjuIntRateBaseColl);
                    }
                    if (currenDate.compareTo(adjustDate) >= 0 && currenDate.compareTo(firstRateAdjustDate) <= 0) {
                        BigDecimal intRateBase = IntCalHelper.getIntRateBase((Date)currenDate, (IntRateBaseCollection)adjuIntRateBaseColl);
                        BigDecimal intRateAfterAdj = FinHelper.getNewRateByFloatAction(intRateBase, loanAdjColl.get(index).getBasePoints(), loanAdjColl.get(index).getFloatAction());
                        intRateMap.put(loanId, intRateAfterAdj);
                        continue;
                    }
                    if (currenDate.compareTo(firstRateAdjustDate) <= 0) continue;
                    int rateAdjustPeriod = loanAdjColl.get(index).getRateAdjustPeriod();
                    if (rateAdjustPeriod > 0) {
                        BigDecimal hoziron = FinHorizon.getHorizon(firstRateAdjustDate, loanAdjColl.get(index).getLoan().getExpiredDate());
                        BigDecimal round = hoziron.divide(new BigDecimal(rateAdjustPeriod), 0, RoundingMode.CEILING);
                        int size = round.intValue();
                        for (int i = 0; i < size; ++i) {
                            Date nextPeriodDate = FinHelper.getNextPeriodDate(firstRateAdjustDate, loanAdjColl.get(index).getRateAdjustPeriod());
                            if (currenDate.compareTo(nextPeriodDate) < 0) {
                                currenDate = firstRateAdjustDate;
                                break;
                            }
                            if (currenDate.compareTo(nextPeriodDate) == 0) {
                                currenDate = nextPeriodDate;
                                break;
                            }
                            if (currenDate.compareTo(nextPeriodDate) <= 0) continue;
                            currenDate = nextPeriodDate;
                        }
                    }
                    BigDecimal intRateBase = IntCalHelper.getIntRateBase((Date)currenDate, (IntRateBaseCollection)adjuIntRateBaseColl);
                    BigDecimal intRateAfterAdj = FinHelper.getNewRateByFloatAction(intRateBase, loanAdjColl.get(index).getBasePoints(), loanAdjColl.get(index).getFloatAction());
                    intRateMap.put(loanId, intRateAfterAdj);
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
        return intRateMap;
    }

    private static Date getNextPeriodDate(Date firstRateAdjustDate, int rateAdjustPeriod) {
        Calendar firstCalendar = Calendar.getInstance();
        firstCalendar.setTime(firstRateAdjustDate);
        int flashDay = firstCalendar.get(5);
        if (flashDay == 29 || flashDay == 30 || flashDay == 31) {
            firstCalendar.add(2, rateAdjustPeriod);
            int days = DateTimeUtils.daysOfMonth((int)firstCalendar.get(1), (int)(firstCalendar.get(2) + 1));
            if (days >= flashDay) {
                firstCalendar.set(5, flashDay);
            } else {
                firstCalendar.set(5, days);
            }
        } else {
            firstCalendar.add(2, rateAdjustPeriod);
        }
        return firstCalendar.getTime();
    }

    private static IntRateBaseCollection getIntRateBaseColl(Context ctx, String intRateTypeId, String currencyId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("type.id", (Object)intRateTypeId));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        filter.getFilterItems().add(new FilterItemInfo("intTerm", null, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)"1"));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("effectiveDate"));
        IIntRateBase iIntRateBase = IntRateBaseFactory.getLocalInstance((Context)ctx);
        IntRateBaseCollection intRateBaseColl = iIntRateBase.getIntRateBaseCollection(evi);
        if (intRateBaseColl == null || intRateBaseColl.isEmpty()) {
            throw new IMException(IMException.NOBASERATE);
        }
        return intRateBaseColl;
    }

    private static IntRateBaseCollection getIntRateBaseColl(String intRateTypeId, String currencyId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("type.id", (Object)intRateTypeId));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        filter.getFilterItems().add(new FilterItemInfo("intTerm", null, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)"1"));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("effectiveDate"));
        IIntRateBase iIntRateBase = IntRateBaseFactory.getRemoteInstance();
        IntRateBaseCollection intRateBaseColl = iIntRateBase.getIntRateBaseCollection(evi);
        if (intRateBaseColl == null || intRateBaseColl.isEmpty()) {
            throw new IMException(IMException.NOBASERATE);
        }
        return intRateBaseColl;
    }

    public static String intListToInClause(List intList) {
        StringBuffer sb = new StringBuffer();
        if (intList.size() == 0) {
            throw new IllegalArgumentException("idCollection.size cannot be 0!");
        }
        if (intList.size() == 1) {
            sb.append("'" + ((BankInterface)intList.get(0)).getNumber() + "'");
            return sb.toString();
        }
        Iterator it = intList.iterator();
        int n = intList.size();
        for (int i = 0; i < n - 1; ++i) {
            sb.append("'" + ((BankInterface)it.next()).getNumber() + "'").append(", ");
        }
        sb.append("'" + ((BankInterface)it.next()).getNumber() + "'");
        return sb.toString();
    }

    public static Object cloneObject(Object obj) throws CloneNotSupportedException {
        try {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            new ObjectOutputStream(bo).writeObject(obj);
            ByteArrayInputStream bi = new ByteArrayInputStream(bo.toByteArray());
            return new ObjectInputStream(bi).readObject();
        }
        catch (Exception e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
    }

    public static boolean hasRepaymentOfLoan(String loanId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)loanId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        RepaymentCollection col = RepaymentFactory.getRemoteInstance().getRepaymentCollection(evi);
        return col == null || col.size() <= 0;
    }

    public static boolean hasRepaymentOfFundTransfer(String loanId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("loan.id", (Object)loanId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        FundTransferRepayBillCollection col = FundTransferRepayBillFactory.getRemoteInstance().getFundTransferRepayBillCollection(evi);
        return col == null || col.size() <= 0;
    }

    public static boolean hasRepaymentOfLoan(Context ctx, String loanId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)loanId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        RepaymentCollection col = RepaymentFactory.getLocalInstance(ctx).getRepaymentCollection(evi);
        return col == null || col.size() <= 0;
    }

    public static void fillCombBillStatus(KDComboBox cboStatus) throws Exception {
        cboStatus.removeAllItems();
        cboStatus.addItems(FinBillStatusEnum.getEnumList().toArray());
    }

    public static void setLayout() {
    }

    public static EntityViewInfo getBlockFlowTypeF7Filter() {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("IsInFlow", (Object)new Boolean(false)));
        return evi;
    }

    public static boolean isRelBankCrediLimit(CreditLimitInfo creitLimitInfo, BankInfo bankInfo) {
        if (creitLimitInfo == null || bankInfo == null) {
            return true;
        }
        if (creitLimitInfo.getCreditInstitution() == null) {
            return true;
        }
        return creitLimitInfo.getCreditInstitution().getId().toString().equals(bankInfo.getId().toString());
    }

    public static void fillAndMergeProps(Context ctx, CoreBaseInfo info, String[] properties) throws BOSException {
        if (info == null || info.getId() == null || info.getId().toString().length() == 0 || properties.length == 0) {
            return;
        }
        Arrays.sort(properties);
        SelectorItemCollection sic = new SelectorItemCollection();
        int n = properties.length;
        for (int i = 0; i < n; ++i) {
            sic.add(properties[i]);
        }
        BOSUuid uid = info.getId();
        IDynamicObject dyn = ctx == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)ctx);
        IObjectValue newinfo = dyn.getValue(uid.getType(), (IObjectPK)new ObjectUuidPK(uid), sic);
        for (String aPropertyName : properties) {
            FinHelper.setValues(ctx, info, (CoreBaseInfo)newinfo, aPropertyName);
        }
    }

    private static void setValues(Context ctx, CoreBaseInfo info, CoreBaseInfo newInfo, String propertyName) throws BOSException {
        if (propertyName.equals("*")) {
            Enumeration ketenum = newInfo.keys();
            while (ketenum.hasMoreElements()) {
                String keyName = (String)ketenum.nextElement();
                Object value = info.get(keyName);
                if (value != null || info.get(keyName) instanceof CoreBaseInfo) continue;
                info.put(keyName, newInfo.get(keyName));
            }
            return;
        }
        int dotIdx = propertyName.indexOf(".");
        if (dotIdx > -1) {
            String oneLevelPropertyName = propertyName.substring(0, dotIdx);
            if (info.getObjectValue(oneLevelPropertyName) == null) {
                info.putAll((IObjectValue)newInfo);
                return;
            }
            String twoLevelPropertyName = propertyName.substring(dotIdx + 1);
            if (!info.getObjectValue(oneLevelPropertyName).get("id").toString().equals(newInfo.getObjectValue(oneLevelPropertyName).get("id").toString())) {
                BOSUuid uid = BOSUuid.read((String)info.getObjectValue(oneLevelPropertyName).get("id").toString());
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(twoLevelPropertyName);
                IDynamicObject dyn = ctx == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)ctx);
                IObjectValue tmp = dyn.getValue(uid.getType(), (IObjectPK)new ObjectUuidPK(uid), sic);
                newInfo.put(oneLevelPropertyName, (Object)tmp);
            }
            FinHelper.setValues(ctx, (CoreBaseInfo)info.get(oneLevelPropertyName), (CoreBaseInfo)newInfo.get(oneLevelPropertyName), twoLevelPropertyName);
        } else {
            Object value = info.get(propertyName);
            if (value != null) {
                return;
            }
            if (info.get(propertyName) instanceof CoreBaseInfo) {
                return;
            }
            info.put(propertyName, newInfo.get(propertyName));
        }
    }

    public static int getUIState(EditUI ui) {
        if (null == ui || null == ui.getUIContext()) {
            return 0;
        }
        int iBotp = ui.getUIContext().get("BOTPViewStatus") == null ? 0 : (Integer)ui.getUIContext().get("BOTPViewStatus");
        String oprtState = ui.getOprtState();
        if (null == oprtState || oprtState.length() == 0) {
            return 0;
        }
        if (iBotp == 0) {
            if (oprtState.equalsIgnoreCase("ADDNEW")) {
                return 1;
            }
            if (oprtState.equalsIgnoreCase("EDIT")) {
                return 2;
            }
            if (oprtState.equalsIgnoreCase("VIEW")) {
                return 3;
            }
            if (oprtState.equalsIgnoreCase("FINDVIEW")) {
                return 4;
            }
            return 0;
        }
        if (iBotp == 1) {
            if (oprtState.equalsIgnoreCase("ADDNEW")) {
                return 5;
            }
            if (oprtState.equalsIgnoreCase("EDIT")) {
                return 6;
            }
            return 0;
        }
        return 0;
    }

    public static boolean isInStates(EditUI ui, int[] states) {
        if (null == states || states.length == 0) {
            return false;
        }
        int uiState = FinHelper.getUIState(ui);
        return FinHelper.isInStates(uiState, states);
    }

    public static boolean isInStates(int uiState, int[] states) {
        if (null == states || states.length == 0) {
            return false;
        }
        int n = states.length;
        for (int i = 0; i < n; ++i) {
            if (uiState != states[i]) continue;
            return true;
        }
        return false;
    }

    public static Date maxDate(Date[] dates) {
        Date maxDate = null;
        if (dates == null || dates.length == 0) {
            return maxDate;
        }
        if (dates.length == 1) {
            maxDate = dates[0];
            return maxDate;
        }
        maxDate = dates[0];
        int n = dates.length;
        for (int i = 1; i < n; ++i) {
            if (dates[i] == null) continue;
            if (maxDate == null) {
                maxDate = dates[i];
                continue;
            }
            if (maxDate.compareTo(dates[i]) >= 0) continue;
            maxDate = dates[i];
        }
        return maxDate;
    }

    public static Date minDate(Date[] dates) {
        Date minDate = null;
        if (dates == null || dates.length == 0) {
            return minDate;
        }
        if (dates.length == 1) {
            minDate = dates[0];
            return minDate;
        }
        minDate = dates[0];
        int n = dates.length;
        for (int i = 1; i < n; ++i) {
            if (dates[i] == null) continue;
            if (minDate == null) {
                minDate = dates[i];
                continue;
            }
            if (minDate.compareTo(dates[i]) <= 0) continue;
            minDate = dates[i];
        }
        return minDate;
    }

    private static String[] getArgNames(BigDecimal[] args) {
        if (args == null) {
            return null;
        }
        String[] ret = new String[args.length];
        int n = args.length;
        for (int i = 0; i < n; ++i) {
            ret[i] = "arg" + i;
        }
        return ret;
    }

    public static BigDecimal calcBigDecimalExprs(String expression, BigDecimal[] args) throws Exception {
        Object[] argName = FinHelper.getArgNames(args);
        HashMap<Object, BigDecimal> ctx = null;
        if (args != null) {
            ctx = new HashMap<Object, BigDecimal>(argName.length);
            int n = argName.length;
            for (int i = 0; i < n; ++i) {
                ctx.put(argName[i], args[i]);
            }
        }
        String script = MessageFormat.format(expression, argName);
        return (BigDecimal)FinHelper.evalScript(script, ctx, null);
    }

    public static Object evalScript(String script, Map args, List packages) throws Exception {
        Interpreter interpreter = new Interpreter();
        if (packages != null && packages.size() > 0) {
            interpreter.namespaces.addAll(packages);
        }
        return interpreter.eval(script, args);
    }

    public static boolean isExistDownBill(String srcEntityID, String srcObjectID) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)srcEntityID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)srcObjectID, CompareType.EQUALS));
        evi.setFilter(filter);
        BOTRelationCollection botp = BOTRelationFactory.getRemoteInstance().getCollection(evi);
        return botp.size() > 0;
    }

    public static void checkInnerAcctCtrl(InnerAccountInfo inAcct, CurrencyInfo currency, BigDecimal billAmount) throws EASBizException, BOSException {
        String msg;
        BigDecimal preAmount;
        String msg2;
        BigDecimal totalFrozenAmt;
        BigDecimal currentBalance;
        BigDecimal kValue;
        if (inAcct == null || currency == null || billAmount == null) {
            return;
        }
        AccountMgrStrategyInfo ctrlStrategy = FinHelper.getAcctMgrStrategy(null, inAcct = FinHelper.getInnerAcctInfo(null, inAcct.getId().toString()));
        if (ctrlStrategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTCONTROL) && ctrlStrategy.isRemind() && (kValue = (currentBalance = FinHelper.getInnerAcctBalance(null, inAcct, currency)).subtract(totalFrozenAmt = InnerFrozenDepositFactory.getRemoteInstance().getTotalFrozenAmt(inAcct.getId().toString(), currency.getId().toString()))).compareTo(billAmount) < 0 && MsgBox.showConfirm2((String)(msg2 = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fs.SettlementBillUI", (String)"overDraftFrozen"), inAcct.getName(), kValue, billAmount.subtract(kValue)))) == 2) {
            SysUtil.abort();
        }
        if (ctrlStrategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.INLIMITCANOVERDRAFT) && ctrlStrategy.isRemind() && (preAmount = (kValue = (currentBalance = FinHelper.getInnerAcctBalance(null, inAcct, currency)).subtract(totalFrozenAmt = InnerFrozenDepositFactory.getRemoteInstance().getTotalFrozenAmt(inAcct.getId().toString(), currency.getId().toString()))).subtract(billAmount)).signum() == -1 && preAmount.compareTo(ctrlStrategy.getOverDraftAmount().negate()) >= 0 && MsgBox.showConfirm2((String)(msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fs.SettlementBillUI", (String)"inSafeDraftFrozen"), inAcct.getName(), kValue, ctrlStrategy.getOverDraftAmount(), billAmount.subtract(kValue)))) == 2) {
            SysUtil.abort();
        }
    }

    public static void checkInnerAcctCtrl(Context ctx, InnerAccountInfo inAcct, CurrencyInfo currency, BigDecimal billAmount) throws BOSException, EASBizException {
        if (inAcct == null || currency == null || billAmount == null) {
            return;
        }
        inAcct = FinHelper.getInnerAcctInfo(ctx, inAcct.getId().toString());
        AccountMgrStrategyInfo ctrlStrategy = FinHelper.getAcctMgrStrategy(ctx, inAcct);
        OverdraftCtrlEnum overdraftCtrl = ctrlStrategy.getOverdraftCtrl();
        BigDecimal curBalance = FinHelper.getInnerAcctBalance(ctx, inAcct, currency);
        BigDecimal totalFrozenAmt = InnerFrozenDepositFactory.getLocalInstance((Context)ctx).getTotalFrozenAmt(inAcct.getId().toString(), currency.getId().toString());
        BigDecimal kValue = curBalance.subtract(totalFrozenAmt);
        BigDecimal preAmount = kValue.subtract(billAmount);
        if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.INLIMITCANOVERDRAFT) && preAmount.compareTo(ctrlStrategy.getOverDraftAmount().negate()) < 0) {
            throw new FSException(FSException.OVERDRAFT, new Object[]{inAcct.getName(), kValue, ctrlStrategy.getOverDraftAmount(), preAmount.abs().subtract(ctrlStrategy.getOverDraftAmount())});
        }
        if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.NOTALLOW) && preAmount.signum() < 0) {
            throw new FSException(FSException.NOALLOWOVERDRAFT, new Object[]{inAcct.getName(), kValue, preAmount.abs()});
        }
        if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.LOWESTDEPOSITGUARANTEE) && preAmount.compareTo(ctrlStrategy.getLowestBalance()) < 0) {
            throw new FSException(FSException.OVERLOWAMOUNT, new Object[]{inAcct.getName(), kValue, ctrlStrategy.getLowestBalance().subtract(preAmount)});
        }
    }

    public static InnerAccountInfo getInnerAcctInfo(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("company");
        sic.add("ctrlParam");
        IInnerAccount iInAcct = null;
        iInAcct = ctx == null ? InnerAccountFactory.getRemoteInstance() : InnerAccountFactory.getLocalInstance((Context)ctx);
        return iInAcct.getInnerAccountInfo((IObjectPK)new ObjectUuidPK(id), sic);
    }

    public static AccountMgrStrategyInfo getAcctMgrStrategy(Context ctx, InnerAccountInfo inAcct) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("overdraftCtrl");
        sic.add("overDraftAmount");
        sic.add("lowestBalance");
        sic.add("remind");
        IAccountMgrStrategy iAcctMgrStrategy = null;
        iAcctMgrStrategy = ctx == null ? AccountMgrStrategyFactory.getRemoteInstance() : AccountMgrStrategyFactory.getLocalInstance((Context)ctx);
        return iAcctMgrStrategy.getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(inAcct.getCtrlParam().getId()), sic);
    }

    public static BigDecimal getInnerAcctBalance(Context ctx, InnerAccountInfo inAcct, CurrencyInfo currency) throws EASBizException, BOSException {
        if (currency == null || inAcct == null) {
            return Constants.ZERO;
        }
        ObjectUuidPK chCompanyPk = new ObjectUuidPK(inAcct.getCompany().getId());
        Date unSettleDate = FSHelper.getClearingHouseInfo((Context)ctx, (String)chCompanyPk.toString()).getSettleDate();
        ICompanyOrgUnit iCompanyOrgUnit = null;
        IInAcct iInAcct = null;
        if (ctx == null) {
            iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
            iInAcct = InAcctFactory.getRemoteInstance();
        } else {
            iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            iInAcct = InAcctFactory.getLocalInstance((Context)ctx);
        }
        CompanyOrgUnitInfo chCompany = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)chCompanyPk);
        BigDecimal balance = iInAcct.inAcct(chCompany.getNumber(), inAcct.getNumber(), currency.getNumber(), unSettleDate, unSettleDate, InAcctDataTypeEnum.K);
        if (balance == null) {
            return Constants.ZERO;
        }
        return balance.setScale(currency.getPrecision(), 4);
    }

    public static Map getConRateMap(Set idSet) {
        StringBuffer sql = new StringBuffer();
        String billState = IntRateStateEnum.AUDITED.getValue();
        sql.append(" select newRate.FID,newRate.IntRate from (\n").append(" select A.FID, case when FRateTypeID ='lJlpCQEQEADgAAc+wKgSjiR9knQ=' then B.FRateAfterAdjt else C.FYearRate end as IntRate \n").append(" from T_CL_ConsignmentLoanBill as A left join (  \n").append(" select A.FID,C.FRateAfterAdjt \n").append(" from T_CL_ConsignmentLoanBill as A ,(select  max(FAdjustSeq) as FAdjustSeq ,A.FID from T_CL_CLRateAdjustmentBill as B,T_CL_ConsignmentLoanBill as A  \n").append(" where A.FID = B.FLoanId group by A.FID) as B,T_CL_CLRateAdjustmentBill as C \n").append(" where A.FID = B.FID and C.FAdjustSeq = B.FAdjustSeq and C.FLoanID = B.FID  \n").append(" ) as B on A.FID = B.FID left join ( \n").append(" select A.FID,C.FYearRate from T_CL_ConsignmentLoanBill as A,( \n").append(" select max(Base.FEffectiveDate) as FEffectiveDate,Base.FCurrencyID,Type.FID from T_INT_IntRateBase as Base,T_INT_IntRateType as Type \n").append(" where Base.FTypeID = Type.FID ").append(" and Base.FbillState = '" + billState + "'").append(" group by Base.FCurrencyID,Type.FID) as B,T_INT_IntRateBase as C \n").append(" where A.FRateTypeID = B.FID and A.FCurrencyID = B.FCurrencyID and C.FTypeID = B.FID and C.FEffectiveDate = B.FEffectiveDate \n").append(" and C.FbillState = '" + billState + "'").append(" ) as C on A.FID = C.FID ) as newRate where 1=1 \n");
        if (idSet.size() > 0) {
            sql.append("\n and FID in(");
            sql.append(BirtUtils.idListToInClause((Collection)idSet)).append(")\n");
        }
        HashMap<String, BigDecimal> conRateMap = new HashMap<String, BigDecimal>();
        IRowSet rs = null;
        try {
            rs = FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sql.toString(), null);
            while (rs.next()) {
                conRateMap.put(rs.getString(1), rs.getBigDecimal(2));
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (SQLException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return conRateMap;
    }

    public static void checkGuara(BigDecimal localAmt, KDTable kdGuara, BOSUuid billId) throws BOSException, EASBizException {
        if (EmptyUtil.isEmpty((Object)localAmt)) {
            return;
        }
        int guaraCount = kdGuara.getRowCount();
        String assureNumber = "";
        for (int i = 0; i < guaraCount; ++i) {
            IRow row = kdGuara.getRow(i);
            String rowGuara = FinHelper.checkRowGuara(localAmt, row, billId);
            if (EmptyUtil.isEmpty((String)rowGuara)) continue;
            assureNumber = assureNumber + rowGuara + "\u3001";
        }
        if (!EmptyUtil.isEmpty((String)assureNumber) && MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"605_GuaraCheck", (Object[])new Object[]{assureNumber.substring(0, assureNumber.length() - 1)})) == 2) {
            SysUtil.abort();
        }
    }

    private static String checkRowGuara(BigDecimal loanLocalAmt, IRow row, BOSUuid billId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("assurePercent"));
        sic.add(new SelectorItemInfo("asLocalLimitAmt"));
        sic.add(new SelectorItemInfo("bizLocalBalance"));
        sic.add(new SelectorItemInfo("assureResAmount"));
        sic.add(new SelectorItemInfo("number"));
        if (row.getCell("billID") == null) {
            return "";
        }
        AssureBillInfo assure = AssureBillFactory.getRemoteInstance().getAssureBillInfo((IObjectPK)new ObjectUuidPK(row.getCell("billId").getValue().toString()), sic);
        BigDecimal loanGuara = loanLocalAmt.multiply(new BigDecimal(row.getCell("scale").getValue().toString()).divide(Constants.ONE_HUNDRED)).multiply(assure.getAssurePercent().divide(Constants.ONE_HUNDRED));
        BigDecimal guaraBal = assure.getAsLocalLimitAmt().subtract(assure.getAssureResAmount());
        if (!EmptyUtil.isEmpty((Object)billId)) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sicUsed = new SelectorItemCollection();
            sicUsed.add(new SelectorItemInfo("finbillId"));
            sicUsed.add(new SelectorItemInfo("usedAssAmount"));
            sicUsed.add(new SelectorItemInfo("assureBillId"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("finbillId", (Object)billId.toString()));
            filter.getFilterItems().add(new FilterItemInfo("assureBillId", (Object)row.getCell("billId").getValue().toString()));
            view.setFilter(filter);
            AssureBillUsedCollection usedCol = AssureBillUsedFactory.getRemoteInstance().getAssureBillUsedCollection(view);
            if (usedCol != null && usedCol.size() > 0) {
                AssureBillUsedInfo usedInfo = usedCol.get(0);
                usedInfo.getUsedAssAmount();
                guaraBal = guaraBal.add(usedInfo.getUsedAssAmount().multiply(assure.getAssurePercent().divide(Constants.ONE_HUNDRED)));
            }
        }
        if (loanGuara.compareTo(guaraBal) > 0) {
            return assure.getNumber();
        }
        return "";
    }

    public static Map getConRateMapWithFloat(Set idSet) {
        HashMap<String, BigDecimal> conRateMap;
        block39: {
            ConsignmentLoanBillCollection chLoanColl;
            block38: {
                conRateMap = new HashMap<String, BigDecimal>();
                if (idSet.isEmpty()) {
                    return conRateMap;
                }
                StringBuffer sql = new StringBuffer();
                Timestamp time = new Timestamp(new Date().getTime());
                String billState = IntRateStateEnum.AUDITED.getValue();
                sql.append(" select newRate.FID,newRate.IntRate,newRate.FFLOATINGPOINT,newRate.FFLOATACTION ,newRate.FISLPR  from (\n").append(" select A.FID, FRateTypeID, FFLOATINGPOINT, FCURRENCYID, FEFFECTIVEDATE, case when FRateTypeID ='lJlpCQEQEADgAAc+wKgSjiR9knQ=' then B.FRateAfterAdjt else C.FYearRate end as IntRate,A.FFLOATACTION ,C.FISLPR  \n").append(" from T_CL_ConsignmentLoanBill as A left join (  \n").append(" select A.FID,C.FRateAfterAdjt \n").append(" from T_CL_ConsignmentLoanBill as A ,(select  max(FAdjustSeq) as FAdjustSeq ,A.FID from T_CL_CLRateAdjustmentBill as B,T_CL_ConsignmentLoanBill as A  \n").append(" where A.FID = B.FLoanId and B.FADJUSTDATE<=? group by A.FID) as B,T_CL_CLRateAdjustmentBill as C \n").append(" where A.FID = B.FID and C.FAdjustSeq = B.FAdjustSeq and C.FLoanID = B.FID and C.FADJUSTDATE<= ?  \n").append(" ) as B on A.FID = B.FID left join ( \n").append(" select A.FID,C.FYearRate,B.FISLPR from T_CL_ConsignmentLoanBill as A,( \n").append(" select max(Base.FEffectiveDate) as FEffectiveDate,Base.FCurrencyID,Type.FID,Type.FISLPR from T_INT_IntRateBase as Base,T_INT_IntRateType as Type \n").append(" where Base.FTypeID = Type.FID and Base.FEffectiveDate<=? ").append(" and Base.FbillState = '" + billState + "'").append(" group by Base.FCurrencyID,Type.FID,Type.FISLPR) as B,T_INT_IntRateBase as C \n").append(" where A.FRateTypeID = B.FID and A.FCurrencyID = B.FCurrencyID and C.FTypeID = B.FID    and C.FEffectiveDate = B.FEffectiveDate \n").append(" and C.FbillState = '" + billState + "'").append(" ) as C on A.FID = C.FID ) as newRate where 1=1 \n");
                if (idSet.size() > 0) {
                    sql.append("\n and FID in(");
                    sql.append(BirtUtils.idListToInClause((Collection)idSet)).append(")\n");
                }
                IRowSet rs = null;
                try {
                    rs = FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sql.toString(), new Object[]{time, time, time});
                    while (rs.next()) {
                        if (rs.getInt(5) == 1) {
                            BigDecimal lprNewRate = FinHelper.getNewRateByFloatAction(rs.getBigDecimal(2), rs.getBigDecimal(3), FloatActionEnum.getEnum(rs.getInt(4)));
                            conRateMap.put(rs.getString(1), lprNewRate);
                            continue;
                        }
                        conRateMap.put(rs.getString(1), rs.getBigDecimal(2));
                    }
                }
                catch (EASBizException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (SQLException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                logger.error((Object)" \u5229\u7387\u7c7b\u578b\u4e3alpr\u7684\u501f\u6b3e\u5355  \u7684\u6700\u65b0\u5229\u7387 \u501f\u6b3e\u5355 \u8ba1\u7b97\u6700\u65b0\u5229\u7387\u65e5\u5fd7 \u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
                chLoanColl = null;
                FilterInfo loanfilter = new FilterInfo();
                SelectorItemCollection loanSic = new SelectorItemCollection();
                loanSic.add(new SelectorItemInfo("id"));
                loanSic.add(new SelectorItemInfo("floatingPoint"));
                loanSic.add(new SelectorItemInfo("firstRateAdjustDate"));
                loanSic.add(new SelectorItemInfo("rateAdjustPeriod"));
                loanSic.add(new SelectorItemInfo("currency.id"));
                loanSic.add(new SelectorItemInfo("rateType.id"));
                loanSic.add(new SelectorItemInfo("rateType.name"));
                loanSic.add(new SelectorItemInfo("rateType.number"));
                loanSic.add(new SelectorItemInfo("rateType.isLPR"));
                loanSic.add(new SelectorItemInfo("effectiveDate"));
                loanSic.add(new SelectorItemInfo("maturityDate"));
                loanSic.add(new SelectorItemInfo("floatAction"));
                loanfilter.getFilterItems().add(new FilterItemInfo("rateType.isLPR", (Object)Constants.ONE));
                loanfilter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
                EntityViewInfo loanEvi = new EntityViewInfo();
                loanEvi.setSelector(loanSic);
                loanEvi.setFilter(loanfilter);
                logger.error((Object)("loanEvi = " + loanEvi.toString()));
                try {
                    chLoanColl = ConsignmentLoanBillFactory.getRemoteInstance().getConsignmentLoanBillCollection(loanEvi);
                    logger.error((Object)("loanColl.size() = " + chLoanColl.size()));
                    if (chLoanColl.size() <= 0) break block38;
                    IntRateBaseCollection adjuIntRateBaseColl = null;
                    HashMap<String, IntRateBaseCollection> intRateBaseMap = new HashMap<String, IntRateBaseCollection>();
                    int count = chLoanColl.size();
                    for (int index = 0; index < count; ++index) {
                        BigDecimal intRateAfterAdj;
                        BigDecimal intRateBase;
                        Date currenDate = new Date();
                        String intRateTypeId = chLoanColl.get(index).getIntRateType().getId().toString();
                        String loanId = chLoanColl.get(index).getId().toString();
                        Date firstRateAdjustDate = chLoanColl.get(index).getFirstRateAdjustDate();
                        String currencyId = chLoanColl.get(index).getCurrency().getId().toString();
                        String rateAndCur = intRateTypeId + currencyId;
                        if (intRateBaseMap.containsKey(rateAndCur)) {
                            adjuIntRateBaseColl = (IntRateBaseCollection)intRateBaseMap.get(rateAndCur);
                        } else {
                            try {
                                adjuIntRateBaseColl = FinHelper.getIntRateBaseColl(intRateTypeId, currencyId);
                            }
                            catch (IMException ime) {
                                logger.error((Object)("\u5bf9\u5e94\u5229\u7387\u7c7b\u578b" + intRateTypeId + "\u6ca1\u6709\u57fa\u51c6\u5229\u7387"));
                                continue;
                            }
                            intRateBaseMap.put(rateAndCur, adjuIntRateBaseColl);
                        }
                        int rateAdjustPeriod = chLoanColl.get(index).getRateAdjustPeriod();
                        if (rateAdjustPeriod == 0) {
                            if (currenDate.compareTo(chLoanColl.get(index).getStartDate()) < 0 || currenDate.compareTo(chLoanColl.get(index).getExpiredDate()) > 0) continue;
                            intRateBase = IntCalHelper.getIntRateBase((Date)currenDate, (IntRateBaseCollection)adjuIntRateBaseColl);
                            intRateAfterAdj = FinHelper.getNewRateByFloatAction(intRateBase, chLoanColl.get(index).getFloatPoint(), chLoanColl.get(index).getFloatAction());
                            conRateMap.put(loanId, intRateAfterAdj);
                            logger.error((Object)(" \u5f53\u524d\u65e5\u671f\u4ecb\u4e8e\u501f\u6b3e\u5355\u8d77\u59cb\u65e5\u548c\u9996\u4e2a\u8c03\u6574\u65e5\u4e4b\u95f4 -->\u53d6\u5f53\u524d\u65e5\u671f\u7684\u5229\u7387 \u501f\u6b3e\u5355id = " + chLoanColl.get(index).getId().toString() + "\uff0cintRateBase = " + intRateBase + "\uff0cbasePoint=" + chLoanColl.get(index).getFloatPoint() + "\uff0c\u6d6e\u52a8\u60c5\u51b5=" + (Object)((Object)chLoanColl.get(index).getFloatAction()) + "\uff0c\u6700\u65b0\u5229\u7387=" + intRateAfterAdj));
                            continue;
                        }
                        if (rateAdjustPeriod <= 0) continue;
                        if (currenDate.compareTo(chLoanColl.get(index).getStartDate()) >= 0 && currenDate.compareTo(chLoanColl.get(index).getFirstRateAdjustDate()) < 0) {
                            intRateBase = IntCalHelper.getIntRateBase((Date)chLoanColl.get(index).getStartDate(), (IntRateBaseCollection)adjuIntRateBaseColl);
                            intRateAfterAdj = FinHelper.getNewRateByFloatAction(intRateBase, chLoanColl.get(index).getFloatPoint(), chLoanColl.get(index).getFloatAction());
                            conRateMap.put(loanId, intRateAfterAdj);
                            logger.error((Object)(" \u5f53\u524d\u65e5\u671f\u5728\u8c03\u6574\u65e5\u4e4b\u524d\uff08\u4e0d\u5305\u62ec\u8c03\u6574\u65e5\uff09 -->\u53d6\u8d77\u59cb\u65e5\u7684\u5229\u7387 \u501f\u6b3e\u5355id = " + chLoanColl.get(index).getId().toString() + "\uff0cintRateBase = " + intRateBase + "\uff0cbasePoint" + chLoanColl.get(index).getFloatPoint() + "\uff0c\u6d6e\u52a8\u60c5\u51b5=" + (Object)((Object)chLoanColl.get(index).getFloatAction()) + "\uff0c\u6700\u65b0\u5229\u7387=" + intRateAfterAdj));
                            continue;
                        }
                        if (currenDate.compareTo(chLoanColl.get(index).getFirstRateAdjustDate()) == 0) {
                            intRateBase = IntCalHelper.getIntRateBase((Date)chLoanColl.get(index).getFirstRateAdjustDate(), (IntRateBaseCollection)adjuIntRateBaseColl);
                            intRateAfterAdj = FinHelper.getNewRateByFloatAction(intRateBase, chLoanColl.get(index).getFloatPoint(), chLoanColl.get(index).getFloatAction());
                            conRateMap.put(loanId, intRateAfterAdj);
                            logger.error((Object)(" \u5f53\u524d\u65e5\u671f\u7b49\u4e8e\u8c03\u6574\u65e5  -->\u53d6\u8c03\u6574\u65e5\u7684\u5229\u7387   \u501f\u6b3e\u5355id = " + chLoanColl.get(index).getId().toString() + "\uff0cintRateBase = " + intRateBase + "\uff0cbasePoint" + chLoanColl.get(index).getFloatPoint() + "\uff0c\u6d6e\u52a8\u60c5\u51b5=" + (Object)((Object)chLoanColl.get(index).getFloatAction()) + "\uff0c\u6700\u65b0\u5229\u7387=" + intRateAfterAdj));
                            continue;
                        }
                        if (currenDate.compareTo(chLoanColl.get(index).getFirstRateAdjustDate()) <= 0) continue;
                        BigDecimal hoziron = FinHorizon.getHorizon(firstRateAdjustDate, chLoanColl.get(index).getExpiredDate());
                        BigDecimal round = hoziron.divide(new BigDecimal(rateAdjustPeriod), 0, RoundingMode.CEILING);
                        int size = round.intValue();
                        for (int i = 0; i < size; ++i) {
                            Date nextPeriodDate = FinHelper.getNextPeriodDate(firstRateAdjustDate, chLoanColl.get(index).getRateAdjustPeriod());
                            if (currenDate.compareTo(nextPeriodDate) < 0) {
                                currenDate = firstRateAdjustDate;
                                break;
                            }
                            if (currenDate.compareTo(nextPeriodDate) == 0) {
                                currenDate = nextPeriodDate;
                                break;
                            }
                            if (currenDate.compareTo(nextPeriodDate) <= 0) continue;
                            firstRateAdjustDate = nextPeriodDate;
                        }
                        BigDecimal intRateBase2 = IntCalHelper.getIntRateBase((Date)currenDate, (IntRateBaseCollection)adjuIntRateBaseColl);
                        BigDecimal intRateAfterAdj2 = FinHelper.getNewRateByFloatAction(intRateBase2, chLoanColl.get(index).getFloatPoint(), chLoanColl.get(index).getFloatAction());
                        conRateMap.put(loanId, intRateAfterAdj2);
                        logger.error((Object)("\u5f53\u524d\u65e5\u671f\u5927\u4e8e\u8c03\u6574\u65e5\u5c0f\u4e8e\u7b49\u4e8e\u5230\u671f\u65e5  -->\u53d6\u5f53\u524d\u65e5\u671f\u6240\u5904\u5468\u671f\u7684\u5229\u7387  \u501f\u6b3e\u5355id = " + chLoanColl.get(index).getId().toString() + "\uff0cintRateBase = " + intRateBase2 + "\uff0cbasePoint" + chLoanColl.get(index).getFloatPoint() + "\uff0c\u6d6e\u52a8\u60c5\u51b5=" + (Object)((Object)chLoanColl.get(index).getFloatAction()) + "\uff0c\u6700\u65b0\u5229\u7387=" + intRateAfterAdj2));
                    }
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                    logger.error((Object)("BOSException \u83b7\u53d6\u501f\u6b3e\u5355\u7684\u6700\u65b0\u5229\u7387\u62a5\u9519\u4e86" + e1.getMessage()));
                    throw new RuntimeException();
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                    logger.error((Object)("EASBizException \u83b7\u53d6\u501f\u6b3e\u5355\u7684\u6700\u65b0\u5229\u7387\u62a5\u9519\u4e86" + e.getMessage()));
                    throw new RuntimeException();
                }
            }
            logger.error((Object)"  \u8c03\u606f\u5355   \u501f\u6b3e\u5355 \u8ba1\u7b97\u6700\u65b0\u5229\u7387\u65e5\u5fd7 \u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("contractNum"));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            evi.setSelector(sic);
            try {
                chLoanColl = ConsignmentLoanBillFactory.getRemoteInstance().getConsignmentLoanBillCollection(evi);
                if (EmptyUtil.isEmpty((AbstractObjectCollection)chLoanColl)) break block39;
                HashSet<String> loanIdSet = new HashSet<String>();
                int count = chLoanColl.size();
                for (int index = 0; index < count; ++index) {
                    loanIdSet.add(chLoanColl.get(index).getId().toString());
                }
                Date currenDate = new Date();
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("adjustDate"));
                sic.add(new SelectorItemInfo("firstRateAdjustDate"));
                sic.add(new SelectorItemInfo("rateAdjustPeriod"));
                sic.add(new SelectorItemInfo("BasePoints"));
                sic.add(new SelectorItemInfo("adjustAfterRate"));
                sic.add(new SelectorItemInfo("IntRateType.id"));
                sic.add(new SelectorItemInfo("IntRateType.name"));
                sic.add(new SelectorItemInfo("IntRateType.number"));
                sic.add(new SelectorItemInfo("loan.*"));
                sic.add(new SelectorItemInfo("loan.currency.id"));
                sic.add(new SelectorItemInfo("floatAction"));
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("loan", loanIdSet, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("modifyRateType", (Object)"2", CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("adjustDate", (Object)currenDate, CompareType.LESS_EQUALS));
                evi = new EntityViewInfo();
                evi.setSelector(sic);
                evi.setFilter(filter);
                evi.getSorter().add(new SorterItemInfo("adjustDate"));
                CLRateAdjustmentBillCollection loanAdjColl = CLRateAdjustmentBillFactory.getRemoteInstance().getCLRateAdjustmentBillCollection(evi);
                if (EmptyUtil.isEmpty((AbstractObjectCollection)loanAdjColl)) break block39;
                HashMap<String, IntRateBaseCollection> intRateBaseMap = new HashMap<String, IntRateBaseCollection>();
                IntRateBaseCollection adjuIntRateBaseColl = null;
                int count2 = loanAdjColl.size();
                for (int index = 0; index < count2; ++index) {
                    currenDate = new Date();
                    IntRateTypeInfo intRateType = loanAdjColl.get(index).getIntRateType();
                    String intRateTypeId = "";
                    if (intRateType != null) {
                        intRateTypeId = intRateType.getId().toString();
                    }
                    String loanId = loanAdjColl.get(index).getLoan().getId().toString();
                    if (GU_DING_LI_LV_ID.equals(intRateTypeId) || EmptyUtil.isEmpty((String)intRateTypeId)) {
                        BigDecimal adjustAfterRate = loanAdjColl.get(index).getRateAfterAdjt();
                        conRateMap.put(loanId, adjustAfterRate);
                        logger.error((Object)("\u56fa\u5b9a\u5229\u7387\u7684\u5229\u7387\uff0c  \u501f\u6b3e\u5355id = " + loanAdjColl.get(index).getId().toString() + "\uff0cadjustAfterRate = " + adjustAfterRate));
                        continue;
                    }
                    Date adjustDate = loanAdjColl.get(index).getAdjustDate();
                    Date firstRateAdjustDate = loanAdjColl.get(index).getFirstRateAdjustDate();
                    String currencyId = loanAdjColl.get(index).getLoan().getCurrency().getId().toString();
                    String rateAndCur = intRateTypeId + currencyId;
                    if (intRateBaseMap.containsKey(rateAndCur)) {
                        adjuIntRateBaseColl = (IntRateBaseCollection)intRateBaseMap.get(rateAndCur);
                    } else {
                        try {
                            adjuIntRateBaseColl = FinHelper.getIntRateBaseColl(intRateTypeId, currencyId);
                        }
                        catch (IMException ime) {
                            logger.error((Object)("\u5bf9\u5e94\u5229\u7387\u7c7b\u578b" + intRateTypeId + "\u6ca1\u6709\u57fa\u51c6\u5229\u7387   \u5e01\u522b = " + currencyId));
                            continue;
                        }
                        intRateBaseMap.put(rateAndCur, adjuIntRateBaseColl);
                    }
                    if (currenDate.compareTo(adjustDate) >= 0 && currenDate.compareTo(firstRateAdjustDate) <= 0) {
                        BigDecimal intRateBase = IntCalHelper.getIntRateBase((Date)currenDate, (IntRateBaseCollection)adjuIntRateBaseColl);
                        BigDecimal intRateAfterAdj = FinHelper.getNewRateByFloatAction(intRateBase, loanAdjColl.get(index).getBasePoints(), loanAdjColl.get(index).getFloatAction());
                        conRateMap.put(loanId, intRateAfterAdj);
                        logger.error((Object)("\u5f53\u524d\u65f6\u95f4\u4ecb\u4e8e\u9996\u6b21\u8c03\u6574\u65e5\u4e0e\u9996\u4e2a\u91cd\u5b9a\u4ef7\u65e5\u4e4b\u95f4\u7684\u5229\u7387\uff0c  \u501f\u6b3e\u5355id = " + loanAdjColl.get(index).getId().toString() + "\uff0cintRateBase = " + intRateBase + "\uff0cbasePoint" + loanAdjColl.get(index).getBasePoints() + "\uff0c\u6d6e\u52a8\u60c5\u51b5=" + (Object)((Object)loanAdjColl.get(index).getFloatAction()) + "\uff0c\u6700\u65b0\u5229\u7387=" + intRateAfterAdj));
                        continue;
                    }
                    if (currenDate.compareTo(firstRateAdjustDate) <= 0) continue;
                    int rateAdjustPeriod = loanAdjColl.get(index).getRateAdjustPeriod();
                    if (rateAdjustPeriod > 0) {
                        BigDecimal hoziron = FinHorizon.getHorizon(firstRateAdjustDate, loanAdjColl.get(index).getLoan().getExpiredDate());
                        BigDecimal round = hoziron.divide(new BigDecimal(rateAdjustPeriod), 0, RoundingMode.CEILING);
                        int size = round.intValue();
                        for (int i = 0; i < size; ++i) {
                            Date nextPeriodDate = FinHelper.getNextPeriodDate(firstRateAdjustDate, loanAdjColl.get(index).getRateAdjustPeriod());
                            if (currenDate.compareTo(nextPeriodDate) < 0) {
                                currenDate = firstRateAdjustDate;
                                break;
                            }
                            if (currenDate.compareTo(nextPeriodDate) == 0) {
                                currenDate = nextPeriodDate;
                                break;
                            }
                            if (currenDate.compareTo(nextPeriodDate) <= 0) continue;
                            currenDate = nextPeriodDate;
                        }
                    }
                    BigDecimal intRateBase = IntCalHelper.getIntRateBase((Date)currenDate, (IntRateBaseCollection)adjuIntRateBaseColl);
                    BigDecimal intRateAfterAdj = FinHelper.getNewRateByFloatAction(intRateBase, loanAdjColl.get(index).getBasePoints(), loanAdjColl.get(index).getFloatAction());
                    conRateMap.put(loanId, intRateAfterAdj);
                    logger.error((Object)("\u5728\u91cd\u5b9a\u4ef7\u65e5\u4e4b\u540e\u7684\u5229\u7387\uff0c  \u501f\u6b3e\u5355id = " + loanAdjColl.get(index).getId().toString() + "\uff0cintRateBase = " + intRateBase + "\uff0cbasePoint" + loanAdjColl.get(index).getBasePoints() + "\uff0c\u6d6e\u52a8\u60c5\u51b5=" + (Object)((Object)loanAdjColl.get(index).getFloatAction()) + "\uff0c\u6700\u65b0\u5229\u7387=" + intRateAfterAdj));
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
        return conRateMap;
    }

    public static Map<String, BigDecimal> getRateMap(Set<String> idSet) {
        HashMap<String, BigDecimal> intRateMap;
        block38: {
            LoanCollection loanColl;
            block37: {
                intRateMap = new HashMap<String, BigDecimal>();
                if (idSet.isEmpty()) {
                    return intRateMap;
                }
                logger.error((Object)"\u501f\u6b3e\u5355 \u8ba1\u7b97\u6700\u65b0\u5229\u7387\u65e5\u5fd7 \u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
                StringBuffer sql = new StringBuffer();
                String billState = IntRateStateEnum.AUDITED.getValue();
                Timestamp time = new Timestamp(new Date().getTime());
                sql.append(" select newRate.FID,case when newRate.FFLOATACTION=1 then newRate.IntRate * (1+newRate.FBASEPOINTS/100) else (newRate.IntRate + newRate.FBASEPOINTS) end as IntRate from ( \n").append(" select A.FID,case when FIntRateTypeID ='lJlpCQEQEADgAAc+wKgSjiR9knQ=' then B.FAdjustAfterRate else C.FYearRate end as IntRate,A.FBASEPOINTS,A.FFLOATACTION \n").append(" from T_Fin_Loan as A left join ( \n").append(" select A.FID,C.FAdjustAfterRate \n").append(" from T_Fin_Loan as A ,(select  max(FAdjustSeq)  as FAdjustSeq ,A.FID from T_Fin_LoanAdjustInterest as B, T_Fin_Loan as A \n").append(" where A.FID = B.FLoanId and B.FADJUSTDATE<=? group by A.FID) as B ,T_Fin_LoanAdjustInterest as C \n").append(" where A.FID = B.FID and C.FAdjustSeq = B.FAdjustSeq and C.FLoanID = B.FID and C.FADJUSTDATE<= ?  \n").append(" ) as B on A.FID = B.FID left join ( \n").append(" select A.FID,C.FYearRate from T_Fin_Loan as A,( \n").append(" select max(Base.FEffectiveDate) as FEffectiveDate,Base.FCurrencyID,Type.FID from T_INT_IntRateBase as Base,T_INT_IntRateType as Type \n").append(" where Base.FTypeID = Type.FID ").append(" and Base.FbillState = '" + billState + "'").append(" group by Base.FCurrencyID,Type.FID) as B,T_INT_IntRateBase as C \n").append(" where A.FIntRateTypeID = B.FID and A.FCurrencyID = B.FCurrencyID and C.FTypeID = B.FID and C.FEffectiveDate = B.FEffectiveDate \n").append(" and C.FbillState = '" + billState + "'").append(" ) as C on A.FID = C.FID ) as newRate where 1=1 \n");
                if (idSet.size() > 0) {
                    sql.append("\n and FID in(");
                    sql.append(BirtUtils.idListToInClause(idSet)).append(")\n");
                }
                logger.error((Object)"sql\u7ed3\u675f  \u501f\u6b3e\u5355 \u8ba1\u7b97\u6700\u65b0\u5229\u7387\u65e5\u5fd7 \u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
                IRowSet rs = null;
                try {
                    rs = FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sql.toString(), new Object[]{time, time});
                    while (rs.next()) {
                        intRateMap.put(rs.getString(1), rs.getBigDecimal(2));
                    }
                }
                catch (EASBizException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (SQLException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                logger.error((Object)" \u5229\u7387\u7c7b\u578b\u4e3alpr\u7684\u501f\u6b3e\u5355  \u7684\u6700\u65b0\u5229\u7387 \u501f\u6b3e\u5355 \u8ba1\u7b97\u6700\u65b0\u5229\u7387\u65e5\u5fd7 \u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
                loanColl = null;
                FilterInfo loanfilter = new FilterInfo();
                SelectorItemCollection loanSic = new SelectorItemCollection();
                loanSic.add(new SelectorItemInfo("id"));
                loanSic.add(new SelectorItemInfo("BasePoints"));
                loanSic.add(new SelectorItemInfo("firstRateAdjustDate"));
                loanSic.add(new SelectorItemInfo("rateAdjustPeriod"));
                loanSic.add(new SelectorItemInfo("currency.id"));
                loanSic.add(new SelectorItemInfo("IntRateType.id"));
                loanSic.add(new SelectorItemInfo("IntRateType.name"));
                loanSic.add(new SelectorItemInfo("IntRateType.number"));
                loanSic.add(new SelectorItemInfo("IntRateType.isLPR"));
                loanSic.add(new SelectorItemInfo("IssueDate"));
                loanSic.add(new SelectorItemInfo("ExpiredDate"));
                loanSic.add(new SelectorItemInfo("FloatAction"));
                loanfilter.getFilterItems().add(new FilterItemInfo("IntRateType.isLPR", (Object)Constants.ONE));
                loanfilter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                EntityViewInfo loanEvi = new EntityViewInfo();
                loanEvi.setSelector(loanSic);
                loanEvi.setFilter(loanfilter);
                logger.error((Object)("loanEvi = " + loanEvi.toString()));
                try {
                    loanColl = LoanFactory.getRemoteInstance().getLoanCollection(loanEvi);
                    logger.error((Object)("loanColl.size() = " + loanColl.size()));
                    if (loanColl.size() <= 0) break block37;
                    IntRateBaseCollection adjuIntRateBaseColl = null;
                    HashMap<String, IntRateBaseCollection> intRateBaseMap = new HashMap<String, IntRateBaseCollection>();
                    int count = loanColl.size();
                    for (int index = 0; index < count; ++index) {
                        BigDecimal intRateAfterAdj;
                        BigDecimal intRateBase;
                        Date currenDate = new Date();
                        String intRateTypeId = loanColl.get(index).getIntRateType().getId().toString();
                        String loanId = loanColl.get(index).getId().toString();
                        Date firstRateAdjustDate = loanColl.get(index).getFirstRateAdjustDate();
                        String currencyId = loanColl.get(index).getCurrency().getId().toString();
                        String rateAndCur = intRateTypeId + currencyId;
                        if (intRateBaseMap.containsKey(rateAndCur)) {
                            adjuIntRateBaseColl = (IntRateBaseCollection)intRateBaseMap.get(rateAndCur);
                        } else {
                            try {
                                adjuIntRateBaseColl = FinHelper.getIntRateBaseColl(intRateTypeId, currencyId);
                            }
                            catch (IMException ime) {
                                logger.error((Object)("\u5bf9\u5e94\u5229\u7387\u7c7b\u578b" + intRateTypeId + "\u6ca1\u6709\u57fa\u51c6\u5229\u7387"));
                                continue;
                            }
                            intRateBaseMap.put(rateAndCur, adjuIntRateBaseColl);
                        }
                        int rateAdjustPeriod = loanColl.get(index).getRateAdjustPeriod();
                        if (rateAdjustPeriod == 0) {
                            if (currenDate.compareTo(loanColl.get(index).getIssueDate()) < 0 || currenDate.compareTo(loanColl.get(index).getExpiredDate()) > 0) continue;
                            intRateBase = IntCalHelper.getIntRateBase((Date)currenDate, (IntRateBaseCollection)adjuIntRateBaseColl);
                            intRateAfterAdj = FinHelper.getNewRateByFloatAction(intRateBase, loanColl.get(index).getBasePoints(), loanColl.get(index).getFloatAction());
                            intRateMap.put(loanId, intRateAfterAdj);
                            logger.error((Object)(" \u5f53\u524d\u65e5\u671f\u4ecb\u4e8e\u501f\u6b3e\u5355\u8d77\u59cb\u65e5\u548c\u9996\u4e2a\u8c03\u6574\u65e5\u4e4b\u95f4 -->\u53d6\u5f53\u524d\u65e5\u671f\u7684\u5229\u7387 \u501f\u6b3e\u5355id = " + loanColl.get(index).getId().toString() + "-->intRateBase = " + intRateBase + "basePoint" + loanColl.get(index).getBasePoints()));
                            continue;
                        }
                        if (rateAdjustPeriod <= 0) continue;
                        if (currenDate.compareTo(loanColl.get(index).getIssueDate()) >= 0 && currenDate.compareTo(loanColl.get(index).getFirstRateAdjustDate()) < 0) {
                            intRateBase = IntCalHelper.getIntRateBase((Date)loanColl.get(index).getIssueDate(), (IntRateBaseCollection)adjuIntRateBaseColl);
                            intRateAfterAdj = FinHelper.getNewRateByFloatAction(intRateBase, loanColl.get(index).getBasePoints(), loanColl.get(index).getFloatAction());
                            intRateMap.put(loanId, intRateAfterAdj);
                            logger.error((Object)(" \u5f53\u524d\u65e5\u671f\u5728\u8c03\u6574\u65e5\u4e4b\u524d\uff08\u4e0d\u5305\u62ec\u8c03\u6574\u65e5\uff09 -->\u53d6\u8d77\u59cb\u65e5\u7684\u5229\u7387 \u501f\u6b3e\u5355id = " + loanColl.get(index).getId().toString() + "-->intRateBase = " + intRateBase + "basePoint" + loanColl.get(index).getBasePoints()));
                            continue;
                        }
                        if (currenDate.compareTo(loanColl.get(index).getFirstRateAdjustDate()) == 0) {
                            intRateBase = IntCalHelper.getIntRateBase((Date)loanColl.get(index).getFirstRateAdjustDate(), (IntRateBaseCollection)adjuIntRateBaseColl);
                            intRateAfterAdj = FinHelper.getNewRateByFloatAction(intRateBase, loanColl.get(index).getBasePoints(), loanColl.get(index).getFloatAction());
                            intRateMap.put(loanId, intRateAfterAdj);
                            logger.error((Object)(" \u5f53\u524d\u65e5\u671f\u7b49\u4e8e\u8c03\u6574\u65e5  -->\u53d6\u8c03\u6574\u65e5\u7684\u5229\u7387   \u501f\u6b3e\u5355id = " + loanColl.get(index).getId().toString() + "-->intRateBase = " + intRateBase + "basePoint" + loanColl.get(index).getBasePoints()));
                            continue;
                        }
                        if (currenDate.compareTo(loanColl.get(index).getFirstRateAdjustDate()) <= 0) continue;
                        BigDecimal hoziron = FinHorizon.getHorizon(firstRateAdjustDate, loanColl.get(index).getExpiredDate());
                        BigDecimal round = hoziron.divide(new BigDecimal(rateAdjustPeriod), 0, RoundingMode.CEILING);
                        int size = round.intValue();
                        for (int i = 0; i < size; ++i) {
                            Date nextPeriodDate = FinHelper.getNextPeriodDate(firstRateAdjustDate, loanColl.get(index).getRateAdjustPeriod());
                            if (currenDate.compareTo(nextPeriodDate) < 0) {
                                currenDate = firstRateAdjustDate;
                                break;
                            }
                            if (currenDate.compareTo(nextPeriodDate) == 0) {
                                currenDate = nextPeriodDate;
                                break;
                            }
                            if (currenDate.compareTo(nextPeriodDate) <= 0) continue;
                            firstRateAdjustDate = nextPeriodDate;
                        }
                        BigDecimal intRateBase2 = IntCalHelper.getIntRateBase((Date)currenDate, (IntRateBaseCollection)adjuIntRateBaseColl);
                        BigDecimal intRateAfterAdj2 = FinHelper.getNewRateByFloatAction(intRateBase2, loanColl.get(index).getBasePoints(), loanColl.get(index).getFloatAction());
                        intRateMap.put(loanId, intRateAfterAdj2);
                        logger.error((Object)("\u5f53\u524d\u65e5\u671f\u5927\u4e8e\u8c03\u6574\u65e5\u5c0f\u4e8e\u7b49\u4e8e\u5230\u671f\u65e5  -->\u53d6\u5f53\u524d\u65e5\u671f\u6240\u5904\u5468\u671f\u7684\u5229\u7387  \u501f\u6b3e\u5355id = " + loanColl.get(index).getId().toString() + "-->intRateBase = " + intRateBase2 + "basePoint" + loanColl.get(index).getBasePoints()));
                    }
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                    logger.error((Object)("BOSException \u83b7\u53d6\u501f\u6b3e\u5355\u7684\u6700\u65b0\u5229\u7387\u62a5\u9519\u4e86" + e1.getMessage()));
                    throw new RuntimeException();
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                    logger.error((Object)("EASBizException \u83b7\u53d6\u501f\u6b3e\u5355\u7684\u6700\u65b0\u5229\u7387\u62a5\u9519\u4e86" + e.getMessage()));
                    throw new RuntimeException();
                }
            }
            logger.error((Object)"  \u8c03\u606f\u5355   \u501f\u6b3e\u5355 \u8ba1\u7b97\u6700\u65b0\u5229\u7387\u65e5\u5fd7 \u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("contractNum"));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            evi.setSelector(sic);
            try {
                loanColl = LoanFactory.getRemoteInstance().getLoanCollection(evi);
                if (EmptyUtil.isEmpty((AbstractObjectCollection)loanColl)) break block38;
                HashSet<String> loanIdSet = new HashSet<String>();
                int count = loanColl.size();
                for (int index = 0; index < count; ++index) {
                    loanIdSet.add(loanColl.get(index).getId().toString());
                }
                Date currenDate = new Date();
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("adjustDate"));
                sic.add(new SelectorItemInfo("firstRateAdjustDate"));
                sic.add(new SelectorItemInfo("rateAdjustPeriod"));
                sic.add(new SelectorItemInfo("BasePoints"));
                sic.add(new SelectorItemInfo("adjustAfterRate"));
                sic.add(new SelectorItemInfo("IntRateType.id"));
                sic.add(new SelectorItemInfo("IntRateType.name"));
                sic.add(new SelectorItemInfo("IntRateType.number"));
                sic.add(new SelectorItemInfo("loan.*"));
                sic.add(new SelectorItemInfo("loan.currency.id"));
                sic.add(new SelectorItemInfo("floatAction"));
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("loan", loanIdSet, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("modifyRateType", (Object)"2", CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("adjustDate", (Object)currenDate, CompareType.LESS_EQUALS));
                evi = new EntityViewInfo();
                evi.setSelector(sic);
                evi.setFilter(filter);
                evi.getSorter().add(new SorterItemInfo("adjustDate"));
                LoanAdjustInterestCollection loanAdjColl = LoanAdjustInterestFactory.getRemoteInstance().getLoanAdjustInterestCollection(evi);
                if (EmptyUtil.isEmpty((AbstractObjectCollection)loanAdjColl)) break block38;
                HashMap<String, IntRateBaseCollection> intRateBaseMap = new HashMap<String, IntRateBaseCollection>();
                IntRateBaseCollection adjuIntRateBaseColl = null;
                int count2 = loanAdjColl.size();
                for (int index = 0; index < count2; ++index) {
                    currenDate = new Date();
                    IntRateTypeInfo intRateType = loanAdjColl.get(index).getIntRateType();
                    String intRateTypeId = "";
                    if (intRateType != null) {
                        intRateTypeId = intRateType.getId().toString();
                    }
                    String loanId = loanAdjColl.get(index).getLoan().getId().toString();
                    String contractNum = loanAdjColl.get(index).getLoan().getContractNum();
                    System.out.println(contractNum);
                    if (GU_DING_LI_LV_ID.equals(intRateTypeId) || EmptyUtil.isEmpty((String)intRateTypeId)) {
                        BigDecimal adjustAfterRate = loanAdjColl.get(index).getAdjustAfterRate();
                        intRateMap.put(loanId, adjustAfterRate);
                        continue;
                    }
                    Date adjustDate = loanAdjColl.get(index).getAdjustDate();
                    Date firstRateAdjustDate = loanAdjColl.get(index).getFirstRateAdjustDate();
                    String currencyId = loanAdjColl.get(index).getLoan().getCurrency().getId().toString();
                    String rateAndCur = intRateTypeId + currencyId;
                    if (intRateBaseMap.containsKey(rateAndCur)) {
                        adjuIntRateBaseColl = (IntRateBaseCollection)intRateBaseMap.get(rateAndCur);
                    } else {
                        try {
                            adjuIntRateBaseColl = FinHelper.getIntRateBaseColl(intRateTypeId, currencyId);
                        }
                        catch (IMException ime) {
                            logger.error((Object)("\u5bf9\u5e94\u5229\u7387\u7c7b\u578b" + intRateTypeId + "\u6ca1\u6709\u57fa\u51c6\u5229\u7387   \u5e01\u522b = " + currencyId));
                            continue;
                        }
                        intRateBaseMap.put(rateAndCur, adjuIntRateBaseColl);
                    }
                    if (currenDate.compareTo(adjustDate) >= 0 && currenDate.compareTo(firstRateAdjustDate) <= 0) {
                        BigDecimal intRateBase = IntCalHelper.getIntRateBase((Date)adjustDate, (IntRateBaseCollection)adjuIntRateBaseColl);
                        BigDecimal intRateAfterAdj = FinHelper.getNewRateByFloatAction(intRateBase, loanAdjColl.get(index).getBasePoints(), loanAdjColl.get(index).getFloatAction());
                        intRateMap.put(loanId, intRateAfterAdj);
                        continue;
                    }
                    if (currenDate.compareTo(firstRateAdjustDate) <= 0) continue;
                    int rateAdjustPeriod = loanAdjColl.get(index).getRateAdjustPeriod();
                    if (rateAdjustPeriod > 0) {
                        BigDecimal hoziron = FinHorizon.getHorizon(firstRateAdjustDate, loanAdjColl.get(index).getLoan().getExpiredDate());
                        BigDecimal round = hoziron.divide(new BigDecimal(rateAdjustPeriod), 0, RoundingMode.CEILING);
                        Date lastPeriodDate = firstRateAdjustDate;
                        Date nextPeriodDate = FinHelper.getNextPeriodDate(firstRateAdjustDate, loanAdjColl.get(index).getRateAdjustPeriod());
                        int size = round.intValue();
                        for (int i = 0; i < size; ++i) {
                            if (currenDate.compareTo(nextPeriodDate) < 0) {
                                currenDate = lastPeriodDate;
                                break;
                            }
                            if (currenDate.compareTo(nextPeriodDate) == 0) {
                                currenDate = nextPeriodDate;
                                break;
                            }
                            lastPeriodDate = nextPeriodDate;
                            nextPeriodDate = FinHelper.getNextPeriodDate(nextPeriodDate, loanAdjColl.get(index).getRateAdjustPeriod());
                        }
                    }
                    BigDecimal intRateBase = IntCalHelper.getIntRateBase((Date)currenDate, (IntRateBaseCollection)adjuIntRateBaseColl);
                    BigDecimal intRateAfterAdj = FinHelper.getNewRateByFloatAction(intRateBase, loanAdjColl.get(index).getBasePoints(), loanAdjColl.get(index).getFloatAction());
                    intRateMap.put(loanId, intRateAfterAdj);
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
        return intRateMap;
    }

    private static BigDecimal getNewRateByFloatAction(BigDecimal intRateBase, BigDecimal basePoints, FloatActionEnum floatActionEnum) {
        if (basePoints == null) {
            basePoints = BigDecimal.ZERO;
        }
        BigDecimal newRate = FloatActionEnum.BASEINTRATE_FLOAT.equals((Object)floatActionEnum) ? intRateBase.multiply(new BigDecimal(String.valueOf(1)).add(basePoints.divide(Constants.ONE_HUNDRED, 10, 4))) : intRateBase.add(basePoints);
        return newRate;
    }

    static {
        logger = Logger.getLogger((String)FinHelper.class.getName());
        ZERO_INT = new Integer("0");
    }
}

