/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.expr.Macro;
import com.kingdee.bos.ctrl.kdf.expr.SyntaxErrorException;
import com.kingdee.bos.ctrl.kdf.expr.TableRelations;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.fi.rpt.ReportCaclProxy;
import com.kingdee.eas.fm.fp.FPFormulaCollection;
import com.kingdee.eas.fm.fp.FPFormulaContext;
import com.kingdee.eas.fm.fp.FPFormulaInfo;
import com.kingdee.eas.fm.fp.FPFormulaProxy;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class FPFormulaRunner {
    Logger logger = Logger.getLogger(FPFormulaRunner.class);
    private boolean isServerSide;
    private Context context;

    private FPFormulaRunner(Context ctx) {
        this.context = ctx;
        this.isServerSide = true;
    }

    private FPFormulaRunner() {
    }

    public static FPFormulaRunner getLocalInstance(Context ctx) {
        FPFormulaRunner formulaRunner = new FPFormulaRunner(ctx);
        return formulaRunner;
    }

    public static FPFormulaRunner getRemoteInstance() {
        return new FPFormulaRunner();
    }

    public void run(FPFormulaContext ctx, FPFormulaInfo formula) throws BOSException {
        FPFormulaProxy proxy = null;
        ReportCaclProxy reportCaclProxy = null;
        if (this.isServerSide) {
            proxy = new FPFormulaProxy(this.context);
            reportCaclProxy = new ReportCaclProxy(this.context);
        } else {
            reportCaclProxy = new ReportCaclProxy();
            proxy = new FPFormulaProxy();
        }
        proxy.setFormulaCtx(ctx);
        TableRelations relations = new TableRelations();
        relations.getDefaultFunctionProvider().add(proxy);
        relations.getDefaultFunctionProvider().add(reportCaclProxy);
        Macro macro = relations.getNewMacroEngine(null, ctx.parse(formula.getScript()));
        this.execScript(macro, formula);
    }

    public void run(FPFormulaContext ctx, FPFormulaCollection coll) throws BOSException {
        FPFormulaProxy proxy = new FPFormulaProxy();
        proxy.setFormulaCtx(ctx);
        TableRelations relations = new TableRelations();
        relations.getDefaultFunctionProvider().add(proxy);
        Macro macro = relations.getNewMacroEngine(null, null);
        for (int i = 0; i < coll.size(); ++i) {
            FPFormulaInfo formula = coll.get(i);
            macro.setFormula(ctx.parse(formula.getScript()));
            this.execScript(macro, formula);
        }
    }

    private void execScript(Macro macro, FPFormulaInfo formula) throws BOSException {
        SyntaxErrorException e;
        boolean executeResult = false;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("script: " + formula.getScript()));
        }
        try {
            executeResult = macro.execute();
        }
        catch (Exception e1) {
            System.err.println(e1);
            this.logger.error((Object)e1);
        }
        if (!executeResult && (e = macro.getSyntaxError()) != null) {
            e.printStackTrace();
        }
        Variant variant = macro.getVariableValue("$VALUE");
        Object theValue = null;
        if (variant != null) {
            theValue = variant.getValue();
        }
        BigDecimal rst = Constants.ZERO;
        try {
            rst = TypeConversionUtils.objToBigDecimal((Object)theValue);
            if (rst == null) {
                rst = Constants.ZERO;
            }
        }
        catch (Exception exp) {
            // empty catch block
        }
        formula.setResult(rst);
    }
}

