/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.fm.fp.CycleRangeCollection;
import com.kingdee.eas.fm.fp.CycleRangeInfo;
import com.kingdee.eas.fm.fp.CycleTypeEnum;
import com.kingdee.eas.fm.fp.FPCycleIntervalEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class FPHelper {
    private static CycleRangeCollection getWeekRangeColl(int beginYear, int beginMonth) {
        CycleRangeCollection list = new CycleRangeCollection();
        GregorianCalendar begincal = new GregorianCalendar(beginYear, beginMonth, 1, 0, 0);
        int firstDay = begincal.getFirstDayOfWeek();
        int d = begincal.get(7);
        int c = 7 - d + firstDay;
        CycleRangeInfo info = null;
        info = new CycleRangeInfo();
        info.setBeginDate(begincal.getTime());
        GregorianCalendar endcal = new GregorianCalendar(beginYear, beginMonth, c, 23, 59, 59);
        info.setEndDate(endcal.getTime());
        info.setType(CycleTypeEnum.WEEK);
        list.add(info);
        int max = ((Calendar)begincal).getActualMaximum(5);
        ((Calendar)begincal).add(5, c);
        for (int i = c; i < max - 7; i += 7) {
            info = new CycleRangeInfo();
            info.setBeginDate(begincal.getTime());
            list.add(info);
            ((Calendar)begincal).add(5, 7);
            ((Calendar)endcal).add(5, 7);
            info.setEndDate(endcal.getTime());
            info.setType(CycleTypeEnum.WEEK);
        }
        endcal = new GregorianCalendar(beginYear, beginMonth, max, 23, 59, 59);
        info = new CycleRangeInfo();
        info.setBeginDate(begincal.getTime());
        info.setEndDate(endcal.getTime());
        info.setType(CycleTypeEnum.WEEK);
        list.add(info);
        return list;
    }

    private static CycleRangeCollection getDayRangeColl(int beginYear, int beginMonth, int k) {
        CycleRangeCollection list = new CycleRangeCollection();
        GregorianCalendar begincal = new GregorianCalendar(beginYear, beginMonth, 1, 0, 0);
        GregorianCalendar endcal = new GregorianCalendar(beginYear, beginMonth, 0, 23, 59, 59);
        int max = ((Calendar)begincal).getActualMaximum(5);
        CycleRangeInfo info = null;
        int end = k == 1 ? max : max - k;
        for (int i = 1; i < end; i += k) {
            info = new CycleRangeInfo();
            info.setBeginDate(begincal.getTime());
            list.add(info);
            ((Calendar)begincal).add(5, k);
            ((Calendar)endcal).add(5, k);
            info.setEndDate(endcal.getTime());
            info.setType(CycleTypeEnum.DAY);
        }
        endcal = new GregorianCalendar(beginYear, beginMonth, max, 23, 59, 59);
        info = new CycleRangeInfo();
        info.setBeginDate(begincal.getTime());
        info.setEndDate(endcal.getTime());
        info.setType(CycleTypeEnum.DAY);
        list.add(info);
        return list;
    }

    public static CycleRangeCollection genCycleRanges(CycleTypeEnum cycleType, FPCycleIntervalEnum cycleInterval, int beginYear, int beginMonth, int endYear, int endMonth) {
        CycleRangeCollection cycleRanColl = null;
        if (cycleType == null) {
            return new CycleRangeCollection();
        }
        switch (cycleType.getValue()) {
            case 1: {
                cycleRanColl = FPHelper.genCycleRangeByDay(cycleInterval, beginYear, beginMonth, endYear, endMonth);
                break;
            }
            case 7: {
                cycleRanColl = FPHelper.genCycleRangeByWeek(beginYear, beginMonth, endYear, endMonth);
                break;
            }
            case 30: {
                cycleRanColl = FPHelper.genCycleRangeByMonth(beginYear, beginMonth, endYear, endMonth);
                break;
            }
            case 90: {
                cycleRanColl = FPHelper.genCycleRangeByQuarter(beginYear, beginMonth, endYear, endMonth);
                break;
            }
            case 360: {
                cycleRanColl = FPHelper.genCycleRangeByYear(beginYear, endYear);
            }
        }
        return cycleRanColl;
    }

    private static CycleRangeCollection genCycleRangeByWeek(int beginYear, int beginMonth, int endYear, int endMonth) {
        CycleRangeCollection cycleRanColl = new CycleRangeCollection();
        if (beginYear == endYear) {
            for (int j = beginMonth; j <= endMonth; ++j) {
                cycleRanColl.addCollection(FPHelper.getWeekRangeColl(beginYear, j));
            }
        } else {
            int j;
            for (j = beginMonth; j < 12; ++j) {
                cycleRanColl.addCollection(FPHelper.getWeekRangeColl(beginYear, j));
            }
            for (int i = beginYear + 1; i < endYear; ++i) {
                for (int j2 = 0; j2 < 12; ++j2) {
                    cycleRanColl.addCollection(FPHelper.getWeekRangeColl(i, j2));
                }
            }
            for (j = 0; j <= endMonth; ++j) {
                cycleRanColl.addCollection(FPHelper.getWeekRangeColl(endYear, j));
            }
        }
        return cycleRanColl;
    }

    private static CycleRangeCollection genCycleRangeByYear(int beginYear, int endYear) {
        CycleRangeCollection cycleRanColl = new CycleRangeCollection();
        for (int i = beginYear; i <= endYear; ++i) {
            GregorianCalendar begincal = new GregorianCalendar(i, 0, 1, 0, 0);
            GregorianCalendar endcal = new GregorianCalendar(i, 11, 31, 23, 59, 59);
            CycleRangeInfo info = new CycleRangeInfo();
            info.setBeginDate(begincal.getTime());
            info.setEndDate(endcal.getTime());
            info.setType(CycleTypeEnum.YEAR);
            cycleRanColl.add(info);
        }
        return cycleRanColl;
    }

    private static CycleRangeCollection genCycleRangeByQuarter(int beginYear, int beginMonth, int endYear, int endMonth) throws AssertionError {
        CycleRangeCollection cycleRanColl = new CycleRangeCollection();
        if (beginMonth % 3 != 0) {
            throw new AssertionError((Object)"must 3 multiple");
        }
        int size = (endYear - beginYear) * 4 + (endMonth - beginMonth) / 3 + 1;
        for (int i = 0; i < size; ++i) {
            GregorianCalendar begincal = new GregorianCalendar(beginYear, i * 3 + beginMonth, 1, 0, 0);
            int m = begincal.get(2);
            int max = m == 0 || m == 9 ? 31 : 30;
            GregorianCalendar endcal = new GregorianCalendar(beginYear, i * 3 + beginMonth + 2, max, 23, 59, 59);
            CycleRangeInfo info = new CycleRangeInfo();
            info.setBeginDate(begincal.getTime());
            info.setEndDate(endcal.getTime());
            info.setType(CycleTypeEnum.QUARTER);
            cycleRanColl.add(info);
        }
        return cycleRanColl;
    }

    private static CycleRangeCollection genCycleRangeByMonth(int beginYear, int beginMonth, int endYear, int endMonth) {
        CycleRangeCollection cycleRanColl = new CycleRangeCollection();
        int size = (endYear - beginYear) * 12 + (endMonth - beginMonth) + 1;
        for (int i = 0; i < size; ++i) {
            GregorianCalendar begincal = new GregorianCalendar(beginYear, i + beginMonth, 1, 0, 0);
            int max = ((Calendar)begincal).getActualMaximum(5);
            GregorianCalendar endcal = new GregorianCalendar(beginYear, i + beginMonth, max, 23, 59, 59);
            CycleRangeInfo info = new CycleRangeInfo();
            info.setBeginDate(begincal.getTime());
            info.setEndDate(endcal.getTime());
            info.setType(CycleTypeEnum.MONTH);
            cycleRanColl.add(info);
        }
        return cycleRanColl;
    }

    private static CycleRangeCollection genCycleRangeByDay(FPCycleIntervalEnum cycleInterval, int beginYear, int beginMonth, int endYear, int endMonth) {
        CycleRangeCollection cycleRanColl = new CycleRangeCollection();
        if (beginYear == endYear) {
            for (int j = beginMonth; j <= endMonth; ++j) {
                cycleRanColl.addCollection(FPHelper.getDayRangeColl(beginYear, j, cycleInterval.getValue()));
            }
        } else {
            int j;
            for (j = beginMonth; j < 12; ++j) {
                cycleRanColl.addCollection(FPHelper.getDayRangeColl(beginYear, j, cycleInterval.getValue()));
            }
            for (int i = beginYear + 1; i < endYear; ++i) {
                for (int j2 = 0; j2 < 12; ++j2) {
                    cycleRanColl.addCollection(FPHelper.getDayRangeColl(i, j2, cycleInterval.getValue()));
                }
            }
            for (j = 0; j <= endMonth; ++j) {
                cycleRanColl.addCollection(FPHelper.getDayRangeColl(endYear, j, cycleInterval.getValue()));
            }
        }
        return cycleRanColl;
    }

    public static boolean isExistFPItem(Context ctx, String companyId, String currencyId, Date bizDate) throws BOSException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block4: {
            boolean bl;
            String sqlStr = "SELECT T_FP_FPFormEntry.FID  FROM T_FP_FPFormEntry INNER JOIN T_FP_FPForm ON T_FP_FPFormEntry.FFpFormID = T_FP_FPForm.FID INNER JOIN T_FP_CycleRange ON T_FP_FPFormEntry.FCycleRangeID = T_FP_CycleRange.FID WHERE T_FP_FPForm.FState in ( 10,20) AND (T_FP_FPFormEntry.FType in (2,-2,3,-3,4,-4)) AND (T_FP_FPForm.FCompanyID = ?) AND (T_FP_FPForm.FCurrencyID=?) AND (? BETWEEN T_FP_CycleRange.FBeginDate AND T_FP_CycleRange.FEndDate) ";
            conn = null;
            stmt = null;
            rs = null;
            Object fpFormEntryId = null;
            boolean count = false;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                stmt = conn.prepareStatement(sqlStr.toString());
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)1, (String)companyId);
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)2, (String)currencyId);
                stmt.setDate(3, TypeConversionUtils.objToDate((Object)bizDate));
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                bl = true;
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return false;
    }
}

