/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp;

import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.VOComparator;
import com.kingdee.eas.fm.fp.AbstractFPTemplateInfo;
import com.kingdee.eas.fm.fp.FPItemCollection;
import com.kingdee.eas.fm.fp.FPItemInfo;
import com.kingdee.eas.fm.fp.FPItemTypeEnum;
import com.kingdee.eas.fm.fp.SysDefinedItemEnum;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FPTemplateInfo
extends AbstractFPTemplateInfo
implements Serializable {
    public FPTemplateInfo() {
    }

    public Set getRemovedFormulaIds() {
        HashSet set = (HashSet)this.get("removedFormulaIds");
        if (set == null) {
            set = new HashSet();
            this.put("removedFormulaIds", set);
        }
        return set;
    }

    public Set getRemovedEntryIds() {
        HashSet set = (HashSet)this.get("removedEntryIds");
        if (set == null) {
            set = new HashSet();
            this.put("removedEntryIds", set);
        }
        return set;
    }

    protected FPTemplateInfo(String pkField) {
        super(pkField);
    }

    private void calExpressions() {
        FPItemCollection entries = this.getEntries();
        HashMap<String, FPItemInfo> cache = new HashMap<String, FPItemInfo>(entries.size());
        for (int i = 0; i < entries.size(); ++i) {
            FPItemInfo item = entries.get(i);
            cache.put(item.getNumber(), item);
        }
        this.fillSubTotalExp(entries, cache, FPItemTypeEnum.OPERATINGOUTFLOW);
        this.fillSubTotalExp(entries, cache, FPItemTypeEnum.OPERATINGINFLOW);
        this.fillSubTotalExp(entries, cache, FPItemTypeEnum.FINANCINGOUTFLOW);
        this.fillSubTotalExp(entries, cache, FPItemTypeEnum.FINANCINGINFLOW);
        this.fillSubTotalExp(entries, cache, FPItemTypeEnum.INVESTINGINFLOW);
        this.fillSubTotalExp(entries, cache, FPItemTypeEnum.INVESTINGOUTFLOW);
        this.fillEndExp(cache);
    }

    private void fillEndExp(Map cache) {
        FPItemInfo statusItem = (FPItemInfo)cache.get(SysDefinedItemEnum.ENDING.getName());
        StringBuffer sb = new StringBuffer();
        sb.append("3");
        FPItemInfo item = null;
        item = (FPItemInfo)cache.get(FPItemTypeEnum.OPERATINGINFLOW.getName());
        sb.append("," + item.getLineNo());
        item = (FPItemInfo)cache.get(FPItemTypeEnum.OPERATINGOUTFLOW.getName());
        sb.append(",-" + item.getLineNo());
        item = (FPItemInfo)cache.get(FPItemTypeEnum.FINANCINGINFLOW.getName());
        sb.append("," + item.getLineNo());
        item = (FPItemInfo)cache.get(FPItemTypeEnum.FINANCINGOUTFLOW.getName());
        sb.append(",-" + item.getLineNo());
        item = (FPItemInfo)cache.get(FPItemTypeEnum.INVESTINGINFLOW.getName());
        sb.append("," + item.getLineNo());
        item = (FPItemInfo)cache.get(FPItemTypeEnum.INVESTINGOUTFLOW.getName());
        sb.append(",-" + item.getLineNo());
        statusItem.setExpression(sb.toString());
    }

    private void fillSubTotalExp(FPItemCollection entries, Map cache, FPItemTypeEnum itemTypeEnum) {
        FPItemInfo statusItem = (FPItemInfo)cache.get(itemTypeEnum.getName());
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < entries.size(); ++i) {
            FPItemInfo item = entries.get(i);
            if (!item.getType().equals((Object)itemTypeEnum)) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(item.getLineNo());
        }
        statusItem.setExpression(sb.toString());
    }

    public void fillItemNumber() {
        VOComparator c = new VOComparator(new String[]{"type", "number"});
        Object[] entries = this.getEntries().toArray();
        Arrays.sort(entries, c);
        FPItemInfo lst = null;
        for (int i = 0; i < entries.length; ++i) {
            FPItemInfo entry = (FPItemInfo)entries[i];
            if (FMHelper.isEmpty((String)entry.getNumber())) {
                entry.setNumber(this.NextNumber(lst, entry.getType()));
            }
            lst = entry;
        }
        this.calExpressions();
    }

    private String NextNumber(FPItemInfo lst, FPItemTypeEnum type) {
        if (lst == null) {
            return this.createNumber(1, type);
        }
        FPItemTypeEnum lstType = lst.getType();
        if (lstType.equals((Object)type)) {
            String number = lst.getNumber();
            String sIndex = number.substring(type.getName().length() + 1);
            int i = Integer.parseInt(sIndex);
            return this.createNumber(++i, type);
        }
        return this.createNumber(1, type);
    }

    private String createNumber(int i, FPItemTypeEnum type) {
        return type.getName() + "." + StringUtils.fixNumber((int)i, (int)5);
    }

    public static String getExp(String fpItemExp) {
        int[] ts = FMHelper.splitString((String)fpItemExp, (String)",");
        StringBuffer sb = new StringBuffer(128);
        if (ts == null || ts.length == 0) {
            return null;
        }
        sb.append("=");
        for (int idx = 0; idx < ts.length; ++idx) {
            if (ts[idx] > 0) {
                sb.append("+");
            } else {
                sb.append("-");
            }
            sb.append("cell(" + Math.abs(ts[idx]) + ",COLUMN_INDEX).getValue()");
        }
        return sb.toString();
    }
}

