/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.client.FormulaPickerUI;
import com.kingdee.eas.fi.rpt.client.IFormulaPickerListener;
import com.kingdee.eas.fm.common.FMCommonFacadeFactory;
import com.kingdee.eas.fm.common.IFMCommonFacade;
import com.kingdee.eas.fm.fp.CycleTypeEnum;
import com.kingdee.eas.fm.fp.FPCycleIntervalEnum;
import com.kingdee.eas.fm.fp.FPFormulaTypeEnum;
import com.kingdee.eas.fm.fp.FPItemTypeEnum;
import com.kingdee.eas.fm.fp.FPTemplateCollection;
import com.kingdee.eas.fm.fp.FPTemplateFactory;
import com.kingdee.eas.fm.fp.FPTemplateInfo;
import com.kingdee.eas.fm.fp.IFPTemplate;
import com.kingdee.eas.fm.fp.client.FMFormulaPickerListenerImpl;
import com.kingdee.eas.fm.fp.client.FPFormulaPromptBox;
import com.kingdee.eas.fm.fp.client.FPItemPromptBox;
import com.kingdee.eas.fm.fp.client.FixedFPItemUI;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FPClientHelper {
    public static KDPromptSelector getFormulasF7(IUIObject ui, String companyId, CycleTypeEnum type, FPCycleIntervalEnum interval) {
        return new FPFormulaPromptBox(ui, companyId, type, interval);
    }

    public static KDPromptSelector getFPItemF7(IUIObject ui, String companyId, String currencyId, Date bizDate, FPItemTypeEnum[] types) throws EASBizException {
        return new FPItemPromptBox(ui, companyId, currencyId, bizDate, types);
    }

    public static KDPromptSelector getSingleFPItemF7(IUIObject ui, String companyId, String currencyId, Date bizDate, FPItemTypeEnum[] types) throws EASBizException {
        return new FPItemPromptBox(ui, companyId, currencyId, bizDate, types, true);
    }

    public static FPTemplateCollection getTemplateCollection(String companyID) throws EASBizException, BOSException {
        IFMCommonFacade iFMCommonFacade = FMCommonFacadeFactory.getRemoteInstance();
        Set orgIDSet = iFMCommonFacade.getAllParentOrgIds("00000000-0000-0000-0000-0000000000024F2827FD", companyID);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)orgIDSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2)));
        filterInfo.getFilterItems().add(new FilterItemInfo("effectedStatus", (Object)new Integer(2)));
        ev.setFilter(filterInfo);
        IFPTemplate iTemplate = FPTemplateFactory.getRemoteInstance();
        FPTemplateCollection templateCollection = iTemplate.getFPTemplateCollection(ev);
        return templateCollection;
    }

    public static EntityViewInfo getTemplateFilterInfo(String companyID) throws EASBizException, BOSException {
        IFMCommonFacade iFMCommonFacade = FMCommonFacadeFactory.getRemoteInstance();
        Set orgIDSet = iFMCommonFacade.getAllParentOrgIds("00000000-0000-0000-0000-0000000000024F2827FD", companyID);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)orgIDSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2)));
        filterInfo.getFilterItems().add(new FilterItemInfo("effectedStatus", (Object)new Integer(2)));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID));
        filterInfo.setMaskString("(#0 and #1 and #2 )or #3");
        ev.setFilter(filterInfo);
        return ev;
    }

    public static void fillCellExpression(KDTable tblMain) {
        for (int i = 0; i < tblMain.getRowCount(); ++i) {
            IRow row = tblMain.getRow(i);
            String rowExp = (String)row.getUserObject();
            if (EmptyUtil.isEmpty((String)rowExp)) continue;
            String cellExp = FPTemplateInfo.getExp(rowExp);
            for (int j = 1; j < tblMain.getColumnCount(); ++j) {
                row.getCell(j).setExpressions(cellExp);
            }
        }
    }

    public static void verifyEmpty(FixedFPItemUI ui, String resourcePath, KDFormattedTextField txtNumber, String msg) {
        Number txt = txtNumber.getNumberValue();
        if (txt == null) {
            txtNumber.requestFocus(true);
            MsgBox.showWarning((Component)((Object)ui), (String)EASResource.getString((String)resourcePath, (String)msg));
            SysUtil.abort();
        }
    }

    public static String showDialogWindow(IUIObject ui, FPFormulaTypeEnum type, boolean isGroup) throws UIException {
        if (type == null) {
            return null;
        }
        UIContext ctx = new UIContext((Object)ui);
        ctx.put((Object)"FPFormulaResultType", (Object)type);
        FormulaPickerUI picker = null;
        IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow wnd = fy.create(FormulaPickerUI.class.getName(), (Map)ctx);
        picker = wnd != null ? (FormulaPickerUI)wnd.getUIObject() : null;
        FMFormulaPickerListenerImpl listener = new FMFormulaPickerListenerImpl();
        picker.addFormulaPickerListener((IFormulaPickerListener)listener);
        if (type == FPFormulaTypeEnum.PLANNING) {
            if (isGroup) {
                picker.setFilter("include:categorys{fm_fp},groups{1},formulas{FPFC}");
            } else {
                picker.setFilter("include:categorys{fm_fp},groups{1},formulas{FPFIX,FPFC}");
            }
        } else {
            picker.setFilter("include:categorys{fm_fp},groups{1},formulas{FPAC}");
        }
        picker.open();
        return listener.formula;
    }

    public static void setTemplateFilterByCompany(String[] companyIds, String currentCompanyId, KDBizPromptBox f7Template) throws BOSException, EASBizException {
        if (EmptyUtil.isEmpty((Object[])companyIds)) {
            return;
        }
        Set set = new HashSet();
        IFMCommonFacade fm = FMCommonFacadeFactory.getRemoteInstance();
        String treeId = "00000000-0000-0000-0000-0000000000024F2827FD";
        set = fm.getAllParentOrgIds(treeId, currentCompanyId);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(CheckedStatusEnum.AUDITED.getValue())));
        FilterInfo self = new FilterInfo();
        self.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentCompanyId));
        filter.mergeFilter(self, "or");
        ev.setFilter(filter);
        f7Template.setEntityViewInfo(ev);
        f7Template.setData(null);
    }

    public static Set getItemTypeAry(boolean isPayee) {
        HashSet<Integer> set = new HashSet<Integer>();
        if (isPayee) {
            set.add(new Integer(3));
            set.add(new Integer(4));
            set.add(new Integer(2));
        } else {
            set.add(new Integer(-3));
            set.add(new Integer(-4));
            set.add(new Integer(-2));
        }
        return set;
    }

    public static void initFPItemF7(KDBizPromptBox fpItemF7, String companyId, String currencyId, boolean isPayee) {
        Set itemTypeAry = FPClientHelper.getItemTypeAry(isPayee);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)itemTypeAry, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)DateUtil.getDayBegin(), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)DateUtil.getDayBegin(), CompareType.GREATER_EQUALS));
        ev.setFilter(filter);
        fpItemF7.setEntityViewInfo(ev);
    }
}

