/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fp.AdjustFormEntryCollection;
import com.kingdee.eas.fm.fp.AdjustFormEntryFactory;
import com.kingdee.eas.fm.fp.AdjustFormEntryInfo;
import com.kingdee.eas.fm.fp.FPFormEntryInfo;
import com.kingdee.eas.fm.fp.IAdjustFormEntry;
import com.kingdee.eas.fm.fp.client.AbstractFPEntryAdjustUI;
import com.kingdee.eas.fm.fp.client.FPFormClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.TypeConversionUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;

public class FPEntryAdjustUI
extends AbstractFPEntryAdjustUI {
    public static String CTX_ENTRY = "ENTRY";
    public static String CTX_ADJUSTENTRIES = "ADJUSTENTRIES";
    public static final String CTX_ORIGINALITY_AMOUNT = "ORIGINALITY_AMOUNT";
    public static final String CTX_FORM_NAME = "FORM_NAME";
    public static final String CTX_FORM_NUMBER = "FORM_NUMBER";
    public static final String CTX_CURRENCYID = "CURRENCYID";
    private String ITEM_NAME = "AdjustItem";
    private String ITEM_AMOUNT = "AdjustAmount";
    private String ORIGINALITY_AMOUNT = "OriginalityAmount";
    private String resourcePath = "com.kingdee.eas.fm.fp.FPFormResource";
    private AdjustFormEntryCollection historyAdjustFormEntryColl = null;
    private AdjustFormEntryCollection adjustFormEntryColl = null;
    private AdjustFormEntryInfo origAmount = null;

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    private void initData() throws BOSException {
        FPFormEntryInfo entryInfo = (FPFormEntryInfo)this.getUIContext().get(CTX_ENTRY);
        this.txtName.setText(this.getUIContext().get(CTX_FORM_NAME).toString());
        this.txtNumber.setText(this.getUIContext().get(CTX_FORM_NUMBER).toString());
        this.loadData(entryInfo);
        this.calculateTotal();
    }

    private void loadData(FPFormEntryInfo entryInfo) throws BOSException {
        AdjustFormEntryInfo info;
        int i;
        this.tblMain.checkParsed();
        BOSUuid currencyId = (BOSUuid)this.getUIContext().get(CTX_CURRENCYID);
        String numberFmt = FMClientHelper.getNumberFtm((BOSUuid)currencyId);
        this.historyAdjustFormEntryColl = this.getHistoryFormEntryColl(entryInfo);
        this.adjustFormEntryColl = (AdjustFormEntryCollection)((Object)this.getUIContext().get(CTX_ADJUSTENTRIES));
        int prec = FMClientHelper.getPrecOfCurrency((BOSUuid)currencyId);
        KDTDefaultCellEditor cellEditor = FMClientHelper.getCurrencyEditor((int)prec);
        IColumn col = this.tblMain.addColumn();
        col.setKey(this.ITEM_NAME);
        col = this.tblMain.addColumn();
        col.setEditor((ICellEditor)cellEditor);
        col.getStyleAttributes().setNumberFormat(numberFmt);
        col.setKey(this.ITEM_AMOUNT);
        IRow headRow = this.tblMain.addHeadRow();
        headRow.getCell(this.ITEM_NAME).setValue((Object)EASResource.getString((String)this.resourcePath, (String)this.ITEM_NAME));
        headRow.getCell(this.ITEM_AMOUNT).setValue((Object)EASResource.getString((String)this.resourcePath, (String)this.ITEM_AMOUNT));
        IRow row = null;
        if (this.historyAdjustFormEntryColl.size() == 0 && this.origAmount == null) {
            row = this.tblMain.addRow();
            row.getStyleAttributes().setBackground(Color.YELLOW);
            row.getCell(this.ITEM_NAME).setValue((Object)EASResource.getString((String)this.resourcePath, (String)this.ORIGINALITY_AMOUNT));
            row.getCell(this.ITEM_AMOUNT).setValue((Object)entryInfo.getPlanAmount());
            row.getStyleAttributes().setLocked(true);
            this.origAmount = new AdjustFormEntryInfo();
            this.origAmount.setCause(EASResource.getString((String)this.resourcePath, (String)this.ORIGINALITY_AMOUNT));
            this.origAmount.setCycleRange(entryInfo.getCycleRange());
            this.origAmount.setFpEntry(entryInfo);
            Object oriAmount = this.getUIContext().get(CTX_ORIGINALITY_AMOUNT);
            this.origAmount.setOriginalAmount(new BigDecimal(oriAmount.toString()));
            this.origAmount.setAugmentAmount(new BigDecimal(oriAmount.toString()));
            this.origAmount.setIsOrigAmount(true);
        }
        for (i = 0; i < this.historyAdjustFormEntryColl.size(); ++i) {
            info = this.historyAdjustFormEntryColl.get(i);
            row = this.tblMain.addRow();
            row.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
            row.getCell(this.ITEM_NAME).setValue((Object)info.getCause());
            row.getCell(this.ITEM_AMOUNT).setValue((Object)info.getAugmentAmount());
            row.setUserObject((Object)info);
            row.getStyleAttributes().setLocked(true);
            if (!info.isIsOrigAmount()) continue;
            row.getStyleAttributes().setBackground(Color.YELLOW);
        }
        for (i = 0; i < this.adjustFormEntryColl.size(); ++i) {
            info = this.adjustFormEntryColl.get(i);
            if (info.isIsOrigAmount()) continue;
            row = this.tblMain.addRow();
            row.getCell(this.ITEM_NAME).setValue((Object)info.getCause());
            row.getCell(this.ITEM_AMOUNT).setValue((Object)info.getAugmentAmount());
            row.setUserObject((Object)info);
        }
        for (i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            row.getCell(this.ITEM_AMOUNT).getStyleAttributes().setNumberFormat(numberFmt);
        }
    }

    private AdjustFormEntryCollection getHistoryFormEntryColl(FPFormEntryInfo entryInfo) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("fpEntry", (Object)entryInfo.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("adjustForm.effected", (Object)new Integer(1), CompareType.EQUALS));
        ev.setFilter(filterInfo);
        SorterItemInfo dateSorter = new SorterItemInfo("isOrigAmount");
        dateSorter.setSortType(SortType.DESCEND);
        ev.getSorter().add(dateSorter);
        IAdjustFormEntry iAdjustFormEntry = AdjustFormEntryFactory.getRemoteInstance();
        this.adjustFormEntryColl = iAdjustFormEntry.getAdjustFormEntryCollection(ev);
        return this.adjustFormEntryColl;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        BOSUuid currencyId = (BOSUuid)this.getUIContext().get(CTX_CURRENCYID);
        int prec = FMClientHelper.getPrecOfCurrency((BOSUuid)currencyId);
        this.txtTotal.setPrecision(prec);
        this.initData();
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.destroyWindow();
    }

    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        this.checkInput(this.tblMain.getRow(this.tblMain.getRowCount() - 1));
        AdjustFormEntryCollection adjustEntryColl = new AdjustFormEntryCollection();
        int num = 0;
        num = this.historyAdjustFormEntryColl.size() > 0 ? this.historyAdjustFormEntryColl.size() : 1;
        for (int i = num; i < this.tblMain.getRowCount(); ++i) {
            AdjustFormEntryInfo info = new AdjustFormEntryInfo();
            IRow row = this.tblMain.getRow(i);
            if (row.getUserObject() != null) {
                info = (AdjustFormEntryInfo)row.getUserObject();
            }
            if (info.isIsOrigAmount()) continue;
            FPFormEntryInfo formEntryInfo = (FPFormEntryInfo)this.getUIContext().get(CTX_ENTRY);
            info.setAugmentAmount(new BigDecimal(row.getCell(1).getValue().toString()));
            info.setCause(row.getCell(0).getValue().toString());
            info.setCycleRange(formEntryInfo.getCycleRange());
            info.setFpEntry(formEntryInfo);
            Object oriAmount = this.getUIContext().get(CTX_ORIGINALITY_AMOUNT);
            info.setOriginalAmount(new BigDecimal(oriAmount.toString()));
            info.setIsOrigAmount(false);
            adjustEntryColl.add(info);
        }
        if (this.origAmount != null && !this.adjustFormEntryColl.contains(this.origAmount)) {
            adjustEntryColl.add(this.origAmount);
        }
        this.adjustFormEntryColl = adjustEntryColl;
        this.destroyWindow();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnAdd.setText(null);
        this.btnRemove.setText(null);
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.txtTotal.setEditable(false);
    }

    public AdjustFormEntryCollection getResult() {
        return this.adjustFormEntryColl;
    }

    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        super.btnAdd_actionPerformed(e);
        IRow row = this.tblMain.getRow(this.tblMain.getRowCount() - 1);
        if (row != null) {
            this.checkInput(row);
            this.tblMain.addRow();
        }
    }

    protected void btnRemove_actionPerformed(ActionEvent e) throws Exception {
        super.btnRemove_actionPerformed(e);
        FMClientHelper.checkSelected((Component)((Object)this), (KDTable)this.tblMain);
        int rowNum = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        if (rowNum < this.historyAdjustFormEntryColl.size()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"AdjustHistoryCanNotDel"));
            SysUtil.abort();
        }
        if (this.historyAdjustFormEntryColl.size() == 0 && this.origAmount.getFpEntry().getPlanAmount().equals(this.tblMain.getRow(rowNum).getCell(this.ITEM_AMOUNT).getValue())) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"OriginalCanNotDel"));
            SysUtil.abort();
        }
        if (rowNum != -1) {
            this.tblMain.removeRow(rowNum);
        }
        this.calculateTotal();
    }

    protected void checkInput(IRow row) throws Exception {
        if (row.getCell(this.ITEM_NAME).getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"AdjustItemCanNotNull"));
            SysUtil.abort();
        }
        if (row.getCell(this.ITEM_AMOUNT).getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"AdjustAmountCanNotNull"));
            SysUtil.abort();
        }
        FMClientVerifyHelper.checkStringLength((Component)((Object)this), (String)FPFormClientHelper.resourcePath, (IRow)row, (String)this.ITEM_NAME, (int)80);
    }

    protected boolean checkBeforeWindowClosing() {
        return true;
    }

    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        super.tblMain_editStopped(e);
        this.calculateTotal();
    }

    private void calculateTotal() {
        int rowCount = this.tblMain.getRowCount();
        BigDecimal total = Constants.ZERO;
        for (int i = 0; i < rowCount; ++i) {
            if (this.tblMain.getCell(i, 1).getValue() == null) continue;
            total = total.add(TypeConversionUtils.objToBigDecimal((Object)this.tblMain.getCell(i, 1).getValue()));
        }
        this.txtTotal.setValue((Object)total);
    }
}

