/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.QueryFieldCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.BooleanEnum;
import com.kingdee.eas.base.commonquery.CompareSignEnum;
import com.kingdee.eas.base.commonquery.LeftBracketSignEnum;
import com.kingdee.eas.base.commonquery.LogicSignEnum;
import com.kingdee.eas.base.commonquery.RightBracketSignEnum;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fp.FPFormulaInfo;
import com.kingdee.eas.fm.fp.client.AbstractFPFCFormulaUI;
import com.kingdee.eas.util.client.ComboBoxItem;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.enums.EnumUtils;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class FPFCFormulaUI
extends AbstractFPFCFormulaUI {
    private static final String COL_LOGICSIGN = "logicSign";
    private static final String COL_RIGHTBS = "rightBS";
    private static final String COL_COMPAREFIELD = "compareField";
    private static final String COL_COMPARETYPE = "compareType";
    private static final String COL_COMPAREVALUE = "compareValue";
    private static final String COL_LEFTBS = "leftBS";
    public static final String CTX_BILLTYPE = "billType";
    boolean isCanceled = false;
    private Object data = null;

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public Object getData() {
        return this.data;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        String billType = (String)this.getUIContext().get(CTX_BILLTYPE);
        if (FMHelper.isEmpty((String)billType)) {
            this.abort();
        }
        String fullName = "com.kingdee.eas.fm.formula." + billType;
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        QueryInfo query = loader.getQuery((IMetaDataPK)new MetaDataPK(fullName));
        PropertyUnitCollection units = query.getUnits();
        QueryFieldCollection fields = units.getQueryFields();
        this.cboField.removeAllItems();
        for (int i = 0; i < fields.size(); ++i) {
            QueryFieldInfo fd = fields.get(i);
            String isfilter = fd.getExtendedProperty("isCommonQueryFilter");
            if (!Boolean.valueOf(isfilter).equals(Boolean.TRUE)) continue;
            this.cboField.addItem((Object)new ComboBoxItem(fd.getDisplayName(), (Object)fd));
        }
        this.cboLogicSign.removeAllItems();
        this.cboLogicSign.addItems(LogicSignEnum.getEnumList().toArray());
        this.cboLeftBS.removeAllItems();
        this.cboLeftBS.addItems(LeftBracketSignEnum.getEnumList().toArray());
        this.cboRightBS.removeAllItems();
        this.cboRightBS.addItems(RightBracketSignEnum.getEnumList().toArray());
        this.cboCompareSign.removeAllItems();
        this.cboCompareSign.addItems(CompareSignEnum.getEnumList().toArray());
        this.tblMain.checkParsed();
        this.tblMain.getColumn(COL_LEFTBS).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cboLeftBS));
        this.tblMain.getColumn(COL_COMPAREFIELD).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cboField));
        this.tblMain.getColumn(COL_COMPARETYPE).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cboCompareSign));
        this.tblMain.getColumn(COL_RIGHTBS).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cboRightBS));
        this.tblMain.getColumn(COL_LOGICSIGN).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cboLogicSign));
        this.tblMain.addRows(10);
    }

    protected void btnClear_actionPerformed(ActionEvent e) throws Exception {
        super.btnClear_actionPerformed(e);
        this.tblMain.removeRows();
    }

    protected void btnDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        super.btnDeleteLine_actionPerformed(e);
        int row = this.tblMain.getSelectManager().getActiveRowIndex();
        if (row >= 0) {
            this.tblMain.removeRow(row);
        }
    }

    protected void btnInserLine_actionPerformed(ActionEvent e) throws Exception {
        super.btnInserLine_actionPerformed(e);
        this.tblMain.addRow();
    }

    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        String s = null;
        try {
            s = this.getFilterString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.abort(ex);
        }
        if (!FMHelper.isEmpty((String)s)) {
            FPFormulaInfo info = new FPFormulaInfo();
            info.setTip(s);
            this.data = info;
        } else {
            this.data = null;
        }
        this.destroyWindow();
    }

    protected boolean isBlankRow(int rowIndex) {
        int columnSize = this.tblMain.getColumnCount();
        for (int i = 0; i < columnSize; ++i) {
            if (Util.getValue((Object)this.tblMain.getRow(rowIndex).getCell(i).getValue()).toString().trim().equalsIgnoreCase("")) continue;
            return false;
        }
        return true;
    }

    private String getFilterString() {
        int rowCount = this.tblMain.getRowCount();
        FilterInfo newFilterInfo = new FilterInfo();
        if (rowCount <= 0) {
            return null;
        }
        StringBuffer sbMaskStr = new StringBuffer();
        for (int i = 0; i < rowCount; ++i) {
            if (this.isBlankRow(i)) continue;
            IRow iRow = this.tblMain.getRow(i);
            String leftBracket = Util.getValue((Object)iRow.getCell(COL_LEFTBS).getValue()).toString();
            String condition = null;
            Object value = iRow.getCell(COL_COMPAREFIELD).getValue();
            if (value != null && value instanceof ComboBoxItem) {
                QueryFieldInfo p = (QueryFieldInfo)((ComboBoxItem)value).getValue();
                condition = p.getName();
            }
            String compare = Util.getValue((Object)iRow.getCell(COL_COMPARETYPE).getValue()).toString().toLowerCase();
            Object compareValue = Util.getValue((Object)iRow.getCell(COL_COMPAREVALUE).getValue());
            String rightBracket = Util.getValue((Object)iRow.getCell(COL_RIGHTBS).getValue()).toString();
            String logic = Util.getValue((Object)iRow.getCell(COL_LOGICSIGN).getValue()).toString();
            CompareSignEnum compareSignEnum = CompareSignEnum.getEnum((String)compare.toUpperCase());
            FilterItemInfo includeFilter = this.isIncludeCompare(compareSignEnum) ? new FilterItemInfo(condition, (Object)this.processIncludeValue(compareValue.toString()), CompareType.getEnum((String)compare)) : new FilterItemInfo(condition, compareValue, CompareType.getEnum((String)compare));
            newFilterInfo.getFilterItems().add(includeFilter);
            sbMaskStr.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
        }
        if (sbMaskStr != null && sbMaskStr.length() > 0) {
            newFilterInfo.setMaskString(sbMaskStr.toString().substring(0, sbMaskStr.length() - 1));
        }
        return newFilterInfo.toString();
    }

    protected Set processIncludeValue(String str) {
        HashSet<String> value = new HashSet<String>();
        if (str.indexOf(";") > 0) {
            StringTokenizer tokenizer = new StringTokenizer(str, ";");
            while (tokenizer.hasMoreTokens()) {
                String temp = tokenizer.nextToken();
                value.add(temp);
            }
        } else {
            value.add(str);
        }
        return value;
    }

    protected boolean isIncludeCompare(CompareSignEnum compareSignEnum) {
        if (compareSignEnum != null) {
            if (compareSignEnum.equals((Object)CompareSignEnum.INCLUDESIGN)) {
                return true;
            }
            if (compareSignEnum.equals((Object)CompareSignEnum.NOTINCLUDESIGN)) {
                return true;
            }
        }
        return false;
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.data = null;
        this.isCanceled = true;
        this.destroyWindow();
    }

    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if (colIndex == this.tblMain.getColumnIndex(COL_COMPAREFIELD)) {
            ComboBoxItem item = (ComboBoxItem)this.tblMain.getRow(rowIndex).getCell(COL_COMPAREFIELD).getValue();
            if (item == null) {
                return;
            }
            if (rowIndex >= 0) {
                IRow row = this.tblMain.getRow(rowIndex);
                QueryFieldInfo fd = (QueryFieldInfo)item.getValue();
                PropertyInfo p = fd.getPropertyRefs().get(0).getRefProperty();
                String datatype = p.getString("datatype");
                KDTDefaultCellEditor editor = null;
                if ("String".equals(datatype)) {
                    KDTextField c = new KDTextField();
                    editor = new KDTDefaultCellEditor((JTextField)c);
                } else if ("Boolean".equals(datatype)) {
                    KDComboBox c = new KDComboBox(BooleanEnum.getEnumList().toArray());
                    editor = new KDTDefaultCellEditor((JComboBox)c);
                } else if ("Enum".equals(datatype)) {
                    String md = p.getString("metadataref");
                    KDComboBox c = new KDComboBox(EnumUtils.getEnumList((String)md).toArray());
                    editor = new KDTDefaultCellEditor((JComboBox)c);
                } else {
                    KDTextField c = new KDTextField();
                    editor = new KDTDefaultCellEditor((JTextField)c);
                }
                row.getCell(COL_COMPAREVALUE).setEditor((ICellEditor)editor);
                row.getCell(COL_COMPAREVALUE).setValue(null);
            }
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnInserLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDeleteLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnClear.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
    }
}

