/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fp.AdjustFormCollection;
import com.kingdee.eas.fm.fp.AdjustFormEntryCollection;
import com.kingdee.eas.fm.fp.AdjustFormEntryInfo;
import com.kingdee.eas.fm.fp.AdjustFormFactory;
import com.kingdee.eas.fm.fp.AdjustFormInfo;
import com.kingdee.eas.fm.fp.FPFormEntryInfo;
import com.kingdee.eas.fm.fp.FPFormFactory;
import com.kingdee.eas.fm.fp.FPFormInfo;
import com.kingdee.eas.fm.fp.FPItemTypeEnum;
import com.kingdee.eas.fm.fp.IAdjustForm;
import com.kingdee.eas.fm.fp.client.AbstractFPFormAdjustUI;
import com.kingdee.eas.fm.fp.client.FPEntryAdjustUI;
import com.kingdee.eas.fm.fp.client.FPFormClientHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class FPFormAdjustUI
extends AbstractFPFormAdjustUI {
    private String resourcePath = "com.kingdee.eas.fm.fp.FPFormResource";
    private AdjustFormInfo adjustFormInfo;

    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        if ("VIEW".equals(this.getOprtState())) {
            this.btnEdit.setEnabled(false);
        }
    }

    public void loadFields() {
        super.loadFields();
        FPFormInfo formInfo = (FPFormInfo)this.getDataObject();
        String periodStr = FPFormClientHelper.getPeriodStr(formInfo.getBeginYear(), formInfo.getBeginMonth() + 1, formInfo.getEndYear(), formInfo.getEndMonth() + 1);
        this.txtPeriod.setText(periodStr);
        FPFormClientHelper.setData(this.tblMain, formInfo, true, true);
        this.attachAdjusted();
    }

    private void attachAdjusted() {
        Iterator iter = this.adjustFormInfo.getEntries().iterator();
        while (iter.hasNext()) {
            AdjustFormEntryInfo afei = (AdjustFormEntryInfo)iter.next();
            if (afei.isIsOrigAmount()) continue;
            FPFormEntryInfo entryInfo = afei.getFpEntry();
            int lineNo = entryInfo.getFpItem().getLineNo();
            String colKey = entryInfo.getCycleRange().genTimeKey();
            ICell cell = this.tblMain.getCell(lineNo - 1, colKey);
            cell.setValue((Object)afei.getAugmentAmount().add((BigDecimal)cell.getValue()));
        }
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FPFormFactory.getRemoteInstance();
    }

    protected void btnAdjust_actionPerformed(ActionEvent e) throws Exception {
        super.btnAdjust_actionPerformed(e);
        if (!this.checkAdjustCell()) {
            return;
        }
        ICell cell = this.getSelectedCell();
        FPFormEntryInfo entryInfo = (FPFormEntryInfo)cell.getUserObject();
        Date beginDate = entryInfo.getCycleRange().getBeginDate();
        Date endDate = entryInfo.getCycleRange().getBeginDate();
        if (new Date().getMonth() > endDate.getMonth() && new Date().getYear() >= endDate.getYear()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"HistoryPlanCanNotAdjust"));
            SysUtil.abort();
        }
        AdjustFormEntryCollection collection = new AdjustFormEntryCollection();
        String entryId = entryInfo.getId().toString();
        if (this.adjustFormInfo != null) {
            AdjustFormEntryCollection adEntries = this.adjustFormInfo.getEntries();
            for (int i = 0; i < adEntries.size(); ++i) {
                if (!adEntries.get(i).getFpEntry().getId().toString().equals(entryId)) continue;
                collection.add(adEntries.get(i));
            }
        }
        IUIWindow adjustEntryUIWindow = this.getUIWindow(cell, entryInfo, collection);
        adjustEntryUIWindow.show();
        AdjustFormEntryCollection results = ((FPEntryAdjustUI)adjustEntryUIWindow.getUIObject()).getResult();
        if (results == null) {
            return;
        }
        this.onAdjustEntry(cell, entryInfo, collection, results);
        this.tblMain.getScriptManager().run();
    }

    private ICell getSelectedCell() {
        int rowNum = this.tblMain.getSelectManager().getActiveRowIndex();
        int colNum = this.tblMain.getSelectManager().getActiveColumnIndex();
        ICell cell = this.tblMain.getCell(rowNum, colNum);
        return cell;
    }

    private boolean checkAdjustCell() {
        ICell cell = this.getSelectedCell();
        if (cell == null) {
            return false;
        }
        int rowNum = cell.getRowIndex();
        int colNum = cell.getColumnIndex();
        if (colNum < 2 || colNum == this.tblMain.getColumnCount() - 1) {
            return false;
        }
        IRow row = this.tblMain.getRow(rowNum);
        FPFormEntryInfo info = (FPFormEntryInfo)row.getUserObject();
        return info.getType() != FPItemTypeEnum.SYSTEMHOLD && info.getType() != FPItemTypeEnum.SUBTOTAL;
    }

    private void onAdjustEntry(ICell cell, FPFormEntryInfo entryInfo, AdjustFormEntryCollection collection, AdjustFormEntryCollection results) {
        for (int i = 0; i < collection.size(); ++i) {
            this.adjustFormInfo.getEntries().remove(collection.get(i));
        }
        this.adjustFormInfo.getEntries().addCollection(results);
        BigDecimal disValue = Constants.ZERO;
        disValue = disValue.add(entryInfo.getPlanAmount());
        for (int i = 0; i < results.size(); ++i) {
            AdjustFormEntryInfo result = results.get(i);
            if (result.isIsOrigAmount()) continue;
            disValue = disValue.add(result.getAugmentAmount());
        }
        cell.setValue((Object)disValue);
    }

    private IUIWindow getUIWindow(ICell cell, FPFormEntryInfo entryInfo, AdjustFormEntryCollection collection) throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)FPEntryAdjustUI.CTX_ENTRY, (Object)entryInfo);
        uiContext.put((Object)FPEntryAdjustUI.CTX_ADJUSTENTRIES, (Object)collection);
        uiContext.put((Object)"ORIGINALITY_AMOUNT", (Object)entryInfo.getPlanAmount());
        FPFormInfo formInfo = (FPFormInfo)this.getDataObject();
        uiContext.put((Object)"FORM_NAME", (Object)formInfo.getName());
        uiContext.put((Object)"FORM_NUMBER", (Object)formInfo.getNumber());
        uiContext.put((Object)"CURRENCYID", (Object)formInfo.getCurrency().getId());
        IUIWindow adjustEntryUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FPEntryAdjustUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        return adjustEntryUIWindow;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        IAdjustForm iAdjustForm = AdjustFormFactory.getRemoteInstance();
        iAdjustForm.submit(this.adjustFormInfo);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        FPFormInfo formInfo = FPFormClientHelper.getUserDefValue(pk);
        this.adjustFormInfo = this.getAdjustFormInfoByFormId(pk);
        if (this.adjustFormInfo == null) {
            this.adjustFormInfo = new AdjustFormInfo();
            this.adjustFormInfo.setCompany(formInfo.getCompany());
            this.adjustFormInfo.setVerAuditTime(formInfo.getAuditedTime());
            this.adjustFormInfo.setAdjustor(ContextHelperFactory.getRemoteInstance().getCurrentUser());
            this.adjustFormInfo.setEffected(false);
            this.adjustFormInfo.setVersionNo(Constants.FIRST_VERSION);
        }
        this.adjustFormInfo.setFpForm(formInfo);
        return formInfo;
    }

    private AdjustFormInfo getAdjustFormInfoByFormId(IObjectPK pk) throws BOSException {
        IAdjustForm iAdjustForm = AdjustFormFactory.getRemoteInstance();
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("entries.fpEntry.fpItem.lineNo"));
        sic.add(new SelectorItemInfo("entries.fpEntry.cycleRange.*"));
        sic.add(new SelectorItemInfo("adjustor.*"));
        sic.add(new SelectorItemInfo("company.*"));
        ev.getSelector().addObjectCollection((IObjectCollection)sic);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("fpForm", (Object)pk.toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("effected", (Object)new Integer(0), CompareType.EQUALS));
        ev.setFilter(filterInfo);
        SorterItemInfo versionNoSorter = new SorterItemInfo("versionNo");
        ev.getSorter().add(versionNoSorter);
        AdjustFormCollection adjustFormColl = iAdjustForm.getAdjustFormCollection(ev);
        if (adjustFormColl != null && adjustFormColl.size() > 0) {
            return adjustFormColl.get(0);
        }
        return null;
    }

    protected void btnViewOverdue_actionPerformed(ActionEvent e) throws Exception {
        super.btnViewOverdue_actionPerformed(e);
        FPFormClientHelper.viewOverdue(this.tblMain);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAdjust.setIcon(EASResource.getIcon((String)"imgTbtn_budgetadjust"));
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.btnAdjust.setEnabled(false);
        }
        FMClientHelper.clearSeparatorOnToolBar((KDToolBar)this.toolBar);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }
}

