/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTEditHelper;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionEvent;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fm.common.FMCommonFacadeFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.fm.common.HashSearchEngine;
import com.kingdee.eas.fm.common.IFMCommonFacade;
import com.kingdee.eas.fm.common.IFMIsqlFacade;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fp.FPException;
import com.kingdee.eas.fm.fp.FPFormEntryCollection;
import com.kingdee.eas.fm.fp.FPFormEntryInfo;
import com.kingdee.eas.fm.fp.FPFormFactory;
import com.kingdee.eas.fm.fp.FPFormInfo;
import com.kingdee.eas.fm.fp.FPFormStateEnum;
import com.kingdee.eas.fm.fp.FPFormulaCollection;
import com.kingdee.eas.fm.fp.FPFormulaContext;
import com.kingdee.eas.fm.fp.FPFormulaFactory;
import com.kingdee.eas.fm.fp.FPFormulaInfo;
import com.kingdee.eas.fm.fp.FPFormulaTypeEnum;
import com.kingdee.eas.fm.fp.IFPForm;
import com.kingdee.eas.fm.fp.IFPFormula;
import com.kingdee.eas.fm.fp.client.AbstractFPFormEditUI;
import com.kingdee.eas.fm.fp.client.FPFormAddNewCondParam;
import com.kingdee.eas.fm.fp.client.FPFormClientHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FPFormEditUI
extends AbstractFPFormEditUI {
    public static final String resourcePath = "com.kingdee.eas.fm.fp.FPFormResource";
    private TabChangeListener changeListener = new TabChangeListener();
    private KDTable table = new KDTable();
    private KDTabbedPane tabPane = new KDTabbedPane();
    private FPFormEntryInfo so = null;
    ICell currentCell;

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSubmitWF.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnAntiAudit.setIcon(EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.btnViewSubmitProcess.setIcon(EASResource.getIcon((String)"imgTbtn_descrydispose"));
        this.btnViewSubmitProcess.setText(null);
    }

    private void setWorkButtonStatus(FPFormStateEnum stateEnum) {
        if ("VIEW".equals(this.getOprtState())) {
            if (stateEnum.equals((Object)FPFormStateEnum.BEFOREAPPROVAL)) {
                this.btnAntiAudit.setEnabled(false);
                this.btnAudit.setEnabled(true);
            }
            if (stateEnum.equals((Object)FPFormStateEnum.APPROVED)) {
                this.btnAudit.setEnabled(false);
                this.btnAntiAudit.setEnabled(true);
            }
        }
        FMClientHelper.clearSeparatorOnToolBar((KDToolBar)this.toolBar);
    }

    public FPFormEditUI() throws Exception {
        this.table.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    FPFormEditUI.this.table_editStopped(e);
                }
                catch (Exception exc) {
                    FPFormEditUI.this.handUIException(exc);
                }
            }
        });
        this.table.addKDTActiveCellListener(new KDTActiveCellListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void activeCellChanged(KDTActiveCellEvent e) {
                try {
                    FPFormEditUI.this.table_activeCellChanged(e);
                }
                catch (Exception exc) {
                    FPFormEditUI.this.handUIException(exc);
                }
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        FPFormInfo formInfo = (FPFormInfo)this.getDataObject();
        String periodStr = formInfo.getBeginDate() + " - " + formInfo.getEndDate();
        this.txtPeriod.setText(periodStr);
        if (this.editData.isIsJoint()) {
            this.initCompanyPage(formInfo.getTemplate().getId().toString());
            this.addComponent((Component)this.tabPane);
            this.tabPane.addChangeListener((ChangeListener)this.changeListener);
            KDScrollPane firstPane = (KDScrollPane)this.tabPane.getComponentAt(0);
            firstPane.getViewport().add((Component)this.table);
            if (OprtState.ADDNEW.equals(this.oprtState) || OprtState.EDIT.equals(this.oprtState)) {
                FPFormClientHelper.setData(this.table, formInfo, false, true);
            } else {
                FPFormClientHelper.setData(this.table, formInfo, true, true);
            }
        } else {
            this.addComponent((Component)this.table);
            if (OprtState.ADDNEW.equals(this.oprtState) || OprtState.EDIT.equals(this.oprtState)) {
                FPFormClientHelper.setData(this.table, formInfo, false, true);
            } else {
                FPFormClientHelper.setData(this.table, formInfo, true, true);
            }
        }
        this.setWorkButtonStatus(this.editData.getState());
        FMClientHelper.updateUITitle((CoreUIObject)this, (String)this.resHelper.getString("this.title"));
        this.enableExportExcel(this.table);
    }

    private void addComponent(Component comp) {
        comp.setVisible(true);
        this.add(comp, new KDLayout.Constraints(10, 76, 850, 465, 15));
    }

    public void loadFields() {
        super.loadFields();
        if (this.oprtState.equals(OprtState.ADDNEW)) {
            FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.editData.getCompany().getId().toString());
        }
    }

    protected IObjectValue createNewData() {
        FPFormAddNewCondParam param = (FPFormAddNewCondParam)this.getUIContext().get("param");
        FPFormInfo formInfo = null;
        try {
            formInfo = this.genFPForm(param);
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgBox.showError((Component)((Object)this), (String)(EASResource.getString((String)resourcePath, (String)"createPlanFormFail") + e));
            SysUtil.abort((Throwable)e);
        }
        formInfo.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
        return formInfo;
    }

    private FPFormInfo genFPForm(FPFormAddNewCondParam param) throws BOSException, EASBizException {
        IFPForm iFPForm = FPFormFactory.getRemoteInstance();
        FPFormInfo formInfo = param.isJointSubFPForm() ? iFPForm.genFPJointForm(param.getCompany(), param.getTemplate().getId().toString(), param.getCurrency(), param.getBeginYear(), param.getBeginMonth(), param.getEndYear(), param.getEndMonth()) : iFPForm.genFPForm(param.getCompany(), param.getTemplate().getId().toString(), param.getCurrency(), param.getBeginYear(), param.getBeginMonth(), param.getEndYear(), param.getEndMonth());
        if (formInfo.getCreator() == null) {
            formInfo.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
        }
        return formInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FPFormFactory.getRemoteInstance();
    }

    private void initCompanyPage(String fptemplateId) throws EASBizException, BOSException {
        if (this.editData.isIsJoint()) {
            this.initTab(this.editData.getCompany());
            String groupId = this.editData.getCompany().getId().toString();
            IFMCommonFacade facade = FMCommonFacadeFactory.getRemoteInstance();
            Set allSubOrgIds = null;
            allSubOrgIds = facade.getChildrenOrgIds("00000000-0000-0000-0000-0000000000024F2827FD", groupId);
            if (allSubOrgIds == null || allSubOrgIds.size() == 0) {
                return;
            }
            SQLUtil sb = new SQLUtil("select distinct fcompanyid  from t_fp_fpform where FState = 10 and fcompanyid in (");
            sb.appendParam(allSubOrgIds.toArray());
            sb.appendSql(")");
            sb.appendSql("and ftemplateid=");
            sb.appendParam((Object)fptemplateId);
            IFMIsqlFacade ifa = FMIsqlFacadeFactory.getRemoteInstance();
            IRowSet rs = ifa.executeQuery(sb.getSql(), sb.getParamaters().toArray());
            if (rs != null) {
                ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getRemoteInstance();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("name"));
                try {
                    while (rs.next()) {
                        String subOrgId = rs.getString(1);
                        CompanyOrgUnitInfo company = null;
                        try {
                            company = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(subOrgId), selector);
                        }
                        catch (Exception e) {
                            continue;
                        }
                        this.initTab(company);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void initTab(CompanyOrgUnitInfo company) {
        KDScrollPane scrollPane = new KDScrollPane();
        this.tabPane.addTab(company.getName(), (Component)scrollPane);
        scrollPane.setUserObject((Object)company);
    }

    protected void table_editStopped(KDTEditEvent e) throws Exception {
        if (FPFormClientHelper.isEditOverdueDeal(this.table, e.getColIndex())) {
            FPFormClientHelper.afterEditOverdueDeal(this.table, e.getRowIndex(), e.getColIndex());
            return;
        }
        if (FPFormClientHelper.isEditComment(this.table, e.getColIndex())) {
            FPFormClientHelper.afterEditComment(this.table, e.getRowIndex(), e.getColIndex());
            return;
        }
        FPFormClientHelper.afterEditPlanAmount(this.table, e.getRowIndex(), e.getColIndex());
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
        FPFormInfo formInfo = (FPFormInfo)this.getDataObject();
        FPFormClientHelper.auditForm((Component)((Object)this), formInfo.getId().toString());
        this.editData.setState(FPFormStateEnum.APPROVED);
        this.setWorkButtonStatus(this.editData.getState());
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.txtNumber.isEnabled()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDTextField)this.txtNumber, (String)"NoNumber");
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDTextField)this.txtName, (String)"NoName");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDTextField)this.txtCompany, (String)"NoCompany");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDTextField)this.txtTemplate, (String)"NoTemplate");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDTextField)this.txtCurrency, (String)"NoCurrency");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDTextField)this.txtPeriod, (String)"NoPeriod");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDBizPromptBox)this.bizPromptCreator, (String)"NoCreator");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDDatePicker)this.dtpCreateTime, (String)"NoCreateTime");
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        this.so = null;
        this.currentCell = null;
        return FPFormClientHelper.getUserDefValue(pk);
    }

    protected void btnViewOverdue_actionPerformed(ActionEvent e) throws Exception {
        super.btnViewOverdue_actionPerformed(e);
        FPFormClientHelper.viewOverdue(this.table);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        FPFormInfo info = (FPFormInfo)this.getDataObject();
        if (this.isExsitCodeRule(info)) {
            this.txtNumber.setEditable(false);
        }
        if ("VIEW".equals(this.getOprtState())) {
            this.btnImport.setEnabled(false);
            this.actionViewSubmitProcess.setEnabled(true);
        } else if ("ADDNEW".equals(this.getOprtState())) {
            this.btnAntiAudit.setEnabled(false);
            this.btnAudit.setEnabled(false);
            this.btnAntiAudit.setVisible(false);
            this.btnAudit.setVisible(false);
        } else if ("FINDVIEW".equals(this.getOprtState())) {
            this.btnSubmit.setEnabled(false);
            this.btnImport.setEnabled(false);
        }
    }

    public boolean isExsitCodeRule(FPFormInfo info) {
        String companyId = info.getCompany().getId().toString();
        boolean isExistRule = false;
        boolean isUseIntermitNumber = false;
        Object caller = null;
        ICodingRuleManager icrm = null;
        if (companyId != null && companyId.trim().length() > 0) {
            try {
                icrm = CodingRuleManagerFactory.getRemoteInstance();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            try {
                isExistRule = icrm.isExist((IObjectValue)info, companyId);
            }
            catch (CodingRuleException e1) {
                e1.printStackTrace();
            }
            catch (EASBizException e1) {
                e1.printStackTrace();
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
        }
        return isExistRule;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (OprtState.ADDNEW.equals(this.oprtState)) {
            Date endDate;
            Date beginDate;
            String companyId = this.editData.getCompany().getId().toString();
            String currencyId = this.editData.getCurrency().getId().toString();
            String templateId = this.editData.getTemplate().getId().toString();
            boolean isPass = FPFormClientHelper.checkInterlaced(companyId, templateId, currencyId, beginDate = this.editData.getBeginDate(), endDate = this.editData.getEndDate());
            if (!isPass) {
                throw new FPException(FPException.FPFORMINTERLACEDEXISTED);
            }
        }
        String original = this.getOprtState();
        this.setOprtState("EDIT");
        try {
            super.actionSubmit_actionPerformed(e);
        }
        catch (Exception ex) {
            this.setOprtState(original);
            throw ex;
        }
    }

    public void actionSubmitWF_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmitWF_actionPerformed(e);
        IFPForm iFPForm = FPFormFactory.getRemoteInstance();
        iFPForm.submitWF(this.editData.getId());
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        FMClientHelper.exportExcel((Component)((Object)this), (KDTable)this.table, (boolean)true);
    }

    public boolean checkBeforeWindowClosing() {
        return true;
    }

    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        ICell cell = null;
        IRow row = null;
        FPFormClientHelper.importExcel((Component)((Object)this), this.table);
        int headRowCount = this.table.getHeadRowCount();
        int maxColumn = this.table.getColumnCount();
        int maxRow = this.table.getRowCount();
        FPFormEntryInfo formEntryInfo = null;
        String strValue = null;
        BigDecimal theValue = null;
        for (int i = 0; i < maxRow; ++i) {
            row = this.table.getRow(i);
            for (int j = 1; j < maxColumn; ++j) {
                cell = this.table.getRow(i).getCell(j);
                formEntryInfo = (FPFormEntryInfo)cell.getUserObject();
                if (formEntryInfo == null) {
                    return;
                }
                if (cell.getStyleAttributes().isLocked()) continue;
                if (cell.getValue() != null) {
                    strValue = cell.getValue().toString();
                    if (strValue.equals("")) {
                        strValue = "0";
                    }
                } else {
                    strValue = "0";
                }
                theValue = new BigDecimal(strValue);
                formEntryInfo.setPlanAmount(theValue);
            }
        }
    }

    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAntiAudit_actionPerformed(e);
        FPFormInfo formInfo = (FPFormInfo)this.getDataObject();
        String formId = this.editData.getId().toString();
        FPFormStateEnum stateEnum = this.editData.getState();
        FPFormClientHelper.antiAuditForm((Component)((Object)this), formId, stateEnum);
        this.editData.setState(FPFormStateEnum.BEFOREAPPROVAL);
        this.setWorkButtonStatus(this.editData.getState());
    }

    protected void table_activeCellChanged(KDTActiveCellEvent e) {
        boolean locked;
        int columnIndex = e.getColumnIndex();
        int rowIndex = e.getRowIndex();
        ICell cell = this.table.getCell(rowIndex, columnIndex);
        if (cell == null) {
            return;
        }
        Object userInfo = cell.getUserObject();
        if (userInfo == null) {
            System.out.println("user info is null");
        }
        String script = null;
        if (userInfo != null && userInfo instanceof FPFormEntryInfo) {
            this.so = (FPFormEntryInfo)userInfo;
            script = this.so.getPlanFormula();
            if (FMHelper.isEmptyScript((String)script)) {
                script = this.so.getFpItem().getPlanFormula();
            }
        }
        if ((locked = cell.getStyleAttributes().isLocked()) || columnIndex == 0 || columnIndex == 1) {
            this.so = null;
            this.txtFormula.setText(null);
            this.txtFormula.setEnabled(false);
            this.actionFormula.setEnabled(false);
            this.actionResetCell.setEnabled(false);
            this.currentCell = null;
        } else {
            this.txtFormula.setText(script);
            if (script != null && script.length() > 0) {
                this.txtFormula.setCaretPosition(script.length());
            }
            this.txtFormula.setEnabled(true);
            this.actionFormula.setEnabled(true);
            this.actionResetCell.setEnabled(true);
            this.currentCell = cell;
            this.table.getEditManager().editCellAt(rowIndex, columnIndex);
        }
    }

    public void actionResetCell_actionPerformed(ActionEvent e) throws Exception {
        super.actionResetCell_actionPerformed(e);
        if (this.currentCell == null) {
            return;
        }
        Object userInfo = this.currentCell.getUserObject();
        String script = null;
        if (userInfo != null && userInfo instanceof FPFormEntryInfo) {
            this.so = (FPFormEntryInfo)userInfo;
            script = this.so.getPlanFormula();
            if (FMHelper.isEmptyScript((String)script)) {
                script = this.so.getFpItem().getPlanFormula();
            }
        }
        if (FMHelper.isEmpty(script)) {
            return;
        }
        FPFormulaInfo info = new FPFormulaInfo();
        if ('=' == script.charAt(0)) {
            info.setScript(script);
        } else {
            info.setScript('=' + script);
        }
        FPFormulaContext formulaCtx = new FPFormulaContext();
        formulaCtx.setCompany(this.editData.getCompany().getNumber());
        formulaCtx.setCurrency(this.editData.getCurrency().getNumber());
        formulaCtx.setCycleType(this.editData.getCycleType());
        formulaCtx.setCycleInterval(this.editData.getCycleInterval());
        formulaCtx.setBegin(this.so.getCycleRange().getBeginDate());
        formulaCtx.setEnd(this.so.getCycleRange().getEndDate());
        info.setFormulaCtx(formulaCtx);
        info.setRefObjectID(this.so.getId());
        IFPFormula formula = FPFormulaFactory.getRemoteInstance();
        FPFormulaInfo rst = formula.runner(info);
        if (rst.getResult() != null) {
            this.so.setPlanAmount(rst.getResult());
        } else {
            this.so.setPlanAmount(new BigDecimal("0.0"));
        }
        FPFormClientHelper.setData(this.table, this.editData, false, true);
    }

    public void actionReset_actionPerformed(ActionEvent e) throws Exception {
        super.actionReset_actionPerformed(e);
        FPFormEntryCollection entries = this.editData.getEntries();
        FPFormulaCollection coll = new FPFormulaCollection();
        for (int i = 0; i < entries.size(); ++i) {
            FPFormulaInfo info = new FPFormulaInfo();
            FPFormEntryInfo entry = entries.get(i);
            String script = entry.getPlanFormula();
            if (FMHelper.isEmptyScript((String)script)) {
                script = entry.getFpItem().getPlanFormula();
            }
            if (FMHelper.isEmpty((String)script)) continue;
            if ('=' == script.charAt(0)) {
                info.setScript(script);
            } else {
                info.setScript('=' + script);
            }
            FPFormulaContext formulaCtx = new FPFormulaContext();
            formulaCtx.setCompany(this.editData.getCompany().getNumber());
            formulaCtx.setCurrency(this.editData.getCurrency().getNumber());
            formulaCtx.setCycleType(this.editData.getCycleType());
            formulaCtx.setCycleInterval(this.editData.getCycleInterval());
            formulaCtx.setBegin(entry.getCycleRange().getBeginDate());
            formulaCtx.setEnd(entry.getCycleRange().getEndDate());
            info.setFormulaCtx(formulaCtx);
            info.setRefObjectID(entry.getId());
            coll.add(info);
        }
        IFPFormula formula = FPFormulaFactory.getRemoteInstance();
        FPFormulaCollection rst = formula.runner(coll);
        HashSearchEngine se = new HashSearchEngine((IObjectCollection)rst, new String[]{"refObjectID"});
        se.setDestKeys(new String[]{"id"});
        for (int i = 0; i < entries.size(); ++i) {
            FPFormEntryInfo entry = entries.get(i);
            if (!se.evaluate((IObjectValue)entry)) continue;
            FPFormulaInfo object = (FPFormulaInfo)se.getResult();
            if (object.getResult() != null) {
                entry.setPlanAmount(object.getResult());
                continue;
            }
            entry.setPlanAmount(new BigDecimal("0.0"));
        }
        FPFormClientHelper.setData(this.table, this.editData, false, true);
    }

    protected void txtFormula_keyReleased(KeyEvent e) throws Exception {
        super.txtFormula_keyReleased(e);
        if (this.so != null) {
            String script = this.txtFormula.getText();
            System.out.println("set formnula: " + this.so.getName() + " script :" + script);
            if (FMHelper.isEmptyScript((String)script) || script.equalsIgnoreCase(this.so.getFpItem().getPlanFormula())) {
                this.so.setPlanFormula(null);
                return;
            }
            this.so.setPlanFormula(script);
        }
    }

    public FPFormulaTypeEnum getRstType() {
        return FPFormulaTypeEnum.PLANNING;
    }

    protected boolean isGroup() {
        FPFormInfo formInfo = (FPFormInfo)this.getDataObject();
        try {
            return ContextHelperFactory.getRemoteInstance().isOnlyUnion(formInfo.getCompany());
        }
        catch (EASBizException e) {
            return false;
        }
        catch (BOSException e) {
            return false;
        }
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.preparePrintPage(this.table);
        this.table.getPrintManager().print();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.preparePrintPage(this.table);
        this.table.getPrintManager().printPreview();
    }

    public void actionViewSubmitProcess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewSubmitProcess_actionPerformed(e);
        FMClientHelper.viewProccessDef((CoreUIObject)this, (String)"FPFormFunction", (String)"com.kingdee.eas.fm.fp", (String)"ActionSubmitWF");
    }

    private final class TableBeforeAction
    implements BeforeActionListener {
        private TableBeforeAction() {
        }

        public void beforeAction(BeforeActionEvent e) {
            KDTable table = (KDTable)e.getSource();
            boolean deletable = true;
            ICell cell = null;
            switch (e.getType()) {
                case 7: {
                    int mark = (Integer)e.getParameter();
                    boolean isSpecialDelete = false;
                    if (!KDTEditHelper.isUserObject((int)mark)) break;
                    KDTRange range = table.getSelectManager().toRange();
                    Iterator iterator = range.iterator();
                    KDTSelectBlock block = null;
                    Object o = null;
                    Object rptCell = null;
                    int rowEnd = 0;
                    int colEnd = 0;
                    while (iterator.hasNext()) {
                        block = (KDTSelectBlock)iterator.next();
                        colEnd = block.getEndCol();
                        if (colEnd == 0) {
                            colEnd = table.getExpandedColumnCount() - 1;
                        }
                        for (int col = block.getBeginCol(); col <= colEnd; ++col) {
                            rowEnd = block.getEndRow();
                            if (rowEnd == 0) {
                                rowEnd = table.getExpandedRowCount() - 1;
                            }
                            for (int row = block.getBeginRow(); row <= rowEnd; ++row) {
                                cell = table.getCell(row, col);
                                cell.setValue(null);
                            }
                        }
                    }
                    e.setCancel(false);
                    break;
                }
            }
        }
    }

    private class TabChangeListener
    implements ChangeListener {
        private TabChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            try {
                this.getSubOrgFormInfo();
            }
            catch (EASBizException e1) {
                e1.printStackTrace();
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
        }

        private void getSubOrgFormInfo() throws BOSException, EASBizException {
            int index = FPFormEditUI.this.tabPane.getSelectedIndex();
            KDScrollPane currentPane = (KDScrollPane)FPFormEditUI.this.tabPane.getComponentAt(index);
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)currentPane.getUserObject();
            IFPForm iFPForm = FPFormFactory.getRemoteInstance();
            String templateId = FPFormEditUI.this.editData.getTemplate().getId().toString();
            CurrencyInfo currency = FPFormEditUI.this.editData.getCurrency();
            int beginYear = FPFormEditUI.this.editData.getBeginYear();
            int beginMonth = FPFormEditUI.this.editData.getBeginMonth();
            int endYear = FPFormEditUI.this.editData.getEndYear();
            int endMonth = FPFormEditUI.this.editData.getEndMonth();
            FPFormInfo formInfo = null;
            formInfo = company.getId().toString().equals(FPFormEditUI.this.editData.getCompany().getId().toString()) ? FPFormEditUI.this.editData : iFPForm.genSubOrgFPForm(company, templateId, currency, beginYear, beginMonth, endYear, endMonth);
            FPFormClientHelper.clearTable(FPFormEditUI.this.table);
            if (index == 0) {
                FPFormClientHelper.setData(FPFormEditUI.this.table, formInfo, false, true);
            } else {
                FPFormClientHelper.setData(FPFormEditUI.this.table, formInfo, true, true);
            }
            currentPane.getViewport().add((Component)FPFormEditUI.this.table, null);
        }
    }
}

