/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fp.CycleTypeEnum;
import com.kingdee.eas.fm.fp.FPCycleIntervalEnum;
import com.kingdee.eas.fm.fp.FPFormulaCollection;
import com.kingdee.eas.fm.fp.FPFormulaInfo;
import com.kingdee.eas.fm.fp.FixedFPItemCollection;
import com.kingdee.eas.fm.fp.FixedFPItemFactory;
import com.kingdee.eas.fm.fp.FixedFPItemInfo;
import com.kingdee.eas.fm.fp.IFixedFPItem;
import com.kingdee.eas.fm.fp.client.AbstractFPFormulaEditUI;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;

public class FPFormulaEditUI
extends AbstractFPFormulaEditUI {
    public static final String CTX_COMPANYID = "companyId";
    public static final String CTX_CYCLETYPE = "cycleType";
    public static final String CTX_CYCLEINTERVAL = "cycleInterval";
    private static final String COL_SELECTED = "selected";
    private static final String COL_NUMBER = "number";
    private static final String COL_NAME = "name";
    private static final String COL_CURRENCY = "currency";
    private static final String COL_AMOUNT = "amount";
    private static final String COL_COMMENT = "comment";
    private boolean canceled = true;
    Object[] result;

    protected void comboDataSource_actionPerformed(ActionEvent e) throws Exception {
        super.comboDataSource_actionPerformed(e);
    }

    protected void cbxSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.cbxSelectAll_actionPerformed(e);
        Boolean theBoolean = this.cbxSelectAll.isSelected();
        int size = this.tblFixedFPItems.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblFixedFPItems.getRow(i);
            row.getCell(COL_SELECTED).setValue((Object)theBoolean);
        }
    }

    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        this.canceled = false;
        this.result = this.buildResult();
        if (this.result.length == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)FMClientHelper.formatMessage((String)"com.kingdee.eas.fm.fp.client.FPTemplateResource", (String)"pleaseSelectContect", null));
            return;
        }
        this.getUIWindow().close();
    }

    private Object[] buildResult() {
        FPFormulaCollection collection = new FPFormulaCollection();
        int size = this.tblFixedFPItems.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblFixedFPItems.getRow(i);
            if (!((Boolean)row.getCell(COL_SELECTED).getValue()).booleanValue()) continue;
            FPFormulaInfo info = new FPFormulaInfo();
            FixedFPItemInfo fixedFPItemInfo = (FixedFPItemInfo)row.getUserObject();
            info.setTip(fixedFPItemInfo.getNumber());
            collection.add(info);
        }
        return collection.toArray();
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.canceled = true;
        this.getUIWindow().close();
    }

    public Object getData() {
        if (this.isCanceled()) {
            return null;
        }
        return this.result;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private void initFixedFPItemsTable() {
        FixedFPItemCollection collection = null;
        try {
            IFixedFPItem iFixedFPItem = FixedFPItemFactory.getRemoteInstance();
            String companyId = (String)this.getUIContext().get(CTX_COMPANYID);
            CycleTypeEnum cycleType = (CycleTypeEnum)((Object)this.getUIContext().get(CTX_CYCLETYPE));
            FPCycleIntervalEnum cycleInterval = (FPCycleIntervalEnum)((Object)this.getUIContext().get(CTX_CYCLEINTERVAL));
            collection = iFixedFPItem.getValidItems(companyId, cycleType, cycleInterval);
        }
        catch (Exception e) {
            this.handUIException(e);
            collection = null;
        }
        if (collection == null) {
            return;
        }
        this.tblFixedFPItems.checkParsed();
        this.tblFixedFPItems.getColumn(COL_AMOUNT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            FixedFPItemInfo info = collection.get(i);
            IRow row = this.tblFixedFPItems.addRow();
            row.getCell(COL_SELECTED).setValue((Object)Boolean.FALSE);
            row.getCell(COL_NUMBER).setValue((Object)info.getNumber());
            row.getCell(COL_NAME).setValue((Object)info.getName());
            row.getCell(COL_CURRENCY).setValue((Object)info.getCurrency().getName());
            BigDecimal amount = info.getAmount();
            if (amount != null) {
                row.getCell(COL_AMOUNT).setValue((Object)amount.setScale(info.getCurrency().getPrecision(), 5));
            } else {
                row.getCell(COL_AMOUNT).setValue((Object)Constants.ZERO);
            }
            row.getCell(COL_COMMENT).setValue((Object)info.getDescription());
            row.setUserObject((Object)info);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initFixedFPItemsTable();
    }
}

