/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fp.FPMonitorFactory;
import com.kingdee.eas.fm.fp.IFPMonitor;
import com.kingdee.eas.fm.fp.client.AbstractFPMonitorLockListUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Set;

public class FPMonitorLockListUI
extends AbstractFPMonitorLockListUI {
    private String resourcePath = "com.kingdee.eas.fm.fp.FPFormResource";

    public FPMonitorLockListUI() throws Exception {
        this.btnReleaseLock.setIcon(EASResource.getIcon((String)"imgTbtn_ffreeze"));
        this.btnAttachment.setVisible(false);
    }

    public void actionReleaseLock_actionPerformed(ActionEvent e) throws Exception {
        FMClientHelper.checkSelected((Component)((Object)this), (KDTable)this.tblMain);
        Set rowNumbers = FMClientHelper.getSelectedRows((KDTable)this.tblMain);
        String[] ids = new String[rowNumbers.size()];
        for (int i = 0; i < rowNumbers.size(); ++i) {
            String id;
            ids[i] = id = this.tblMain.getRow(i).getCell("id").getValue().toString();
        }
        this.releaseLock(ids);
        MsgBox.showInfo((String)EASResource.getString((String)this.resourcePath, (String)"ReleaseLockSuccess"));
        this.tblMain.removeRows();
    }

    private void releaseLock(String[] ids) throws Exception {
        IFPMonitor monitor = FPMonitorFactory.getRemoteInstance();
        monitor.releaseLocks(ids);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("isLocked", (Object)new Integer(1)));
        return fi;
    }

    public void onGetRowSet(IRowSet rowSet) {
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                java.sql.Date beginDate = rowSet.getDate("cycleRange.beginDate");
                java.sql.Date endDate = rowSet.getDate("cycleRange.endDate");
                String period = beginDate + " - " + endDate;
                if (beginDate.compareTo(endDate) == 0) {
                    period = ((Date)beginDate).toString();
                }
                rowSet.updateString("cycleRange", period);
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            this.abort(ex);
        }
        super.onGetRowSet(rowSet);
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }
}

