/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.RptBaseHandler;
import com.kingdee.eas.fm.fp.CycleRangeCollection;
import com.kingdee.eas.fm.fp.CycleRangeInfo;
import com.kingdee.eas.fm.fp.CycleRangeTotalInfo;
import com.kingdee.eas.fm.fp.CycleTypeEnum;
import com.kingdee.eas.fm.fp.FPCycleIntervalEnum;
import com.kingdee.eas.fm.fp.FPHelper;
import com.kingdee.eas.fm.fp.FPScheduleCondParam;
import com.kingdee.eas.fm.fp.FPSumAnalysisOrderEnum;
import com.kingdee.eas.fm.fp.client.FPScheduleChartUIParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public class FPScheduleHandler
extends RptBaseHandler {
    public static String resourcePath = "com.kingdee.eas.fm.fp.client.FPScheduleResource";

    public void fillFirstCol(KDTable tblMain, IRowSet rs) throws SQLException {
        String key = this.getFirstColKey();
        rs.beforeFirst();
        String lstName = null;
        while (rs.next()) {
            String entryName = rs.getString(key);
            if (entryName.equals(lstName)) continue;
            IRow row = tblMain.addRow();
            row.getCell(0).setValue((Object)entryName);
            lstName = entryName;
        }
    }

    public String getFirstColKey() {
        return "ENTRIESNAME";
    }

    public IRowSet getRowset(IMetaDataPK mainQueryPK, EntityViewInfo mainQuery, FPScheduleCondParam p) throws BOSException {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)mainQueryPK);
        EntityViewInfo ev = (EntityViewInfo)mainQuery.clone();
        exec.setObjectView(ev);
        String sql = exec.getSQL();
        StringBuffer sb = new StringBuffer(128);
        sb.append("(select * from (SELECT ");
        sb.append(" ENTRIESNAME, SUM(ENTRIESPLANAMOUNT) AS PLANAMOUNT, SUM(ENTRIESACTUALAMOUNT) AS ACTUALAMOUNT, FPITEMLINENO");
        sb.append(this.sqlStrOfDate(p));
        sb.append(" from (");
        sb.append(sql);
        sb.append(") a");
        sb.append(" GROUP BY");
        sb.append(" ENTRIESNAME,FPITEMLINENO");
        sb.append(this.sqlStrOfGroup(p));
        sb.append("\n union \n ");
        sb.append("SELECT ");
        sb.append(" ENTRIESNAME, SUM(ENTRIESPLANAMOUNT) AS PLANAMOUNT, SUM(ENTRIESACTUALAMOUNT) AS ACTUALAMOUNT, FPITEMLINENO");
        sb.append(",'9999-99'");
        sb.append(" AS CYCLENAME");
        sb.append(" from (");
        sb.append(sql);
        sb.append(") a");
        sb.append(" GROUP BY");
        sb.append(" ENTRIESNAME,FPITEMLINENO ) X ");
        sb.append(" ORDER BY FPITEMLINENO )");
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)sb.toString());
        IRowSet rs = sqlExe.executeSQL();
        return rs;
    }

    public String sqlStrOfDate(FPScheduleCondParam p) {
        String sqlStr = "";
        int cycleType = p.getCycleType();
        sqlStr = cycleType == 30 ? ", to_char(CYCLERANGEYEAR)|| to_char(CYCLERANGEMONTH)  AS CYCLENAME " : (cycleType == 90 ? ", to_char(CYCLERANGEYEAR)|| to_char(CYCLERANGEQUARTER)  AS CYCLENAME" : (cycleType == 360 ? ", to_char(CYCLERANGEYEAR)  AS CYCLENAME" : ", to_char(CYCLERANGEYEAR)|| to_char(CYCLERANGEMONTH)  AS CYCLENAME "));
        return sqlStr;
    }

    public String sqlStrOfGroup(FPScheduleCondParam p) {
        String sqlStr = "";
        int cycleType = p.getCycleType();
        sqlStr = cycleType == 30 ? ",CYCLERANGEYEAR,CYCLERANGEMONTH" : (cycleType == 90 ? ",CYCLERANGEYEAR,CYCLERANGEQUARTER" : (cycleType == 360 ? ",CYCLERANGEYEAR" : ",CYCLERANGEYEAR,CYCLERANGEMONTH"));
        return sqlStr;
    }

    public void initTableHeader(KDTable tblMain, FPScheduleCondParam param) {
        CycleTypeEnum cycleType = CycleTypeEnum.getEnum(param.getCycleType());
        boolean amountNumber = true;
        CycleRangeCollection coll = FPHelper.genCycleRanges(cycleType, FPCycleIntervalEnum.ONE, param.getBeginYear(), param.getBeginMonth() - 1, param.getEndYear(), param.getEndMonth() - 1);
        coll.add(new CycleRangeTotalInfo());
        this.insertHeader(tblMain, param, (IObjectCollection)coll);
        this.initCycleHeader(tblMain, coll);
    }

    public void initCycleHeader(KDTable tblMain, CycleRangeCollection coll) {
        IRow headRow = tblMain.getHeadRow(0);
        CycleTypeEnum cycleType = CycleTypeEnum.MONTH;
        int idx = 1;
        for (int i = 0; i < coll.size(); ++i) {
            CycleRangeInfo info = coll.get(i);
            for (int j = 0; j < 4; ++j) {
                ICell cell = headRow.getCell(idx);
                cell.setValue((Object)info.toString());
                cell.setUserObject((Object)info.genDateKey());
                ++idx;
            }
        }
    }

    public void insertHeader(KDTable tblMain, FPScheduleCondParam param, IObjectCollection coll) {
        tblMain.addColumns(1 + coll.size() * 4);
        tblMain.addHeadRows(2);
        tblMain.getColumn(0).setWidth(300);
        IRow headRow = tblMain.getHeadRow(0);
        FPSumAnalysisOrderEnum firstColType = FPSumAnalysisOrderEnum.ITEM;
        headRow.getCell(0).setValue((Object)firstColType);
        String sPlan = EASResource.getString((String)resourcePath, (String)"PLANAMOUNT");
        String sActual = EASResource.getString((String)resourcePath, (String)"ACTUALAMOUNT");
        String sScale = EASResource.getString((String)resourcePath, (String)"SCALE");
        IRow headRow1 = tblMain.getHeadRow(1);
        headRow1.getCell(0).setValue((Object)firstColType);
        tblMain.getHeadMergeManager().mergeBlock(0, 0, 1, 0);
        for (int idx = 1; idx < tblMain.getColumnCount(); idx += 4) {
            headRow1.getCell(idx).setValue((Object)sPlan);
            headRow1.getCell(idx + 1).setValue((Object)sScale);
            tblMain.getHeadMergeManager().mergeBlock(0, idx, 0, idx + 3);
            headRow1.getCell(idx + 2).setValue((Object)sActual);
            headRow1.getCell(idx + 3).setValue((Object)sScale);
        }
        String numberFtm = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)param.getCurrencyId()));
        for (int i = 1; i < tblMain.getColumnCount() - 1; i += 2) {
            tblMain.getColumn(i).getStyleAttributes().setNumberFormat(numberFtm);
            tblMain.getColumn(i).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            tblMain.getColumn(i + 1).getStyleAttributes().setNumberFormat("%r{0.00}p");
            tblMain.getColumn(i + 1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            tblMain.getColumn(i + 1).setWidth(80);
            tblMain.getColumn(i + 1).getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        }
    }

    public Map getRowsetMap(IRowSet rs) throws SQLException {
        String[] keys = new String[]{"ENTRIESNAME", "CYCLENAME"};
        String[] valueskey = new String[]{"PLANAMOUNT", "ACTUALAMOUNT"};
        Map cache = FMHelper.populateMap((ResultSet)rs, (String[])valueskey, (String[])keys);
        return cache;
    }

    public void fillData(KDTable tblMain, Map cache) {
        IRow headRow = tblMain.getHeadRow(0);
        for (int i = 0; i < tblMain.getRowCount(); ++i) {
            IRow row = tblMain.getRow(i);
            String itemName = row.getCell(0).getValue().toString();
            for (int j = 1; j < tblMain.getColumnCount() - 3; j += 4) {
                Object[] value = (Object[])cache.get(itemName + headRow.getCell(j).getUserObject());
                if (value == null) continue;
                row.getCell(j).setValue(value[0]);
                row.getCell(j + 2).setValue(value[1]);
            }
        }
    }

    public void fillScale(KDTable tblMain) {
        int columnCount = tblMain.getColumnCount();
        for (int i = 0; i < tblMain.getRowCount(); ++i) {
            IRow row = tblMain.getRow(i);
            this.fillScale(columnCount, row);
        }
    }

    private void fillScale(int columnCount, IRow row) {
        BigDecimal totalPlan = this.getCellValue(row.getCell(columnCount - 4));
        if (!FMHelper.isZERO((BigDecimal)totalPlan)) {
            this.fillScale(row, columnCount, totalPlan, 1);
            this.fillScale(row, columnCount, totalPlan, 3);
        }
    }

    private BigDecimal getCellValue(ICell cell) {
        Object value = cell.getValue();
        if (value == null) {
            return Constants.ZERO;
        }
        BigDecimal totalPlan = null;
        if (value instanceof BigDecimal) {
            totalPlan = (BigDecimal)value;
        } else {
            Object val = ((Variant)value).getValue();
            if (val == null) {
                return Constants.ZERO;
            }
            totalPlan = val instanceof BigDecimal ? (BigDecimal)val : new BigDecimal(val.toString());
        }
        return totalPlan;
    }

    private void fillScale(IRow row, int columnCount, BigDecimal totalAmount, int k) {
        for (int j = k; j < columnCount - 1; j += 4) {
            BigDecimal amount = this.getCellValue(row.getCell(j));
            if (amount != null) {
                row.getCell(j + 1).setValue((Object)amount.divide(totalAmount, 4, 4));
                continue;
            }
            row.getCell(j + 1).setValue((Object)Constants.ZERO);
        }
    }

    public FPScheduleChartUIParam getChartData(KDTable tbl) {
        KDTSelectBlock selectBlock = tbl.getSelectManager().get();
        if (selectBlock == null || selectBlock.getTop() == -1) {
            SysUtil.abort();
        }
        int rowIndex = selectBlock.getTop();
        String sPlan = EASResource.getString((String)resourcePath, (String)"PLANAMOUNT");
        String sActual = EASResource.getString((String)resourcePath, (String)"ACTUALAMOUNT");
        String sScale = EASResource.getString((String)resourcePath, (String)"SCALE");
        FPScheduleChartUIParam chartData = new FPScheduleChartUIParam();
        int size = (tbl.getColumnCount() - 6) / 4 + 1;
        String[] groupsKeys = new String[size];
        double[] data1 = new double[size];
        double[] data2 = new double[size];
        IRow row = tbl.getRow(rowIndex);
        int i = 1;
        int k = 0;
        while (i < tbl.getColumnCount() - 7) {
            groupsKeys[k] = String.valueOf(tbl.getHeadRow(0).getCell(i).getValue());
            if (k == 0) {
                data1[k] = this.getDoubleValue(row.getCell(i + 1).getValue());
                data2[k] = this.getDoubleValue(row.getCell(i + 3).getValue());
            } else {
                data1[k] = data1[k - 1] + this.getDoubleValue(row.getCell(i + 1).getValue());
                data2[k] = data2[k - 1] + this.getDoubleValue(row.getCell(i + 3).getValue());
            }
            i += 4;
            ++k;
        }
        chartData.setGroupsKeys(groupsKeys);
        chartData.setSeriesKeys(new String[]{sPlan, sActual});
        chartData.setValues(new double[][]{data1, data2});
        Object title = row.getCell(0).getValue();
        if (title != null) {
            chartData.setTilte(title.toString());
        }
        return chartData;
    }

    private double getDoubleValue(Object value) {
        if (value == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(value.toString());
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public void initStatus(KDTable tblMain) {
        int i;
        if (tblMain.getRowCount() == 0) {
            return;
        }
        tblMain.getGroupManager().setTotalize(true);
        tblMain.getColumn(1).setStat(true);
        tblMain.getGroupManager().setOrientation(1);
        IRow row0 = tblMain.getGroupManager().getStatRowTemplate(-1);
        for (i = 0; i < tblMain.getColumnCount(); ++i) {
            row0.getCell(i).getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        }
        row0.getCell(0).setValue((Object)FMSysDefinedEnum.TOTAL.getAlias());
        for (i = 1; i < tblMain.getColumnCount(); i += 2) {
            row0.getCell(i).setExpressions("SUM");
            tblMain.getColumn(i + 1).setStat(false);
        }
        tblMain.getGroupManager().group();
        this.fillScale(tblMain.getColumnCount(), tblMain.getRow(tblMain.getRowCount() - 1));
    }
}

