/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fp.CycleTypeEnum;
import com.kingdee.eas.fm.fp.FPSumAnalysisCondParam;
import com.kingdee.eas.fm.fp.FPSumAnalysisOrderEnum;
import com.kingdee.eas.fm.fp.FPTemplateFactory;
import com.kingdee.eas.fm.fp.FPTemplateInfo;
import com.kingdee.eas.fm.fp.IFPTemplate;
import com.kingdee.eas.fm.fp.client.AbstractFPSumAnalysisCondUI;
import com.kingdee.eas.fm.fp.client.FPClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class FPSumAnalysisCondUI
extends AbstractFPSumAnalysisCondUI {
    public static String resourcePath = "com.kingdee.eas.fm.fp.client.FPSumAnalysisResource";

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    public Object getParam() {
        FPSumAnalysisCondParam para = new FPSumAnalysisCondParam();
        String[] companyIds = this.getCompanyIds();
        para.setCompanyIdAry(companyIds);
        para.setTemplateId(AccessHelper.getF7Id((KDBizPromptBox)this.f7Template));
        para.setTemplateName((String)AccessHelper.getF7Attribute((KDBizPromptBox)this.f7Template, (String)"name"));
        para.setCurrencyId(AccessHelper.getCboId((KDComboBox)this.cboCurrency));
        para.setCurrencyName((String)AccessHelper.getCboAttribute((KDComboBox)this.cboCurrency, (String)"name"));
        para.setBeginMonth(AccessHelper.getSpiValue((KDSpinner)this.spiBeginMonth));
        para.setBeginYear(AccessHelper.getSpiValue((KDSpinner)this.spiBeginYear));
        para.setEndMonth(AccessHelper.getSpiValue((KDSpinner)this.spiEndMonth));
        para.setEndYear(AccessHelper.getSpiValue((KDSpinner)this.spiEndYear));
        para.setOrderOne(AccessHelper.getCboInt((KDComboBox)this.cboOrderOne));
        para.setOrderTow(AccessHelper.getCboInt((KDComboBox)this.cboOrderTwo));
        para.setDispActual(this.chkPlanActualAmount.isSelected());
        para.setCycleType(AccessHelper.getCboInt((KDComboBox)this.cboCycleType));
        return para;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof FPSumAnalysisCondParam)) {
            return;
        }
        FPSumAnalysisCondParam formFilterParam = (FPSumAnalysisCondParam)param;
        String[] companyIds = formFilterParam.getCompanyIdAry();
        this.setCompanyIds(companyIds);
        String currencyId = formFilterParam.getCurrencyId();
        CurrencyInfo currencyInfo = null;
        try {
            ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
            currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
            this.cboCurrency.setSelectedItem((Object)currencyInfo);
        }
        catch (EASBizException e1) {
            SysUtil.abort();
        }
        catch (BOSException e1) {
            SysUtil.abort();
        }
        String templateId = formFilterParam.getTemplateId();
        FPTemplateInfo templateInfo = null;
        try {
            IFPTemplate iTemplate = FPTemplateFactory.getRemoteInstance();
            templateInfo = iTemplate.getFPTemplateInfo((IObjectPK)new ObjectUuidPK(templateId));
            this.f7Template.setData((Object)templateInfo);
        }
        catch (EASBizException e2) {
            SysUtil.abort();
        }
        catch (BOSException e2) {
            SysUtil.abort();
        }
        this.cboCycleType.setSelectedItem((Object)CycleTypeEnum.getEnum(formFilterParam.getCycleType()));
        this.spiBeginYear.setValue((Object)new Integer(formFilterParam.getBeginYear()));
        this.spiBeginMonth.setValue((Object)new Integer(formFilterParam.getBeginMonth()));
        this.spiEndYear.setValue((Object)new Integer(formFilterParam.getEndYear()));
        this.spiEndMonth.setValue((Object)new Integer(formFilterParam.getEndMonth()));
        this.cboOrderOne.setSelectedItem((Object)FPSumAnalysisOrderEnum.getEnum(formFilterParam.getOrderOne()));
        this.cboOrderTwo.setSelectedItem((Object)FPSumAnalysisOrderEnum.getEnum(formFilterParam.getOrderTow()));
        this.chkPlanActualAmount.setSelected(formFilterParam.getIsDispActual());
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected void init() throws Exception {
        super.init();
        this.initCompanyIds();
        this.f7Template.setEditable(true);
        this.f7Template.setCommitFormat("$number$");
        this.f7Template.setRequired(true);
        this.f7Template.setHasCUDefaultFilter(false);
        FMClientHelper.initSpinFromTO((KDSpinner)this.spiBeginYear, (KDSpinner)this.spiBeginMonth, (KDSpinner)this.spiEndYear, (KDSpinner)this.spiEndMonth);
        FMClientHelper.initCurrency((KDComboBox)this.cboCurrency);
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company));
        this.cboCycleType.removeAllItems();
        this.cboCycleType.addItem((Object)CycleTypeEnum.MONTH);
        this.cboCycleType.addItem((Object)CycleTypeEnum.QUARTER);
        this.cboCycleType.addItem((Object)CycleTypeEnum.YEAR);
    }

    protected void initCompanyIds() throws BOSException {
        String[] companyIds = new String[]{this.currentCompany.getId().toString()};
        this.setCompanyIds(companyIds);
        try {
            FPClientHelper.setTemplateFilterByCompany(companyIds, this.currentCompany.getId().toString(), this.f7Template);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void companyValueChange(Object object) throws Exception {
        super.companyValueChange(object);
        String[] companyIds = this.getCompanyIds();
        FPClientHelper.setTemplateFilterByCompany(companyIds, this.currentCompany.getId().toString(), this.f7Template);
    }

    protected void f7Template_dataChanged(DataChangeEvent e) throws Exception {
        super.f7Template_dataChanged(e);
        FPTemplateInfo info = (FPTemplateInfo)this.f7Template.getData();
        if (info == null) {
            return;
        }
        if (!info.containsKey("cycleType")) {
            IFPTemplate template = FPTemplateFactory.getRemoteInstance();
            info = template.getFPTemplateInfo("select *  where id='" + info.getId() + "'");
        }
        CycleTypeEnum ct = info.getCycleType();
        this.cboCycleType.removeAllItems();
        if (ct.equals((Object)CycleTypeEnum.DAY) || ct.equals((Object)CycleTypeEnum.WEEK) || ct.equals((Object)CycleTypeEnum.MONTH)) {
            this.cboCycleType.addItem((Object)CycleTypeEnum.MONTH);
            this.cboCycleType.addItem((Object)CycleTypeEnum.QUARTER);
            this.cboCycleType.addItem((Object)CycleTypeEnum.YEAR);
        } else if (ct.equals((Object)CycleTypeEnum.QUARTER)) {
            this.cboCycleType.addItem((Object)CycleTypeEnum.QUARTER);
            this.cboCycleType.addItem((Object)CycleTypeEnum.YEAR);
        } else if (ct.equals((Object)CycleTypeEnum.YEAR)) {
            this.cboCycleType.addItem((Object)CycleTypeEnum.YEAR);
        }
        FMClientHelper.initSpinFromTO((KDSpinner)this.spiBeginYear, (KDSpinner)this.spiBeginMonth, (KDSpinner)this.spiEndYear, (KDSpinner)this.spiEndMonth);
        if (ct.equals((Object)CycleTypeEnum.QUARTER)) {
            Calendar instance = Calendar.getInstance();
            int thisMonth = instance.get(2);
            int quarter = DateUtil.getSeason((int)thisMonth);
            SpinnerNumberModel mBeginModel = new SpinnerNumberModel(3 * quarter - 2, 1, 10, 3);
            this.spiBeginMonth.setModel((SpinnerModel)mBeginModel);
            SpinnerNumberModel mEndModel = new SpinnerNumberModel(3 * quarter, 3, 12, 3);
            this.spiEndMonth.setModel((SpinnerModel)mEndModel);
        }
        if (ct.equals((Object)CycleTypeEnum.YEAR)) {
            SpinnerNumberModel mBeginModel = new SpinnerNumberModel(1, 1, 1, 1);
            this.spiBeginMonth.setModel((SpinnerModel)mBeginModel);
            SpinnerNumberModel mEndModel = new SpinnerNumberModel(12, 12, 12, 1);
            this.spiEndMonth.setModel((SpinnerModel)mEndModel);
        }
    }

    protected void cboOrderOne_actionPerformed(ActionEvent e) throws Exception {
        super.cboOrderOne_actionPerformed(e);
        Object selectedItem = this.cboOrderOne.getSelectedItem();
        if (selectedItem.equals((Object)FPSumAnalysisOrderEnum.COMPANY) || selectedItem.equals((Object)FPSumAnalysisOrderEnum.CYCLE)) {
            this.cboOrderTwo.setEnabled(false);
        } else {
            this.cboOrderTwo.removeAllItems();
            this.cboOrderTwo.addItem((Object)FPSumAnalysisOrderEnum.COMPANY);
            this.cboOrderTwo.addItem((Object)FPSumAnalysisOrderEnum.CYCLE);
            this.cboOrderTwo.setEnabled(true);
        }
    }

    public boolean verify() {
        int endMonth;
        int endYear;
        int beginMonth;
        int beginYear;
        Integer value;
        super.verify();
        if (this.getCompanyIds() == null || this.getCompanyIds().length == 0) {
            this.btnCompanySelect.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CompanyNotEmpty"));
            SysUtil.abort();
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDBizPromptBox)this.f7Template, (String)"templateCannotEmpty");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDComboBox)this.cboCurrency, (String)"CurrencyNotEmpty");
        CycleTypeEnum ctype = (CycleTypeEnum)((Object)this.cboCycleType.getSelectedItem());
        if (ctype.equals((Object)CycleTypeEnum.QUARTER) && (value = (Integer)this.spiBeginMonth.getValue()) % 3 != 1) {
            this.spiBeginMonth.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"MustFirstMonth"));
            SysUtil.abort();
        }
        if ((beginYear = ((Integer)this.spiBeginYear.getValue()).intValue()) * 100 + (beginMonth = ((Integer)this.spiBeginMonth.getValue()).intValue()) > (endYear = ((Integer)this.spiEndYear.getValue()).intValue()) * 100 + (endMonth = ((Integer)this.spiEndMonth.getValue()).intValue())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"BeginThanEnd"));
            SysUtil.abort();
        }
        return true;
    }
}

