/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.core.ORMHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.fm.fp.CycleTypeEnum;
import com.kingdee.eas.fm.fp.FPCycleIntervalEnum;
import com.kingdee.eas.fm.fp.FPItemCollection;
import com.kingdee.eas.fm.fp.FPItemInfo;
import com.kingdee.eas.fm.fp.FPItemTypeEnum;
import com.kingdee.eas.fm.fp.FPTemplateInfo;
import com.kingdee.eas.fm.fp.SysDefinedItemEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.enums.Enum;
import java.sql.Timestamp;
import java.util.List;

public class FPTemplateHandler {
    public void itemMoveUp(KDTable kdtEntries) {
        KDTSelectBlock selectBlock = kdtEntries.getSelectManager().get();
        int idx = 0;
        if (selectBlock == null || selectBlock.getTop() == -1 || selectBlock.getTop() == 0) {
            return;
        }
        idx = selectBlock.getTop();
        IRow row = kdtEntries.removeRow(idx);
        kdtEntries.addRow(idx - 1, row);
    }

    public void itemMoveDown(KDTable kdtEntries) {
        KDTSelectBlock selectBlock = kdtEntries.getSelectManager().get();
        int idx = 0;
        if (selectBlock == null || selectBlock.getTop() == -1 || selectBlock.getTop() == kdtEntries.getRowCount() - 1) {
            return;
        }
        idx = selectBlock.getTop();
        IRow row = kdtEntries.removeRow(idx);
        kdtEntries.addRow(idx + 1, row);
    }

    public FPItemCollection getDefinedItem() {
        FPItemCollection coll = new FPItemCollection();
        Object info = null;
        this.fillDefinedItem(coll, (Enum)SysDefinedItemEnum.ACBEGINNING);
        this.fillDefinedItem(coll, (Enum)SysDefinedItemEnum.FCBEGINNING);
        this.fillDefinedItem(coll, (Enum)SysDefinedItemEnum.BEGINNING);
        List list = FPItemTypeEnum.getEnumList();
        for (int i = 0; i < list.size(); ++i) {
            FPItemTypeEnum e = (FPItemTypeEnum)((Object)list.get(i));
            if (e.equals((Object)FPItemTypeEnum.SYSTEMHOLD) || e.equals((Object)FPItemTypeEnum.ONLYREFERENCED) || e.equals((Object)FPItemTypeEnum.SUBTOTAL)) continue;
            this.fillDefinedItem(coll, (Enum)e);
        }
        this.fillDefinedItem(coll, (Enum)SysDefinedItemEnum.ENDING);
        return coll;
    }

    private void fillDefinedItem(FPItemCollection coll, Enum e) {
        FPItemInfo info = new FPItemInfo();
        info.setName(e.toString());
        info.setType(FPItemTypeEnum.SYSTEMHOLD);
        info.setNumber(e.getName());
        coll.add(info);
    }

    public void initDefaultValue(FPTemplateInfo info) {
        IContextHelper ctxHelper = ContextHelperFactory.getRemoteInstance();
        info.setCompany(ctxHelper.getCurrentCompany());
        info.setCreator(ctxHelper.getCurrentUser());
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        try {
            info.setIsGroup(ctxHelper.isOnlyUnion(info.getCompany()));
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        info.setCycleType(CycleTypeEnum.MONTH);
        info.setCycleInterval(FPCycleIntervalEnum.ONE);
        info.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        ORMHelper.setIsNew((IObjectValue)info, (boolean)true);
    }

    public FPTemplateInfo copyFPTemplate(FPTemplateInfo old) {
        FPTemplateInfo info = new FPTemplateInfo();
        this.initDefaultValue(info);
        info.setCompany(old.getCompany());
        info.setCycleInterval(old.getCycleInterval());
        info.setCycleType(old.getCycleType());
        info.setIsGroup(old.isIsGroup());
        FPItemCollection entries = info.getEntries();
        info.getEntries().addCollection(this.copyEntries(old.getEntries()));
        return info;
    }

    private FPItemCollection copyEntries(FPItemCollection oldEntries) {
        FPItemCollection entries = new FPItemCollection();
        for (int i = 0; i < oldEntries.size(); ++i) {
            FPItemInfo item = new FPItemInfo();
            FPItemInfo oldItem = oldEntries.get(i);
            item.setName(oldItem.getName());
            item.setComment(oldItem.getComment());
            item.setType(oldItem.getType());
            item.setNumber(oldItem.getNumber());
            item.setActualFormula(oldItem.getActualFormula());
            item.setPlanFormula(oldItem.getPlanFormula());
            item.setExpression(oldItem.getExpression());
            entries.add(item);
        }
        return entries;
    }
}

