/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fp.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMLoginModel;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fp.FixedFPItemFactory;
import com.kingdee.eas.fm.fp.client.AbstractFixedFPItemListUI;
import com.kingdee.eas.fm.fp.client.FixedFPItemFilterUI;
import com.kingdee.eas.fm.fp.client.FixedFPItemUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Map;

public class FixedFPItemListUI
extends AbstractFixedFPItemListUI {
    private FixedFPItemFilterUI filterUI;
    FillListener fillListener = new FillListener();

    protected String getEditUIName() {
        return FixedFPItemUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FixedFPItemFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initData();
    }

    private void initData() throws Exception {
        CompanyOrgUnitInfo curCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        boolean isOnlyUnion = ContextHelperFactory.getRemoteInstance().isOnlyUnion(curCompany);
        if (isOnlyUnion) {
            this.actionAddNew.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionCopy.setVisible(false);
            this.actionRemove.setVisible(false);
        }
        IColumn col = this.tblMain.getColumn("amount");
        col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    private void setNumberFormat(KDTable tblMain) {
        int rowsNum = tblMain.getRowCount();
        for (int i = 0; i < rowsNum; ++i) {
            String currencyID = tblMain.getRow(i).getCell("currencyID").getValue().toString();
            String numberFormat = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)currencyID));
            tblMain.getRow(i).getCell("amount").getStyleAttributes().setNumberFormat(numberFormat);
        }
    }

    public static void main(String[] args) {
        FMLoginModel login = FMLoginModel.newInstance();
        login.login("zhaon", "", "eas", "eas41");
        String uiname = FixedFPItemListUI.class.getName();
        System.out.println(uiname);
        login.loginMain(uiname);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new FixedFPItemFilterUI();
        }
        return this.filterUI;
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"COPY_FLAG", (Object)true);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.refresh(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionRemove_actionPerformed(e);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
        this.btnCopy.setText(null);
        this.btnAuditResult.setIcon(EASResource.getIcon((String)"imgTbtn_multapproveresult"));
    }

    public void onGetRowSet(IRowSet rowSet) {
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                String cId = rowSet.getString("currencyId");
                BigDecimal amount = rowSet.getBigDecimal("amount");
                int scale = FMClientHelper.getPrecOfCurrency((BOSUuid)BOSUuid.read((String)cId));
                amount = amount.setScale(scale, 5);
                rowSet.updateBigDecimal("amount", amount);
            }
            rowSet.beforeFirst();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.abort(e);
        }
        super.onGetRowSet(rowSet);
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            int rowsNum = FixedFPItemListUI.this.tblMain.getRowCount();
            String numberFormat = null;
            IRow row = null;
            for (int i = 0; i < rowsNum; ++i) {
                row = FixedFPItemListUI.this.tblMain.getRow(i);
                numberFormat = row.getCell("currencyID") == null || row.getCell("currencyID").getValue() == null ? "00.00" : FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)((String)row.getCell("currencyID").getValue())));
                row.getCell("amount").getStyleAttributes().setNumberFormat(numberFormat);
            }
        }
    }
}

